/*
 * Decompiled with CFR 0.152.
 */
package de.golfgl.gdx.controllers.mapping;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.Controller;
import de.golfgl.gdx.controllers.mapping.ConfiguredInput;
import de.golfgl.gdx.controllers.mapping.ControllerMappings;

public class MappedController {
    private Controller controller;
    private ControllerMappings mappings;
    private ControllerMappings.MappedInputs controllerMapping;
    private float analogToDigitalTreshold;

    public MappedController(Controller controller, ControllerMappings mappings) {
        this.controller = controller;
        this.mappings = mappings;
        this.analogToDigitalTreshold = mappings.analogToDigitalTreshold;
        this.refreshMappingCache();
    }

    public void refreshMappingCache() {
        this.controllerMapping = this.mappings.getControllerMapping(this.controller);
        if (this.controllerMapping == null || !this.controllerMapping.checkCompleted()) {
            Gdx.app.log("CONTROLLERMAPPING", "MappedController created with incomplete configuration");
        }
    }

    public boolean isButtonPressed(int configuredId) {
        if (this.controllerMapping == null) {
            return false;
        }
        ControllerMappings.MappedInput mappedInput = this.controllerMapping.getMappedInput(configuredId);
        if (mappedInput == null) {
            return false;
        }
        int buttonIndex = mappedInput.getButtonIndex();
        if (buttonIndex >= 0) {
            return this.controller.getButton(buttonIndex);
        }
        return false;
    }

    public float getConfiguredAxisValue(int configuredId) {
        if (this.controllerMapping == null) {
            return 0.0f;
        }
        ControllerMappings.MappedInput mappedInput = this.controllerMapping.getMappedInput(configuredId);
        if (mappedInput == null) {
            return 0.0f;
        }
        ConfiguredInput.Type configuredInputType = mappedInput.getConfiguredInputType();
        int axisId = mappedInput.getAxisIndex();
        if (axisId >= 0) {
            float value = this.controller.getAxis(axisId);
            if (configuredInputType == ConfiguredInput.Type.axisDigital) {
                return Math.abs(value) < this.analogToDigitalTreshold ? 0.0f : 1.0f * Math.signum(value);
            }
            return value;
        }
        if (configuredInputType == ConfiguredInput.Type.axisAnalog) {
            return 0.0f;
        }
        int buttonIndex = mappedInput.getButtonIndex();
        if (buttonIndex >= 0 && this.controller.getButton(buttonIndex)) {
            return 1.0f;
        }
        int reverseButtonIndex = mappedInput.getReverseButtonIndex();
        if (reverseButtonIndex >= 0 && this.controller.getButton(reverseButtonIndex)) {
            return -1.0f;
        }
        return 0.0f;
    }

    public String getControllerName() {
        return this.controller.getName();
    }
}

