/*
 * Decompiled with CFR 0.152.
 */
package de.golfgl.gdx.controllers.mapping;

import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.controllers.Controller;
import de.golfgl.gdx.controllers.mapping.ControllerMappings;
import de.golfgl.gdx.controllers.mapping.MappedControllerAdapter;
import java.util.HashMap;

public class ControllerToInputAdapter
extends MappedControllerAdapter {
    public float analogToDigitalTreshold;
    private InputProcessor targetInput;
    private HashMap<Integer, Integer> buttonMappings;
    private HashMap<Integer, AxisMapping> axisMappings;

    public ControllerToInputAdapter(ControllerMappings mappings) {
        super(mappings);
        this.analogToDigitalTreshold = mappings.analogToDigitalTreshold;
        this.buttonMappings = new HashMap();
        this.axisMappings = new HashMap();
    }

    public InputProcessor getInputProcessor() {
        return this.targetInput;
    }

    public void setInputProcessor(InputProcessor targetInput) {
        this.targetInput = targetInput;
    }

    @Override
    public boolean configuredAxisMoved(Controller controller, int axisId, float value) {
        boolean positivePressed;
        boolean negativePressed;
        if (this.targetInput == null || !this.axisMappings.containsKey(axisId)) {
            return false;
        }
        AxisMapping thisMapping = this.axisMappings.get(axisId);
        if (value >= this.analogToDigitalTreshold) {
            negativePressed = false;
            positivePressed = true;
        } else if (value <= -this.analogToDigitalTreshold) {
            negativePressed = true;
            positivePressed = false;
        } else {
            negativePressed = false;
            positivePressed = false;
        }
        if (thisMapping.negativeKeyPressed != negativePressed) {
            if (negativePressed) {
                this.targetInput.keyDown(thisMapping.keyCodeNegative);
            } else {
                this.targetInput.keyUp(thisMapping.keyCodeNegative);
            }
            thisMapping.negativeKeyPressed = negativePressed;
        }
        if (thisMapping.positiveKeyPressed != positivePressed) {
            if (positivePressed) {
                this.targetInput.keyDown(thisMapping.keyCodePositive);
            } else {
                this.targetInput.keyUp(thisMapping.keyCodePositive);
            }
            thisMapping.positiveKeyPressed = positivePressed;
        }
        return true;
    }

    @Override
    public boolean configuredButtonDown(Controller controller, int buttonId) {
        if (this.targetInput == null || !this.buttonMappings.containsKey(buttonId)) {
            return false;
        }
        return this.targetInput.keyDown(this.buttonMappings.get(buttonId).intValue());
    }

    @Override
    public boolean configuredButtonUp(Controller controller, int buttonId) {
        if (this.targetInput == null || !this.buttonMappings.containsKey(buttonId)) {
            return false;
        }
        return this.targetInput.keyUp(this.buttonMappings.get(buttonId).intValue());
    }

    public ControllerToInputAdapter addButtonMapping(int configuredButtonId, int targetKeyCode) {
        this.buttonMappings.put(configuredButtonId, targetKeyCode);
        return this;
    }

    public ControllerToInputAdapter addAxisMapping(int configuredAxisId, int targetKeyCodeNegative, int targetKeyCodePositive) {
        AxisMapping axisMapping = new AxisMapping();
        axisMapping.keyCodeNegative = targetKeyCodeNegative;
        axisMapping.keyCodePositive = targetKeyCodePositive;
        this.axisMappings.put(configuredAxisId, axisMapping);
        return this;
    }

    private static class AxisMapping {
        public int keyCodeNegative;
        public int keyCodePositive;
        public boolean negativeKeyPressed;
        public boolean positiveKeyPressed;

        private AxisMapping() {
        }
    }
}

