/*
 * Decompiled with CFR 0.152.
 */
package de.golfgl.gdx.controllers.mapping;

import com.badlogic.gdx.controllers.AdvancedController;
import com.badlogic.gdx.controllers.Controller;
import com.badlogic.gdx.utils.JsonValue;
import de.golfgl.gdx.controllers.mapping.ConfiguredInput;
import java.util.HashMap;

public class ControllerMappings {
    public static final String LOG_TAG = "CONTROLLERMAPPING";
    public float analogToDigitalTreshold = 0.5f;
    public float maxAcceptedAnalogValue = 1.1f;
    private HashMap<Integer, ConfiguredInput> configuredInputs;
    private HashMap<String, MappedInputs> mappedInputs;
    private boolean initialized;
    private int waitingForReverseButtonAxisId = -1;
    private int waitingForReverseButtonFirstIdx = -1;

    public static int findHighAxisValue(Controller controller, float analogToDigitalTreshold, float maxAcceptedAnalogValue) {
        float highestValue = 0.0f;
        int axisWithHighestValue = -1;
        int maxAxisIndex = controller instanceof AdvancedController ? ((AdvancedController)controller).getAxisCount() - 1 : 500;
        for (int i = 0; i <= maxAxisIndex; ++i) {
            float abs = Math.abs(controller.getAxis(i));
            if (!(abs > highestValue) || !(abs >= analogToDigitalTreshold) || !(abs <= maxAcceptedAnalogValue)) continue;
            highestValue = abs;
            axisWithHighestValue = i;
        }
        return axisWithHighestValue;
    }

    public static int findPressedButton(Controller controller) {
        int minButtonIndex = controller instanceof AdvancedController ? ((AdvancedController)controller).getMinButtonIndex() : 0;
        int maxButtonIndex = controller instanceof AdvancedController ? ((AdvancedController)controller).getMaxButtonIndex() : 500;
        for (int i = minButtonIndex; i <= maxButtonIndex; ++i) {
            if (!controller.getButton(i)) continue;
            return i;
        }
        return -1;
    }

    public JsonValue toJson() {
        JsonValue json = new JsonValue(JsonValue.ValueType.array);
        if (this.mappedInputs != null) {
            for (MappedInputs controllerMapping : this.mappedInputs.values()) {
                if (!controllerMapping.isRecorded) continue;
                JsonValue controllerJson = new JsonValue(JsonValue.ValueType.object);
                controllerJson.addChild("name", new JsonValue(controllerMapping.getControllerName()));
                controllerJson.addChild("mapping", controllerMapping.toJson());
                json.addChild(controllerJson);
            }
        }
        return json;
    }

    public boolean fillFromJson(JsonValue json) {
        if (this.mappedInputs == null) {
            this.mappedInputs = new HashMap();
        }
        JsonValue controllerJson = json.child;
        while (controllerJson != null) {
            String controllerName = controllerJson.getString("name");
            if (this.mappedInputs.containsKey(controllerName)) {
                this.mappedInputs.remove(controllerName);
            }
            MappedInputs newMapping = new MappedInputs(controllerName);
            this.mappedInputs.put(controllerName, newMapping);
            newMapping.isRecorded = true;
            JsonValue mappingsJson = controllerJson.get((String)"mapping").child;
            while (mappingsJson != null) {
                int confId = mappingsJson.getInt("confId");
                if (mappingsJson.has("axis")) {
                    newMapping.putMapping(new MappedInput(confId, new ControllerAxis(mappingsJson.getInt("axis"))));
                } else if (mappingsJson.has("pov")) {
                    newMapping.putMapping(new MappedInput(confId, new ControllerPovButton(mappingsJson.getInt("pov"), mappingsJson.getBoolean("vertical"))));
                } else if (mappingsJson.has("buttonR")) {
                    newMapping.putMapping(new MappedInput(confId, new ControllerButton(mappingsJson.getInt("button")), new ControllerButton(mappingsJson.getInt("buttonR"))));
                } else if (mappingsJson.has("button")) {
                    newMapping.putMapping(new MappedInput(confId, new ControllerButton(mappingsJson.getInt("button"))));
                }
                mappingsJson = mappingsJson.next;
            }
            controllerJson = controllerJson.next;
        }
        return true;
    }

    protected MappedInputs getControllerMapping(Controller controller) {
        MappedInputs defaultMapping;
        if (!this.initialized) {
            throw new IllegalStateException("Call commitConfig() before creating Controller Listeners");
        }
        MappedInputs retVal = null;
        if (this.mappedInputs == null) {
            this.mappedInputs = new HashMap();
        }
        if ((retVal = this.mappedInputs.get(controller.getName())) == null && this.getDefaultMapping(defaultMapping = new MappedInputs(controller), controller)) {
            retVal = defaultMapping;
            this.mappedInputs.put(retVal.controllerName, retVal);
        }
        return retVal;
    }

    public boolean getDefaultMapping(MappedInputs defaultMapping, Controller controller) {
        return false;
    }

    public ControllerMappings addConfiguredInput(ConfiguredInput configuredInput) {
        if (this.initialized) {
            throw new IllegalStateException("Changing config not allowed after commitConfig() is called");
        }
        if (this.configuredInputs == null) {
            this.configuredInputs = new HashMap();
        }
        this.configuredInputs.put(configuredInput.inputId, configuredInput);
        return this;
    }

    public void commitConfig() {
        this.initialized = true;
    }

    public void resetMappings(Controller controller) {
        if (this.mappedInputs == null) {
            return;
        }
        this.mappedInputs.remove(controller.getName());
        this.waitingForReverseButtonFirstIdx = -1;
        this.waitingForReverseButtonAxisId = -1;
    }

    public RecordResult recordMapping(Controller controller, int configuredInputId) {
        if (!this.initialized) {
            throw new IllegalStateException("Recording not allowed before commitConfig() is called");
        }
        ConfiguredInput configuredInput = this.configuredInputs.get(configuredInputId);
        if (this.mappedInputs == null) {
            this.mappedInputs = new HashMap();
        }
        if (!this.mappedInputs.containsKey(controller.getName())) {
            this.mappedInputs.put(controller.getName(), new MappedInputs(controller));
        }
        MappedInputs mappedInput = this.getControllerMapping(controller);
        mappedInput.isRecorded = true;
        switch (configuredInput.inputType) {
            case button: {
                int buttonIndex = ControllerMappings.findPressedButton(controller);
                if (buttonIndex >= 0) {
                    boolean added = mappedInput.putMapping(new MappedInput(configuredInputId, new ControllerButton(buttonIndex)));
                    return added ? RecordResult.recorded : RecordResult.not_added;
                }
                return RecordResult.nothing_done;
            }
            case axis: 
            case axisDigital: {
                int foundButtonIndex = ControllerMappings.findPressedButton(controller);
                if (foundButtonIndex >= 0) {
                    if (this.waitingForReverseButtonAxisId == configuredInputId) {
                        boolean added = mappedInput.putMapping(new MappedInput(configuredInputId, new ControllerButton(this.waitingForReverseButtonFirstIdx), new ControllerButton(foundButtonIndex)));
                        if (added) {
                            this.waitingForReverseButtonAxisId = -1;
                            this.waitingForReverseButtonFirstIdx = -1;
                            return RecordResult.recorded;
                        }
                        return RecordResult.not_added_need_button;
                    }
                    if (mappedInput.isButtonInMapping(foundButtonIndex)) {
                        return RecordResult.not_added;
                    }
                    this.waitingForReverseButtonAxisId = configuredInputId;
                    this.waitingForReverseButtonFirstIdx = foundButtonIndex;
                    return RecordResult.need_second_button;
                }
                if (this.waitingForReverseButtonAxisId == configuredInputId) {
                    return RecordResult.not_added_need_button;
                }
                switch (controller.getPov(0)) {
                    case east: 
                    case west: {
                        return mappedInput.putMapping(new MappedInput(configuredInputId, new ControllerPovButton(0, false))) ? RecordResult.recorded : RecordResult.not_added;
                    }
                    case north: 
                    case south: {
                        return mappedInput.putMapping(new MappedInput(configuredInputId, new ControllerPovButton(0, true))) ? RecordResult.recorded : RecordResult.not_added;
                    }
                    case northEast: 
                    case northWest: 
                    case southEast: 
                    case southWest: {
                        return RecordResult.not_added;
                    }
                }
            }
            case axisAnalog: {
                int axisIndex = ControllerMappings.findHighAxisValue(controller, this.analogToDigitalTreshold, this.maxAcceptedAnalogValue);
                if (axisIndex >= 0) {
                    boolean added = mappedInput.putMapping(new MappedInput(configuredInputId, new ControllerAxis(axisIndex)));
                    return added ? RecordResult.recorded : RecordResult.not_added;
                }
                return RecordResult.nothing_done;
            }
        }
        return RecordResult.nothing_done;
    }

    protected class MappedInputs {
        public boolean isRecorded;
        private String controllerName;
        private HashMap<Integer, MappedInput> mappingsByConfigured;
        private HashMap<Integer, MappedInput> mappingsByButton;
        private HashMap<Integer, MappedInput> mappingsByAxis;
        private HashMap<Integer, MappedInput> mappingsByPov;

        private MappedInputs(Controller controller) {
            this(controller.getName());
        }

        private MappedInputs(String controllerName) {
            this.controllerName = controllerName;
            this.mappingsByConfigured = new HashMap(ControllerMappings.this.mappedInputs.size());
            this.mappingsByButton = new HashMap(ControllerMappings.this.mappedInputs.size());
            this.mappingsByAxis = new HashMap(ControllerMappings.this.mappedInputs.size());
            this.mappingsByPov = new HashMap(2);
        }

        public boolean checkCompleted() {
            boolean completed = true;
            for (Integer configureId : ControllerMappings.this.configuredInputs.keySet()) {
                completed = completed && this.mappingsByConfigured.containsKey(configureId);
            }
            return completed;
        }

        public String getControllerName() {
            return this.controllerName;
        }

        public boolean putMapping(MappedInput mapping) {
            if (this.mappingsByConfigured.containsKey(mapping.configuredInputId)) {
                return false;
            }
            if (mapping.controllerInput instanceof ControllerButton) {
                ControllerButton controllerButton = (ControllerButton)mapping.controllerInput;
                if (this.mappingsByButton.containsKey(controllerButton.buttonIndex)) {
                    return false;
                }
                if (mapping.secondButtonForAxis != null && this.mappingsByButton.containsKey(((MappedInput)mapping).secondButtonForAxis.buttonIndex)) {
                    return false;
                }
                if (mapping.secondButtonForAxis != null && controllerButton.buttonIndex == ((MappedInput)mapping).secondButtonForAxis.buttonIndex) {
                    return false;
                }
                this.mappingsByButton.put(controllerButton.buttonIndex, mapping);
                if (mapping.secondButtonForAxis != null) {
                    this.mappingsByButton.put(((MappedInput)mapping).secondButtonForAxis.buttonIndex, mapping);
                }
            } else if (mapping.controllerInput instanceof ControllerAxis) {
                ControllerAxis controllerAxis = (ControllerAxis)mapping.controllerInput;
                if (this.mappingsByAxis.containsKey(controllerAxis.axisIndex)) {
                    return false;
                }
                this.mappingsByAxis.put(controllerAxis.axisIndex, mapping);
            } else if (mapping.controllerInput instanceof ControllerPovButton) {
                ControllerPovButton controllerPov = (ControllerPovButton)mapping.controllerInput;
                if (this.mappingsByPov.containsKey(controllerPov.getKey())) {
                    return false;
                }
                this.mappingsByPov.put(controllerPov.getKey(), mapping);
            } else {
                return false;
            }
            this.mappingsByConfigured.put(mapping.configuredInputId, mapping);
            return true;
        }

        public JsonValue toJson() {
            JsonValue json = new JsonValue(JsonValue.ValueType.array);
            for (MappedInput mapping : this.mappingsByConfigured.values()) {
                JsonValue jsonmaping = new JsonValue(JsonValue.ValueType.object);
                jsonmaping.addChild("confId", new JsonValue((long)mapping.configuredInputId));
                if (mapping.controllerInput instanceof ControllerAxis) {
                    jsonmaping.addChild("axis", new JsonValue((long)((ControllerAxis)((MappedInput)mapping).controllerInput).axisIndex));
                } else if (mapping.controllerInput instanceof ControllerButton) {
                    jsonmaping.addChild("button", new JsonValue((long)((ControllerButton)((MappedInput)mapping).controllerInput).buttonIndex));
                    if (mapping.secondButtonForAxis != null) {
                        jsonmaping.addChild("buttonR", new JsonValue((long)((MappedInput)mapping).secondButtonForAxis.buttonIndex));
                    }
                } else if (mapping.controllerInput instanceof ControllerPovButton) {
                    jsonmaping.addChild("pov", new JsonValue((long)((ControllerPovButton)((MappedInput)mapping).controllerInput).povIndex));
                    jsonmaping.addChild("vertical", new JsonValue(((ControllerPovButton)((MappedInput)mapping).controllerInput).povDirectionVertical));
                }
                json.addChild(jsonmaping);
            }
            return json;
        }

        protected boolean isButtonInMapping(int buttonIndex) {
            return this.mappingsByButton.containsKey(buttonIndex);
        }

        public ConfiguredInput getConfiguredFromButton(int buttonIndex) {
            MappedInput mappedInput = this.mappingsByButton.get(buttonIndex);
            if (mappedInput != null && (mappedInput.secondButtonForAxis == null || ((MappedInput)mappedInput).secondButtonForAxis.buttonIndex != buttonIndex)) {
                return (ConfiguredInput)ControllerMappings.this.configuredInputs.get(mappedInput.configuredInputId);
            }
            return null;
        }

        public ConfiguredInput getConfiguredFromReverseButton(int buttonIndex) {
            MappedInput mappedInput = this.mappingsByButton.get(buttonIndex);
            if (mappedInput != null && mappedInput.secondButtonForAxis != null && ((MappedInput)mappedInput).secondButtonForAxis.buttonIndex == buttonIndex) {
                return (ConfiguredInput)ControllerMappings.this.configuredInputs.get(mappedInput.configuredInputId);
            }
            return null;
        }

        public MappedInput getMappedInput(int configuredId) {
            return this.mappingsByConfigured.get(configuredId);
        }

        public ConfiguredInput getConfiguredFromAxis(int axisIndex) {
            MappedInput mappedInput = this.mappingsByAxis.get(axisIndex);
            if (mappedInput != null) {
                return (ConfiguredInput)ControllerMappings.this.configuredInputs.get(mappedInput.configuredInputId);
            }
            return null;
        }

        public ConfiguredInput getConfiguredFromPov(int povIndex, boolean vertical) {
            MappedInput mappedInput = this.mappingsByPov.get(povIndex * 10 + (vertical ? 1 : 0));
            if (mappedInput != null) {
                return (ConfiguredInput)ControllerMappings.this.configuredInputs.get(mappedInput.configuredInputId);
            }
            return null;
        }
    }

    protected class MappedInput {
        private int configuredInputId;
        private ControllerInput controllerInput;
        private ControllerButton secondButtonForAxis;

        public MappedInput(int configuredInputId, ControllerInput controllerInput) {
            this.configuredInputId = configuredInputId;
            this.controllerInput = controllerInput;
        }

        public MappedInput(int configuredInputId, ControllerButton controllerInput, ControllerButton reverseButton) {
            this.configuredInputId = configuredInputId;
            this.controllerInput = controllerInput;
            this.secondButtonForAxis = reverseButton;
        }

        public int getButtonIndex() {
            if (this.controllerInput instanceof ControllerButton) {
                return ((ControllerButton)this.controllerInput).buttonIndex;
            }
            return -1;
        }

        public int getAxisIndex() {
            if (this.controllerInput instanceof ControllerAxis) {
                return ((ControllerAxis)this.controllerInput).axisIndex;
            }
            return -1;
        }

        public int getPovIndex() {
            if (this.controllerInput instanceof ControllerPovButton) {
                return ((ControllerPovButton)this.controllerInput).povIndex;
            }
            return -1;
        }

        public boolean getPovVertical() {
            if (this.controllerInput instanceof ControllerPovButton) {
                return ((ControllerPovButton)this.controllerInput).povDirectionVertical;
            }
            return false;
        }

        public ConfiguredInput.Type getConfiguredInputType() {
            return ((ConfiguredInput)((ControllerMappings)ControllerMappings.this).configuredInputs.get((Object)Integer.valueOf((int)this.configuredInputId))).inputType;
        }

        public int getReverseButtonIndex() {
            if (this.secondButtonForAxis != null) {
                return this.secondButtonForAxis.buttonIndex;
            }
            return -1;
        }
    }

    public static class ControllerPovButton
    extends ControllerInput {
        public static final String VERTICAL = "V";
        public int povIndex;
        public boolean povDirectionVertical;

        public ControllerPovButton(int povIndex, boolean isVerticalDirection) {
            this.povDirectionVertical = isVerticalDirection;
            this.povIndex = povIndex;
        }

        public int getKey() {
            return this.povIndex * 10 + (this.povDirectionVertical ? 1 : 0);
        }
    }

    public static class ControllerAxis
    extends ControllerInput {
        public int axisIndex;

        public ControllerAxis(int axisIndex) {
            this.axisIndex = axisIndex;
        }
    }

    public static class ControllerButton
    extends ControllerInput {
        public int buttonIndex;

        public ControllerButton(int buttonIndex) {
            this.buttonIndex = buttonIndex;
        }
    }

    public static abstract class ControllerInput {
        public static final char PREFIX_BUTTON = 'B';
        public static final char PREFIX_AXIS = 'A';
        public static final char PREFIX_POV = 'P';
    }

    public static enum RecordResult {
        recorded,
        nothing_done,
        not_added,
        need_second_button,
        not_added_need_button;

    }
}

