/*
 * Decompiled with CFR 0.152.
 */
package gofabian.r2dbc.jooq;

import gofabian.r2dbc.jooq.ReactiveQueryExecutor;
import gofabian.r2dbc.jooq.RowConverter;
import gofabian.r2dbc.jooq.Tools;
import gofabian.r2dbc.jooq.converter.Converter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import org.jooq.Attachable;
import org.jooq.ConditionProvider;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.DeleteQuery;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.InsertQuery;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.SelectQuery;
import org.jooq.StoreQuery;
import org.jooq.Support;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableRecord;
import org.jooq.UniqueKey;
import org.jooq.UpdatableRecord;
import org.jooq.UpdateQuery;
import org.jooq.conf.Settings;
import org.jooq.exception.NoDataFoundException;
import org.jooq.tools.JooqLogger;
import org.springframework.r2dbc.core.DatabaseClient;
import reactor.core.publisher.Mono;

public class ReactiveRecordExecutor {
    private static final JooqLogger log = JooqLogger.getLogger(RowConverter.class);
    private final DSLContext dslContext;
    private final ReactiveQueryExecutor reactiveQueryExecutor;

    public ReactiveRecordExecutor(DSLContext dslContext, DatabaseClient databaseClient, Converter converter) {
        this.dslContext = Objects.requireNonNull(dslContext);
        this.reactiveQueryExecutor = new ReactiveQueryExecutor(dslContext, databaseClient, converter);
    }

    public static ReactiveRecordExecutor from(Attachable attachable) {
        return ReactiveRecordExecutor.from(attachable.configuration().dsl());
    }

    public static ReactiveRecordExecutor from(DSLContext dslContext) {
        Configuration configuration = dslContext.configuration();
        DatabaseClient databaseClient = (DatabaseClient)configuration.data((Object)"databaseClient");
        Converter converter = (Converter)configuration.data((Object)"converter");
        return new ReactiveRecordExecutor(dslContext, databaseClient, converter);
    }

    @Support
    public Mono<Integer> store(UpdatableRecord<?> record) {
        TableField[] keys = record.getTable().getPrimaryKey().getFieldsArray();
        boolean executeUpdate = false;
        for (TableField field : keys) {
            if (record.changed((Field)field) || !field.getDataType().nullable() && record.get((Field)field) == null) {
                executeUpdate = false;
                break;
            }
            executeUpdate = true;
        }
        if (executeUpdate) {
            return this.update(record);
        }
        return this.insert((TableRecord<?>)record);
    }

    @Support
    public Mono<Integer> insert(TableRecord<?> record) {
        InsertQuery insert = this.dslContext.insertQuery(record.getTable());
        this.addChangedValues(record, (StoreQuery<?>)insert);
        return this.executeStore(record, (StoreQuery<?>)insert);
    }

    @Support
    public Mono<Integer> update(UpdatableRecord<?> record) {
        UpdateQuery update = this.dslContext.updateQuery(record.getTable());
        this.addChangedValues((TableRecord<?>)record, (StoreQuery<?>)update);
        Tools.addConditions((ConditionProvider)update, record, record.getTable().getPrimaryKey().getFieldsArray());
        return this.executeStore((TableRecord<?>)record, (StoreQuery<?>)update);
    }

    private Mono<Integer> executeStore(TableRecord<?> record, StoreQuery<?> insert) {
        if (!insert.isExecutable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Query is not executable", insert);
            }
            return Mono.just((Object)0);
        }
        Collection<Field<?>> key = this.setReturningIfNeeded(record, insert);
        Mono monoResult = key == null || key.isEmpty() ? this.reactiveQueryExecutor.execute((Query)insert) : this.reactiveQueryExecutor.executeReturning(insert).collectList().flatMap(returnedRecords -> {
            TableRecord r = returnedRecords.isEmpty() ? null : (TableRecord)returnedRecords.get(0);
            Mono<Void> monoRefresh = this.getReturningIfNeeded((Record)r, record, key);
            return monoRefresh.thenReturn((Object)record);
        }).hasElement().map(hasElement -> hasElement != false ? 1 : 0);
        return monoResult.doOnNext(result -> {
            if (result > 0) {
                record.changed(false);
            }
        });
    }

    private void addChangedValues(TableRecord<?> record, StoreQuery<?> query) {
        for (Field field : record.fields()) {
            if (!record.changed(field)) continue;
            this.addValue(record, field, query);
        }
    }

    private <T> void addValue(TableRecord<?> record, Field<T> field, StoreQuery<?> store) {
        Object value = record.get(field);
        store.addValue(field, Tools.field(value, field));
    }

    private Collection<Field<?>> setReturningIfNeeded(TableRecord<?> record, StoreQuery<?> query) {
        Settings settings;
        Collection<Object> key = null;
        Configuration configuration = this.dslContext.configuration();
        if (record.configuration() != null && !Boolean.FALSE.equals((settings = configuration.settings()).isReturnIdentityOnUpdatableRecord())) {
            if (Boolean.TRUE.equals(settings.isReturnAllOnUpdatableRecord())) {
                key = Arrays.asList(record.fields());
            } else if (query instanceof InsertQuery) {
                key = this.getReturning(record);
            }
        }
        if (key != null) {
            query.setReturning(key);
        }
        return key;
    }

    private Object data(Configuration configuration, String keyString) {
        for (Object key : configuration.data().keySet()) {
            if (!keyString.equals(key.toString())) continue;
            return configuration.data(key);
        }
        return null;
    }

    private Collection<Field<?>> getReturning(TableRecord<?> record) {
        UniqueKey key;
        LinkedHashSet result = new LinkedHashSet();
        Identity identity = record.getTable().getIdentity();
        if (identity != null) {
            result.add((Field<?>)identity.getField());
        }
        if ((key = record.getTable().getPrimaryKey()) != null) {
            result.addAll(key.getFields());
        }
        return result;
    }

    private Mono<Void> getReturningIfNeeded(Record returnedRecord, TableRecord<?> record, Collection<Field<?>> key) {
        if (key != null && !key.isEmpty()) {
            if (returnedRecord != null) {
                for (Field<?> field : key) {
                    this.setValue(returnedRecord, record, field);
                    record.changed(field, false);
                }
            }
            if (Boolean.TRUE.equals(this.dslContext.settings().isReturnAllOnUpdatableRecord()) && this.dslContext.family() == SQLDialect.MYSQL && record instanceof UpdatableRecord) {
                return this.refresh((UpdatableRecord)record, key.toArray(new Field[0]));
            }
        }
        return Mono.empty();
    }

    private <T> void setValue(Record sourceRecord, TableRecord<?> targetRecord, Field<T> field) {
        Object value = sourceRecord.get(field);
        targetRecord.setValue(field, value);
    }

    @Support
    public <R extends UpdatableRecord<R>> Mono<Integer> delete(R record) {
        TableField[] keys = record.getTable().getPrimaryKey().getFieldsArray();
        DeleteQuery delete = this.dslContext.deleteQuery(record.getTable());
        Tools.addConditions((ConditionProvider)delete, record, keys);
        Mono<Integer> monoResult = this.reactiveQueryExecutor.execute((Query)delete);
        return monoResult.doFinally(result -> record.changed(true));
    }

    @Support
    public <R extends UpdatableRecord<R>> Mono<Void> refresh(R record) {
        return this.refresh(record, record.fields());
    }

    private Mono<Void> refresh(UpdatableRecord<?> record, Field<?> ... refreshFields) {
        SelectQuery select = this.dslContext.selectQuery();
        select.addSelect(refreshFields);
        select.addFrom((TableLike)record.getTable());
        Tools.addConditions((ConditionProvider)select, record, record.getTable().getPrimaryKey().getFieldsArray());
        Mono monoRecord = this.reactiveQueryExecutor.fetchOne(select);
        monoRecord = monoRecord.doOnNext(returnedRecord -> {
            for (Field field : refreshFields) {
                this.setValue((Record)returnedRecord, (TableRecord<?>)record, (Field)field);
                record.changed(field, false);
            }
        });
        return monoRecord.hasElement().flatMap(hasElement -> {
            if (!hasElement.booleanValue()) {
                throw new NoDataFoundException("Exactly one row expected for refresh. Record does not exist in database.");
            }
            return Mono.empty();
        });
    }
}

