/*
 * Decompiled with CFR 0.152.
 */
package gofabian.r2dbc.jooq;

import gofabian.r2dbc.jooq.JooqInternals;
import gofabian.r2dbc.jooq.RowConverter;
import gofabian.r2dbc.jooq.converter.Converter;
import io.r2dbc.spi.Row;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jooq.Attachable;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Identity;
import org.jooq.InsertResultStep;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectJoinStep;
import org.jooq.StoreQuery;
import org.jooq.Support;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.UpdateResultStep;
import org.jooq.conf.ParamType;
import org.reactivestreams.Publisher;
import org.springframework.r2dbc.core.DatabaseClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveQueryExecutor {
    private final DSLContext dslContext;
    private final DatabaseClient databaseClient;
    private final Converter converter;
    private final RowConverter rowConverter;

    public ReactiveQueryExecutor(DSLContext dslContext, DatabaseClient databaseClient, Converter converter) {
        this.dslContext = Objects.requireNonNull(dslContext);
        this.databaseClient = Objects.requireNonNull(databaseClient);
        this.converter = Objects.requireNonNull(converter);
        this.rowConverter = new RowConverter(converter);
    }

    public static ReactiveQueryExecutor from(Attachable attachable) {
        return ReactiveQueryExecutor.from(attachable.configuration().dsl());
    }

    public static ReactiveQueryExecutor from(DSLContext dslContext) {
        Configuration configuration = dslContext.configuration();
        DatabaseClient databaseClient = (DatabaseClient)configuration.data((Object)"databaseClient");
        Converter converter = (Converter)configuration.data((Object)"converter");
        return new ReactiveQueryExecutor(dslContext, databaseClient, converter);
    }

    @Support
    public Mono<Integer> execute(Query jooqQuery) {
        return this.createR2dbcExecuteSpec(jooqQuery).fetch().rowsUpdated();
    }

    @Support
    public <R extends Record> Flux<R> executeReturning(InsertResultStep<R> query) {
        StoreQuery storeQuery = JooqInternals.getQueryDelegate(query);
        return this.executeReturning(storeQuery);
    }

    @Support
    public <R extends Record> Mono<R> executeReturningOne(InsertResultStep<R> query) {
        StoreQuery storeQuery = JooqInternals.getQueryDelegate(query);
        return this.executeReturningOne(storeQuery);
    }

    @Support(value={SQLDialect.H2, SQLDialect.POSTGRES})
    public <R extends Record> Flux<R> executeReturning(UpdateResultStep<R> query) {
        StoreQuery storeQuery = JooqInternals.getQueryDelegate(query);
        return this.executeReturning(storeQuery);
    }

    @Support(value={SQLDialect.H2, SQLDialect.POSTGRES})
    public <R extends Record> Mono<R> executeReturningOne(UpdateResultStep<R> query) {
        StoreQuery storeQuery = JooqInternals.getQueryDelegate(query);
        return this.executeReturningOne(storeQuery);
    }

    @Support
    public <R extends Record> Flux<R> fetch(Select<R> jooqQuery) {
        return this.createR2dbcExecuteSpec((Query)jooqQuery).map(row -> this.convertSelectedRowToRecord((Row)row, jooqQuery)).all();
    }

    @Support
    public <R extends Record> Mono<R> fetchOne(Select<R> jooqQuery) {
        return this.createR2dbcExecuteSpec((Query)jooqQuery).map(row -> this.convertSelectedRowToRecord((Row)row, jooqQuery)).one();
    }

    @Support
    public <R extends Record> Mono<R> fetchAny(Select<R> jooqQuery) {
        return this.createR2dbcExecuteSpec((Query)jooqQuery).map(row -> this.convertSelectedRowToRecord((Row)row, jooqQuery)).first();
    }

    private <R extends Record> R convertSelectedRowToRecord(Row row, Select<R> jooqQuery) {
        List allFields = jooqQuery.getSelect();
        Class recordType = jooqQuery.getRecordType();
        return this.rowConverter.convertRowToRecord(this.dslContext, row, allFields, recordType);
    }

    @Support
    public Mono<Boolean> fetchExists(Select<?> jooqQuery) {
        SelectConditionStep existsQuery = this.dslContext.selectOne().whereExists(jooqQuery);
        return this.fetchOne((Select)existsQuery).map(Objects::nonNull);
    }

    @Support
    public Mono<Integer> fetchCount(Select<?> jooqQuery) {
        SelectJoinStep countQuery = this.dslContext.selectCount().from(jooqQuery);
        return this.fetchOne((Select)countQuery).map(record -> (Integer)record.get(0, Integer.class));
    }

    private <R extends Record> Mono<R> executeReturningOne(StoreQuery<R> query) {
        return this.executeReturning(query).collectList().flatMap(list -> {
            if (list.isEmpty()) {
                return Mono.empty();
            }
            return Mono.just(list.get(0));
        });
    }

    <R extends Record> Flux<R> executeReturning(StoreQuery<R> query) {
        Table<R> table = JooqInternals.getQueryTable(query);
        List<Field<?>> returningFields = JooqInternals.getQueryReturning(query);
        List<Field<?>> returningResolvedFields = JooqInternals.getQueryReturningResolved(query);
        Class recordType = table.getRecordType();
        query.setReturning(Collections.emptyList());
        DatabaseClient.GenericExecuteSpec executeSpec = this.createR2dbcExecuteSpec((Query)query);
        query.setReturning(returningFields);
        if (returningFields.isEmpty()) {
            return executeSpec.then().flatMapMany(x -> Flux.empty());
        }
        executeSpec = executeSpec.filter(s -> {
            switch (this.dslContext.family()) {
                case MYSQL: {
                    return s.returnGeneratedValues(new String[0]);
                }
            }
            String[] fieldNames = (String[])returningResolvedFields.stream().map(Field::getName).toArray(String[]::new);
            return s.returnGeneratedValues(fieldNames);
        });
        switch (this.dslContext.family()) {
            case MYSQL: {
                Identity identity = table.getIdentity();
                if (identity == null) {
                    return executeSpec.then().flatMapMany(x -> Flux.empty());
                }
                TableField idField = identity.getField();
                return executeSpec.map(arg_0 -> ReactiveQueryExecutor.lambda$executeReturning$9((Field)idField, arg_0)).all().collectList().flatMapMany(arg_0 -> this.lambda$executeReturning$11(returningResolvedFields, (Field)idField, returningFields, table, arg_0)).map(r -> (Record)r.into(recordType));
            }
        }
        return executeSpec.map(row -> this.rowConverter.convertRowToRecord(this.dslContext, (Row)row, returningResolvedFields, recordType)).all();
    }

    private DatabaseClient.GenericExecuteSpec createR2dbcExecuteSpec(Query jooqQuery) {
        String sql = jooqQuery.getSQL(ParamType.NAMED);
        DatabaseClient.GenericExecuteSpec executeSpec = this.databaseClient.sql(sql);
        List parameters = jooqQuery.getParams().values().stream().filter(p -> p.getParamType() != ParamType.INLINED).collect(Collectors.toList());
        for (int i = 0; i < parameters.size(); ++i) {
            Param parameter = (Param)parameters.get(i);
            Object bindValue = parameter.getValue();
            Class<?> bindType = parameter.getType();
            if (bindValue == null) {
                bindType = this.converter.toR2dbcType(bindType);
                executeSpec = executeSpec.bindNull(i, bindType);
                continue;
            }
            bindValue = this.converter.toR2dbcValue(bindValue);
            executeSpec = executeSpec.bind(i, bindValue);
        }
        return executeSpec;
    }

    private /* synthetic */ Publisher lambda$executeReturning$11(List returningResolvedFields, Field idField, List returningFields, Table table, List ids) {
        if (returningResolvedFields.size() == 1 && ((Field)returningResolvedFields.get(0)).getName().equals(idField.getName())) {
            List records = ids.stream().map(id -> {
                Record record = this.dslContext.newRecord((Collection)returningResolvedFields);
                record.set(idField, id);
                record.changed(false);
                return record;
            }).collect(Collectors.toList());
            return Flux.fromIterable(records);
        }
        SelectConditionStep select = this.dslContext.select((Collection)returningFields).from((TableLike)table).where(idField.in((Collection)ids));
        return this.fetch((Select)select);
    }

    private static /* synthetic */ Object lambda$executeReturning$9(Field idField, Row row) {
        Object value = row.get(0, Object.class);
        return idField.getDataType().convert(value);
    }
}

