/*
 * Decompiled with CFR 0.152.
 */
package gofabian.r2dbc.jooq;

import gofabian.r2dbc.jooq.converter.CompositeConverter;
import gofabian.r2dbc.jooq.converter.Converter;
import gofabian.r2dbc.jooq.converter.JsonConverter;
import io.r2dbc.spi.ConnectionFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.r2dbc.dialect.DialectResolver;
import org.springframework.data.r2dbc.dialect.H2Dialect;
import org.springframework.data.r2dbc.dialect.MySqlDialect;
import org.springframework.data.r2dbc.dialect.PostgresDialect;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.r2dbc.core.DatabaseClient;

@Configuration
public class R2dbcJooqAutoConfiguration {
    @Bean
    public DSLContext dslContext(DatabaseClient databaseClient, ConnectionFactory connectionFactory) {
        R2dbcDialect r2dbcDialect = DialectResolver.getDialect((ConnectionFactory)connectionFactory);
        SQLDialect jooqDialect = this.translateToJooqDialect(r2dbcDialect);
        DSLContext dslContext = DSL.using((SQLDialect)jooqDialect);
        dslContext.configuration().data((Object)"databaseClient", (Object)databaseClient);
        dslContext.configuration().data((Object)"converter", (Object)this.getConverter(jooqDialect));
        return dslContext;
    }

    private SQLDialect translateToJooqDialect(R2dbcDialect r2dbcDialect) {
        if (r2dbcDialect instanceof MySqlDialect) {
            return SQLDialect.MYSQL;
        }
        if (r2dbcDialect instanceof H2Dialect) {
            return SQLDialect.H2;
        }
        if (r2dbcDialect instanceof PostgresDialect) {
            return SQLDialect.POSTGRES;
        }
        throw new IllegalArgumentException("unsupported r2dbc dialect " + r2dbcDialect.getClass());
    }

    private Converter getConverter(SQLDialect sqlDialect) {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        converters.add(new JsonConverter());
        if (sqlDialect == SQLDialect.POSTGRES) {
            Converter converter = this.createConverter("gofabian.r2dbc.jooq.converter.PostgresConverter");
            converters.add(converter);
        }
        Converter[] array = converters.toArray(new Converter[0]);
        return new CompositeConverter(array);
    }

    private Converter createConverter(String className) {
        try {
            return (Converter)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create instance of '" + className + "'");
        }
    }
}

