/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.poifab.target.model;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import de.gofabian.poifab.core.FieldParser;
import de.gofabian.poifab.option.ParseOptions;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelParser {
    private final ObjectMapper objectMapper;

    public ModelParser() {
        this.objectMapper = new ObjectMapper();
    }

    public ModelParser(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public <T> List<T> parse(Class<T> modelClass, ParseOptions options) {
        Map<Field, FieldParser> fieldToParserMap = this.getFieldParsers(modelClass, options.fieldParsers());
        List<Map<Field, Object>> listOfFieldToValueMap = options.tableParser().parse(fieldToParserMap, options);
        ArrayList listOfFieldNameToValueMap = new ArrayList();
        for (Map<Field, Object> fieldToValueMap : listOfFieldToValueMap) {
            HashMap fieldNameToValueMap = new HashMap();
            fieldToValueMap.forEach((field, value) -> fieldNameToValueMap.put(field.getName(), value));
            listOfFieldNameToValueMap.add(fieldNameToValueMap);
        }
        CollectionType jacksonType = this.objectMapper.getTypeFactory().constructCollectionType(List.class, modelClass);
        return (List)this.objectMapper.convertValue(listOfFieldNameToValueMap, (JavaType)jacksonType);
    }

    private Map<Field, FieldParser> getFieldParsers(Class<?> modelClass, List<FieldParser> allFieldParsers) {
        LinkedHashMap<Field, FieldParser> fieldToParserMap = new LinkedHashMap<Field, FieldParser>();
        for (Field field : modelClass.getDeclaredFields()) {
            boolean notFound = true;
            for (FieldParser parser : allFieldParsers) {
                if (!parser.supports(field)) continue;
                fieldToParserMap.put(field, parser);
                notFound = false;
                break;
            }
            if (!notFound) continue;
            throw new IllegalArgumentException("Field is not supported by any field parser: " + field);
        }
        return fieldToParserMap;
    }
}

