/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.poifab.target.model;

import de.gofabian.poifab.core.FieldParser;
import de.gofabian.poifab.option.IndexRange;
import de.gofabian.poifab.option.ParseOptions;
import de.gofabian.poifab.target.model.ExcelColumnTitle;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExcelColumnTitleFieldParser
implements FieldParser {
    private Map<String, Integer> columnTitleToIndexMap = null;

    @Override
    public boolean supports(Field field) {
        return field.getAnnotation(ExcelColumnTitle.class) != null;
    }

    @Override
    public Object parse(Field field, int rowIndex, ParseOptions options) {
        String columnTitle = field.getAnnotation(ExcelColumnTitle.class).value();
        int columnIndex = this.mapColumnTitleToIndex(columnTitle, options);
        return options.cellParser().parse(field, rowIndex, columnIndex, options);
    }

    private int mapColumnTitleToIndex(String title, ParseOptions options) {
        Integer columnIndex;
        if (this.columnTitleToIndexMap == null) {
            this.columnTitleToIndexMap = this.parseTitles(options);
        }
        if ((columnIndex = this.columnTitleToIndexMap.get(title)) == null) {
            throw new IllegalArgumentException("Column title cannot be found in Excel sheet: " + title);
        }
        return columnIndex;
    }

    private Map<String, Integer> parseTitles(ParseOptions options) {
        if (options.titleRowRange() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> columnTitleToIndexMap = new HashMap<String, Integer>();
        options.titleRowRange().forEach(rowIndex -> {
            IndexRange columnRange = options.getRealColumnRange((int)rowIndex);
            columnRange.forEach(columnIndex -> {
                String title;
                Object value = options.cellParser().parse(null, (int)rowIndex, (int)columnIndex, options);
                String string = title = value == null ? null : value.toString().trim();
                if (title != null && !title.isEmpty()) {
                    columnTitleToIndexMap.put(title, (Integer)columnIndex);
                }
            });
        });
        return columnTitleToIndexMap;
    }
}

