/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.poifab.option;

import de.gofabian.poifab.core.CellParser;
import de.gofabian.poifab.core.CompositeCellParser;
import de.gofabian.poifab.core.DefaultTableParser;
import de.gofabian.poifab.core.FieldParser;
import de.gofabian.poifab.core.FormattingCellParser;
import de.gofabian.poifab.core.RawCellParser;
import de.gofabian.poifab.core.TableParser;
import de.gofabian.poifab.option.IndexRange;
import de.gofabian.poifab.option.ParseOptions;
import de.gofabian.poifab.target.model.ExcelColumnIndexFieldParser;
import de.gofabian.poifab.target.model.ExcelColumnTitleFieldParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Sheet;

public class ParseOptionsBuilder {
    private static final List<FieldParser> defaultFieldParsers = Arrays.asList(new ExcelColumnIndexFieldParser(), new ExcelColumnTitleFieldParser());
    private Sheet sheet;
    private IndexRange titleRowRange;
    private IndexRange dataRowRange;
    private IndexRange columnRange;
    private CellParser defaultCellParser = new RawCellParser();
    private final List<CellParser> cellParsers = new ArrayList<CellParser>();
    private final List<FieldParser> fieldParsers = new ArrayList<FieldParser>();
    private TableParser tableParser = new DefaultTableParser();

    public ParseOptionsBuilder sheet(Sheet sheet) {
        this.sheet = sheet;
        return this;
    }

    public ParseOptionsBuilder noTitleRows() {
        this.titleRowRange = null;
        return this;
    }

    public ParseOptionsBuilder titleRow(int rowIndex) {
        this.titleRowRange = new IndexRange(rowIndex, rowIndex);
        return this;
    }

    public ParseOptionsBuilder titleRows(int startRowIndex, int endRowIndex) {
        this.titleRowRange = new IndexRange(startRowIndex, endRowIndex);
        return this;
    }

    public ParseOptionsBuilder allDataRows() {
        this.dataRowRange = null;
        return this;
    }

    public ParseOptionsBuilder dataRows(int startRowIndex, int endRowIndex) {
        this.dataRowRange = new IndexRange(startRowIndex, endRowIndex);
        return this;
    }

    public ParseOptionsBuilder allColumns() {
        this.columnRange = null;
        return this;
    }

    public ParseOptionsBuilder columns(int startColumnIndex, int endColumnIndex) {
        this.columnRange = new IndexRange(startColumnIndex, endColumnIndex);
        return this;
    }

    public ParseOptionsBuilder rawData() {
        this.defaultCellParser = new RawCellParser();
        return this;
    }

    public ParseOptionsBuilder formattedData() {
        this.defaultCellParser = new FormattingCellParser();
        return this;
    }

    public ParseOptionsBuilder resetCellParsers() {
        this.cellParsers.clear();
        return this;
    }

    public ParseOptionsBuilder addCellParser(CellParser cellParser) {
        this.cellParsers.add(Objects.requireNonNull(cellParser));
        return this;
    }

    public ParseOptionsBuilder addCellParsers(List<CellParser> cellParsers) {
        this.cellParsers.addAll((Collection<CellParser>)Objects.requireNonNull(cellParsers));
        return this;
    }

    public ParseOptionsBuilder resetFieldParsers() {
        this.fieldParsers.clear();
        return this;
    }

    public ParseOptionsBuilder addFieldParser(FieldParser fieldParser) {
        this.fieldParsers.add(Objects.requireNonNull(fieldParser));
        return this;
    }

    public ParseOptionsBuilder addFieldParsers(List<FieldParser> fieldParsers) {
        this.fieldParsers.addAll((Collection<FieldParser>)Objects.requireNonNull(fieldParsers));
        return this;
    }

    public ParseOptionsBuilder tableParser(TableParser tableParser) {
        this.tableParser = Objects.requireNonNull(tableParser);
        return this;
    }

    public ParseOptions build() {
        ArrayList<CellParser> cellParsers = new ArrayList<CellParser>(this.cellParsers);
        cellParsers.add(this.defaultCellParser);
        ArrayList<FieldParser> fieldParsers = new ArrayList<FieldParser>(this.fieldParsers);
        fieldParsers.addAll(defaultFieldParsers);
        return new ParseOptions(this.sheet, this.titleRowRange, this.dataRowRange, this.columnRange, new CompositeCellParser(cellParsers), fieldParsers, this.tableParser);
    }
}

