/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.poifab.core;

import de.gofabian.poifab.core.CellParser;
import de.gofabian.poifab.option.ParseOptions;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.FormulaEvaluator;

public class FormattingCellParser
implements CellParser {
    private final DataFormatter dataFormatter;
    private final FormulaEvaluator formulaEvaluator;

    public FormattingCellParser() {
        this(FormattingCellParser.createDefaultDataFormatter(), null);
    }

    public FormattingCellParser(DataFormatter dataFormatter, FormulaEvaluator formulaEvaluator) {
        this.dataFormatter = Objects.requireNonNull(dataFormatter);
        this.formulaEvaluator = formulaEvaluator;
    }

    private static DataFormatter createDefaultDataFormatter() {
        DataFormatter dataFormatter = new DataFormatter();
        dataFormatter.setUseCachedValuesForFormulaCells(true);
        return dataFormatter;
    }

    @Override
    public boolean supports(Field field, int rowIndex, int columnIndex, ParseOptions options) {
        return true;
    }

    @Override
    public Object parse(Field field, int rowIndex, int columnIndex, ParseOptions options) {
        Cell cell = options.getCell(rowIndex, columnIndex);
        return this.dataFormatter.formatCellValue(cell, this.formulaEvaluator);
    }
}

