/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.poifab.core;

import de.gofabian.poifab.core.CellParser;
import de.gofabian.poifab.option.ParseOptions;
import java.lang.reflect.Field;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;

public class RawCellParser
implements CellParser {
    @Override
    public boolean supports(Field field, int rowIndex, int columnIndex, ParseOptions options) {
        return true;
    }

    @Override
    public Object parse(Field field, int rowIndex, int columnIndex, ParseOptions options) {
        Cell cell = options.getCell(rowIndex, columnIndex);
        if (cell == null) {
            return null;
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            cellType = cell.getCachedFormulaResultType();
        }
        switch (cellType) {
            case BLANK: {
                return null;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case STRING: {
                String string = cell.getStringCellValue().trim();
                if (string.isEmpty()) {
                    return null;
                }
                return string;
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getLocalDateTimeCellValue();
                }
                return cell.getNumericCellValue();
            }
        }
        throw new IllegalStateException("unexpected cell type: " + cellType);
    }
}

