/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.jfixture;

import de.gofabian.jfixture.FixtureDefinition;
import de.gofabian.jfixture.Scope;
import de.gofabian.jfixture.api.Fixture;
import de.gofabian.jfixture.api.FixtureContext;
import de.gofabian.jfixture.api.LoadFixtures;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FixtureMethodParser {
    private final Map<Object, List<FixtureDefinition>> cache = new HashMap<Object, List<FixtureDefinition>>();

    public List<FixtureDefinition> parseClass(Class<?> clazz) {
        Object instance = this.createInstance(clazz);
        return this.parseInstance(instance);
    }

    public List<FixtureDefinition> parseInstance(Object instance) {
        Object plus;
        List<FixtureDefinition> definitions = this.cache.get(instance.getClass());
        if (definitions != null) {
            return definitions;
        }
        definitions = new ArrayList<FixtureDefinition>();
        for (Class<?> externalClass : this.collectExternalClasses(instance.getClass())) {
            plus = this.parseClass(externalClass);
            ((ArrayList)definitions).addAll((Collection<FixtureDefinition>)plus);
        }
        for (Method method : this.collectMethodsFromClass(instance.getClass())) {
            plus = this.createFixtureDefinition(instance, method);
            ((ArrayList)definitions).add((FixtureDefinition)plus);
        }
        this.cache.put(instance.getClass(), definitions);
        return definitions;
    }

    private List<Class<?>> collectExternalClasses(Class<?> clazz) {
        return Arrays.stream((LoadFixtures[])clazz.getAnnotationsByType(LoadFixtures.class)).map(LoadFixtures::value).collect(Collectors.toList());
    }

    private List<Method> collectMethodsFromClass(Class<?> clazz) {
        return Arrays.stream(clazz.getMethods()).filter(m -> m.getAnnotation(Fixture.class) != null).collect(Collectors.toList());
    }

    private Object createInstance(Class<?> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("cannot create instance of fixture container " + clazz, e);
        }
    }

    public FixtureDefinition createFixtureDefinition(final Object instance, final Method method) {
        Class<?> type = method.getReturnType();
        final Class[] parameterTypes = method.getParameterTypes();
        List dependencyTypes = Arrays.stream(parameterTypes).filter(t -> t != FixtureContext.class).collect(Collectors.toList());
        Fixture annotation = method.getAnnotation(Fixture.class);
        Scope scope = annotation.scope();
        boolean autoUse = annotation.autoUse();
        return new FixtureDefinition(scope, type, dependencyTypes, autoUse){
            private FixtureContext context;

            @Override
            public Object setUp(List<Object> dependencies) {
                this.context = new FixtureContext();
                Iterator<Object> dependencyIterator = dependencies.iterator();
                Object[] args = Arrays.stream(parameterTypes).map(type -> {
                    if (type == FixtureContext.class) {
                        return this.context;
                    }
                    if (dependencyIterator.hasNext()) {
                        return dependencyIterator.next();
                    }
                    throw new IllegalArgumentException("missing parameter!");
                }).toArray();
                try {
                    return method.invoke(instance, args);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public void tearDown(Object object) {
                for (Runnable tearDown : this.context.getTearDowns()) {
                    tearDown.run();
                }
            }
        };
    }
}

