/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.jfixture;

import de.gofabian.jfixture.FixtureDefinition;
import de.gofabian.jfixture.FixtureDefinitionQueries;
import de.gofabian.jfixture.FixtureLifecycle;
import de.gofabian.jfixture.FixtureSession;
import de.gofabian.jfixture.Scope;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class FixtureManager {
    private final FixtureSession session;
    private final FixtureDefinitionQueries definitions;

    public FixtureManager(FixtureSession session, List<FixtureDefinition> definitions) {
        this.session = session;
        this.definitions = new FixtureDefinitionQueries(definitions);
    }

    public void enter(Scope scope) {
        for (FixtureDefinition definition : this.definitions.filterBy(d -> d.getScope() == scope && d.isAutoUse())) {
            this.setUp(definition);
        }
    }

    public void leave(Scope scope) {
        List lifecycles = this.session.orderedLifecycles.stream().filter(l -> l.getDefinition().getScope() == scope).collect(Collectors.toList());
        ListIterator it = lifecycles.listIterator(lifecycles.size());
        while (it.hasPrevious()) {
            FixtureLifecycle lifecycle = (FixtureLifecycle)it.previous();
            lifecycle.tearDown();
            this.session.orderedLifecycles.remove(lifecycle);
        }
    }

    public boolean supports(Class<?> type) {
        FixtureDefinition definition = this.definitions.findByType(type);
        return definition != null;
    }

    public Object resolve(Class<?> type) {
        FixtureDefinition definition = this.getFixtureDefinition(type);
        return this.setUp(definition);
    }

    private Object setUp(FixtureDefinition definition) {
        FixtureLifecycle lifecycle = this.getFixtureLifecycle(definition);
        if (lifecycle.isSetUp()) {
            return lifecycle.getObject();
        }
        ArrayList<Object> dependencies = new ArrayList<Object>();
        for (Class<?> type : definition.getDependencyTypes()) {
            FixtureDefinition dependencyDefinition = this.getFixtureDefinition(type);
            if (dependencyDefinition.getScope().getOrder() > definition.getScope().getOrder()) {
                throw new IllegalArgumentException("Fixture has wider scope than dependency: fixture=" + definition + ", dependency: " + dependencyDefinition);
            }
            Object dependency = this.setUp(dependencyDefinition);
            dependencies.add(dependency);
        }
        Object object = lifecycle.setUp(dependencies);
        this.session.orderedLifecycles.add(lifecycle);
        return object;
    }

    private FixtureDefinition getFixtureDefinition(Class<?> type) {
        FixtureDefinition definition = this.definitions.findByType(type);
        if (definition == null) {
            throw new IllegalArgumentException("could not find fixture of type " + type);
        }
        return definition;
    }

    FixtureLifecycle getFixtureLifecycle(FixtureDefinition definition) {
        return this.session.definitionLifecycleMap.computeIfAbsent(definition, d -> new FixtureLifecycle(definition));
    }
}

