/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.jfixture;

import de.gofabian.jfixture.ExtensionContextUtil;
import de.gofabian.jfixture.FixtureDefinition;
import de.gofabian.jfixture.FixtureManager;
import de.gofabian.jfixture.FixtureMethodParser;
import de.gofabian.jfixture.FixtureSession;
import de.gofabian.jfixture.Scope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class FixtureExtension
implements TestInstancePostProcessor,
ParameterResolver,
BeforeAllCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
AfterAllCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FixtureExtension.class});

    public void beforeAll(ExtensionContext context) {
        ExtensionContextUtil.registerAfterSessionCallback(context, this::afterSession);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        FixtureMethodParser parser = (FixtureMethodParser)context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)"parser", k -> new FixtureMethodParser(), FixtureMethodParser.class);
        List<FixtureDefinition> definitions = parser.parseInstance(testInstance);
        this.storeAdditionalDefinitions(definitions, context);
    }

    public void beforeTestExecution(ExtensionContext context) {
        FixtureManager manager = this.getManager(context);
        manager.enter(Scope.SESSION);
        manager.enter(Scope.FILE);
        manager.enter(Scope.CLASS);
        manager.enter(Scope.METHOD);
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        FixtureManager manager = this.getManager(extensionContext);
        manager.leave(Scope.METHOD);
    }

    public void afterAll(ExtensionContext context) {
        FixtureManager manager = this.getManager(context);
        manager.leave(Scope.CLASS);
        if (ExtensionContextUtil.isOuterClassContext(context)) {
            manager.leave(Scope.FILE);
        }
    }

    private void afterSession(ExtensionContext context) {
        FixtureManager manager = this.getManager(context);
        manager.leave(Scope.SESSION);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        FixtureManager manager = this.getManager(extensionContext);
        Class<?> type = parameterContext.getParameter().getType();
        return manager.supports(type);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        FixtureManager manager = this.getManager(extensionContext);
        Class<?> type = parameterContext.getParameter().getType();
        return manager.resolve(type);
    }

    private FixtureManager getManager(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        return (FixtureManager)store.getOrComputeIfAbsent((Object)"manager", k -> this.storeEmptyManager(context), FixtureManager.class);
    }

    private FixtureManager storeAdditionalDefinitions(List<FixtureDefinition> plusDefinitions, ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        List parentDefinitions = (List)store.getOrDefault((Object)"definitions", List.class, new ArrayList());
        ArrayList<FixtureDefinition> childDefinitions = new ArrayList<FixtureDefinition>(parentDefinitions);
        childDefinitions.addAll(plusDefinitions);
        store.put((Object)"definitions", childDefinitions);
        FixtureSession session = (FixtureSession)context.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)"session", k -> new FixtureSession(), FixtureSession.class);
        FixtureManager manager = new FixtureManager(session, childDefinitions);
        context.getStore(NAMESPACE).put((Object)"manager", (Object)manager);
        return manager;
    }

    private FixtureManager storeEmptyManager(ExtensionContext context) {
        return this.storeAdditionalDefinitions(Collections.emptyList(), context);
    }
}

