/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.jfixture;

import de.gofabian.jfixture.FixtureDefinition;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class FixtureDefinitionQueries {
    private final List<FixtureDefinition> definitions;

    public FixtureDefinitionQueries(List<FixtureDefinition> definitions) {
        this.definitions = definitions;
    }

    public List<FixtureDefinition> filterBy(Predicate<FixtureDefinition> predicate) {
        return this.definitions.stream().filter(predicate).collect(Collectors.toList());
    }

    public FixtureDefinition findByType(Class<?> type) {
        ListIterator<FixtureDefinition> it = this.definitions.listIterator(this.definitions.size());
        while (it.hasPrevious()) {
            FixtureDefinition definition = it.previous();
            if (!FixtureDefinitionQueries.supportsType(definition, type)) continue;
            return definition;
        }
        return null;
    }

    private static boolean supportsType(FixtureDefinition definition, Class<?> type) {
        return type.isAssignableFrom(definition.getType());
    }
}

