package de.gofabian.jmigrate.jooq;

import de.gofabian.jmigrate.Command;
import de.gofabian.jmigrate.TransactionExecutor;
import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings("WeakerAccess")
public class JooqTransactionExecutor implements TransactionExecutor<DSLContext> {

    private static final Logger logger = LoggerFactory.getLogger(JooqTransactionExecutor.class);

    private DSLContext context;

    public JooqTransactionExecutor(DSLContext context) {
        this.context = context;
    }

    @Override
    public void execute(Command<DSLContext> command) {
        logger.debug("Create transaction");
        try {
            executeImpl(command);
            logger.debug("Applied transaction");
        } catch (Exception e) {
            logger.debug("Rolled back transaction");
            throw e;
        }
    }

    private void executeImpl(Command<DSLContext> command) {
        context.transaction(configuration -> {
            DSLContext create = DSL.using(configuration);
            command.execute(create);
        });
    }

}
