package de.gofabian.jmigrate.jooq;

import de.gofabian.jmigrate.MigrationTool;
import de.gofabian.jmigrate.utility.PackageMigrationLoader;
import org.jooq.DSLContext;

@SuppressWarnings("unused")
public final class JooqMigrationToolFactory {

    private JooqMigrationToolFactory() {
    }

    public static MigrationTool create(DSLContext context, String packagePath) {
        return MigrationTool.create(
                new JooqHistoryStorage(context),
                new PackageMigrationLoader<>(packagePath),
                new JooqTransactionExecutor(context)
        );
    }

}
