package de.gofabian.jmigrate.jooq;

import de.gofabian.jmigrate.HistoryEntry;
import de.gofabian.jmigrate.HistoryStorage;
import org.jooq.DSLContext;

import java.util.List;


public class JooqHistoryStorage implements HistoryStorage {

    private LockRepository lockRepository;
    private HistoryRepository historyRepository;

    @SuppressWarnings("WeakerAccess")
    public JooqHistoryStorage(DSLContext context) {
        this(
                new LockRepository(context, "jmigrate_lock"),
                new HistoryRepository(context, "jmigrate_history")
        );
    }

    private JooqHistoryStorage(LockRepository lockRepository, HistoryRepository historyRepository) {
        this.lockRepository = lockRepository;
        this.historyRepository = historyRepository;
    }

    @Override
    public List<HistoryEntry> loadHistory() {
        lockRepository.verifyNoLockExists();
        lockRepository.lock();

        historyRepository.createTableIfNotExists();
        List<HistoryEntry> historyEntries = historyRepository.findHistory();

        lockRepository.unlock();

        return historyEntries;
    }

    @Override
    public void pushHistory(List<HistoryEntry> moreHistory) {
        lockRepository.verifyNoLockExists();
        lockRepository.lock();

        historyRepository.createTableIfNotExists();
        historyRepository.appendHistory(moreHistory);

        lockRepository.unlock();
    }

    @Override
    public void popHistory(List<HistoryEntry> lessHistory) {
        lockRepository.verifyNoLockExists();
        lockRepository.lock();

        historyRepository.createTableIfNotExists();
        historyRepository.deleteHistory(lessHistory);

        lockRepository.unlock();
    }


}