/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.jmigrate.cli;

import de.gofabian.jmigrate.HistoryEntry;
import de.gofabian.jmigrate.Migration;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

class HistoryFormatter {
    HistoryFormatter() {
    }

    String formatHistory(List<HistoryEntry> history) {
        String[] titles = new String[]{"order", "name", "applied at", "author", "description", "jmigrate"};
        return this.formatList(titles, history, this::convertHistoryEntry);
    }

    String formatMigrations(List<Migration> migrations) {
        String[] titles = new String[]{"name", "author", "description"};
        return this.formatList(titles, migrations, this::convertMigration);
    }

    private <T> String formatList(String[] titles, List<T> list, Function<T, String[]> converter) {
        int[] maxChars = new int[titles.length];
        String[][] rows = new String[list.size() + 1][];
        rows[0] = titles;
        this.collectMaxChars(maxChars, titles);
        for (int i = 0; i < list.size(); ++i) {
            T t = list.get(i);
            String[] value = converter.apply(t);
            rows[i + 1] = value;
            this.collectMaxChars(maxChars, value);
        }
        return this.formatRows(maxChars, rows);
    }

    private void collectMaxChars(int[] maxChars, String[] value) {
        for (int j = 0; j < value.length; ++j) {
            int length = value[j].length();
            if (length <= maxChars[j]) continue;
            maxChars[j] = length;
        }
    }

    private String[] convertHistoryEntry(HistoryEntry entry) {
        return new String[]{entry.getOrder() + "", entry.getMigrationName(), entry.getAppliedAt().format(DateTimeFormatter.ISO_LOCAL_DATE_TIME), entry.getAuthor(), entry.getDescription(), entry.getJmigrateVersion()};
    }

    private String[] convertMigration(Migration migration) {
        return new String[]{migration.getName(), migration.getAuthor(), migration.getDescription()};
    }

    private void appendSeparatorLine(StringBuilder result, int[] maxChars) {
        int sum = 0;
        for (int j = 0; j < maxChars.length; ++j) {
            sum += maxChars[j];
            if (j >= maxChars.length - 1) continue;
            sum += 3;
        }
        char[] line = new char[sum];
        Arrays.fill(line, '-');
        result.append(line);
        result.append('\n');
    }

    private void appendValue(StringBuilder result, int maxChars, String v) {
        result.append(v);
        int spaceCount = maxChars - v.length();
        char[] spaces = new char[spaceCount];
        Arrays.fill(spaces, ' ');
        result.append(spaces);
    }

    private void appendRow(StringBuilder builder, int[] maxChars, String[] row) {
        for (int j = 0; j < row.length; ++j) {
            this.appendValue(builder, maxChars[j], row[j]);
            if (j >= row.length - 1) continue;
            builder.append(" | ");
        }
        builder.append('\n');
    }

    private String formatRows(int[] maxChars, String[][] rows) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < rows.length; ++i) {
            this.appendRow(result, maxChars, rows[i]);
            if (i != 0) continue;
            this.appendSeparatorLine(result, maxChars);
        }
        return result.toString();
    }
}

