/*
 * Decompiled with CFR 0.152.
 */
package de.gofabian.jmigrate.cli;

import de.gofabian.jmigrate.MigrationTool;
import de.gofabian.jmigrate.cli.HistoryFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliAdapter {
    private static final Logger logger = LoggerFactory.getLogger(CliAdapter.class);
    private final HistoryFormatter historyFormatter = new HistoryFormatter();
    private final MigrationTool migrationTool;

    public CliAdapter(MigrationTool migrationTool) {
        this.migrationTool = migrationTool;
    }

    public boolean handleCommandLineArgs(String ... args) {
        if (args.length < 1) {
            return false;
        }
        switch (args[0]) {
            case "help": {
                this.help();
                return true;
            }
            case "version": {
                this.version();
                return true;
            }
            case "show": {
                this.show();
                return true;
            }
            case "validate": {
                this.validate();
                return true;
            }
            case "migrate": {
                this.migrate(args);
                return true;
            }
            case "rollback": {
                this.rollback(args);
                return true;
            }
        }
        this.help();
        return false;
    }

    private void help() {
        logger.info("Execute help\n\njmigrate command line help:\n\nexample: java -jar app.jar migrate 1\n\nmigrate    -> apply all pending migrations\nmigrate n  -> apply n pending migrations\nrollback   -> rollback 1 applied migration\nrollback n -> rollback n applied migrations\nvalidate   -> validate history and migrations\nshow       -> show history and pending migrations\nversion    -> show jmigrate version\n");
    }

    private void version() {
        logger.info("Execute version\n\nVersion: " + this.migrationTool.getVersion() + "\n");
    }

    private void show() {
        List history = this.migrationTool.getHistory();
        String message = "Found " + history.size() + " history entries\n";
        if (!history.isEmpty()) {
            message = message + "\n" + this.historyFormatter.formatHistory(history);
        }
        List migrations = this.migrationTool.getPendingMigrations();
        message = message + "\nFound " + migrations.size() + " pending migrations\n";
        if (!migrations.isEmpty()) {
            message = message + "\n" + this.historyFormatter.formatMigrations(migrations);
        }
        logger.info("Execute show\n\n" + message);
    }

    private void validate() {
        try {
            this.migrationTool.validate();
            logger.info("Execute validate\n\nValidation passed\n");
        }
        catch (Exception e) {
            logger.error("Execute validate\n\nValidation failed\n", (Throwable)e);
        }
    }

    private void migrate(String[] args) {
        if (args.length < 2) {
            logger.info("Execute migrate all");
            this.migrationTool.migrateAll();
            return;
        }
        String nString = args[1];
        logger.info("Execute migrate " + nString);
        try {
            int n = Integer.parseInt(nString);
            this.migrationTool.migrateN(n);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number of migrations: " + e.getMessage());
        }
    }

    private void rollback(String[] args) {
        if (args.length < 2) {
            logger.info("Execute rollback 1");
            this.migrationTool.rollbackN(1);
            return;
        }
        String nString = args[1];
        logger.info("Execute rollback " + nString);
        try {
            int n = Integer.parseInt(nString);
            this.migrationTool.rollbackN(n);
        }
        catch (NumberFormatException e) {
            logger.error("Invalid number of migrations: " + e.getMessage());
        }
    }
}

