/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppStatus;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b4\b\u0086\u0001\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001AB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@\u00a8\u0006B"}, d2={"Lde/gmuth/ipp/core/IppStatus;", "", "code", "", "(Ljava/lang/String;II)V", "getCode", "()I", "isClientError", "", "isServerError", "isSuccessful", "logLevel", "Ljava/util/logging/Level;", "toString", "", "SuccessfulOk", "SuccessfulOkIgnoredOrSubstitutedAttributes", "SuccessfulOkConflictingAttributes", "SuccessfulOkIgnoredSubscriptions", "SuccessfulOkTooManyEvents", "SuccessfulOkEventsComplete", "ClientErrorBadRequest", "ClientErrorForbidden", "ClientErrorNotAuthenticated", "ClientErrorNotAuthorized", "ClientErrorNotPossible", "ClientErrorTimeout", "ClientErrorNotFound", "ClientErrorGone", "ClientErrorRequestEntityTooLarge", "ClientErrorRequestValueTooLarge", "ClientErrorDocumentFormatNotSupported", "ClientErrorAttributesOrValuesNotSupported", "ClientErrorUriSchemeNotSupported", "ClientErrorCharsetNotSupported", "ClientErrorConflictingAttribute", "ClientErrorCompressionNotSupported", "ClientErrorCompressionError", "ClientErrorDocumentFormatError", "ClientErrorDocumentAccessError", "ClientErrorAttributesNotSettable", "ClientErrorIgnoredAllSubscriptions", "ClientErrorTooManySubscriptions", "ClientErrorDocumentPasswordError", "ClientErrorDocumentPermissionError", "ClientErrorDocumentSecurityError", "ClientErrorDocumentUnprintableError", "ClientErrorAccountInfoNeeded", "ClientErrorAccountClosed", "ClientErrorAccountLimitReached", "ClientErrorAccountAuthorizationFailed", "ClientErrorNotFetchable", "ServerErrorInternalError", "ServerErrorOperationNotSupported", "ServerErrorServiceUnavailable", "ServerErrorVersionNotSupported", "ServerErrorDeviceError", "ServerErrorTemporaryError", "ServerErrorNotAcceptingJobs", "ServerErrorBusy", "ServerErrorJobCanceled", "ServerErrorMultipleDocumentJobsNotSupported", "ServerErrorPrinterIsDeactivated", "ServerErrorTooManyJobs", "ServerErrorTooManyDocuments", "Companion", "ipp-client"})
public final class IppStatus
extends Enum<IppStatus> {
    @NotNull
    public static final Companion Companion;
    private final int code;
    public static final /* enum */ IppStatus SuccessfulOk;
    public static final /* enum */ IppStatus SuccessfulOkIgnoredOrSubstitutedAttributes;
    public static final /* enum */ IppStatus SuccessfulOkConflictingAttributes;
    public static final /* enum */ IppStatus SuccessfulOkIgnoredSubscriptions;
    public static final /* enum */ IppStatus SuccessfulOkTooManyEvents;
    public static final /* enum */ IppStatus SuccessfulOkEventsComplete;
    public static final /* enum */ IppStatus ClientErrorBadRequest;
    public static final /* enum */ IppStatus ClientErrorForbidden;
    public static final /* enum */ IppStatus ClientErrorNotAuthenticated;
    public static final /* enum */ IppStatus ClientErrorNotAuthorized;
    public static final /* enum */ IppStatus ClientErrorNotPossible;
    public static final /* enum */ IppStatus ClientErrorTimeout;
    public static final /* enum */ IppStatus ClientErrorNotFound;
    public static final /* enum */ IppStatus ClientErrorGone;
    public static final /* enum */ IppStatus ClientErrorRequestEntityTooLarge;
    public static final /* enum */ IppStatus ClientErrorRequestValueTooLarge;
    public static final /* enum */ IppStatus ClientErrorDocumentFormatNotSupported;
    public static final /* enum */ IppStatus ClientErrorAttributesOrValuesNotSupported;
    public static final /* enum */ IppStatus ClientErrorUriSchemeNotSupported;
    public static final /* enum */ IppStatus ClientErrorCharsetNotSupported;
    public static final /* enum */ IppStatus ClientErrorConflictingAttribute;
    public static final /* enum */ IppStatus ClientErrorCompressionNotSupported;
    public static final /* enum */ IppStatus ClientErrorCompressionError;
    public static final /* enum */ IppStatus ClientErrorDocumentFormatError;
    public static final /* enum */ IppStatus ClientErrorDocumentAccessError;
    public static final /* enum */ IppStatus ClientErrorAttributesNotSettable;
    public static final /* enum */ IppStatus ClientErrorIgnoredAllSubscriptions;
    public static final /* enum */ IppStatus ClientErrorTooManySubscriptions;
    public static final /* enum */ IppStatus ClientErrorDocumentPasswordError;
    public static final /* enum */ IppStatus ClientErrorDocumentPermissionError;
    public static final /* enum */ IppStatus ClientErrorDocumentSecurityError;
    public static final /* enum */ IppStatus ClientErrorDocumentUnprintableError;
    public static final /* enum */ IppStatus ClientErrorAccountInfoNeeded;
    public static final /* enum */ IppStatus ClientErrorAccountClosed;
    public static final /* enum */ IppStatus ClientErrorAccountLimitReached;
    public static final /* enum */ IppStatus ClientErrorAccountAuthorizationFailed;
    public static final /* enum */ IppStatus ClientErrorNotFetchable;
    public static final /* enum */ IppStatus ServerErrorInternalError;
    public static final /* enum */ IppStatus ServerErrorOperationNotSupported;
    public static final /* enum */ IppStatus ServerErrorServiceUnavailable;
    public static final /* enum */ IppStatus ServerErrorVersionNotSupported;
    public static final /* enum */ IppStatus ServerErrorDeviceError;
    public static final /* enum */ IppStatus ServerErrorTemporaryError;
    public static final /* enum */ IppStatus ServerErrorNotAcceptingJobs;
    public static final /* enum */ IppStatus ServerErrorBusy;
    public static final /* enum */ IppStatus ServerErrorJobCanceled;
    public static final /* enum */ IppStatus ServerErrorMultipleDocumentJobsNotSupported;
    public static final /* enum */ IppStatus ServerErrorPrinterIsDeactivated;
    public static final /* enum */ IppStatus ServerErrorTooManyJobs;
    public static final /* enum */ IppStatus ServerErrorTooManyDocuments;
    private static final /* synthetic */ IppStatus[] $VALUES;

    private IppStatus(int code) {
        this.code = code;
    }

    public final int getCode() {
        return this.code;
    }

    public final boolean isSuccessful() {
        int n = this.code;
        return 0 <= n ? n < 256 : false;
    }

    public final boolean isClientError() {
        int n = this.code;
        return 1024 <= n ? n < 1280 : false;
    }

    public final boolean isServerError() {
        int n = this.code;
        return 1280 <= n ? n < 1536 : false;
    }

    @NotNull
    public String toString() {
        CharSequence charSequence = this.name();
        Regex regex = new Regex("(.)([A-Z])");
        Function1 function1 = toString.1.INSTANCE;
        String string = regex.replace(charSequence, function1).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return string;
    }

    @NotNull
    public final Level logLevel() {
        Level level;
        if (this.isClientError()) {
            Level level2 = Level.WARNING;
            level = level2;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"WARNING");
        } else if (this.isServerError()) {
            Level level3 = Level.SEVERE;
            level = level3;
            Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"SEVERE");
        } else {
            Level level4 = Level.INFO;
            level = level4;
            Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"INFO");
        }
        return level;
    }

    public static IppStatus[] values() {
        return (IppStatus[])$VALUES.clone();
    }

    public static IppStatus valueOf(String value) {
        return Enum.valueOf(IppStatus.class, value);
    }

    static {
        SuccessfulOk = new IppStatus(0);
        SuccessfulOkIgnoredOrSubstitutedAttributes = new IppStatus(1);
        SuccessfulOkConflictingAttributes = new IppStatus(2);
        SuccessfulOkIgnoredSubscriptions = new IppStatus(3);
        SuccessfulOkTooManyEvents = new IppStatus(5);
        SuccessfulOkEventsComplete = new IppStatus(7);
        ClientErrorBadRequest = new IppStatus(1024);
        ClientErrorForbidden = new IppStatus(1025);
        ClientErrorNotAuthenticated = new IppStatus(1026);
        ClientErrorNotAuthorized = new IppStatus(1027);
        ClientErrorNotPossible = new IppStatus(1028);
        ClientErrorTimeout = new IppStatus(1029);
        ClientErrorNotFound = new IppStatus(1030);
        ClientErrorGone = new IppStatus(1031);
        ClientErrorRequestEntityTooLarge = new IppStatus(1032);
        ClientErrorRequestValueTooLarge = new IppStatus(1033);
        ClientErrorDocumentFormatNotSupported = new IppStatus(1034);
        ClientErrorAttributesOrValuesNotSupported = new IppStatus(1035);
        ClientErrorUriSchemeNotSupported = new IppStatus(1036);
        ClientErrorCharsetNotSupported = new IppStatus(1037);
        ClientErrorConflictingAttribute = new IppStatus(1038);
        ClientErrorCompressionNotSupported = new IppStatus(1039);
        ClientErrorCompressionError = new IppStatus(1040);
        ClientErrorDocumentFormatError = new IppStatus(1041);
        ClientErrorDocumentAccessError = new IppStatus(1042);
        ClientErrorAttributesNotSettable = new IppStatus(1043);
        ClientErrorIgnoredAllSubscriptions = new IppStatus(1044);
        ClientErrorTooManySubscriptions = new IppStatus(1045);
        ClientErrorDocumentPasswordError = new IppStatus(1048);
        ClientErrorDocumentPermissionError = new IppStatus(1049);
        ClientErrorDocumentSecurityError = new IppStatus(1050);
        ClientErrorDocumentUnprintableError = new IppStatus(1051);
        ClientErrorAccountInfoNeeded = new IppStatus(1052);
        ClientErrorAccountClosed = new IppStatus(1053);
        ClientErrorAccountLimitReached = new IppStatus(1054);
        ClientErrorAccountAuthorizationFailed = new IppStatus(1055);
        ClientErrorNotFetchable = new IppStatus(1056);
        ServerErrorInternalError = new IppStatus(1280);
        ServerErrorOperationNotSupported = new IppStatus(1281);
        ServerErrorServiceUnavailable = new IppStatus(1282);
        ServerErrorVersionNotSupported = new IppStatus(1283);
        ServerErrorDeviceError = new IppStatus(1284);
        ServerErrorTemporaryError = new IppStatus(1285);
        ServerErrorNotAcceptingJobs = new IppStatus(1286);
        ServerErrorBusy = new IppStatus(1287);
        ServerErrorJobCanceled = new IppStatus(1288);
        ServerErrorMultipleDocumentJobsNotSupported = new IppStatus(1289);
        ServerErrorPrinterIsDeactivated = new IppStatus(1290);
        ServerErrorTooManyJobs = new IppStatus(1291);
        ServerErrorTooManyDocuments = new IppStatus(1292);
        $VALUES = ippStatusArray = new IppStatus[]{IppStatus.SuccessfulOk, IppStatus.SuccessfulOkIgnoredOrSubstitutedAttributes, IppStatus.SuccessfulOkConflictingAttributes, IppStatus.SuccessfulOkIgnoredSubscriptions, IppStatus.SuccessfulOkTooManyEvents, IppStatus.SuccessfulOkEventsComplete, IppStatus.ClientErrorBadRequest, IppStatus.ClientErrorForbidden, IppStatus.ClientErrorNotAuthenticated, IppStatus.ClientErrorNotAuthorized, IppStatus.ClientErrorNotPossible, IppStatus.ClientErrorTimeout, IppStatus.ClientErrorNotFound, IppStatus.ClientErrorGone, IppStatus.ClientErrorRequestEntityTooLarge, IppStatus.ClientErrorRequestValueTooLarge, IppStatus.ClientErrorDocumentFormatNotSupported, IppStatus.ClientErrorAttributesOrValuesNotSupported, IppStatus.ClientErrorUriSchemeNotSupported, IppStatus.ClientErrorCharsetNotSupported, IppStatus.ClientErrorConflictingAttribute, IppStatus.ClientErrorCompressionNotSupported, IppStatus.ClientErrorCompressionError, IppStatus.ClientErrorDocumentFormatError, IppStatus.ClientErrorDocumentAccessError, IppStatus.ClientErrorAttributesNotSettable, IppStatus.ClientErrorIgnoredAllSubscriptions, IppStatus.ClientErrorTooManySubscriptions, IppStatus.ClientErrorDocumentPasswordError, IppStatus.ClientErrorDocumentPermissionError, IppStatus.ClientErrorDocumentSecurityError, IppStatus.ClientErrorDocumentUnprintableError, IppStatus.ClientErrorAccountInfoNeeded, IppStatus.ClientErrorAccountClosed, IppStatus.ClientErrorAccountLimitReached, IppStatus.ClientErrorAccountAuthorizationFailed, IppStatus.ClientErrorNotFetchable, IppStatus.ServerErrorInternalError, IppStatus.ServerErrorOperationNotSupported, IppStatus.ServerErrorServiceUnavailable, IppStatus.ServerErrorVersionNotSupported, IppStatus.ServerErrorDeviceError, IppStatus.ServerErrorTemporaryError, IppStatus.ServerErrorNotAcceptingJobs, IppStatus.ServerErrorBusy, IppStatus.ServerErrorJobCanceled, IppStatus.ServerErrorMultipleDocumentJobsNotSupported, IppStatus.ServerErrorPrinterIsDeactivated, IppStatus.ServerErrorTooManyJobs, IppStatus.ServerErrorTooManyDocuments};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppStatus$Companion;", "", "()V", "fromInt", "Lde/gmuth/ipp/core/IppStatus;", "code", "", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IppStatus fromInt(int code) {
            IppStatus ippStatus;
            Object[] objectArray;
            block2: {
                objectArray = IppStatus.values();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    IppStatus ippStatus2;
                    IppStatus it = ippStatus2 = objectArray[i];
                    boolean bl = false;
                    if (!(it.getCode() == code)) continue;
                    ippStatus = ippStatus2;
                    break block2;
                }
                ippStatus = null;
            }
            if (ippStatus == null) {
                String string = "Unknown status code %04X";
                objectArray = new Object[]{code};
                String string2 = String.format(string, (Object[])Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                throw new IppException(string2, null, 2, null);
            }
            return ippStatus;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

