/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.attributes.Compression;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppInputStream;
import de.gmuth.ipp.core.IppOutputStream;
import de.gmuth.ipp.core.IppTag;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 v2\u00020\u0001:\u0003tuvB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0002J\u000e\u0010J\u001a\u00020\u00102\u0006\u0010D\u001a\u00020EJ\u000e\u0010K\u001a\u00020G2\u0006\u0010L\u001a\u00020!J\u001a\u0010M\u001a\n 1*\u0004\u0018\u00010!0!2\b\b\u0002\u0010N\u001a\u00020CH\u0007J#\u0010O\u001a\u0004\u0018\u0001HP\"\u0004\b\u0000\u0010P2\u0006\u0010Q\u001a\u00020E2\u0006\u0010R\u001a\u00020\u0003\u00a2\u0006\u0002\u0010SJ\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100T2\u0006\u0010D\u001a\u00020EJ\u000e\u0010U\u001a\u00020\u00102\u0006\u0010D\u001a\u00020EJ\u0006\u0010V\u001a\u00020CJ$\u0010W\u001a\u00020G2\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010X\u001a\u00020Y2\b\b\u0002\u0010Z\u001a\u00020\u0003H\u0017J\u000e\u0010[\u001a\u00020G2\u0006\u0010\\\u001a\u00020]J\u000e\u0010[\u001a\u00020G2\u0006\u0010^\u001a\u00020'J\u000e\u0010[\u001a\u00020G2\u0006\u0010_\u001a\u00020`J\u0018\u0010a\u001a\u00020G2\u0006\u0010b\u001a\u00020]2\b\b\u0002\u0010c\u001a\u00020]J\u0018\u0010a\u001a\u00020G2\u0006\u0010d\u001a\u00020`2\b\b\u0002\u0010e\u001a\u00020`J\u000e\u0010f\u001a\u00020G2\u0006\u0010_\u001a\u00020`J\u000e\u0010g\u001a\u00020G2\u0006\u0010\\\u001a\u00020]J\u000e\u0010h\u001a\u00020G2\u0006\u0010\\\u001a\u00020]J\u000e\u0010h\u001a\u00020G2\u0006\u0010_\u001a\u00020`J\u000e\u0010i\u001a\u00020]2\u0006\u0010\\\u001a\u00020]J\u000e\u0010i\u001a\u00020G2\u0006\u0010_\u001a\u00020`J\u0018\u0010j\u001a\u00020G2\u0006\u0010\\\u001a\u00020]2\b\b\u0002\u0010k\u001a\u00020CJ\u001a\u0010j\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010k\u001a\u00020CH\u0007J\u0018\u0010j\u001a\u00020G2\u0006\u0010_\u001a\u00020`2\b\b\u0002\u0010k\u001a\u00020CJ\u000e\u0010l\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u000e\u0010m\u001a\u00020G2\u0006\u0010H\u001a\u00020IJ\u001a\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020o2\n\b\u0002\u0010q\u001a\u0004\u0018\u00010\u0003J\u001a\u0010n\u001a\u00020o2\u0006\u0010r\u001a\u00020s2\n\b\u0002\u0010q\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u000b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0019\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0016\u0010/\u001a\n 1*\u0004\u0018\u00010000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\u001bR\u0011\u00103\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b4\u0010.R\u0011\u00105\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b6\u0010.R\u001c\u00107\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010#\"\u0004\b9\u0010%R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b:\u0010\u0015\"\u0004\b;\u0010\u0017R\u0011\u0010<\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b=\u0010.R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010>\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u001b\"\u0004\b@\u0010A\u00a8\u0006w"}, d2={"Lde/gmuth/ipp/core/IppMessage;", "", "version", "", "requestId", "", "charset", "Ljava/nio/charset/Charset;", "naturalLanguage", "(Ljava/lang/String;ILjava/nio/charset/Charset;Ljava/lang/String;)V", "()V", "attributesCharset", "getAttributesCharset", "()Ljava/nio/charset/Charset;", "attributesGroups", "", "Lde/gmuth/ipp/core/IppAttributesGroup;", "getAttributesGroups", "()Ljava/util/List;", "code", "getCode", "()Ljava/lang/Integer;", "setCode", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "codeDescription", "getCodeDescription", "()Ljava/lang/String;", "compression", "Lde/gmuth/ipp/attributes/Compression;", "getCompression", "()Lde/gmuth/ipp/attributes/Compression;", "documentBytes", "", "getDocumentBytes", "()[B", "setDocumentBytes", "([B)V", "documentInputStream", "Ljava/io/InputStream;", "getDocumentInputStream", "()Ljava/io/InputStream;", "setDocumentInputStream", "(Ljava/io/InputStream;)V", "jobGroup", "getJobGroup", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getNaturalLanguage", "operationGroup", "getOperationGroup", "printerGroup", "getPrinterGroup", "rawBytes", "getRawBytes", "setRawBytes", "getRequestId", "setRequestId", "subscriptionGroup", "getSubscriptionGroup", "value", "getVersion", "setVersion", "(Ljava/lang/String;)V", "containsGroup", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "copyUnconsumedDocumentInputStream", "", "outputStream", "Ljava/io/OutputStream;", "createAttributesGroup", "decode", "byteArray", "encode", "appendDocumentIfAvailable", "getAttributeValuesOrNull", "T", "groupTag", "attributeName", "(Lde/gmuth/ipp/core/IppTag;Ljava/lang/String;)Ljava/lang/Object;", "", "getSingleAttributesGroup", "hasDocument", "log", "level", "Ljava/util/logging/Level;", "prefix", "read", "file", "Ljava/io/File;", "inputStream", "path", "Ljava/nio/file/Path;", "readBytesAndSaveText", "bytesFile", "textFile", "bytesPath", "textPath", "saveBytes", "saveBytes1", "saveDocument", "saveText", "write", "writeDocumentIfAvailable", "writeBytes", "writeDocument", "writeText", "Ljava/io/PrintWriter;", "printWriter", "title", "writer", "Ljava/io/Writer;", "ByteArraySavingInputStream", "ByteArraySavingOutputStream", "Companion", "ipp-client"})
public abstract class IppMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    @Nullable
    private Integer code;
    @Nullable
    private Integer requestId;
    @Nullable
    private String version;
    @NotNull
    private final List<IppAttributesGroup> attributesGroups;
    @Nullable
    private InputStream documentInputStream;
    @Nullable
    private byte[] rawBytes;
    @Nullable
    private byte[] documentBytes;
    private static boolean keepDocumentCopy;

    public IppMessage() {
        this.logger = Logger.getLogger(IppMessage.class.getName());
        this.attributesGroups = new ArrayList();
    }

    @Nullable
    public final Integer getCode() {
        return this.code;
    }

    public final void setCode(@Nullable Integer n) {
        this.code = n;
    }

    @Nullable
    public final Integer getRequestId() {
        return this.requestId;
    }

    public final void setRequestId(@Nullable Integer n) {
        this.requestId = n;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@Nullable String value) {
        Regex regex = new Regex("^\\d\\.\\d$");
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        if (!regex.matches((CharSequence)string)) {
            throw new IppException("Invalid version string: " + value, null, 2, null);
        }
        this.version = value;
    }

    @NotNull
    public final List<IppAttributesGroup> getAttributesGroups() {
        return this.attributesGroups;
    }

    @Nullable
    public final InputStream getDocumentInputStream() {
        return this.documentInputStream;
    }

    public final void setDocumentInputStream(@Nullable InputStream inputStream) {
        this.documentInputStream = inputStream;
    }

    @Nullable
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    public final void setRawBytes(@Nullable byte[] byArray) {
        this.rawBytes = byArray;
    }

    @Nullable
    public final byte[] getDocumentBytes() {
        return this.documentBytes;
    }

    public final void setDocumentBytes(@Nullable byte[] byArray) {
        this.documentBytes = byArray;
    }

    @NotNull
    public abstract String getCodeDescription();

    public IppMessage(@NotNull String version2, int requestId, @NotNull Charset charset, @NotNull String naturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)naturalLanguage, (String)"naturalLanguage");
        this();
        this.setVersion(version2);
        this.requestId = requestId;
        IppAttributesGroup $this$_init__u24lambda_u240 = this.createAttributesGroup(IppTag.Operation);
        boolean bl = false;
        Object[] objectArray = new Object[]{charset};
        $this$_init__u24lambda_u240.attribute("attributes-charset", IppTag.Charset, objectArray);
        objectArray = new Object[]{naturalLanguage};
        $this$_init__u24lambda_u240.attribute("attributes-natural-language", IppTag.NaturalLanguage, objectArray);
    }

    @NotNull
    public final IppAttributesGroup getOperationGroup() {
        return this.getSingleAttributesGroup(IppTag.Operation);
    }

    @NotNull
    public final IppAttributesGroup getPrinterGroup() {
        return this.getSingleAttributesGroup(IppTag.Printer);
    }

    @NotNull
    public final IppAttributesGroup getJobGroup() {
        return this.getSingleAttributesGroup(IppTag.Job);
    }

    @NotNull
    public final IppAttributesGroup getSubscriptionGroup() {
        return this.getSingleAttributesGroup(IppTag.Subscription);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppAttributesGroup> getAttributesGroups(@NotNull IppTag tag) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Iterable $this$filter$iv = this.attributesGroups;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IppAttributesGroup it = (IppAttributesGroup)element$iv$iv;
            boolean bl = false;
            if (!(it.getTag() == tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final IppAttributesGroup getSingleAttributesGroup(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        List<IppAttributesGroup> $this$getSingleAttributesGroup_u24lambda_u242 = this.getAttributesGroups(tag);
        boolean bl = false;
        if ($this$getSingleAttributesGroup_u24lambda_u242.isEmpty()) {
            throw new IppException("No group found with tag '" + (Object)((Object)tag) + "' in " + this.attributesGroups, null, 2, null);
        }
        return (IppAttributesGroup)CollectionsKt.single($this$getSingleAttributesGroup_u24lambda_u242);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsGroup(@NotNull IppTag tag) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Iterable $this$map$iv = this.attributesGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTag());
        }
        return ((List)destination$iv$iv).contains((Object)tag);
    }

    @Nullable
    public final <T> T getAttributeValuesOrNull(@NotNull IppTag groupTag, @NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)((Object)groupTag), (String)"groupTag");
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return this.containsGroup(groupTag) ? (T)this.getSingleAttributesGroup(groupTag).getValuesOrNull(attributeName) : null;
    }

    @NotNull
    public final IppAttributesGroup createAttributesGroup(@NotNull IppTag tag) {
        IppAttributesGroup ippAttributesGroup;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        IppAttributesGroup $this$createAttributesGroup_u24lambda_u244 = ippAttributesGroup = new IppAttributesGroup(tag);
        boolean bl = false;
        this.attributesGroups.add($this$createAttributesGroup_u24lambda_u244);
        return ippAttributesGroup;
    }

    public final boolean hasDocument() {
        return this.documentInputStream != null;
    }

    @NotNull
    public final Charset getAttributesCharset() {
        return (Charset)this.getOperationGroup().getValue("attributes-charset");
    }

    @NotNull
    public final String getNaturalLanguage() {
        return (String)this.getOperationGroup().getValue("attributes-natural-language");
    }

    @NotNull
    public final Compression getCompression() {
        return Compression.Companion.fromString((String)this.getOperationGroup().getValue("compression"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final void write(@NotNull OutputStream outputStream, boolean writeDocumentIfAvailable) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ByteArraySavingOutputStream byteArraySavingOutputStream = new ByteArraySavingOutputStream(outputStream);
        try {
            new IppOutputStream(byteArraySavingOutputStream).writeMessage(this);
        }
        finally {
            this.rawBytes = byteArraySavingOutputStream.getSavedBytes();
        }
        if (writeDocumentIfAvailable && this.hasDocument()) {
            OutputStream outputStreamWithCompressionSupport = this.getOperationGroup().containsKey((Object)"compression") ? this.getCompression().getCompressingOutputStream(outputStream) : outputStream;
            this.logger.fine(() -> IppMessage.write$lambda$5(outputStreamWithCompressionSupport));
            this.copyUnconsumedDocumentInputStream(outputStreamWithCompressionSupport);
            outputStreamWithCompressionSupport.close();
        }
    }

    public static /* synthetic */ void write$default(IppMessage ippMessage, OutputStream outputStream, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        ippMessage.write(outputStream, bl);
    }

    public final void write(@NotNull File file, boolean writeDocumentIfAvailable) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.write(new FileOutputStream(file), writeDocumentIfAvailable);
    }

    public static /* synthetic */ void write$default(IppMessage ippMessage, File file, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        ippMessage.write(file, bl);
    }

    public final void write(@NotNull Path path, boolean writeDocumentIfAvailable) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(path)");
        this.write(outputStream, writeDocumentIfAvailable);
    }

    public static /* synthetic */ void write$default(IppMessage ippMessage, Path path, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: write");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        ippMessage.write(path, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public final byte[] encode(boolean appendDocumentIfAvailable) {
        byte[] byArray;
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            this.write(it, appendDocumentIfAvailable);
            byArray = it.toByteArray();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byArray;
    }

    public static /* synthetic */ byte[] encode$default(IppMessage ippMessage, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: encode");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return ippMessage.encode(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArraySavingInputStream byteArraySavingInputStream = new ByteArraySavingInputStream(inputStream);
        InputStream inputStream2 = byteArraySavingInputStream;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        try {
            new IppInputStream(bufferedInputStream).readMessage(this);
            if (bufferedInputStream.available() == 0) {
                this.logger.finest(IppMessage::read$lambda$7);
            } else {
                this.documentInputStream = this.getOperationGroup().containsKey((Object)"compression") ? this.getCompression().getDecompressingInputStream(bufferedInputStream) : (InputStream)bufferedInputStream;
                this.logger.fine(() -> IppMessage.read$lambda$8(this));
            }
        }
        finally {
            this.rawBytes = byteArraySavingInputStream.getSavedBytes();
        }
    }

    public final void read(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger.finer(() -> IppMessage.read$lambda$9(file));
        this.read(new FileInputStream(file));
    }

    public final void read(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.logger.finer(() -> IppMessage.read$lambda$10(path));
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(path)");
        this.read(inputStream);
    }

    public final void decode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.logger.finer(() -> IppMessage.decode$lambda$11(byteArray));
        this.read(new ByteArrayInputStream(byteArray));
    }

    private final void copyUnconsumedDocumentInputStream(OutputStream outputStream) {
        long l;
        if (this.hasDocument()) {
            InputStream inputStream = this.documentInputStream;
            Intrinsics.checkNotNull((Object)inputStream);
            if (inputStream.available() == 0) {
                throw new IppException("documentInputStream is consumed", null, 2, null);
            }
        }
        OutputStream outputStreamWithCopySupport = keepDocumentCopy ? (OutputStream)new ByteArraySavingOutputStream(outputStream) : outputStream;
        InputStream inputStream = this.documentInputStream;
        Intrinsics.checkNotNull((Object)inputStream);
        long $this$copyUnconsumedDocumentInputStream_u24lambda_u2413 = l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStreamWithCopySupport, (int)0, (int)2, null);
        boolean bl = false;
        this.logger.finer(() -> IppMessage.copyUnconsumedDocumentInputStream$lambda$13$lambda$12($this$copyUnconsumedDocumentInputStream_u24lambda_u2413));
        if (outputStreamWithCopySupport instanceof ByteArraySavingOutputStream) {
            this.documentBytes = ((ByteArraySavingOutputStream)outputStreamWithCopySupport).getSavedBytes();
            StringBuilder stringBuilder = new StringBuilder().append("Keeping ");
            Intrinsics.checkNotNull((Object)this.documentBytes);
            this.logger.finer(stringBuilder.append(this.documentBytes.length).append(" document bytes").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeDocument(@NotNull OutputStream outputStream) {
        block7: {
            block9: {
                block8: {
                    Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
                    InputStream inputStream = this.documentInputStream;
                    Intrinsics.checkNotNull((Object)inputStream);
                    if (inputStream.available() != 0) break block7;
                    if (this.documentBytes == null) break block8;
                    Intrinsics.checkNotNull((Object)this.documentBytes);
                    if (!(this.documentBytes.length == 0)) break block9;
                }
                throw new IppException("Nothing available from documentInputStream. Enable IppMessage.keepDocumentCopy in order to keep documentBytes.", null, 2, null);
            }
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)this.documentBytes);
                it.write(this.documentBytes);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        this.copyUnconsumedDocumentInputStream(outputStream);
    }

    public final void saveDocument(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$saveDocument_u24lambda_u2416 = file;
        boolean bl = false;
        this.writeDocument(new FileOutputStream($this$saveDocument_u24lambda_u2416));
        this.logger.info(() -> IppMessage.saveDocument$lambda$16$lambda$15($this$saveDocument_u24lambda_u2416));
    }

    public final void saveDocument(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(path)");
        this.writeDocument(outputStream);
        this.logger.info(() -> IppMessage.saveDocument$lambda$17(path));
    }

    public final void writeBytes(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        if (this.rawBytes == null) {
            throw new IppException("No raw bytes to write. You must call read/decode or write/encode before.", null, 2, null);
        }
        Intrinsics.checkNotNull((Object)this.rawBytes);
        outputStream.write(this.rawBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveBytes1(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$saveBytes1_u24lambda_u2420 = file;
        boolean bl = false;
        Closeable closeable = new FileOutputStream($this$saveBytes1_u24lambda_u2420);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl2 = false;
            this.writeBytes(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info(() -> IppMessage.saveBytes1$lambda$20$lambda$19($this$saveBytes1_u24lambda_u2420));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveBytes(@NotNull Path path) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path3 = path.getParent();
        if (path3 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path4 = Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createDirectories(this, *attributes)");
        } else {
            path2 = null;
        }
        Closeable closeable = Files.newOutputStream(path, new OpenOption[0]);
        Throwable throwable = null;
        try {
            OutputStream it = (OutputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.writeBytes(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info(() -> IppMessage.saveBytes$lambda$22(path));
    }

    @NotNull
    public final PrintWriter writeText(@NotNull PrintWriter printWriter, @Nullable String title) {
        PrintWriter printWriter2;
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        PrintWriter $this$writeText_u24lambda_u2426 = printWriter2 = printWriter;
        boolean bl = false;
        String string = title;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$writeText_u24lambda_u2426.println(it);
        }
        $this$writeText_u24lambda_u2426.print("---------------------------------------------------------------------");
        if (this.rawBytes != null) {
            byte[] $this$writeText_u24lambda_u2426_u24lambda_u2424 = this.rawBytes;
            boolean bl3 = false;
            $this$writeText_u24lambda_u2426.print("" + ' ' + $this$writeText_u24lambda_u2426_u24lambda_u2424.length + " raw bytes ----------");
        }
        $this$writeText_u24lambda_u2426.println();
        $this$writeText_u24lambda_u2426.println("version " + this.version);
        $this$writeText_u24lambda_u2426.println(this.getCodeDescription());
        $this$writeText_u24lambda_u2426.println("request-id " + this.requestId);
        Iterable $this$forEach$iv = this.attributesGroups;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IppAttributesGroup it = (IppAttributesGroup)element$iv;
            boolean bl4 = false;
            IppAttributesGroup.writeText$default(it, $this$writeText_u24lambda_u2426, null, null, 6, null);
        }
        return printWriter2;
    }

    public static /* synthetic */ PrintWriter writeText$default(IppMessage ippMessage, PrintWriter printWriter, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeText");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return ippMessage.writeText(printWriter, string);
    }

    @NotNull
    public final PrintWriter writeText(@NotNull Writer writer, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        return this.writeText(new PrintWriter(writer), title);
    }

    public static /* synthetic */ PrintWriter writeText$default(IppMessage ippMessage, Writer writer, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: writeText");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return ippMessage.writeText(writer, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File saveText(@NotNull File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$saveText_u24lambda_u2429 = file2 = file;
        boolean bl = false;
        Object object = $this$saveText_u24lambda_u2429;
        Object object2 = Charsets.UTF_8;
        Object object3 = object;
        int n = 8192;
        Object object4 = object3;
        object4 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object4), (Charset)object2);
        object = new PrintWriter(object4 instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n));
        object2 = null;
        try {
            PrintWriter it = (PrintWriter)object;
            boolean bl2 = false;
            object3 = this.writeText(it, "File: " + $this$saveText_u24lambda_u2429.getName());
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        this.logger.info(() -> IppMessage.saveText$lambda$29$lambda$28($this$saveText_u24lambda_u2429));
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveText(@NotNull Path path) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path3 = path.getParent();
        if (path3 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path4 = Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createDirectories(this, *attributes)");
        } else {
            path2 = null;
        }
        Closeable closeable = Files.newBufferedWriter(path, new OpenOption[0]);
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            PrintWriter printWriter = this.writeText(it, "File: " + path.getFileName());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info(() -> IppMessage.saveText$lambda$31(path));
    }

    public final void readBytesAndSaveText(@NotNull File bytesFile, @NotNull File textFile) {
        Intrinsics.checkNotNullParameter((Object)bytesFile, (String)"bytesFile");
        Intrinsics.checkNotNullParameter((Object)textFile, (String)"textFile");
        this.read(bytesFile);
        this.saveText(textFile);
    }

    public static /* synthetic */ void readBytesAndSaveText$default(IppMessage ippMessage, File file, File file2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readBytesAndSaveText");
        }
        if ((n & 2) != 0) {
            File $this$readBytesAndSaveText_u24lambda_u2432 = file;
            boolean bl = false;
            file2 = new File($this$readBytesAndSaveText_u24lambda_u2432.getParentFile(), $this$readBytesAndSaveText_u24lambda_u2432.getName() + ".txt");
        }
        ippMessage.readBytesAndSaveText(file, file2);
    }

    public final void readBytesAndSaveText(@NotNull Path bytesPath, @NotNull Path textPath) {
        Intrinsics.checkNotNullParameter((Object)bytesPath, (String)"bytesPath");
        Intrinsics.checkNotNullParameter((Object)textPath, (String)"textPath");
        this.read(bytesPath);
        this.saveText(textPath);
    }

    public static /* synthetic */ void readBytesAndSaveText$default(IppMessage ippMessage, Path path, Path path2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readBytesAndSaveText");
        }
        if ((n & 2) != 0) {
            Path path3 = path.getParent().resolve(PathsKt.getName((Path)path) + ".txt");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"bytesPath.parent.resolve(\"${bytesPath.name}.txt\")");
            path2 = path3;
        }
        ippMessage.readBytesAndSaveText(path, path2);
    }

    @JvmOverloads
    public void log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.rawBytes != null) {
            logger.log(level, () -> IppMessage.log$lambda$33(prefix, this));
        }
        logger.log(level, () -> IppMessage.log$lambda$34(prefix, this));
        logger.log(level, () -> IppMessage.log$lambda$35(prefix, this));
        logger.log(level, () -> IppMessage.log$lambda$36(prefix, this));
        for (IppAttributesGroup group : this.attributesGroups) {
            IppAttributesGroup.log$default(group, logger, level, null, prefix, 4, null);
        }
    }

    public static /* synthetic */ void log$default(IppMessage ippMessage, Logger logger, Level level, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        ippMessage.log(logger, level, string);
    }

    @JvmOverloads
    public final void write(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        IppMessage.write$default(this, outputStream, false, 2, null);
    }

    @JvmOverloads
    public final byte[] encode() {
        return IppMessage.encode$default(this, false, 1, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppMessage.log$default(this, logger, level, null, 4, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppMessage.log$default(this, logger, null, null, 6, null);
    }

    private static final String write$lambda$5(OutputStream $outputStreamWithCompressionSupport) {
        Intrinsics.checkNotNullParameter((Object)$outputStreamWithCompressionSupport, (String)"$outputStreamWithCompressionSupport");
        return "Write document using " + $outputStreamWithCompressionSupport.getClass().getSimpleName();
    }

    private static final String read$lambda$7() {
        return "No document bytes available from bufferedInputStream after readMessage()";
    }

    private static final String read$lambda$8(IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StringBuilder stringBuilder = new StringBuilder().append("documentInputStream class: ");
        InputStream inputStream = this$0.documentInputStream;
        Intrinsics.checkNotNull((Object)inputStream);
        return stringBuilder.append(inputStream.getClass().getSimpleName()).toString();
    }

    private static final String read$lambda$9(File $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return "Read file " + $file.getAbsolutePath() + ": " + $file.length() + " bytes";
    }

    private static final String read$lambda$10(Path $path) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        return "Read path " + $path.toAbsolutePath() + ": " + Files.size($path) + " bytes";
    }

    private static final String decode$lambda$11(byte[] $byteArray) {
        Intrinsics.checkNotNullParameter((Object)$byteArray, (String)"$byteArray");
        return "Decode " + $byteArray.length + " bytes";
    }

    private static final String copyUnconsumedDocumentInputStream$lambda$13$lambda$12(long $this_apply) {
        return "Consumed documentInputStreamWithUncompressingSupport: " + $this_apply + " bytes";
    }

    private static final String saveDocument$lambda$16$lambda$15(File $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "Saved " + $this_run.length() + " document bytes to " + $this_run.getPath();
    }

    private static final String saveDocument$lambda$17(Path $path) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        return "Saved " + Files.size($path) + " document bytes to " + $path;
    }

    private static final String saveBytes1$lambda$20$lambda$19(File $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "Saved " + $this_run.getPath() + " (" + $this_run.length() + " bytes)";
    }

    private static final String saveBytes$lambda$22(Path $path) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        return "Saved " + $path + " (" + Files.size($path) + " bytes)";
    }

    private static final String saveText$lambda$29$lambda$28(File $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Saved " + $this_apply.getPath() + " (" + $this_apply.length() + " bytes)";
    }

    private static final String saveText$lambda$31(Path $path) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        return "Saved " + $path + " (" + Files.size($path) + " bytes)";
    }

    private static final String log$lambda$33(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StringBuilder stringBuilder = new StringBuilder().append($prefix);
        Intrinsics.checkNotNull((Object)this$0.rawBytes);
        return stringBuilder.append(this$0.rawBytes.length).append(" raw ipp bytes").toString();
    }

    private static final String log$lambda$34(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + "version = " + this$0.version;
    }

    private static final String log$lambda$35(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + this$0.getCodeDescription();
    }

    private static final String log$lambda$36(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + "request-id = " + this$0.requestId;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/gmuth/ipp/core/IppMessage$Companion;", "", "()V", "keepDocumentCopy", "", "getKeepDocumentCopy", "()Z", "setKeepDocumentCopy", "(Z)V", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getKeepDocumentCopy() {
            return keepDocumentCopy;
        }

        public final void setKeepDocumentCopy(boolean bl) {
            keepDocumentCopy = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/gmuth/ipp/core/IppMessage$ByteArraySavingOutputStream;", "Ljava/io/OutputStream;", "outputStream", "(Ljava/io/OutputStream;)V", "byteArrayOutputStream", "Ljava/io/ByteArrayOutputStream;", "getByteArrayOutputStream", "()Ljava/io/ByteArrayOutputStream;", "getSavedBytes", "", "write", "", "byte", "", "ipp-client"})
    private static final class ByteArraySavingOutputStream
    extends OutputStream {
        @NotNull
        private final OutputStream outputStream;
        @NotNull
        private final ByteArrayOutputStream byteArrayOutputStream;

        public ByteArraySavingOutputStream(@NotNull OutputStream outputStream) {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            this.outputStream = outputStream;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @NotNull
        public final ByteArrayOutputStream getByteArrayOutputStream() {
            return this.byteArrayOutputStream;
        }

        @NotNull
        public final byte[] getSavedBytes() {
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
            return byArray;
        }

        @Override
        public void write(int n) {
            Unit unit;
            this.outputStream.write(n);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.byteArrayOutputStream.write(n);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/gmuth/ipp/core/IppMessage$ByteArraySavingInputStream;", "Ljava/io/InputStream;", "inputStream", "(Ljava/io/InputStream;)V", "byteArrayOutputStream", "Ljava/io/ByteArrayOutputStream;", "getByteArrayOutputStream", "()Ljava/io/ByteArrayOutputStream;", "setByteArrayOutputStream", "(Ljava/io/ByteArrayOutputStream;)V", "getSavedBytes", "", "read", "", "ipp-client"})
    private static final class ByteArraySavingInputStream
    extends InputStream {
        @NotNull
        private final InputStream inputStream;
        @NotNull
        private ByteArrayOutputStream byteArrayOutputStream;

        public ByteArraySavingInputStream(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            this.inputStream = inputStream;
            this.byteArrayOutputStream = new ByteArrayOutputStream();
        }

        @NotNull
        public final ByteArrayOutputStream getByteArrayOutputStream() {
            return this.byteArrayOutputStream;
        }

        public final void setByteArrayOutputStream(@NotNull ByteArrayOutputStream byteArrayOutputStream) {
            Intrinsics.checkNotNullParameter((Object)byteArrayOutputStream, (String)"<set-?>");
            this.byteArrayOutputStream = byteArrayOutputStream;
        }

        @NotNull
        public final byte[] getSavedBytes() {
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
            return byArray;
        }

        @Override
        public int read() {
            int n;
            int it = n = this.inputStream.read();
            boolean bl = false;
            if (it != -1) {
                this.byteArrayOutputStream.write(it);
            }
            return n;
        }
    }
}

