/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppDateTime;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppInputStream;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppResolution;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u001f\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\b\b\u0002\u0010#\u001a\u00020!H\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b&J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0017\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b0J(\u00101\u001a\u00020(*\u00020\u00192\b\b\u0002\u00102\u001a\u00020\u001b2\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020(04R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00066"}, d2={"Lde/gmuth/ipp/core/IppInputStream;", "Ljava/io/DataInputStream;", "inputStream", "Ljava/io/BufferedInputStream;", "(Ljava/io/BufferedInputStream;)V", "attributesCharset", "Ljava/nio/charset/Charset;", "getAttributesCharset$ipp_client", "()Ljava/nio/charset/Charset;", "setAttributesCharset$ipp_client", "(Ljava/nio/charset/Charset;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger$ipp_client", "()Ljava/util/logging/Logger;", "readAttribute", "Lde/gmuth/ipp/core/IppAttribute;", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "readAttribute$ipp_client", "readAttributeValue", "readAttributeValue$ipp_client", "readBytes", "", "length", "", "readBytes$ipp_client", "readCollection", "Lde/gmuth/ipp/core/IppCollection;", "readCollection$ipp_client", "readExpectedValueLength", "", "expected", "throwException", "readExpectedValueLength$ipp_client", "readLengthAndValue", "readLengthAndValue$ipp_client", "readMessage", "", "message", "Lde/gmuth/ipp/core/IppMessage;", "readString", "", "charset", "readString$ipp_client", "readTag", "readTag$ipp_client", "hexdump", "maxRows", "dump", "Lkotlin/Function1;", "Companion", "ipp-client"})
public final class IppInputStream
extends DataInputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger logger;
    public Charset attributesCharset;
    private static boolean readAttribute_ignoreException;

    public IppInputStream(@NotNull BufferedInputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public final Logger getLogger$ipp_client() {
        return this.logger;
    }

    @NotNull
    public final Charset getAttributesCharset$ipp_client() {
        Charset charset = this.attributesCharset;
        if (charset != null) {
            return charset;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"attributesCharset");
        return null;
    }

    public final void setAttributesCharset$ipp_client(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.attributesCharset = charset;
    }

    public final void readMessage(@NotNull IppMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IppMessage $this$readMessage_u24lambda_u243 = message;
        boolean bl = false;
        $this$readMessage_u24lambda_u243.setVersion("" + this.readUnsignedByte() + '.' + this.readUnsignedByte());
        this.logger.finer(() -> IppInputStream.readMessage$lambda$3$lambda$0($this$readMessage_u24lambda_u243));
        $this$readMessage_u24lambda_u243.setCode(this.readUnsignedShort());
        this.logger.finer(() -> IppInputStream.readMessage$lambda$3$lambda$1($this$readMessage_u24lambda_u243));
        $this$readMessage_u24lambda_u243.setRequestId(this.readInt());
        this.logger.finer(() -> IppInputStream.readMessage$lambda$3$lambda$2($this$readMessage_u24lambda_u243));
        IppAttributesGroup currentGroup = null;
        IppAttribute<Object> currentAttribute = null;
        try {
            IppTag tag;
            do {
                tag = this.readTag$ipp_client();
                if (tag.isGroupTag()) {
                    currentGroup = message.createAttributesGroup(tag);
                    continue;
                }
                if (!tag.isValueTag()) continue;
                IppAttribute<Object> attribute = this.readAttribute$ipp_client(tag);
                this.logger.finer(() -> IppInputStream.readMessage$lambda$4(attribute));
                if (((CharSequence)attribute.getName()).length() > 0) {
                    IppAttributesGroup ippAttributesGroup = currentGroup;
                    if (ippAttributesGroup == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"currentGroup");
                        ippAttributesGroup = null;
                    }
                    ippAttributesGroup.put(attribute);
                    currentAttribute = attribute;
                    continue;
                }
                IppAttribute<Object> ippAttribute = currentAttribute;
                if (ippAttribute == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"currentAttribute");
                    ippAttribute = null;
                }
                ippAttribute.additionalValue(attribute);
            } while (tag != IppTag.End);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof EOFException)) {
                byte[] byArray;
                byte[] $this$readMessage_u24lambda_u246 = byArray = ByteStreamsKt.readBytes((InputStream)this);
                boolean bl2 = false;
                if (!($this$readMessage_u24lambda_u246.length == 0)) {
                    this.logger.warning(() -> IppInputStream.readMessage$lambda$6$lambda$5($this$readMessage_u24lambda_u246));
                    IppInputStream.hexdump$default(this, $this$readMessage_u24lambda_u246, 0, (Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ IppInputStream this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.this$0.getLogger$ipp_client().finer(() -> readMessage.3.2.invoke$lambda$0(it));
                        }

                        private static final String invoke$lambda$0(String $it) {
                            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                            return $it;
                        }
                    }, 1, null);
                }
            }
            throw new IppException("Failed to read ipp message", throwable);
        }
    }

    @NotNull
    public final IppTag readTag$ipp_client() {
        IppTag ippTag;
        IppTag $this$readTag_u24lambda_u248 = ippTag = IppTag.Companion.fromByte(this.readByte());
        boolean bl = false;
        if ($this$readTag_u24lambda_u248.isDelimiterTag()) {
            this.logger.finer(() -> IppInputStream.readTag$lambda$8$lambda$7($this$readTag_u24lambda_u248));
        }
        return ippTag;
    }

    @NotNull
    public final IppAttribute<Object> readAttribute$ipp_client(@NotNull IppTag tag) {
        IppAttribute<Object> ippAttribute;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        IppAttribute<Object> $this$readAttribute_u24lambda_u2411 = ippAttribute = new IppAttribute<Object>(IppInputStream.readString$ipp_client$default(this, null, 1, null), tag);
        boolean bl = false;
        try {
            $this$readAttribute_u24lambda_u2411.getValues().add(this.readAttributeValue$ipp_client(tag));
        }
        catch (Throwable throwable) {
            IppException ippException;
            IppException $this$readAttribute_u24lambda_u2411_u24lambda_u2410 = ippException = new IppException("Failed to read attribute value for '" + $this$readAttribute_u24lambda_u2411.getName() + "' (" + (Object)((Object)tag) + ')', throwable);
            boolean bl2 = false;
            if (readAttribute_ignoreException) {
                this.logger.warning(() -> IppInputStream.readAttribute$lambda$11$lambda$10$lambda$9($this$readAttribute_u24lambda_u2411_u24lambda_u2410));
            }
            throw $this$readAttribute_u24lambda_u2411_u24lambda_u2410;
        }
        if (Intrinsics.areEqual((Object)$this$readAttribute_u24lambda_u2411.getName(), (Object)"attributes-charset")) {
            Object t = $this$readAttribute_u24lambda_u2411.getValue();
            Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type java.nio.charset.Charset");
            this.setAttributesCharset$ipp_client((Charset)t);
        }
        return ippAttribute;
    }

    @NotNull
    public final Object readAttributeValue$ipp_client(@NotNull IppTag tag) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        switch (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 1: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 1, false, 2, null);
                object = this.readBoolean();
                break;
            }
            case 2: 
            case 3: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 4, false, 2, null);
                object = this.readInt();
                break;
            }
            case 4: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 8, false, 2, null);
                object = new IntRange(this.readInt(), this.readInt());
                break;
            }
            case 5: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 9, false, 2, null);
                object = new IppResolution(this.readInt(), this.readInt(), this.readByte());
                break;
            }
            case 6: {
                object = Charset.forName(IppInputStream.readString$ipp_client$default(this, null, 1, null));
                break;
            }
            case 7: {
                Object object2;
                String uriString = StringsKt.replace$default((String)IppInputStream.readString$ipp_client$default(this, null, 1, null), (String)" ", (String)"%20", (boolean)false, (int)4, null);
                try {
                    object2 = URI.create(uriString);
                }
                catch (Throwable throwable) {
                    this.logger.fine(() -> IppInputStream.readAttributeValue$lambda$12(tag, throwable));
                    object2 = uriString;
                }
                object = object2;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                object = IppInputStream.readString$ipp_client$default(this, null, 1, null);
                break;
            }
            case 14: 
            case 15: {
                object = new IppString(this.readString$ipp_client(this.getAttributesCharset$ipp_client()), null, 2, null);
                break;
            }
            case 16: 
            case 17: {
                this.mark(2);
                short it22 = this.readShort();
                boolean bl = false;
                if (it22 < 6) {
                    this.reset();
                }
                Object object3 = this.readString$ipp_client(this.getAttributesCharset$ipp_client());
                String it22 = this.readString$ipp_client(this.getAttributesCharset$ipp_client());
                object = new IppString(it22, (String)object3);
                break;
            }
            case 18: {
                IppInputStream.readExpectedValueLength$ipp_client$default(this, 11, false, 2, null);
                object = new IppDateTime(this.readShort(), this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte(), this.readUnsignedByte(), (char)this.readByte(), this.readUnsignedByte(), this.readUnsignedByte());
                break;
            }
            case 19: {
                if (this.readExpectedValueLength$ipp_client(0, false)) {
                    object = this.readCollection$ipp_client();
                    break;
                }
                this.logger.warning(IppInputStream::readAttributeValue$lambda$14);
                object = new IppCollection(null, 1, null);
                break;
            }
            default: {
                Object object3;
                byte[] $this$readAttributeValue_u24lambda_u2416 = object3 = this.readLengthAndValue$ipp_client();
                boolean bl = false;
                if (!($this$readAttributeValue_u24lambda_u2416.length == 0)) {
                    this.logger.finest(() -> IppInputStream.readAttributeValue$lambda$16$lambda$15($this$readAttributeValue_u24lambda_u2416, tag));
                    IppInputStream.hexdump$default(this, $this$readAttributeValue_u24lambda_u2416, 0, (Function1)new Function1<String, Unit>(this){
                        final /* synthetic */ IppInputStream this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            this.this$0.getLogger$ipp_client().finest(() -> readAttributeValue.4.2.invoke$lambda$0(it));
                        }

                        private static final String invoke$lambda$0(String $it) {
                            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                            return $it;
                        }
                    }, 1, null);
                }
                object = object3;
            }
        }
        Object object4 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"when (tag) {\n\n        Ip\u2026        }\n        }\n    }");
        return object4;
    }

    @NotNull
    public final IppCollection readCollection$ipp_client() {
        IppAttribute<Object> attribute;
        IppCollection ippCollection;
        IppCollection $this$readCollection_u24lambda_u2417 = ippCollection = new IppCollection(null, 1, null);
        boolean bl = false;
        IppAttribute<Object> currentMemberAttribute = null;
        do {
            attribute = this.readAttribute$ipp_client(this.readTag$ipp_client());
            if (attribute.getTag().isMemberAttrName()) {
                Object object = attribute.getValue();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String memberName = (String)object;
                IppAttribute<Object> firstValue = this.readAttribute$ipp_client(this.readTag$ipp_client());
                Object[] objectArray = new Object[]{firstValue.getValue()};
                currentMemberAttribute = new IppAttribute<Object>(memberName, firstValue.getTag(), objectArray);
                $this$readCollection_u24lambda_u2417.add(currentMemberAttribute);
                continue;
            }
            if (!attribute.getTag().isMemberAttrValue()) continue;
            IppAttribute<Object> ippAttribute = currentMemberAttribute;
            if (ippAttribute == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentMemberAttribute");
                ippAttribute = null;
            }
            ippAttribute.additionalValue(attribute);
        } while (attribute.getTag() != IppTag.EndCollection);
        return ippCollection;
    }

    @NotNull
    public final String readString$ipp_client(@NotNull Charset charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String it = string = new String(this.readLengthAndValue$ipp_client(), charset);
        boolean bl = false;
        this.logger.finest(() -> IppInputStream.readString$lambda$19$lambda$18(charset, it));
        return string;
    }

    public static /* synthetic */ String readString$ipp_client$default(IppInputStream ippInputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.US_ASCII;
        }
        return ippInputStream.readString$ipp_client(charset);
    }

    @NotNull
    public final byte[] readLengthAndValue$ipp_client() {
        return this.readBytes$ipp_client(this.readUnsignedShort());
    }

    @NotNull
    public final byte[] readBytes$ipp_client(int length) {
        byte[] byArray;
        byte[] $this$readBytes_u24lambda_u2420 = byArray = new byte[length];
        boolean bl = false;
        this.readFully($this$readBytes_u24lambda_u2420);
        return byArray;
    }

    public final boolean readExpectedValueLength$ipp_client(int expected, boolean throwException) {
        boolean bl;
        this.mark(2);
        int length = this.readUnsignedShort();
        boolean $this$readExpectedValueLength_u24lambda_u2423 = bl = length == expected;
        boolean bl2 = false;
        if (!$this$readExpectedValueLength_u24lambda_u2423) {
            this.reset();
            String $this$readExpectedValueLength_u24lambda_u2423_u24lambda_u2422 = "Expected value length of " + expected + " bytes but found " + length;
            boolean bl3 = false;
            if (throwException) {
                throw new IppException($this$readExpectedValueLength_u24lambda_u2423_u24lambda_u2422, null, 2, null);
            }
            this.logger.warning(() -> IppInputStream.readExpectedValueLength$lambda$23$lambda$22$lambda$21($this$readExpectedValueLength_u24lambda_u2423_u24lambda_u2422));
        }
        return bl;
    }

    public static /* synthetic */ boolean readExpectedValueLength$ipp_client$default(IppInputStream ippInputStream, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return ippInputStream.readExpectedValueLength$ipp_client(n, bl);
    }

    public final void hexdump(@NotNull byte[] $this$hexdump, int maxRows, @NotNull Function1<? super String, Unit> dump) {
        Intrinsics.checkNotNullParameter((Object)$this$hexdump, (String)"<this>");
        Intrinsics.checkNotNullParameter(dump, (String)"dump");
        StringBuilder hexStringBuilder = new StringBuilder();
        StringBuilder charStringBuilder = new StringBuilder();
        int n = $this$hexdump.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            byte b = $this$hexdump[i];
            String string = "%02X ";
            Object[] objectArray = new Object[]{b};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
            hexStringBuilder.append(string2);
            charStringBuilder.append((char)b);
            if ((index + 1) % maxRows != 0) continue;
            IppInputStream.hexdump$dumpLine(dump, maxRows, hexStringBuilder, charStringBuilder);
            StringsKt.clear((StringBuilder)hexStringBuilder);
            StringsKt.clear((StringBuilder)charStringBuilder);
        }
        if (((CharSequence)hexStringBuilder).length() > 0) {
            IppInputStream.hexdump$dumpLine(dump, maxRows, hexStringBuilder, charStringBuilder);
        }
    }

    public static /* synthetic */ void hexdump$default(IppInputStream ippInputStream, byte[] byArray, int n, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 32;
        }
        ippInputStream.hexdump(byArray, n, (Function1<? super String, Unit>)function1);
    }

    private static final String readMessage$lambda$3$lambda$0(IppMessage $this_with) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        return "version = " + $this_with.getVersion();
    }

    private static final String readMessage$lambda$3$lambda$1(IppMessage $this_with) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        return "code = " + $this_with.getCode() + " (" + $this_with.getCodeDescription() + ')';
    }

    private static final String readMessage$lambda$3$lambda$2(IppMessage $this_with) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        return "requestId = " + $this_with.getRequestId();
    }

    private static final String readMessage$lambda$4(IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return $attribute.toString();
    }

    private static final String readMessage$lambda$6$lambda$5(byte[] $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Skipped " + $this_apply.length + " unparsed bytes";
    }

    private static final String readTag$lambda$8$lambda$7(IppTag $this_apply) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this_apply), (String)"$this_apply");
        return "--- " + (Object)((Object)$this_apply) + " ---";
    }

    private static final String readAttribute$lambda$11$lambda$10$lambda$9(IppException $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Ignore exception: " + $this_apply;
    }

    private static final String readAttributeValue$lambda$12(IppTag $tag, Throwable $throwable) {
        Intrinsics.checkNotNullParameter((Object)((Object)$tag), (String)"$tag");
        Intrinsics.checkNotNullParameter((Object)$throwable, (String)"$throwable");
        return "readAttributeValue(" + (Object)((Object)$tag) + "): " + $throwable;
    }

    private static final String readAttributeValue$lambda$14() {
        return "Invalid value length for IppCollection, trying to recover";
    }

    private static final String readAttributeValue$lambda$16$lambda$15(byte[] $this_apply, IppTag $tag) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)((Object)$tag), (String)"$tag");
        return "Ignore " + $this_apply.length + " value bytes tagged '" + (Object)((Object)$tag) + '\'';
    }

    private static final String readString$lambda$19$lambda$18(Charset $charset, String $it) {
        Intrinsics.checkNotNullParameter((Object)$charset, (String)"$charset");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "readString(" + $charset + "): \"" + $it + '\"';
    }

    private static final String readExpectedValueLength$lambda$23$lambda$22$lambda$21(String $this_with) {
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        return $this_with;
    }

    private static final void hexdump$dumpLine(Function1<? super String, Unit> $dump, int $maxRows, StringBuilder hexStringBuilder, StringBuilder charStringBuilder) {
        String string = "%-" + $maxRows * 3 + "s  '%s'";
        Object[] objectArray = new Object[]{hexStringBuilder, charStringBuilder};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        $dump.invoke((Object)string2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/gmuth/ipp/core/IppInputStream$Companion;", "", "()V", "readAttribute_ignoreException", "", "getReadAttribute_ignoreException", "()Z", "setReadAttribute_ignoreException", "(Z)V", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getReadAttribute_ignoreException() {
            return readAttribute_ignoreException;
        }

        public final void setReadAttribute_ignoreException(boolean bl) {
            readAttribute_ignoreException = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IppTag.values().length];
            try {
                nArray[IppTag.Boolean.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Enum.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.RangeOfInteger.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Resolution.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Charset.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Uri.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Keyword.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.UriScheme.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.OctetString.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.MimeMediaType.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.MemberAttrName.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.NaturalLanguage.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.TextWithoutLanguage.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.NameWithoutLanguage.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.TextWithLanguage.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.NameWithLanguage.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.DateTime.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.BegCollection.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

