/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\b\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nBG\b\u0012\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\f\u0012\u0006\u0010\u0012\u001a\u00020\f\u0012\u0006\u0010\u0013\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0014BU\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\f\u0012\u0006\u0010\u0012\u001a\u00020\f\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\f\u0012\u0006\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0019J\t\u0010&\u001a\u00020\fH\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\t\u0010(\u001a\u00020\fH\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\fH\u00c6\u0003J\t\u0010+\u001a\u00020\fH\u00c6\u0003J\t\u0010,\u001a\u00020\fH\u00c6\u0003J\t\u0010-\u001a\u00020\fH\u00c6\u0003J\t\u0010.\u001a\u00020\u0016H\u00c6\u0003J\t\u0010/\u001a\u00020\fH\u00c6\u0003Jm\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\f2\b\b\u0002\u0010\u0010\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\f2\b\b\u0002\u0010\u0012\u001a\u00020\f2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\fH\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u00104\u001a\u0002052\u0006\u00104\u001a\u000205H\u0002J\r\u00106\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b7J\r\u00108\u001a\u000205H\u0000\u00a2\u0006\u0002\b9J\t\u0010:\u001a\u00020\fH\u00d6\u0001J\u0006\u0010;\u001a\u00020\u0006J\u0006\u0010<\u001a\u00020\tJ\u0006\u0010=\u001a\u000205J\u0006\u0010>\u001a\u000205J\b\u0010?\u001a\u000205H\u0016J\u0006\u0010@\u001a\u00020\u0003R\u0011\u0010\u000e\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0012\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010\u0017\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001bR\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0011\u0010\u0018\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001bR\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001b\u00a8\u0006B"}, d2={"Lde/gmuth/ipp/core/IppDateTime;", "", "zonedDateTime", "Ljava/time/ZonedDateTime;", "(Ljava/time/ZonedDateTime;)V", "calendar", "Ljava/util/Calendar;", "(Ljava/util/Calendar;)V", "date", "Ljava/util/Date;", "(Ljava/util/Date;)V", "year", "", "month", "day", "hour", "minutes", "seconds", "deciSeconds", "offsetMinutes", "(IIIIIIII)V", "directionFromUTC", "", "hoursFromUTC", "minutesFromUTC", "(IIIIIIICII)V", "getDay", "()I", "getDeciSeconds", "getDirectionFromUTC", "()C", "getHour", "getHoursFromUTC", "getMinutes", "getMinutesFromUTC", "getMonth", "getSeconds", "getYear", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "format", "", "getOffsetMinutes", "getOffsetMinutes$ipp_client", "getTimeZoneId", "getTimeZoneId$ipp_client", "hashCode", "toCalendar", "toDate", "toISO8601", "toRFC2579", "toString", "toZonedDateTime", "Companion", "ipp-client"})
public final class IppDateTime {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minutes;
    private final int seconds;
    private final int deciSeconds;
    private final char directionFromUTC;
    private final int hoursFromUTC;
    private final int minutesFromUTC;

    public IppDateTime(int year, int month, int day, int hour, int minutes, int seconds, int deciSeconds, char directionFromUTC, int hoursFromUTC, int minutesFromUTC) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minutes = minutes;
        this.seconds = seconds;
        this.deciSeconds = deciSeconds;
        this.directionFromUTC = directionFromUTC;
        this.hoursFromUTC = hoursFromUTC;
        this.minutesFromUTC = minutesFromUTC;
    }

    public final int getYear() {
        return this.year;
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getDay() {
        return this.day;
    }

    public final int getHour() {
        return this.hour;
    }

    public final int getMinutes() {
        return this.minutes;
    }

    public final int getSeconds() {
        return this.seconds;
    }

    public final int getDeciSeconds() {
        return this.deciSeconds;
    }

    public final char getDirectionFromUTC() {
        return this.directionFromUTC;
    }

    public final int getHoursFromUTC() {
        return this.hoursFromUTC;
    }

    public final int getMinutesFromUTC() {
        return this.minutesFromUTC;
    }

    @NotNull
    public String toString() {
        return this.toISO8601();
    }

    @NotNull
    public final String toRFC2579() {
        return this.format("%d-%d-%d,%d:%d:%d.%d,%c%d:%d");
    }

    @NotNull
    public final String toISO8601() {
        return this.format("%04d-%02d-%02dT%02d:%02d:%02d.%01d%c%02d:%02d");
    }

    private final String format(String format) {
        String string = format;
        Object[] objectArray = new Object[]{this.year, this.month, this.day, this.hour, this.minutes, this.seconds, this.deciSeconds, Character.valueOf(this.directionFromUTC), this.hoursFromUTC, this.minutesFromUTC};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    public IppDateTime(@NotNull ZonedDateTime zonedDateTime) {
        Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"zonedDateTime");
        this(zonedDateTime.getYear(), zonedDateTime.getMonthValue(), zonedDateTime.getDayOfMonth(), zonedDateTime.getHour(), zonedDateTime.getMinute(), zonedDateTime.getSecond(), zonedDateTime.get(ChronoField.MILLI_OF_SECOND) / 100, zonedDateTime.getZone().getRules().getOffset(zonedDateTime.toLocalDateTime()).getTotalSeconds() / 60);
    }

    @NotNull
    public final ZonedDateTime toZonedDateTime() {
        ZonedDateTime zonedDateTime = ZonedDateTime.of(LocalDateTime.of(this.year, this.month, this.day, this.hour, this.minutes, this.seconds, this.deciSeconds * 100 * 1000 * 1000), ZoneOffset.ofTotalSeconds(this.getOffsetMinutes$ipp_client() * 60));
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(\n            LocalDat\u2026Minutes() * 60)\n        )");
        return zonedDateTime;
    }

    public IppDateTime(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        this(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14) / 100, IppDateTime.Companion.dstSavingsOffsetMillis(calendar) / 1000 / 60);
    }

    @NotNull
    public final Calendar toCalendar() {
        Calendar calendar;
        Calendar $this$toCalendar_u24lambda_u240 = calendar = Calendar.getInstance();
        boolean bl = false;
        $this$toCalendar_u24lambda_u240.set(1, this.year);
        $this$toCalendar_u24lambda_u240.set(2, this.month - 1);
        $this$toCalendar_u24lambda_u240.set(5, this.day);
        $this$toCalendar_u24lambda_u240.set(11, this.hour);
        $this$toCalendar_u24lambda_u240.set(12, this.minutes);
        $this$toCalendar_u24lambda_u240.set(13, this.seconds);
        $this$toCalendar_u24lambda_u240.set(14, this.deciSeconds * 100);
        $this$toCalendar_u24lambda_u240.setTimeZone(TimeZone.getTimeZone(this.getTimeZoneId$ipp_client()));
        Calendar calendar2 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"getInstance().apply {\n  \u2026etTimeZoneId())\n        }");
        return calendar2;
    }

    /*
     * WARNING - void declaration
     */
    public IppDateTime(@NotNull Date date) {
        void $this$_init__u24lambda_u241;
        Calendar calendar;
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Calendar calendar2 = calendar = Calendar.getInstance();
        IppDateTime ippDateTime = this;
        boolean bl = false;
        $this$_init__u24lambda_u241.setTime(date);
        $this$_init__u24lambda_u241.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar3 = calendar;
        Intrinsics.checkNotNullExpressionValue((Object)calendar3, (String)"getInstance().apply {\n  \u2026Zone(\"UTC\")\n            }");
        ippDateTime(calendar3);
    }

    @NotNull
    public final Date toDate() {
        Date date = this.toCalendar().getTime();
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"toCalendar().time");
        return date;
    }

    private IppDateTime(int year, int month, int day, int hour, int minutes, int seconds, int deciSeconds, int offsetMinutes) {
        this(year, month, day, hour, minutes, seconds, deciSeconds, offsetMinutes < 0 ? (char)'-' : '+', Math.abs(offsetMinutes) / 60, Math.abs(offsetMinutes) % 60);
    }

    public final int getOffsetMinutes$ipp_client() {
        return (this.directionFromUTC == '-' ? -1 : 1) * (this.hoursFromUTC * 60 + this.minutesFromUTC);
    }

    @NotNull
    public final String getTimeZoneId$ipp_client() {
        String string = "GMT%c%02d%02d";
        Object[] objectArray = new Object[]{Character.valueOf(this.directionFromUTC), this.hoursFromUTC, this.minutesFromUTC};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    public final int component1() {
        return this.year;
    }

    public final int component2() {
        return this.month;
    }

    public final int component3() {
        return this.day;
    }

    public final int component4() {
        return this.hour;
    }

    public final int component5() {
        return this.minutes;
    }

    public final int component6() {
        return this.seconds;
    }

    public final int component7() {
        return this.deciSeconds;
    }

    public final char component8() {
        return this.directionFromUTC;
    }

    public final int component9() {
        return this.hoursFromUTC;
    }

    public final int component10() {
        return this.minutesFromUTC;
    }

    @NotNull
    public final IppDateTime copy(int year, int month, int day, int hour, int minutes, int seconds, int deciSeconds, char directionFromUTC, int hoursFromUTC, int minutesFromUTC) {
        return new IppDateTime(year, month, day, hour, minutes, seconds, deciSeconds, directionFromUTC, hoursFromUTC, minutesFromUTC);
    }

    public static /* synthetic */ IppDateTime copy$default(IppDateTime ippDateTime, int n, int n2, int n3, int n4, int n5, int n6, int n7, char c, int n8, int n9, int n10, Object object) {
        if ((n10 & 1) != 0) {
            n = ippDateTime.year;
        }
        if ((n10 & 2) != 0) {
            n2 = ippDateTime.month;
        }
        if ((n10 & 4) != 0) {
            n3 = ippDateTime.day;
        }
        if ((n10 & 8) != 0) {
            n4 = ippDateTime.hour;
        }
        if ((n10 & 0x10) != 0) {
            n5 = ippDateTime.minutes;
        }
        if ((n10 & 0x20) != 0) {
            n6 = ippDateTime.seconds;
        }
        if ((n10 & 0x40) != 0) {
            n7 = ippDateTime.deciSeconds;
        }
        if ((n10 & 0x80) != 0) {
            c = ippDateTime.directionFromUTC;
        }
        if ((n10 & 0x100) != 0) {
            n8 = ippDateTime.hoursFromUTC;
        }
        if ((n10 & 0x200) != 0) {
            n9 = ippDateTime.minutesFromUTC;
        }
        return ippDateTime.copy(n, n2, n3, n4, n5, n6, n7, c, n8, n9);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.year);
        result = result * 31 + Integer.hashCode(this.month);
        result = result * 31 + Integer.hashCode(this.day);
        result = result * 31 + Integer.hashCode(this.hour);
        result = result * 31 + Integer.hashCode(this.minutes);
        result = result * 31 + Integer.hashCode(this.seconds);
        result = result * 31 + Integer.hashCode(this.deciSeconds);
        result = result * 31 + Character.hashCode(this.directionFromUTC);
        result = result * 31 + Integer.hashCode(this.hoursFromUTC);
        result = result * 31 + Integer.hashCode(this.minutesFromUTC);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IppDateTime)) {
            return false;
        }
        IppDateTime ippDateTime = (IppDateTime)other;
        if (this.year != ippDateTime.year) {
            return false;
        }
        if (this.month != ippDateTime.month) {
            return false;
        }
        if (this.day != ippDateTime.day) {
            return false;
        }
        if (this.hour != ippDateTime.hour) {
            return false;
        }
        if (this.minutes != ippDateTime.minutes) {
            return false;
        }
        if (this.seconds != ippDateTime.seconds) {
            return false;
        }
        if (this.deciSeconds != ippDateTime.deciSeconds) {
            return false;
        }
        if (this.directionFromUTC != ippDateTime.directionFromUTC) {
            return false;
        }
        if (this.hoursFromUTC != ippDateTime.hoursFromUTC) {
            return false;
        }
        return this.minutesFromUTC == ippDateTime.minutesFromUTC;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006J\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lde/gmuth/ipp/core/IppDateTime$Companion;", "", "()V", "now", "Lde/gmuth/ipp/core/IppDateTime;", "zone", "Ljava/time/ZoneId;", "dstSavingsOffsetMillis", "", "Ljava/util/Calendar;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IppDateTime now(@NotNull ZoneId zone) {
            Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
            ZonedDateTime zonedDateTime = ZonedDateTime.now(zone);
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now(zone)");
            return new IppDateTime(zonedDateTime);
        }

        public static /* synthetic */ IppDateTime now$default(Companion companion, ZoneId zoneId, int n, Object object) {
            if ((n & 1) != 0) {
                ZoneId zoneId2 = ZoneId.systemDefault();
                Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
                zoneId = zoneId2;
            }
            return companion.now(zoneId);
        }

        private final int dstSavingsOffsetMillis(Calendar $this$dstSavingsOffsetMillis) {
            TimeZone $this$dstSavingsOffsetMillis_u24lambda_u240 = $this$dstSavingsOffsetMillis.getTimeZone();
            boolean bl = false;
            return $this$dstSavingsOffsetMillis_u24lambda_u240.getRawOffset() + ($this$dstSavingsOffsetMillis_u24lambda_u240.useDaylightTime() && $this$dstSavingsOffsetMillis_u24lambda_u240.inDaylightTime($this$dstSavingsOffsetMillis.getTime()) ? $this$dstSavingsOffsetMillis_u24lambda_u240.getDSTSavings() : 0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

