/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\"\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005B\u0019\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0004J\u0018\u0010\u0012\u001a\u00020\u00102\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0013J/\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007H\u00c6\u0003J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0016J\u001d\u0010\u001e\u001a\u00020\u00002\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001a\u0010!\u001a\b\u0012\u0004\u0012\u0002H\"0\u0004\"\u0004\b\u0000\u0010\"2\u0006\u0010\u001d\u001a\u00020\u0016J\u001c\u0010#\u001a\n\u0012\u0004\u0012\u0002H\"\u0018\u00010\u0004\"\u0004\b\u0000\u0010\"2\u0006\u0010\u001d\u001a\u00020\u0016J\u0019\u0010$\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u001d\u001a\u00020\u0016\u00a2\u0006\u0002\u0010%J\u001b\u0010&\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u001d\u001a\u00020\u0016\u00a2\u0006\u0002\u0010%J\u001a\u0010'\u001a\b\u0012\u0004\u0012\u0002H\"0\u0007\"\u0004\b\u0000\u0010\"2\u0006\u0010\u001d\u001a\u00020\u0016J\t\u0010(\u001a\u00020\fH\u00d6\u0001J\"\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u0016J\b\u00100\u001a\u00020\u0016H\u0016R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00061"}, d2={"Lde/gmuth/ipp/core/IppCollection;", "", "attributes", "", "Lde/gmuth/ipp/core/IppAttribute;", "([Lde/gmuth/ipp/core/IppAttribute;)V", "members", "", "(Ljava/util/Collection;)V", "getMembers", "()Ljava/util/Collection;", "size", "", "getSize", "()I", "add", "", "attribute", "addAll", "", "addAttribute", "name", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "values", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)Z", "component1", "containsMember", "memberName", "copy", "equals", "other", "getMember", "T", "getMemberOrNull", "getValue", "(Ljava/lang/String;)Ljava/lang/Object;", "getValueOrNull", "getValues", "hashCode", "log", "", "logger", "Ljava/util/logging/Logger;", "level", "Ljava/util/logging/Level;", "prefix", "toString", "ipp-client"})
public final class IppCollection {
    @NotNull
    private final Collection<IppAttribute<?>> members;

    public IppCollection(@NotNull Collection<IppAttribute<?>> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        this.members = members;
    }

    public /* synthetic */ IppCollection(Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            collection = new ArrayList();
        }
        this(collection);
    }

    @NotNull
    public final Collection<IppAttribute<?>> getMembers() {
        return this.members;
    }

    public IppCollection(IppAttribute<?> ... attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this(ArraysKt.toMutableList((Object[])attributes));
    }

    public final boolean addAttribute(@NotNull String name, @NotNull IppTag tag, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.add(new IppAttribute(name, tag, ArraysKt.toMutableList((Object[])values)));
    }

    public final boolean add(@NotNull IppAttribute<?> attribute) {
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        return this.members.add(attribute);
    }

    public final boolean addAll(@NotNull Collection<? extends IppAttribute<?>> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        return this.members.addAll(attributes);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsMember(@NotNull String memberName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Iterable $this$map$iv = this.members;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttribute ippAttribute = (IppAttribute)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return ((List)destination$iv$iv).contains(memberName);
    }

    @NotNull
    public final <T> IppAttribute<T> getMember(@NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        Iterable $this$single$iv = this.members;
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IppAttribute it = (IppAttribute)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)memberName)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object v0 = single$iv;
        Intrinsics.checkNotNull(v0, (String)"null cannot be cast to non-null type de.gmuth.ipp.core.IppAttribute<T of de.gmuth.ipp.core.IppCollection.getMember>");
        return v0;
    }

    @Nullable
    public final <T> IppAttribute<T> getMemberOrNull(@NotNull String memberName) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
            Iterable $this$singleOrNull$iv = this.members;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IppAttribute it = (IppAttribute)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)memberName)) continue;
                if (found$iv) {
                    v0 = null;
                    break block2;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    @NotNull
    public final <T> Collection<T> getValues(@NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getMember(memberName).getValues();
    }

    public final <T> T getValue(@NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        return this.getMember(memberName).getValue();
    }

    @Nullable
    public final <T> T getValueOrNull(@NotNull String memberName) {
        Intrinsics.checkNotNullParameter((Object)memberName, (String)"memberName");
        IppAttribute<T> ippAttribute = this.getMemberOrNull(memberName);
        return (T)(ippAttribute != null ? ippAttribute.getValue() : null);
    }

    public final int getSize() {
        return this.members.size();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.members, (CharSequence)" ", (CharSequence)"{", (CharSequence)"}", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        String string = this.toString();
        if (string.length() < 160) {
            logger.log(level, () -> IppCollection.log$lambda$3(prefix, string));
        } else {
            Iterable $this$forEach$iv = this.members;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IppAttribute member = (IppAttribute)element$iv;
                boolean bl = false;
                member.log(logger, level, prefix);
            }
        }
    }

    public static /* synthetic */ void log$default(IppCollection ippCollection, Logger logger, Level level, String string, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        ippCollection.log(logger, level, string);
    }

    @NotNull
    public final Collection<IppAttribute<?>> component1() {
        return this.members;
    }

    @NotNull
    public final IppCollection copy(@NotNull Collection<IppAttribute<?>> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        return new IppCollection(members);
    }

    public static /* synthetic */ IppCollection copy$default(IppCollection ippCollection, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            collection = ippCollection.members;
        }
        return ippCollection.copy(collection);
    }

    public int hashCode() {
        return ((Object)this.members).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IppCollection)) {
            return false;
        }
        IppCollection ippCollection = (IppCollection)other;
        return Intrinsics.areEqual(this.members, ippCollection.members);
    }

    private static final String log$lambda$3(String $prefix, String $string) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)$string, (String)"$string");
        return $prefix + $string;
    }

    public IppCollection() {
        this(null, 1, null);
    }
}

