/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppTag;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 @2&\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001j\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`\u0004:\u0001@B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00032\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015J\u000e\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0002J\u0019\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000b\u001a\u00020\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\"\u001a\u00020#J\u001b\u0010$\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0019\u0010%\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010&\u001a\u0004\u0018\u0001H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u001bJ.\u0010'\u001a\u00020(2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u00022\b\b\u0002\u0010,\u001a\u00020\u0002H\u0007J\u001e\u0010-\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u00032\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0003J\u000e\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\u0000J\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00030\u0018J\u000e\u00100\u001a\u00020(2\u0006\u00101\u001a\u000202J\u000e\u00100\u001a\u00020(2\u0006\u00103\u001a\u000204J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0002H\u0002J\u0006\u00108\u001a\u00020\u0002J\b\u00109\u001a\u00020\u0002H\u0016J\u0006\u0010:\u001a\u00020\u0002J&\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020=2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010,\u001a\u00020\u0002H\u0007J&\u0010;\u001a\u00020(2\u0006\u0010>\u001a\u00020?2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00022\b\b\u0002\u0010,\u001a\u00020\u0002H\u0007R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006A"}, d2={"Lde/gmuth/ipp/core/IppAttributesGroup;", "Ljava/util/LinkedHashMap;", "", "Lde/gmuth/ipp/core/IppAttribute;", "Lkotlin/collections/LinkedHashMap;", "tag", "Lde/gmuth/ipp/core/IppTag;", "(Lde/gmuth/ipp/core/IppTag;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "name", "getName", "()Ljava/lang/String;", "getTag", "()Lde/gmuth/ipp/core/IppTag;", "attribute", "", "values", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)Lde/gmuth/ipp/core/IppAttribute;", "", "getKeywordOrName", "getKeywordsOrNames", "", "getValue", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getValueAsDurationOfSeconds", "Ljava/time/Duration;", "getValueAsURI", "Ljava/net/URI;", "getValueAsZonedDateTime", "Ljava/time/ZonedDateTime;", "zoneId", "Ljava/time/ZoneId;", "getValueOrNull", "getValues", "getValuesOrNull", "log", "", "level", "Ljava/util/logging/Level;", "title", "prefix", "put", "attributesGroup", "removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag", "saveText", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "throwIppAttributeNotFoundException", "", "attributeName", "toCompactString", "toString", "toValuesString", "writeText", "printWriter", "Ljava/io/PrintWriter;", "writer", "Ljava/io/Writer;", "Companion", "ipp-client"})
public final class IppAttributesGroup
extends LinkedHashMap<String, IppAttribute<?>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppTag tag;
    private final Logger logger;
    @NotNull
    private final String name;
    private static boolean replaceEnabled = true;

    public IppAttributesGroup(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.tag = tag;
        this.logger = Logger.getLogger(this.getClass().getName());
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.tag.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        this.name = stringBuilder.append(string).append(" group").toString();
        if (!this.tag.isGroupTag()) {
            boolean bl = false;
            String string2 = "" + '\'' + (Object)((Object)this.tag) + "' is not a group tag";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final IppTag getTag() {
        return this.tag;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final IppAttribute<? extends Object> put(@NotNull IppAttribute<?> attribute) {
        IppAttribute<?> ippAttribute;
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        if (this.containsKey((Object)attribute.getName())) {
            if (replaceEnabled) {
                IppAttribute<?> ippAttribute2;
                IppAttribute<?> it = ippAttribute2 = this.put(attribute.getName(), attribute);
                boolean bl = false;
                this.logger.fine(() -> IppAttributesGroup.put$lambda$2$lambda$1(this, it, attribute));
                ippAttribute = ippAttribute2;
            } else {
                this.logger.fine(() -> IppAttributesGroup.put$lambda$3(attribute));
                ippAttribute = null;
            }
        } else {
            ippAttribute = this.put(attribute.getName(), attribute);
        }
        return ippAttribute;
    }

    @NotNull
    public final IppAttribute<Object> attribute(@NotNull String name, @NotNull IppTag tag, Object ... values) {
        IppAttribute<Object> ippAttribute;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        IppAttribute<Object> it = ippAttribute = new IppAttribute<Object>(name, tag, ArraysKt.toList((Object[])values));
        boolean bl = false;
        this.put(it);
        return ippAttribute;
    }

    @NotNull
    public final IppAttribute<Object> attribute(@NotNull String name, @NotNull IppTag tag, @NotNull Collection<? extends Object> values) {
        IppAttribute<Object> ippAttribute;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        IppAttribute<Object> it = ippAttribute = new IppAttribute<Object>(name, tag, values);
        boolean bl = false;
        this.put(it);
        return ippAttribute;
    }

    @Nullable
    public final <T> T getValueOrNull(@NotNull String name) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppAttribute ippAttribute = (IppAttribute)this.get((Object)name);
        if (ippAttribute != null) {
            IppAttribute $this$getValueOrNull_u24lambda_u247 = ippAttribute;
            boolean bl = false;
            if ($this$getValueOrNull_u24lambda_u247.getTag().isValueTagAndIsNotOutOfBandTag()) {
                if ($this$getValueOrNull_u24lambda_u247.getValues().size() == 1) {
                    v1 = $this$getValueOrNull_u24lambda_u247.getValue();
                } else {
                    this.logger.warning(() -> IppAttributesGroup.getValueOrNull$lambda$7$lambda$6(name, $this$getValueOrNull_u24lambda_u247));
                    v1 = null;
                }
            } else {
                v1 = null;
            }
        } else {
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final <T> T getValuesOrNull(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppAttribute ippAttribute = (IppAttribute)this.get((Object)name);
        if (ippAttribute != null) {
            IppAttribute $this$getValuesOrNull_u24lambda_u248 = ippAttribute;
            boolean bl = false;
            object = $this$getValuesOrNull_u24lambda_u248.getTag().isValueTagAndIsNotOutOfBandTag() ? (Object)$this$getValuesOrNull_u24lambda_u248.getValues() : null;
        } else {
            object = null;
        }
        return (T)object;
    }

    public final <T> T getValue(@NotNull String name) {
        IppAttribute ippAttribute;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                ippAttribute = (IppAttribute)this.get((Object)name);
                if (ippAttribute == null) break block4;
                IppAttribute $this$getValue_u24lambda_u249 = ippAttribute;
                boolean bl = false;
                if (!$this$getValue_u24lambda_u249.getTag().isValueTagAndIsNotOutOfBandTag()) {
                    throw new IppException('\'' + name + "' value is out-of-band: tag=" + (Object)((Object)$this$getValue_u24lambda_u249.getTag()), null, 2, null);
                }
                Object t = $this$getValue_u24lambda_u249.getValue();
                ippAttribute = t;
                if (t != null) break block5;
            }
            this.throwIppAttributeNotFoundException(name);
            throw new KotlinNothingValueException();
        }
        return (T)ippAttribute;
    }

    public final <T> T getValues(@NotNull String name) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                object = (IppAttribute)this.get((Object)name);
                if (object == null) break block4;
                IppAttribute $this$getValues_u24lambda_u2410 = object;
                boolean bl = false;
                if (!$this$getValues_u24lambda_u2410.getTag().isValueTagAndIsNotOutOfBandTag()) {
                    throw new IppException('\'' + name + "' values are out-of-band: tag=" + (Object)((Object)$this$getValues_u24lambda_u2410.getTag()), null, 2, null);
                }
                Object object2 = $this$getValues_u24lambda_u2410.getValues();
                object = object2;
                if (object2 != null) break block5;
            }
            this.throwIppAttributeNotFoundException(name);
            throw new KotlinNothingValueException();
        }
        return (T)object;
    }

    @NotNull
    public final URI getValueAsURI(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (URI)this.getValue(name);
    }

    @NotNull
    public final String getKeywordOrName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = (IppAttribute)this.get((Object)name);
        if (object == null || (object = ((IppAttribute)object).getKeywordOrName()) == null) {
            this.throwIppAttributeNotFoundException(name);
            throw new KotlinNothingValueException();
        }
        return object;
    }

    @NotNull
    public final List<String> getKeywordsOrNames(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = (IppAttribute)this.get((Object)name);
        if (object == null || (object = ((IppAttribute)object).getKeywordsOrNames()) == null) {
            this.throwIppAttributeNotFoundException(name);
            throw new KotlinNothingValueException();
        }
        return object;
    }

    @NotNull
    public final ZonedDateTime getValueAsZonedDateTime(@NotNull String name, @NotNull ZoneId zoneId) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        Object object = (IppAttribute)this.get((Object)name);
        ZonedDateTime zonedDateTime2 = object != null && (object = ((IppAttribute)object).getValueAsZonedDateTime()) != null ? ((ZonedDateTime)object).withZoneSameInstant(zoneId) : (zonedDateTime = null);
        if (zonedDateTime == null) {
            throw new IppException.IppAttributeNotFoundException(name, this.tag);
        }
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getValueAsZonedDateTime$default(IppAttributesGroup ippAttributesGroup, String string, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        return ippAttributesGroup.getValueAsZonedDateTime(string, zoneId);
    }

    @NotNull
    public final Duration getValueAsDurationOfSeconds(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = (IppAttribute)this.get((Object)name);
        if (object == null || (object = ((IppAttribute)object).getValueAsDurationOfSeconds()) == null) {
            this.throwIppAttributeNotFoundException(name);
            throw new KotlinNothingValueException();
        }
        return object;
    }

    private final Void throwIppAttributeNotFoundException(String attributeName) {
        throw new IppException.IppAttributeNotFoundException(attributeName, this.tag);
    }

    @NotNull
    public final List<IppAttribute<?>> removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag() {
        Iterable $this$mapTo$iv$iv;
        IppAttribute it;
        Iterable $this$filterTo$iv$iv;
        Collection<IppAttribute<?>> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IppAttribute)element$iv$iv;
            boolean bl = false;
            if (!(!it.getTag().isValueTagAndIsNotOutOfBandTag())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IppAttribute)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add((IppAttribute)this.remove((Object)it.getName()));
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = $this$mapTo$iv$iv = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (IppAttribute)element$iv;
            boolean bl2 = false;
            this.logger.finer(() -> IppAttributesGroup.removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag$lambda$14$lambda$13(this, it));
        }
        Iterable iterable2 = $this$mapTo$iv$iv;
        List $this$removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag_u24lambda_u2416 = (List)iterable2;
        boolean bl3 = false;
        if (!((Collection)$this$removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag_u24lambda_u2416).isEmpty()) {
            this.logger.fine(() -> IppAttributesGroup.removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag$lambda$16$lambda$15(this, $this$removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag_u24lambda_u2416));
        }
        return (List)iterable2;
    }

    public final void put(@NotNull IppAttributesGroup attributesGroup) {
        Intrinsics.checkNotNullParameter((Object)attributesGroup, (String)"attributesGroup");
        Collection<IppAttribute<?>> collection = attributesGroup.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"attributesGroup.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IppAttribute it = (IppAttribute)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.put(it);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.name + " (" + this.size() + " attributes)";
    }

    @NotNull
    public final String toValuesString() {
        Collection<IppAttribute<?>> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"values");
        return CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, (Function1)toValuesString.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public final String toCompactString() {
        Collection<IppAttribute<?>> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"values");
        return CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)" ", null, null, (int)0, null, (Function1)toCompactString.1.INSTANCE, (int)30, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String title, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        logger.log(level, () -> IppAttributesGroup.log$lambda$18(prefix, title));
        Set<String> set = this.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            logger.log(level, () -> IppAttributesGroup.log$lambda$20$lambda$19(prefix, this, it));
        }
    }

    public static /* synthetic */ void log$default(IppAttributesGroup ippAttributesGroup, Logger logger, Level level, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = ippAttributesGroup.toString();
        }
        if ((n & 8) != 0) {
            string2 = "";
        }
        ippAttributesGroup.log(logger, level, string, string2);
    }

    @JvmOverloads
    public final void writeText(@NotNull PrintWriter printWriter, @Nullable String title, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        PrintWriter $this$writeText_u24lambda_u2423 = printWriter;
        boolean bl = false;
        String string = title;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$writeText_u24lambda_u2423.println(it);
        }
        Collection<IppAttribute<?>> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IppAttribute it = (IppAttribute)element$iv;
            boolean bl3 = false;
            $this$writeText_u24lambda_u2423.println(prefix + it);
        }
    }

    public static /* synthetic */ void writeText$default(IppAttributesGroup ippAttributesGroup, PrintWriter printWriter, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = ippAttributesGroup.toString();
        }
        if ((n & 4) != 0) {
            string2 = "  ";
        }
        ippAttributesGroup.writeText(printWriter, string, string2);
    }

    @JvmOverloads
    public final void writeText(@NotNull Writer writer, @Nullable String title, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.writeText(new PrintWriter(writer), title, prefix);
    }

    public static /* synthetic */ void writeText$default(IppAttributesGroup ippAttributesGroup, Writer writer, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = ippAttributesGroup.toString();
        }
        if ((n & 4) != 0) {
            string2 = "  ";
        }
        ippAttributesGroup.writeText(writer, string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveText(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$saveText_u24lambda_u2426 = file;
        boolean bl = false;
        Object object = $this$saveText_u24lambda_u2426;
        Object object2 = Charsets.UTF_8;
        File file2 = object;
        int n = 8192;
        Object object3 = file2;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = new PrintWriter(object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n));
        object2 = null;
        try {
            PrintWriter it = (PrintWriter)object;
            boolean bl2 = false;
            this.writeText(it, "File: " + $this$saveText_u24lambda_u2426.getName(), "");
            file2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        this.logger.info(() -> IppAttributesGroup.saveText$lambda$26$lambda$25($this$saveText_u24lambda_u2426));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveText(@NotNull Path path) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path3 = path.getParent();
        if (path3 != null) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path4 = Files.createDirectories(path3, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path2 = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createDirectories(this, *attributes)");
        } else {
            path2 = null;
        }
        Closeable closeable = Files.newBufferedWriter(path, new OpenOption[0]);
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.writeText(it, "File: " + this.name, "");
            this.logger.info(() -> IppAttributesGroup.saveText$lambda$28$lambda$27(path));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        IppAttributesGroup.log$default(this, logger, level, title, null, 8, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this, logger, level, null, null, 12, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppAttributesGroup.log$default(this, logger, null, null, null, 14, null);
    }

    @JvmOverloads
    public final void writeText(@NotNull PrintWriter printWriter, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        IppAttributesGroup.writeText$default(this, printWriter, title, null, 4, null);
    }

    @JvmOverloads
    public final void writeText(@NotNull PrintWriter printWriter) {
        Intrinsics.checkNotNullParameter((Object)printWriter, (String)"printWriter");
        IppAttributesGroup.writeText$default(this, printWriter, null, null, 6, null);
    }

    @JvmOverloads
    public final void writeText(@NotNull Writer writer, @Nullable String title) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        IppAttributesGroup.writeText$default(this, writer, title, null, 4, null);
    }

    @JvmOverloads
    public final void writeText(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        IppAttributesGroup.writeText$default(this, writer, null, null, 6, null);
    }

    private static final String put$lambda$2$lambda$1(IppAttributesGroup this$0, IppAttribute $it, IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return this$0.name + ": '" + $it + "' replaced with '" + CollectionsKt.joinToString$default((Iterable)$attribute.getValues(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + '\'';
    }

    private static final String put$lambda$3(IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return "Ignored replacement attribute: " + $attribute;
    }

    private static final String getValueOrNull$lambda$7$lambda$6(String $name, IppAttribute $this_run) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "For '" + $name + "' one value was expected but found " + $this_run.getValues().size() + " values: " + $this_run.getValues() + " (ignoring all)";
    }

    private static final String removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag$lambda$14$lambda$13(IppAttributesGroup this$0, IppAttribute $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.name + ": Removed attribute " + $it;
    }

    private static final String removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag$lambda$16$lambda$15(IppAttributesGroup this$0, List $this_apply) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return this$0.name + ": Removed " + $this_apply.size() + " attributes  " + CollectionsKt.joinToString$default((Iterable)$this_apply, (CharSequence)",", null, null, (int)0, null, (Function1)removeAttributesWhereTagIsNotValueTagOrTagIsOutOfBandTag.4.1.1.INSTANCE, (int)30, null);
    }

    private static final String log$lambda$18(String $prefix, String $title) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        return $prefix + $title;
    }

    private static final String log$lambda$20$lambda$19(String $prefix, IppAttributesGroup this$0, String $it) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $prefix + "  " + this$0.get((Object)$it);
    }

    private static final String saveText$lambda$26$lambda$25(File $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "Saved " + $this_run.getPath();
    }

    private static final String saveText$lambda$28$lambda$27(Path $path) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        return "Saved " + $path;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/gmuth/ipp/core/IppAttributesGroup$Companion;", "", "()V", "replaceEnabled", "", "getReplaceEnabled", "()Z", "setReplaceEnabled", "(Z)V", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getReplaceEnabled() {
            return replaceEnabled;
        }

        public final void setReplaceEnabled(boolean bl) {
            replaceEnabled = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

