/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import de.gmuth.ipp.iana.IppRegistrationsSection6;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 ?*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001?B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\"\u00028\u0000\u00a2\u0006\u0002\u0010\u000bB#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\"\u00028\u0000\u00a2\u0006\u0002\u0010\fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u0000J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0006H\u00c6\u0003J#\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020%J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010%H\u00d6\u0003J\u0006\u0010)\u001a\u00020\u0004J\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+J\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\n \u0010*\u0004\u0018\u00010/0/J\t\u00100\u001a\u000201H\u00d6\u0001J\u0006\u00102\u001a\u00020'J\u0006\u00103\u001a\u00020'J\"\u00104\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u00105\u001a\u0002062\b\b\u0002\u00107\u001a\u00020\u0004J\r\u00108\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b9J\u0006\u0010:\u001a\u00020\u0004J\b\u0010;\u001a\u00020\u0004H\u0016J\u0015\u0010<\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010=J\u0006\u0010>\u001a\u00020\u0004R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006@"}, d2={"Lde/gmuth/ipp/core/IppAttribute;", "T", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "name", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "values", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;Ljava/util/Collection;)V", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "getTag", "()Lde/gmuth/ipp/core/IppTag;", "value", "getValue", "()Ljava/lang/Object;", "", "getValues", "()Ljava/util/Collection;", "additionalValue", "", "attribute", "buildIppAttribute", "printerAttributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "component1", "component2", "copy", "enumNameOrValue", "", "equals", "", "other", "getKeywordOrName", "getKeywordsOrNames", "", "getValueAsDurationOfSeconds", "Ljava/time/Duration;", "getValueAsZonedDateTime", "Ljava/time/ZonedDateTime;", "hashCode", "", "is1setOf", "isCollection", "log", "level", "Ljava/util/logging/Level;", "prefix", "requireTagKeywordOrName", "requireTagKeywordOrName$ipp_client", "toCompactString", "toString", "valueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "valuesToString", "Companion", "ipp-client"})
public final class IppAttribute<T>
implements IppAttributeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final IppTag tag;
    private final Logger logger;
    @NotNull
    private final Collection<T> values;

    public IppAttribute(@NotNull String name, @NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.name = name;
        this.tag = tag;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.values = new ArrayList();
        if (!this.tag.isValueTag()) {
            boolean bl = false;
            String string = "" + '\'' + (Object)((Object)this.tag) + "' is not a value tag";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final IppTag getTag() {
        return this.tag;
    }

    @NotNull
    public final Collection<T> getValues() {
        return this.values;
    }

    public IppAttribute(@NotNull String name, @NotNull IppTag tag, @NotNull Collection<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, tag);
        if (!values.isEmpty()) {
            Object object = CollectionsKt.first((Iterable)values);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            tag.validateValueClass(object);
        }
        this.values.addAll(values);
    }

    public IppAttribute(@NotNull String name, @NotNull IppTag tag, T ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, tag, ArraysKt.toList((Object[])values));
    }

    public IppAttribute(@NotNull String name, T ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, IppTag.NoValue, ArraysKt.toList((Object[])values));
        IppTag ippTag = IppRegistrationsSection2.INSTANCE.tagForAttribute(name);
        if (ippTag == null) {
            throw new IppException("No tag found for '" + name + '\'', null, 2, null);
        }
        IppTag tag = ippTag;
        throw new IllegalArgumentException("Use constructor with tag: IppAttribute(\"" + name + "\", IppTag." + tag.name() + ", ...)");
    }

    public final T getValue() {
        if (Intrinsics.areEqual((Object)IppRegistrationsSection2.INSTANCE.attributeIs1setOf(this.name), (Object)true)) {
            throw new IppException('\'' + this.name + "' is registered as '1setOf', use 'values' instead", null, 2, null);
        }
        if (this.values.size() > 1) {
            throw new IppException('\'' + this.name + "' has " + this.values.size() + " values, use 'values' instead", null, 2, null);
        }
        if (this.values.isEmpty()) {
            throw new IppException('\'' + this.name + "' has no values", null, 2, null);
        }
        return (T)CollectionsKt.single((Iterable)this.values);
    }

    public final void additionalValue(@NotNull IppAttribute<?> attribute) {
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        if (((CharSequence)attribute.name).length() > 0) {
            throw new IppException("For additional '" + this.name + "' values attribute name must be empty", null, 2, null);
        }
        if (attribute.values.size() != 1) {
            throw new IppException("Expected 1 additional value, not " + attribute.values.size(), null, 2, null);
        }
        if (attribute.tag != this.tag) {
            this.logger.warning(() -> IppAttribute.additionalValue$lambda$1(this, attribute));
        } else {
            IppTag ippTag = attribute.tag;
            Object object = CollectionsKt.single((Iterable)attribute.values);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            ippTag.validateValueClass(object);
            this.values.add(CollectionsKt.single((Iterable)attribute.values));
        }
    }

    public final boolean is1setOf() {
        return this.values.size() > 1 || Intrinsics.areEqual((Object)IppRegistrationsSection2.INSTANCE.attributeIs1setOf(this.name), (Object)true);
    }

    public final boolean isCollection() {
        return this.tag == IppTag.BegCollection;
    }

    public final void requireTagKeywordOrName$ipp_client() {
        IppTag[] ippTagArray = new IppTag[]{IppTag.Keyword, IppTag.NameWithoutLanguage, IppTag.NameWithLanguage};
        if (!CollectionsKt.listOf((Object[])ippTagArray).contains((Object)this.tag)) {
            boolean bl = false;
            String string = "Tag is not keyword or name: " + (Object)((Object)this.tag);
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getKeywordOrName() {
        String string;
        T t = this.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Any");
        String $this$getKeywordOrName_u24lambda_u243 = string = Companion.getStringOrIppStringText$ipp_client(t);
        boolean bl = false;
        this.requireTagKeywordOrName$ipp_client();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getKeywordsOrNames() {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Any");
            collection.add(Companion.getStringOrIppStringText$ipp_client(it));
        }
        List $this$getKeywordsOrNames_u24lambda_u245 = list = (List)destination$iv$iv;
        boolean bl = false;
        this.requireTagKeywordOrName$ipp_client();
        return list;
    }

    @NotNull
    public IppAttribute<T> buildIppAttribute(@NotNull IppAttributesGroup printerAttributes) {
        Intrinsics.checkNotNullParameter((Object)printerAttributes, (String)"printerAttributes");
        return this;
    }

    public final ZonedDateTime getValueAsZonedDateTime() {
        T t = this.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Int");
        return Instant.ofEpochSecond(((Integer)t).intValue()).atZone(ZoneOffset.UTC);
    }

    @NotNull
    public final Duration getValueAsDurationOfSeconds() {
        T t = this.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Int");
        Duration duration = Duration.ofSeconds(((Integer)t).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds((value as Int).toLong())");
        return duration;
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u246 = new StringBuilder(this.name);
        boolean bl = false;
        $this$toString_u24lambda_u246.append(" (" + (this.is1setOf() ? "1setOf " : "") + (Object)((Object)this.tag) + ") = ");
        $this$toString_u24lambda_u246.append(this.valuesToString());
        String string = $this$toString_u24lambda_u246.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(name).run \u2026\n        toString()\n    }");
        return string;
    }

    @NotNull
    public final String toCompactString() {
        return this.name + '=' + this.valuesToString();
    }

    @NotNull
    public final String valuesToString() {
        return this.values.isEmpty() ? "no-values" : CollectionsKt.joinToString$default((Iterable)this.values, (CharSequence)",", null, null, (int)0, null, (Function1)new Function1<T, CharSequence>(this){
            final /* synthetic */ IppAttribute<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(T it) {
                return IppAttribute.access$valueToString(this.this$0, it);
            }
        }, (int)30, null);
    }

    private final String valueToString(T value) {
        String string;
        if (this.tag == IppTag.Charset) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type java.nio.charset.Charset");
            Charset $this$valueToString_u24lambda_u247 = (Charset)value;
            boolean bl = false;
            String string2 = $this$valueToString_u24lambda_u247.name();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name()");
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else if (this.tag == IppTag.RangeOfInteger) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ranges.IntRange");
            IntRange $this$valueToString_u24lambda_u248 = (IntRange)value;
            boolean bl = false;
            string = "" + $this$valueToString_u24lambda_u248.getStart() + '-' + $this$valueToString_u24lambda_u248.getEndInclusive();
        } else if (this.tag == IppTag.Integer && (StringsKt.endsWith$default((String)this.name, (String)"duration", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.name, (String)"time-interval", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.name, (String)"time-out", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.name, (String)"printer-up-time", (boolean)false, (int)2, null))) {
            Duration duration = this.getValueAsDurationOfSeconds();
            string = duration.compareTo(Duration.ofDays(3650L)) > 0 ? value + " (" + this.getValueAsZonedDateTime() + ')' : value + " (" + duration + ')';
        } else if (this.tag == IppTag.Integer && (StringsKt.endsWith$default((String)this.name, (String)"time", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.name, (String)"time", (boolean)false, (int)2, null))) {
            string = value + " (" + this.getValueAsZonedDateTime() + ')';
        } else if (value instanceof byte[]) {
            T $this$valueToString_u24lambda_u249 = value;
            boolean bl = false;
            string = ((byte[])$this$valueToString_u24lambda_u249).length == 0 ? "" : ((byte[])$this$valueToString_u24lambda_u249).length + " bytes";
        } else {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Any");
            string = this.enumNameOrValue(value).toString();
        }
        return string;
    }

    @NotNull
    public final Object enumNameOrValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.tag == IppTag.Enum ? IppRegistrationsSection6.INSTANCE.getEnumName(this.name, value) : value;
    }

    @NotNull
    public final Logger log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix) {
        Logger logger2;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Logger it = logger2 = logger;
        boolean bl = false;
        String string = this.toString();
        if (string.length() < 160) {
            it.log(level, () -> IppAttribute.log$lambda$13$lambda$10(prefix, string));
        } else {
            it.log(level, () -> IppAttribute.log$lambda$13$lambda$11(prefix, this));
            for (T value : this.values) {
                if (value instanceof IppCollection) {
                    ((IppCollection)value).log(logger, level, prefix + "  ");
                    continue;
                }
                it.log(level, () -> IppAttribute.log$lambda$13$lambda$12(prefix, this, value));
            }
        }
        return logger2;
    }

    public static /* synthetic */ Logger log$default(IppAttribute ippAttribute, Logger logger, Level level, String string, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        return ippAttribute.log(logger, level, string);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final IppTag component2() {
        return this.tag;
    }

    @NotNull
    public final IppAttribute<T> copy(@NotNull String name, @NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        return new IppAttribute<T>(name, tag);
    }

    public static /* synthetic */ IppAttribute copy$default(IppAttribute ippAttribute, String string, IppTag ippTag, int n, Object object) {
        if ((n & 1) != 0) {
            string = ippAttribute.name;
        }
        if ((n & 2) != 0) {
            ippTag = ippAttribute.tag;
        }
        return ippAttribute.copy(string, ippTag);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.tag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IppAttribute)) {
            return false;
        }
        IppAttribute ippAttribute = (IppAttribute)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)ippAttribute.name)) {
            return false;
        }
        return this.tag == ippAttribute.tag;
    }

    private static final String additionalValue$lambda$1(IppAttribute this$0, IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return this$0.name + ": ignore additional value \"" + $attribute + "\" - tag is not '" + (Object)((Object)this$0.tag) + '\'';
    }

    private static final String log$lambda$13$lambda$10(String $prefix, String $string) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)$string, (String)"$string");
        return $prefix + $string;
    }

    private static final String log$lambda$13$lambda$11(String $prefix, IppAttribute this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + this$0.name + " (" + (Object)((Object)this$0.tag) + ") =";
    }

    private static final String log$lambda$13$lambda$12(String $prefix, IppAttribute this$0, Object $value) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StringBuilder stringBuilder = new StringBuilder().append($prefix).append("  ");
        Intrinsics.checkNotNull((Object)$value, (String)"null cannot be cast to non-null type kotlin.Any");
        return stringBuilder.append(this$0.enumNameOrValue($value)).toString();
    }

    public static final /* synthetic */ String access$valueToString(IppAttribute $this, Object value) {
        return $this.valueToString(value);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/core/IppAttribute$Companion;", "", "()V", "getStringOrIppStringText", "", "value", "getStringOrIppStringText$ipp_client", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getStringOrIppStringText$ipp_client(@NotNull Object value) {
            String string;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Object object = value;
            if (object instanceof String) {
                string = (String)value;
            } else if (object instanceof IppString) {
                string = ((IppString)value).getText();
            } else {
                throw new IllegalArgumentException("Expected String or IppString value but found " + value.getClass().getName());
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

