/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ6\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\b\b\u0002\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u0010\u0018\u001a\u00020\u00162\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u001c*\u00020\u0007H\u0002R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lde/gmuth/ipp/client/IppRequestExchangedEvent;", "", "requestPath", "Ljava/nio/file/Path;", "responsePath", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "request", "Lde/gmuth/ipp/core/IppRequest;", "response", "Lde/gmuth/ipp/core/IppResponse;", "(Lde/gmuth/ipp/core/IppRequest;Lde/gmuth/ipp/core/IppResponse;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getRequest", "()Lde/gmuth/ipp/core/IppRequest;", "getResponse", "()Lde/gmuth/ipp/core/IppResponse;", "save", "", "directory", "saveEvent", "", "saveDocument", "saveRawMessages", "maxFilenameLength", "", "toString", "", "getDocumentFormatFilenameExtension", "ipp-client"})
public final class IppRequestExchangedEvent {
    @NotNull
    private final IppRequest request;
    @NotNull
    private final IppResponse response;
    private final Logger logger;

    public IppRequestExchangedEvent(@NotNull IppRequest request, @NotNull IppResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.request = request;
        this.response = response;
        this.logger = Logger.getLogger(Reflection.getOrCreateKotlinClass(IppRequestExchangedEvent.class).getQualifiedName());
    }

    @NotNull
    public final IppRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final IppResponse getResponse() {
        return this.response;
    }

    /*
     * WARNING - void declaration
     */
    public IppRequestExchangedEvent(@NotNull Path requestPath, @NotNull Path responsePath) {
        void $this$_init__u24lambda_u241;
        IppMessage $this$_init__u24lambda_u240;
        IppMessage ippMessage;
        Intrinsics.checkNotNullParameter((Object)requestPath, (String)"requestPath");
        Intrinsics.checkNotNullParameter((Object)responsePath, (String)"responsePath");
        IppRequest ippRequest = ippMessage = new IppRequest(null, 1, null);
        IppRequestExchangedEvent ippRequestExchangedEvent = this;
        boolean bl = false;
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(requestPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
        $this$_init__u24lambda_u240.read(inputStream);
        IppRequest ippRequest2 = ippMessage;
        $this$_init__u24lambda_u240 = ippMessage = new IppResponse();
        IppRequest ippRequest3 = ippRequest2;
        boolean bl2 = false;
        OpenOption[] openOptionArray2 = new OpenOption[]{};
        InputStream inputStream2 = Files.newInputStream(responsePath, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"newInputStream(this, *options)");
        $this$_init__u24lambda_u241.read(inputStream2);
        Unit unit = Unit.INSTANCE;
        ippRequestExchangedEvent(ippRequest3, (IppResponse)ippMessage);
    }

    @NotNull
    public String toString() {
        String string = "#%04d %-60s = #%04d %s";
        Object[] objectArray = new Object[]{this.request.getRequestId(), this.request, this.response.getRequestId(), this.response};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Path directory, boolean saveEvent, boolean saveDocument, boolean saveRawMessages, int maxFilenameLength) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.logger.fine("Save files in " + directory);
        try {
            String string = this.request.connectionName();
            String string2 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            Path connectionDirectory = directory.resolve(StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)string2, (String)"_", (boolean)false, (int)4, null), (String)":", (String)"_", (boolean)false, (int)4, null));
            if (saveRawMessages) {
                this.logger.fine(IppRequestExchangedEvent::save$lambda$3);
                Path path = IppRequestExchangedEvent.save$fileWithExtension(connectionDirectory, this, maxFilenameLength, "req");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fileWithExtension(\"req\")");
                this.request.saveBytes(path);
                Path path2 = IppRequestExchangedEvent.save$fileWithExtension(connectionDirectory, this, maxFilenameLength, "res");
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"fileWithExtension(\"res\")");
                this.response.saveBytes(path2);
            }
            if (saveEvent) {
                Path path;
                Path $this$save_u24lambda_u247 = IppRequestExchangedEvent.save$fileWithExtension(connectionDirectory, this, maxFilenameLength, "txt");
                boolean bl = false;
                Object object = $this$save_u24lambda_u247.getParent();
                Path path3 = object;
                if (path3 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"parent");
                    FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                    Path path4 = Files.createDirectories((Path)object, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
                    path = path4;
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"createDirectories(this, *attributes)");
                } else {
                    path = null;
                }
                object = Files.newBufferedWriter($this$save_u24lambda_u247, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    Unit unit;
                    BufferedWriter it = (BufferedWriter)object;
                    boolean bl2 = false;
                    PrintWriter printWriter = new PrintWriter(it);
                    this.request.writeText(printWriter, "File: " + $this$save_u24lambda_u247);
                    IppMessage.writeText$default((IppMessage)this.response, printWriter, null, 2, null);
                    printWriter.println("---------------------------------------------------------------------");
                    String string3 = this.request.getHttpUserAgent();
                    if (string3 != null) {
                        String $this$save_u24lambda_u247_u24lambda_u246_u24lambda_u244 = string3;
                        boolean bl3 = false;
                        printWriter.println("UserAgent: " + $this$save_u24lambda_u247_u24lambda_u246_u24lambda_u244);
                    }
                    String string4 = this.response.getHttpServer();
                    if (string4 != null) {
                        String $this$save_u24lambda_u247_u24lambda_u246_u24lambda_u245 = string4;
                        boolean bl4 = false;
                        printWriter.println("Server: " + $this$save_u24lambda_u247_u24lambda_u246_u24lambda_u245);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    Unit unit2 = unit;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                this.logger.fine("Saved " + $this$save_u24lambda_u247.toAbsolutePath() + " (" + Files.size($this$save_u24lambda_u247) + " bytes)");
            }
            if (saveDocument && this.request.hasDocument()) {
                this.logger.fine(IppRequestExchangedEvent::save$lambda$8);
                IppRequest $this$save_u24lambda_u249 = this.request;
                boolean bl = false;
                String filenameExtension = $this$save_u24lambda_u249.getOperationGroup().containsKey((Object)"document-format") ? this.getDocumentFormatFilenameExtension($this$save_u24lambda_u249) : "bin";
                Path path = IppRequestExchangedEvent.save$fileWithExtension(connectionDirectory, this, maxFilenameLength, filenameExtension);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"fileWithExtension(filenameExtension)");
                this.request.saveDocument(path);
            }
        }
        catch (Throwable throwable) {
            this.logger.severe("Failed to save: " + throwable);
        }
    }

    public static /* synthetic */ void save$default(IppRequestExchangedEvent ippRequestExchangedEvent, Path path, boolean bl, boolean bl2, boolean bl3, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x10) != 0) {
            n = 200;
        }
        ippRequestExchangedEvent.save(path, bl, bl2, bl3, n);
    }

    private final String getDocumentFormatFilenameExtension(IppRequest $this$getDocumentFormatFilenameExtension) {
        return IppDocument.Companion.getDocumentFormatFilenameExtension($this$getDocumentFormatFilenameExtension.getOperationGroup());
    }

    private static final String save$filename(IppRequestExchangedEvent this$0, int $maxFilenameLength, String extension) {
        StringBuilder $this$save_u24filename_u24lambda_u242 = new StringBuilder();
        boolean bl = false;
        $this$save_u24filename_u24lambda_u242.append(DateTimeFormatter.ofPattern("HHmmssSSS").format(LocalDateTime.now()));
        String string = " #%04d";
        Object[] objectArray = new Object[]{this$0.request.getRequestId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        $this$save_u24filename_u24lambda_u242.append(string2);
        $this$save_u24filename_u24lambda_u242.append("" + ' ' + this$0.request + " = " + this$0.response);
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = $this$save_u24filename_u24lambda_u242.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString()");
        String string4 = stringBuilder.append(StringsKt.take((String)string3, (int)($maxFilenameLength - 1 - extension.length()))).append('.').append(extension).toString();
        String string5 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"separator");
        return StringsKt.replace$default((String)string4, (String)string5, (String)"_", (boolean)false, (int)4, null);
    }

    private static final Path save$fileWithExtension(Path connectionDirectory, IppRequestExchangedEvent this$0, int $maxFilenameLength, String extension) {
        return connectionDirectory.resolve(IppRequestExchangedEvent.save$filename(this$0, $maxFilenameLength, extension));
    }

    private static final String save$lambda$3() {
        return "Save raw IPP messages";
    }

    private static final String save$lambda$8() {
        return "Save document";
    }
}

