/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppTag;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lde/gmuth/ipp/client/IppOperationException;", "Lde/gmuth/ipp/client/IppExchangeException;", "request", "Lde/gmuth/ipp/core/IppRequest;", "status", "Lde/gmuth/ipp/core/IppStatus;", "message", "", "cause", "", "(Lde/gmuth/ipp/core/IppRequest;Lde/gmuth/ipp/core/IppStatus;Ljava/lang/String;Ljava/lang/Throwable;)V", "response", "Lde/gmuth/ipp/core/IppResponse;", "(Lde/gmuth/ipp/core/IppRequest;Lde/gmuth/ipp/core/IppResponse;Ljava/lang/String;Ljava/lang/Throwable;)V", "getResponse", "()Lde/gmuth/ipp/core/IppResponse;", "log", "", "logger", "Ljava/util/logging/Logger;", "level", "Ljava/util/logging/Level;", "saveMessages", "directory", "Ljava/nio/file/Path;", "fileNameWithoutSuffix", "statusIs", "", "ClientErrorNotFoundException", "Companion", "ipp-client"})
public class IppOperationException
extends IppExchangeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppResponse response;

    public IppOperationException(@NotNull IppRequest request, @NotNull IppResponse response, @NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super(request, message, cause);
        this.response = response;
    }

    public /* synthetic */ IppOperationException(IppRequest ippRequest, IppResponse ippResponse, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = Companion.defaultMessage(ippRequest, ippResponse);
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        this(ippRequest, ippResponse, string, throwable);
    }

    @NotNull
    public final IppResponse getResponse() {
        return this.response;
    }

    public IppOperationException(@NotNull IppRequest request, @NotNull IppStatus status, @NotNull String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Integer n = request.getRequestId();
        Throwable throwable = cause;
        this(request, new IppResponse(status, n != null ? n : 9999, message + ": " + (throwable != null ? throwable.getMessage() : null), null, 8, null), message, cause);
    }

    public /* synthetic */ IppOperationException(IppRequest ippRequest, IppStatus ippStatus, String string, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        this(ippRequest, ippStatus, string, throwable);
    }

    public final boolean statusIs(@NotNull IppStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        return this.response.getStatus() == status;
    }

    @Override
    public void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Logger $this$log_u24lambda_u240 = logger;
        boolean bl = false;
        super.log(logger, level);
        this.response.log($this$log_u24lambda_u240, level, "RESPONSE: ");
    }

    @Override
    public void saveMessages(@NotNull Path directory, @NotNull String fileNameWithoutSuffix) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileNameWithoutSuffix, (String)"fileNameWithoutSuffix");
        IppRequest ippRequest = this.getRequest();
        Path path = directory.resolve(fileNameWithoutSuffix + ".req");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"directory.resolve(\"$fileNameWithoutSuffix.req\")");
        ippRequest.saveBytes(path);
        Path path2 = directory.resolve(fileNameWithoutSuffix + ".res");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"directory.resolve(\"$fileNameWithoutSuffix.res\")");
        this.response.saveBytes(path2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/client/IppOperationException$ClientErrorNotFoundException;", "Lde/gmuth/ipp/client/IppOperationException;", "request", "Lde/gmuth/ipp/core/IppRequest;", "response", "Lde/gmuth/ipp/core/IppResponse;", "(Lde/gmuth/ipp/core/IppRequest;Lde/gmuth/ipp/core/IppResponse;)V", "ipp-client"})
    public static final class ClientErrorNotFoundException
    extends IppOperationException {
        public ClientErrorNotFoundException(@NotNull IppRequest request, @NotNull IppResponse response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            super(request, response, null, null, 12, null);
            if (!(response.getStatus() == IppStatus.ClientErrorNotFound)) {
                boolean bl = false;
                String string = "IPP response status is not ClientErrorNotFound: " + (Object)((Object)response.getStatus());
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lde/gmuth/ipp/client/IppOperationException$Companion;", "", "()V", "defaultMessage", "", "request", "Lde/gmuth/ipp/core/IppRequest;", "response", "Lde/gmuth/ipp/core/IppResponse;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String defaultMessage(@NotNull IppRequest request, @NotNull IppResponse response) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            StringBuilder $this$defaultMessage_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$defaultMessage_u24lambda_u241.append((Object)((Object)request.getOperation()) + " failed");
            IppResponse $this$defaultMessage_u24lambda_u241_u24lambda_u240 = response;
            boolean bl2 = false;
            $this$defaultMessage_u24lambda_u241.append(": '" + (Object)((Object)$this$defaultMessage_u24lambda_u241_u24lambda_u240.getStatus()) + '\'');
            if ($this$defaultMessage_u24lambda_u241_u24lambda_u240.containsGroup(IppTag.Operation) && $this$defaultMessage_u24lambda_u241_u24lambda_u240.getOperationGroup().containsKey((Object)"status-message")) {
                $this$defaultMessage_u24lambda_u241.append(", " + $this$defaultMessage_u24lambda_u241_u24lambda_u240.getStatusMessage());
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026   }\n        }.toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

