/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.attributes.DocumentFormat;
import de.gmuth.ipp.attributes.JobState;
import de.gmuth.ipp.client.HttpPostException;
import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00a5\u00012\u00020\u0001:\u0002\u00a5\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010W\u001a\u00020\u00052\n\b\u0002\u0010X\u001a\u0004\u0018\u00010\u000bH\u0007J\u0006\u0010Y\u001a\u00020\u0005J\u001a\u0010Z\u001a\u00020?2\u0010\b\u0002\u0010[\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;H\u0007J\u0012\u0010\\\u001a\u00020]2\b\b\u0002\u0010^\u001a\u00020\u0017H\u0007J.\u0010_\u001a\b\u0012\u0004\u0012\u00020]0;2\b\b\u0002\u0010`\u001a\u00020O2\b\b\u0002\u0010a\u001a\u00020b2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010\u000bH\u0007J\u000e\u0010d\u001a\u00020\u00052\u0006\u0010e\u001a\u00020\u0003J\u000e\u0010d\u001a\u00020\u00052\u0006\u00102\u001a\u000203J6\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\u0006\u0010j\u001a\u00020O2\b\u0010k\u001a\u0004\u0018\u00010\u000b2\b\u0010l\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010mH\u0002J\u0010\u0010n\u001a\u00020\u00052\u0006\u0010o\u001a\u00020gH\u0002J\u001f\u0010p\u001a\u00020\b2\u0012\u0010q\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0r\"\u00020\u000b\u00a2\u0006\u0002\u0010sJ\u001a\u0010p\u001a\u00020\b2\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;H\u0007J\b\u0010u\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010v\u001a\u00020\u0017J\b\u0010w\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010x\u001a\u00020\u0005J\"\u0010y\u001a\u00020g2\u0006\u0010h\u001a\u00020i2\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;H\u0002J\u0012\u0010z\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u0012\u0010|\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u0012\u0010}\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u0006\u0010~\u001a\u00020OJ\u0012\u0010\u007f\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u0007\u0010\u0080\u0001\u001a\u00020OJ\u0013\u0010\u0081\u0001\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u0013\u0010\u0082\u0001\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u0007\u0010\u0083\u0001\u001a\u00020OJ\u0013\u0010\u0084\u0001\u001a\u00020O2\b\b\u0002\u0010{\u001a\u00020OH\u0007J\u001e\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010\u0087\u0001\u001a\u00030\u0088\u0001H\u0007J\u0007\u0010\u0089\u0001\u001a\u00020\u0005J\u0007\u0010\u008a\u0001\u001a\u00020OJ\u0007\u0010\u008b\u0001\u001a\u00020\u0005J\u0007\u0010\u008c\u0001\u001a\u00020\u0005JB\u0010\u008d\u0001\u001a\u00030\u0086\u00012\b\u0010\u008e\u0001\u001a\u00030\u008f\u00012\b\b\u0002\u0010j\u001a\u00020O2\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010l\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010mH\u0007JB\u0010\u008d\u0001\u001a\u00030\u0086\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u00012\b\b\u0002\u0010j\u001a\u00020O2\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010l\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010mH\u0007JA\u0010\u008d\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0092\u0001\u001a\u00020b2\b\b\u0002\u0010j\u001a\u00020O2\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010l\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010mH\u0007JA\u0010\u0093\u0001\u001a\u00030\u0086\u00012\u0007\u0010\u0094\u0001\u001a\u0002032\b\b\u0002\u0010j\u001a\u00020O2\n\b\u0002\u0010k\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010l\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010mH\u0007J\u001a\u0010\u0095\u0001\u001a\u00020O2\u0006\u0010{\u001a\u00020O2\u0007\u0010\u0096\u0001\u001a\u000207H\u0002J\u0010\u0010\u0097\u0001\u001a\u00020O2\u0007\u0010\u0098\u0001\u001a\u00020\u000bJ\t\u0010\u0099\u0001\u001a\u00020\u000bH\u0016J\"\u0010\u009a\u0001\u001a\u00030\u0086\u00012\u0012\u0010t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0r\"\u00020\u000b\u00a2\u0006\u0003\u0010\u009b\u0001J\u001c\u0010\u009a\u0001\u001a\u00030\u0086\u00012\u0010\b\u0002\u0010t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;H\u0007J2\u0010\u009c\u0001\u001a\u00030\u0086\u00012\n\b\u0002\u0010\u009d\u0001\u001a\u00030\u009e\u00012\f\b\u0002\u0010\u009f\u0001\u001a\u0005\u0018\u00010\u0088\u00012\f\b\u0002\u0010\u00a0\u0001\u001a\u0005\u0018\u00010\u0088\u0001H\u0007J&\u0010\u00a1\u0001\u001a\u000f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00a2\u0001*\u00020\b2\n\u0010\u00a3\u0001\u001a\u0005\u0018\u00010\u00a4\u0001H\u0002R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u0011\u0010#\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0015R\u0011\u0010%\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0011\u0010'\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0015R\u0011\u0010)\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0015R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010GR\u0011\u0010J\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010GR\u0011\u0010L\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bM\u00105R\u001a\u0010N\u001a\u00020OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u001a\u0010T\u001a\u00020OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010Q\"\u0004\bV\u0010S\u00a8\u0006\u00a6\u0001"}, d2={"Lde/gmuth/ipp/client/IppJob;", "", "printer", "Lde/gmuth/ipp/client/IppPrinter;", "response", "Lde/gmuth/ipp/core/IppResponse;", "(Lde/gmuth/ipp/client/IppPrinter;Lde/gmuth/ipp/core/IppResponse;)V", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "(Lde/gmuth/ipp/client/IppPrinter;Lde/gmuth/ipp/core/IppAttributesGroup;)V", "appleJobOwner", "", "getAppleJobOwner", "()Ljava/lang/String;", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "documentFormat", "getDocumentFormat", "documentNameSupplied", "Lde/gmuth/ipp/core/IppString;", "getDocumentNameSupplied", "()Lde/gmuth/ipp/core/IppString;", "id", "", "getId", "()I", "impressionsCompleted", "getImpressionsCompleted", "kOctets", "getKOctets", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mediaSheetsCompleted", "getMediaSheetsCompleted", "name", "getName", "numberOfDocuments", "getNumberOfDocuments", "originatingHostName", "getOriginatingHostName", "originatingUserName", "getOriginatingUserName", "pageRanges", "", "Lkotlin/ranges/IntRange;", "getPageRanges", "()Ljava/util/Collection;", "getPrinter", "()Lde/gmuth/ipp/client/IppPrinter;", "printerUri", "Ljava/net/URI;", "getPrinterUri", "()Ljava/net/URI;", "state", "Lde/gmuth/ipp/attributes/JobState;", "getState", "()Lde/gmuth/ipp/attributes/JobState;", "stateReasons", "", "getStateReasons", "()Ljava/util/List;", "subscription", "Lde/gmuth/ipp/client/IppSubscription;", "getSubscription", "()Lde/gmuth/ipp/client/IppSubscription;", "setSubscription", "(Lde/gmuth/ipp/client/IppSubscription;)V", "timeAtCompleted", "Ljava/time/ZonedDateTime;", "getTimeAtCompleted", "()Ljava/time/ZonedDateTime;", "timeAtCreation", "getTimeAtCreation", "timeAtProcessing", "getTimeAtProcessing", "uri", "getUri", "useJobOwnerAsUserName", "", "getUseJobOwnerAsUserName", "()Z", "setUseJobOwnerAsUserName", "(Z)V", "useJobUri", "getUseJobUri", "setUseJobUri", "cancel", "messageForOperator", "close", "createJobSubscription", "notifyEvents", "cupsGetDocument", "Lde/gmuth/ipp/client/IppDocument;", "documentNumber", "cupsGetDocuments", "save", "directory", "Ljava/nio/file/Path;", "optionalCommandToHandleFile", "cupsMoveJob", "ippPrinter", "documentRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "Lde/gmuth/ipp/core/IppOperation;", "lastDocument", "documentName", "documentNaturalLanguage", "Lde/gmuth/ipp/attributes/DocumentFormat;", "exchange", "request", "getJobAttributes", "requestedAttribute", "", "([Ljava/lang/String;)Lde/gmuth/ipp/core/IppAttributesGroup;", "requestedAttributes", "getJobNameOrDocumentNameSuppliedOrAppleJobNameOrNull", "getNumberOfDocumentsOrDocumentCount", "getOriginatingUserNameOrAppleJobOwnerOrNull", "hold", "ippRequest", "isAborted", "updateStateAttributes", "isCanceled", "isCompleted", "isIncoming", "isPending", "isPrinterStopped", "isProcessing", "isProcessingStopped", "isProcessingToStopPoint", "isTerminated", "log", "", "level", "Ljava/util/logging/Level;", "release", "resourcesAreNotReady", "restart", "resubmit", "sendDocument", "file", "Ljava/io/File;", "inputStream", "Ljava/io/InputStream;", "path", "sendUri", "documentUri", "stateIs", "expectedState", "stateReasonsContain", "reason", "toString", "updateAttributes", "([Ljava/lang/String;)V", "waitForTermination", "delay", "Ljava/time/Duration;", "jobProgressLogLevel", "printerStateLogLevel", "put", "Lde/gmuth/ipp/core/IppAttribute;", "attributeBuilder", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "Companion", "ipp-client"})
public final class IppJob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppPrinter printer;
    @NotNull
    private final IppAttributesGroup attributes;
    private final Logger logger;
    @Nullable
    private IppSubscription subscription;
    private boolean useJobOwnerAsUserName;
    private boolean useJobUri;
    @NotNull
    private static Duration defaultDelay;

    public IppJob(@NotNull IppPrinter printer, @NotNull IppAttributesGroup attributes) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.printer = printer;
        this.attributes = attributes;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @NotNull
    public final IppPrinter getPrinter() {
        return this.printer;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    @Nullable
    public final IppSubscription getSubscription() {
        return this.subscription;
    }

    public final void setSubscription(@Nullable IppSubscription ippSubscription) {
        this.subscription = ippSubscription;
    }

    public IppJob(@NotNull IppPrinter printer, @NotNull IppResponse response) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this(printer, response.getJobGroup());
        if (response.getStatus() != IppStatus.SuccessfulOk) {
            this.logger.warning(() -> IppJob._init_$lambda$0(response));
        }
        if (response.containsGroup(IppTag.Subscription)) {
            this.subscription = new IppSubscription(printer, response.getSubscriptionGroup(), false, 4, null);
        }
    }

    public final boolean getUseJobOwnerAsUserName() {
        return this.useJobOwnerAsUserName;
    }

    public final void setUseJobOwnerAsUserName(boolean bl) {
        this.useJobOwnerAsUserName = bl;
    }

    public final boolean getUseJobUri() {
        return this.useJobUri;
    }

    public final void setUseJobUri(boolean bl) {
        this.useJobUri = bl;
    }

    public final int getId() {
        return ((Number)this.attributes.getValue("job-id")).intValue();
    }

    @NotNull
    public final URI getUri() {
        return (URI)this.attributes.getValue("job-uri");
    }

    @NotNull
    public final URI getPrinterUri() {
        return (URI)this.attributes.getValue("job-printer-uri");
    }

    @NotNull
    public final JobState getState() {
        return JobState.Companion.fromAttributes(this.attributes);
    }

    @NotNull
    public final List<String> getStateReasons() {
        return (List)this.attributes.getValues("job-state-reasons");
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("job-name");
    }

    @NotNull
    public final IppString getOriginatingUserName() {
        return (IppString)this.attributes.getValue("job-originating-user-name");
    }

    @NotNull
    public final IppString getOriginatingHostName() {
        return (IppString)this.attributes.getValue("job-originating-host-name");
    }

    public final int getImpressionsCompleted() {
        return ((Number)this.attributes.getValue("job-impressions-completed")).intValue();
    }

    public final int getMediaSheetsCompleted() {
        return ((Number)this.attributes.getValue("job-media-sheets-completed")).intValue();
    }

    public final int getKOctets() {
        return ((Number)this.attributes.getValue("job-k-octets")).intValue();
    }

    @NotNull
    public final Collection<IntRange> getPageRanges() {
        return (Collection)this.attributes.getValues("page-ranges");
    }

    public final int getNumberOfDocuments() {
        return ((Number)this.attributes.getValue("number-of-documents")).intValue();
    }

    @NotNull
    public final IppString getDocumentNameSupplied() {
        return (IppString)this.attributes.getValue("document-name-supplied");
    }

    @NotNull
    public final String getDocumentFormat() {
        return (String)this.attributes.getValue("document-format");
    }

    @NotNull
    public final ZonedDateTime getTimeAtCreation() {
        return IppAttributesGroup.getValueAsZonedDateTime$default(this.attributes, "time-at-creation", null, 2, null);
    }

    @NotNull
    public final ZonedDateTime getTimeAtProcessing() {
        return IppAttributesGroup.getValueAsZonedDateTime$default(this.attributes, "time-at-processing", null, 2, null);
    }

    @NotNull
    public final ZonedDateTime getTimeAtCompleted() {
        return IppAttributesGroup.getValueAsZonedDateTime$default(this.attributes, "time-at-completed", null, 2, null);
    }

    @NotNull
    public final String getAppleJobOwner() {
        return (String)this.attributes.getValue("com.apple.print.JobInfo.PMJobOwner");
    }

    @JvmOverloads
    public final boolean isPending(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Pending);
    }

    public static /* synthetic */ boolean isPending$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isPending(bl);
    }

    @JvmOverloads
    public final boolean isAborted(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Aborted);
    }

    public static /* synthetic */ boolean isAborted$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isAborted(bl);
    }

    @JvmOverloads
    public final boolean isCanceled(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Canceled);
    }

    public static /* synthetic */ boolean isCanceled$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isCanceled(bl);
    }

    @JvmOverloads
    public final boolean isCompleted(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Completed);
    }

    public static /* synthetic */ boolean isCompleted$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isCompleted(bl);
    }

    @JvmOverloads
    public final boolean isProcessing(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Processing);
    }

    public static /* synthetic */ boolean isProcessing$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isProcessing(bl);
    }

    @JvmOverloads
    public final boolean isProcessingStopped(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.ProcessingStopped);
    }

    public static /* synthetic */ boolean isProcessingStopped$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isProcessingStopped(bl);
    }

    @JvmOverloads
    public final boolean isTerminated(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Canceled) || this.stateIs(false, JobState.Aborted) || this.stateIs(false, JobState.Completed);
    }

    public static /* synthetic */ boolean isTerminated$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isTerminated(bl);
    }

    private final boolean stateIs(boolean updateStateAttributes, JobState expectedState) {
        if (updateStateAttributes) {
            String[] stringArray = new String[]{"job-state", "job-state-reasons"};
            this.updateAttributes(stringArray);
        }
        return this.getState() == expectedState;
    }

    public final boolean stateReasonsContain(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return this.getStateReasons().contains(reason);
    }

    public final boolean isProcessingToStopPoint() {
        return this.stateReasonsContain("processing-to-stop-point");
    }

    public final boolean resourcesAreNotReady() {
        return this.stateReasonsContain("resources-are-not-ready");
    }

    public final boolean isPrinterStopped() {
        return this.stateReasonsContain("printer-stopped");
    }

    public final boolean isIncoming() {
        return this.stateReasonsContain("job-incoming");
    }

    @Nullable
    public final String getOriginatingUserNameOrAppleJobOwnerOrNull() {
        return this.attributes.containsKey((Object)"job-originating-user-name") ? this.getOriginatingUserName().getText() : (this.attributes.containsKey((Object)"com.apple.print.JobInfo.PMJobOwner") ? this.getAppleJobOwner() : null);
    }

    @Nullable
    public final String getJobNameOrDocumentNameSuppliedOrAppleJobNameOrNull() {
        return this.attributes.containsKey((Object)"job-name") ? this.getName().getText() : (this.attributes.containsKey((Object)"document-name-supplied") ? this.getDocumentNameSupplied().getText() : (this.attributes.containsKey((Object)"com.apple.print.JobInfo.PMJobName") ? (String)this.attributes.getValue("com.apple.print.JobInfo.PMJobName") : null));
    }

    public final int getNumberOfDocumentsOrDocumentCount() {
        int n;
        if (this.attributes.containsKey((Object)"number-of-documents")) {
            n = this.getNumberOfDocuments();
        } else if (this.attributes.containsKey((Object)"document-count")) {
            n = ((Number)this.attributes.getValue("document-count")).intValue();
        } else {
            throw new IppException("number-of-documents or document-count not found, try calling ippJob.updateAttributes() first", null, 2, null);
        }
        return n;
    }

    @JvmOverloads
    @NotNull
    public final IppAttributesGroup getJobAttributes(@Nullable List<String> requestedAttributes) {
        return this.exchange(this.ippRequest(IppOperation.GetJobAttributes, requestedAttributes)).getJobGroup();
    }

    public static /* synthetic */ IppAttributesGroup getJobAttributes$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return ippJob.getJobAttributes(list);
    }

    @NotNull
    public final IppAttributesGroup getJobAttributes(String ... requestedAttribute) {
        Intrinsics.checkNotNullParameter((Object)requestedAttribute, (String)"requestedAttribute");
        return this.getJobAttributes(ArraysKt.toList((Object[])requestedAttribute));
    }

    @JvmOverloads
    public final void updateAttributes(@Nullable List<String> requestedAttributes) {
        this.attributes.put(this.getJobAttributes(requestedAttributes));
    }

    public static /* synthetic */ void updateAttributes$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        ippJob.updateAttributes(list);
    }

    public final void updateAttributes(String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        this.updateAttributes(ArraysKt.toList((Object[])requestedAttributes));
    }

    @JvmOverloads
    public final void waitForTermination(@NotNull Duration delay, @Nullable Level jobProgressLogLevel, @Nullable Level printerStateLogLevel) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this.logger.info(() -> IppJob.waitForTermination$lambda$1(this));
        Ref.ObjectRef lastJobString = new Ref.ObjectRef();
        lastJobString.element = this.toString();
        Ref.ObjectRef lastPrinterString = new Ref.ObjectRef();
        lastPrinterString.element = "";
        this.logger.info(() -> IppJob.waitForTermination$lambda$4(lastJobString));
        while (!IppJob.isTerminated$default(this, false, 1, null)) {
            Thread.sleep(delay.toMillis());
            IppJob.updateAttributes$default(this, null, 1, null);
            IppJob.waitForTermination$logJobStringWhenChanged(jobProgressLogLevel, this, (Ref.ObjectRef<String>)lastJobString);
            if (IppJob.isProcessing$default(this, false, 1, null) && !(((CharSequence)lastPrinterString.element).length() > 0)) continue;
            this.printer.updateStateAttributes();
            IppJob.waitForTermination$logPrinterStringWhenChanged(printerStateLogLevel, this, (Ref.ObjectRef<String>)lastPrinterString);
            if (!IppPrinter.isStopped$default(this.printer, false, 1, null)) continue;
            Thread.sleep(Duration.ofSeconds(5L).toMillis());
        }
        if (IppJob.isAborted$default(this, false, 1, null)) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            IppJob.log$default(this, logger, null, 2, null);
        }
    }

    public static /* synthetic */ void waitForTermination$default(IppJob ippJob, Duration duration, Level level, Level level2, int n, Object object) {
        if ((n & 1) != 0) {
            duration = defaultDelay;
        }
        if ((n & 2) != 0) {
            level = Level.INFO;
        }
        if ((n & 4) != 0) {
            level2 = Level.INFO;
        }
        ippJob.waitForTermination(duration, level, level2);
    }

    @NotNull
    public final IppResponse hold() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.HoldJob, null, 2, null));
    }

    @NotNull
    public final IppResponse close() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.CloseJob, null, 2, null));
    }

    @NotNull
    public final IppResponse release() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.ReleaseJob, null, 2, null));
    }

    @NotNull
    public final IppResponse restart() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.RestartJob, null, 2, null));
    }

    @NotNull
    public final IppResponse resubmit() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.ResubmitJob, null, 2, null));
    }

    @JvmOverloads
    @NotNull
    public final IppResponse cancel(@Nullable String messageForOperator) {
        IppRequest ippRequest;
        if (IppJob.isCanceled$default(this, false, 1, null)) {
            this.logger.warning(() -> IppJob.cancel$lambda$5(this));
        }
        if (this.isProcessingToStopPoint()) {
            this.logger.warning(() -> IppJob.cancel$lambda$6(this));
        }
        IppRequest $this$cancel_u24lambda_u248 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CancelJob, null, 2, null);
        boolean bl = false;
        String string = messageForOperator;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{it};
            $this$cancel_u24lambda_u248.getOperationGroup().attribute("message", IppTag.TextWithoutLanguage, objectArray);
        }
        IppRequest request = ippRequest;
        this.logger.info(() -> IppJob.cancel$lambda$9(this));
        return this.exchange(request);
    }

    public static /* synthetic */ IppResponse cancel$default(IppJob ippJob, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ippJob.cancel(string);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage, @Nullable DocumentFormat documentFormat) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppRequest $this$sendDocument_u24lambda_u2410 = ippRequest = this.documentRequest(IppOperation.SendDocument, lastDocument, documentName, documentNaturalLanguage, documentFormat);
        boolean bl = false;
        $this$sendDocument_u24lambda_u2410.setDocumentInputStream(inputStream);
        IppRequest request = ippRequest;
        this.attributes.put(this.exchange(request).getJobGroup());
    }

    public static /* synthetic */ void sendDocument$default(IppJob ippJob, InputStream inputStream, boolean bl, String string, String string2, DocumentFormat documentFormat, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            documentFormat = null;
        }
        ippJob.sendDocument(inputStream, bl, string, string2, documentFormat);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage, @Nullable DocumentFormat documentFormat) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.sendDocument(new FileInputStream(file), lastDocument, documentName, documentNaturalLanguage, documentFormat);
    }

    public static /* synthetic */ void sendDocument$default(IppJob ippJob, File file, boolean bl, String string, String string2, DocumentFormat documentFormat, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            documentFormat = null;
        }
        ippJob.sendDocument(file, bl, string, string2, documentFormat);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull Path path, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage, @Nullable DocumentFormat documentFormat) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(path)");
        this.sendDocument(inputStream, lastDocument, documentName, documentNaturalLanguage, documentFormat);
    }

    public static /* synthetic */ void sendDocument$default(IppJob ippJob, Path path, boolean bl, String string, String string2, DocumentFormat documentFormat, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            documentFormat = null;
        }
        ippJob.sendDocument(path, bl, string, string2, documentFormat);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage, @Nullable DocumentFormat documentFormat) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppRequest $this$sendUri_u24lambda_u2411 = ippRequest = this.documentRequest(IppOperation.SendURI, lastDocument, documentName, documentNaturalLanguage, documentFormat);
        boolean bl = false;
        Object[] objectArray = new Object[]{documentUri};
        $this$sendUri_u24lambda_u2411.getOperationGroup().attribute("document-uri", IppTag.Uri, objectArray);
        IppRequest request = ippRequest;
        this.attributes.put(this.exchange(request).getJobGroup());
    }

    public static /* synthetic */ void sendUri$default(IppJob ippJob, URI uRI, boolean bl, String string, String string2, DocumentFormat documentFormat, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            documentFormat = null;
        }
        ippJob.sendUri(uRI, bl, string, string2, documentFormat);
    }

    private final IppRequest documentRequest(IppOperation operation, boolean lastDocument, String documentName, String documentNaturalLanguage, DocumentFormat documentFormat) {
        Object[] objectArray;
        String it;
        IppRequest ippRequest;
        IppRequest $this$documentRequest_u24lambda_u2415 = ippRequest = IppJob.ippRequest$default(this, operation, null, 2, null);
        boolean bl = false;
        IppAttributesGroup $this$documentRequest_u24lambda_u2415_u24lambda_u2414 = $this$documentRequest_u24lambda_u2415.getOperationGroup();
        boolean bl2 = false;
        Object[] objectArray2 = new Object[]{lastDocument};
        $this$documentRequest_u24lambda_u2415_u24lambda_u2414.attribute("last-document", IppTag.Boolean, objectArray2);
        String string = documentName;
        if (string != null) {
            it = string;
            boolean bl3 = false;
            objectArray = new Object[]{it};
            $this$documentRequest_u24lambda_u2415_u24lambda_u2414.attribute("document-name", IppTag.NameWithoutLanguage, objectArray);
        }
        String string2 = documentNaturalLanguage;
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            objectArray = new Object[]{it};
            $this$documentRequest_u24lambda_u2415_u24lambda_u2414.attribute("document-natural-language", IppTag.NaturalLanguage, objectArray);
        }
        this.put($this$documentRequest_u24lambda_u2415_u24lambda_u2414, documentFormat);
        return ippRequest;
    }

    private final IppAttribute<? extends Object> put(IppAttributesGroup $this$put, IppAttributeBuilder attributeBuilder) {
        IppAttribute<? extends Object> ippAttribute;
        IppAttributeBuilder ippAttributeBuilder = attributeBuilder;
        if (ippAttributeBuilder != null) {
            IppAttributeBuilder it = ippAttributeBuilder;
            boolean bl = false;
            ippAttribute = $this$put.put(this.printer.buildIppAttribute(it));
        } else {
            ippAttribute = null;
        }
        return ippAttribute;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppResponse cupsMoveJob(@NotNull URI printerUri) {
        void $this$cupsMoveJob_u24lambda_u2418;
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        IppRequest ippRequest2 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CupsMoveJob, null, 2, null);
        IppJob ippJob = this;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)this.getUri().getHost(), (Object)printerUri.getHost())) {
            boolean bl2 = false;
            String string = "Printer " + printerUri + " must be managed by the same server as " + this.getUri().getHost();
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{printerUri};
        $this$cupsMoveJob_u24lambda_u2418.createAttributesGroup(IppTag.Job).attribute("job-printer-uri", IppTag.Uri, objectArray);
        return ippJob.exchange(ippRequest);
    }

    @NotNull
    public final IppResponse cupsMoveJob(@NotNull IppPrinter ippPrinter) {
        Intrinsics.checkNotNullParameter((Object)ippPrinter, (String)"ippPrinter");
        return this.cupsMoveJob(ippPrinter.getPrinterUri());
    }

    @JvmOverloads
    @NotNull
    public final IppSubscription createJobSubscription(@Nullable List<String> notifyEvents) {
        IppSubscription ippSubscription;
        IppRequest ippRequest;
        IppRequest $this$createJobSubscription_u24lambda_u2419 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CreateJobSubscriptions, null, 2, null);
        boolean bl = false;
        this.printer.checkNotifyEvents((Collection<String>)notifyEvents);
        IppRequest.createSubscriptionAttributesGroup$default($this$createJobSubscription_u24lambda_u2419, notifyEvents, null, null, this.getId(), 6, null);
        IppRequest request = ippRequest;
        IppAttributesGroup subscriptionAttributes = this.exchange(request).getSubscriptionGroup();
        IppSubscription $this$createJobSubscription_u24lambda_u2421 = ippSubscription = new IppSubscription(this.printer, subscriptionAttributes, false, 4, null);
        boolean bl2 = false;
        this.subscription = $this$createJobSubscription_u24lambda_u2421;
        if (notifyEvents != null && !$this$createJobSubscription_u24lambda_u2421.getEvents().containsAll((Collection)notifyEvents)) {
            this.logger.warning(() -> IppJob.createJobSubscription$lambda$21$lambda$20(notifyEvents, $this$createJobSubscription_u24lambda_u2421));
        }
        return ippSubscription;
    }

    public static /* synthetic */ IppSubscription createJobSubscription$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return ippJob.createJobSubscription(list);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final IppDocument cupsGetDocument(int documentNumber) {
        this.logger.fine(() -> IppJob.cupsGetDocument$lambda$22(documentNumber, this));
        try {
            void $this$cupsGetDocument_u24lambda_u2423;
            IppRequest ippRequest;
            IppRequest ippRequest2 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CupsGetDocument, null, 2, null);
            IppJob ippJob = this;
            boolean bl = false;
            Object[] objectArray = new Object[]{documentNumber};
            $this$cupsGetDocument_u24lambda_u2423.getOperationGroup().attribute("document-number", IppTag.Integer, objectArray);
            IppResponse response = ippJob.exchange(ippRequest);
            IppAttributesGroup ippAttributesGroup = response.getJobGroup();
            InputStream inputStream = response.getDocumentInputStream();
            Intrinsics.checkNotNull((Object)inputStream);
            return new IppDocument(this, ippAttributesGroup, inputStream);
        }
        catch (HttpPostException httpPostException) {
            Integer n = httpPostException.getHttpStatus();
            int n2 = 426;
            throw n != null && n == n2 ? (Throwable)new IppException("Server requires TLS encrypted connection", httpPostException) : (Throwable)httpPostException;
        }
    }

    public static /* synthetic */ IppDocument cupsGetDocument$default(IppJob ippJob, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return ippJob.cupsGetDocument(n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments(boolean save, @NotNull Path directory, @Nullable String optionalCommandToHandleFile) {
        void $this$onEach$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Iterable iterable = (Iterable)new IntRange(1, this.getNumberOfDocumentsOrDocumentCount());
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cupsGetDocument((int)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var6_6 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            String it;
            IppDocument document = (IppDocument)element$iv;
            boolean bl2 = false;
            if (!save) continue;
            IppDocument $this$cupsGetDocuments_u24lambda_u2427_u24lambda_u2426 = document;
            boolean bl3 = false;
            IppDocument.save$default($this$cupsGetDocuments_u24lambda_u2427_u24lambda_u2426, directory, null, true, 2, null);
            if (optionalCommandToHandleFile == null) continue;
            boolean bl4 = false;
            $this$cupsGetDocuments_u24lambda_u2427_u24lambda_u2426.runtimeExecCommand(it);
        }
        return (List)var6_6;
    }

    public static /* synthetic */ List cupsGetDocuments$default(IppJob ippJob, boolean bl, Path path, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            path = ippJob.printer.getPrinterDirectory();
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return ippJob.cupsGetDocuments(bl, path, string);
    }

    private final IppRequest ippRequest(IppOperation operation, List<String> requestedAttributes) {
        Object object = this.printer;
        String string = this.useJobOwnerAsUserName && this.attributes.containsKey((Object)"job-originating-user-name") ? this.getOriginatingUserName().getText() : (this.useJobOwnerAsUserName && this.attributes.containsKey((Object)"com.apple.print.JobInfo.PMJobOwner") ? this.getAppleJobOwner() : this.printer.getIppConfig().getUserName());
        Object $this$ippRequest_u24lambda_u2429 = object = IppPrinter.ippRequest$default((IppPrinter)object, operation, requestedAttributes, string, null, null, 16, null);
        boolean bl = false;
        IppAttributesGroup $this$ippRequest_u24lambda_u2429_u24lambda_u2428 = ((IppMessage)$this$ippRequest_u24lambda_u2429).getOperationGroup();
        boolean bl2 = false;
        if (this.useJobUri) {
            Object[] objectArray = new Object[]{this.getUri()};
            $this$ippRequest_u24lambda_u2429_u24lambda_u2428.attribute("job-uri", IppTag.Uri, objectArray);
        } else {
            Object[] objectArray = new Object[]{this.printer.getPrinterUri()};
            $this$ippRequest_u24lambda_u2429_u24lambda_u2428.attribute("printer-uri", IppTag.Uri, objectArray);
            objectArray = new Object[]{this.getId()};
            $this$ippRequest_u24lambda_u2429_u24lambda_u2428.attribute("job-id", IppTag.Integer, objectArray);
        }
        return object;
    }

    static /* synthetic */ IppRequest ippRequest$default(IppJob ippJob, IppOperation ippOperation, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return ippJob.ippRequest(ippOperation, list);
    }

    private final IppResponse exchange(IppRequest request) {
        return this.printer.exchange(request);
    }

    @NotNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder;
        IppAttributesGroup it = this.attributes;
        boolean bl = false;
        StringBuilder $this$toString_u24lambda_u2431_u24lambda_u2430 = stringBuilder = new StringBuilder("Job #" + this.getId());
        boolean bl2 = false;
        if (it.containsKey((Object)"job-state")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", state=" + this.getState());
        }
        if (it.containsKey((Object)"job-state-reasons")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(" (reasons=" + CollectionsKt.joinToString$default((Iterable)this.getStateReasons(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        if (it.containsKey((Object)"job-name")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", name=" + this.getName());
        }
        if (it.containsKey((Object)"job-impressions-completed")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", impressions-completed=" + this.getImpressionsCompleted());
        }
        if (it.containsKey((Object)"job-originating-host-name")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", originating-host-name=" + this.getOriginatingHostName());
        }
        boolean bl3 = (object = (IppAttribute)it.get((Object)"job-originating-user-name")) != null && (object = ((IppAttribute)object).getTag()) != null ? ((IppTag)((Object)object)).isValueTagAndIsNotOutOfBandTag() : false;
        if (bl3) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", originating-user-name=" + this.getOriginatingUserName());
        }
        if (it.containsKey((Object)"com.apple.print.JobInfo.PMJobOwner")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", appleJobOwner=" + this.getAppleJobOwner());
        }
        if (it.containsKey((Object)"number-of-documents") || it.containsKey((Object)"document-count")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", " + this.getNumberOfDocumentsOrDocumentCount() + " documents");
        }
        if (it.containsKey((Object)"job-printer-uri")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", printer-uri=" + this.getPrinterUri());
        }
        if (it.containsKey((Object)"job-uri")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", uri=" + this.getUri());
        }
        if (it.containsKey((Object)"document-format")) {
            $this$toString_u24lambda_u2431_u24lambda_u2430.append(", document-format=" + this.getDocumentFormat());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attributes.let {\n       \u2026       }.toString()\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, "JOB #" + this.getId(), null, 8, null);
    }

    public static /* synthetic */ void log$default(IppJob ippJob, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippJob.log(logger, level);
    }

    @JvmOverloads
    public final boolean isPending() {
        return IppJob.isPending$default(this, false, 1, null);
    }

    @JvmOverloads
    public final boolean isAborted() {
        return IppJob.isAborted$default(this, false, 1, null);
    }

    @JvmOverloads
    public final boolean isCanceled() {
        return IppJob.isCanceled$default(this, false, 1, null);
    }

    @JvmOverloads
    public final boolean isCompleted() {
        return IppJob.isCompleted$default(this, false, 1, null);
    }

    @JvmOverloads
    public final boolean isProcessing() {
        return IppJob.isProcessing$default(this, false, 1, null);
    }

    @JvmOverloads
    public final boolean isProcessingStopped() {
        return IppJob.isProcessingStopped$default(this, false, 1, null);
    }

    @JvmOverloads
    public final boolean isTerminated() {
        return IppJob.isTerminated$default(this, false, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final IppAttributesGroup getJobAttributes() {
        return IppJob.getJobAttributes$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void updateAttributes() {
        IppJob.updateAttributes$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void waitForTermination(@NotNull Duration delay, @Nullable Level jobProgressLogLevel) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        IppJob.waitForTermination$default(this, delay, jobProgressLogLevel, null, 4, null);
    }

    @JvmOverloads
    public final void waitForTermination(@NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        IppJob.waitForTermination$default(this, delay, null, null, 6, null);
    }

    @JvmOverloads
    public final void waitForTermination() {
        IppJob.waitForTermination$default(this, null, null, null, 7, null);
    }

    @JvmOverloads
    @NotNull
    public final IppResponse cancel() {
        return IppJob.cancel$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, documentName, documentNaturalLanguage, null, 16, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, documentName, null, null, 24, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, null, null, null, 28, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, false, null, null, null, 30, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, lastDocument, documentName, documentNaturalLanguage, null, 16, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, lastDocument, documentName, null, null, 24, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, lastDocument, null, null, null, 28, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, false, null, null, null, 30, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull Path path, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IppJob.sendDocument$default(this, path, lastDocument, documentName, documentNaturalLanguage, null, 16, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull Path path, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IppJob.sendDocument$default(this, path, lastDocument, documentName, null, null, 24, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull Path path, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IppJob.sendDocument$default(this, path, lastDocument, null, null, null, 28, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        IppJob.sendDocument$default(this, path, false, null, null, null, 30, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, documentName, documentNaturalLanguage, null, 16, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, documentName, null, null, 24, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, null, null, null, 28, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, false, null, null, null, 30, null);
    }

    @JvmOverloads
    @NotNull
    public final IppSubscription createJobSubscription() {
        return IppJob.createJobSubscription$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final IppDocument cupsGetDocument() {
        return IppJob.cupsGetDocument$default(this, 0, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments(boolean save, @NotNull Path directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return IppJob.cupsGetDocuments$default(this, save, directory, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments(boolean save) {
        return IppJob.cupsGetDocuments$default(this, save, null, null, 6, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments() {
        return IppJob.cupsGetDocuments$default(this, false, null, null, 7, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppJob.log$default(this, logger, null, 2, null);
    }

    private static final String _init_$lambda$0(IppResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        return "Job response status: " + (Object)((Object)$response.getStatus());
    }

    private static final String waitForTermination$lambda$1(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Wait for termination of Job #" + this$0.getId();
    }

    private static final String waitForTermination$logJobStringWhenChanged$lambda$2(Ref.ObjectRef $lastJobString) {
        Intrinsics.checkNotNullParameter((Object)$lastJobString, (String)"$lastJobString");
        return (String)$lastJobString.element;
    }

    private static final void waitForTermination$logJobStringWhenChanged(Level $jobProgressLogLevel, IppJob this$0, Ref.ObjectRef<String> lastJobString) {
        if ($jobProgressLogLevel != null && !Intrinsics.areEqual((Object)this$0.toString(), (Object)lastJobString.element)) {
            lastJobString.element = this$0.toString();
            this$0.logger.log($jobProgressLogLevel, () -> IppJob.waitForTermination$logJobStringWhenChanged$lambda$2(lastJobString));
        }
    }

    private static final String waitForTermination$logPrinterStringWhenChanged$lambda$3(Ref.ObjectRef $lastPrinterString) {
        Intrinsics.checkNotNullParameter((Object)$lastPrinterString, (String)"$lastPrinterString");
        return (String)$lastPrinterString.element;
    }

    private static final void waitForTermination$logPrinterStringWhenChanged(Level $printerStateLogLevel, IppJob this$0, Ref.ObjectRef<String> lastPrinterString) {
        if ($printerStateLogLevel != null && !Intrinsics.areEqual((Object)this$0.printer.toString(), (Object)lastPrinterString.element)) {
            lastPrinterString.element = this$0.printer.toString();
            this$0.logger.log($printerStateLogLevel, () -> IppJob.waitForTermination$logPrinterStringWhenChanged$lambda$3(lastPrinterString));
        }
    }

    private static final String waitForTermination$lambda$4(Ref.ObjectRef $lastJobString) {
        Intrinsics.checkNotNullParameter((Object)$lastJobString, (String)"$lastJobString");
        return (String)$lastJobString.element;
    }

    private static final String cancel$lambda$5(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Job #" + this$0.getId() + " is already 'canceled'";
    }

    private static final String cancel$lambda$6(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Job #" + this$0.getId() + " is already 'processing-to-stop-point'";
    }

    private static final String cancel$lambda$9(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Cancel " + this$0;
    }

    private static final String createJobSubscription$lambda$21$lambda$20(List $notifyEvents, IppSubscription $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Server ignored some notifyEvents " + $notifyEvents + ", subscribed events: " + $this_apply.getEvents();
    }

    private static final String cupsGetDocument$lambda$22(int $documentNumber, IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "CupsGetDocument #" + $documentNumber + " for job #" + this$0.getId();
    }

    static {
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(1)");
        defaultDelay = duration;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lde/gmuth/ipp/client/IppJob$Companion;", "", "()V", "defaultDelay", "Ljava/time/Duration;", "getDefaultDelay", "()Ljava/time/Duration;", "setDefaultDelay", "(Ljava/time/Duration;)V", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDefaultDelay() {
            return defaultDelay;
        }

        public final void setDefaultDelay(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            defaultDelay = duration;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

