/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.attributes.ColorMode;
import de.gmuth.ipp.attributes.CommunicationChannel;
import de.gmuth.ipp.attributes.DocumentFormat;
import de.gmuth.ipp.attributes.Media;
import de.gmuth.ipp.attributes.PrintQuality;
import de.gmuth.ipp.attributes.Sides;
import de.gmuth.ipp.attributes.TemplateAttributes;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppOperationException;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppResponse;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lde/gmuth/ipp/client/IppInspector;", "", "()V", "inspect", "", "printerUri", "Ljava/net/URI;", "cancelJob", "", "Lde/gmuth/ipp/client/IppJob;", "Lde/gmuth/ipp/client/IppPrinter;", "printPdf", "Companion", "ipp-client"})
public final class IppInspector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String pdfA4 = "blank_A4.pdf";
    @NotNull
    private static Path inspectorDirectory;
    private static final Logger logger;

    public final void inspect(@NotNull URI printerUri, boolean cancelJob) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        this.inspect(new IppPrinter(printerUri, null, null, null, false, null, 46, null), cancelJob);
    }

    public static /* synthetic */ void inspect$default(IppInspector ippInspector, URI uRI, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ippInspector.inspect(uRI, bl);
    }

    private final void inspect(IppPrinter $this$inspect, boolean cancelJob) {
        logger.info(() -> IppInspector.inspect$lambda$0($this$inspect));
        String printerModel = IppInspector.Companion.getModel($this$inspect.getPrinterUri());
        logger.info(() -> IppInspector.inspect$lambda$1(printerModel));
        Path path = inspectorDirectory.resolve(printerModel);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"inspectorDirectory.resolve(printerModel)");
        $this$inspect.setPrinterDirectory(path);
        $this$inspect.getIppConfig().setUserName("ipp-inspector");
        $this$inspect.getIppClient().setSaveEvents(true);
        $this$inspect.getIppClient().setSaveMessages(true);
        $this$inspect.getIppClient().setSaveMessagesDirectory($this$inspect.getPrinterDirectory());
        logger.info(IppInspector::inspect$lambda$2);
        IppPrinter.updateAttributes$default($this$inspect, null, 1, null);
        Object $this$inspect_u24lambda_u2410 = $this$inspect.getAttributes();
        boolean bl = false;
        if ($this$inspect_u24lambda_u2410.containsKey((Object)"media-supported")) {
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$3($this$inspect));
        }
        if ($this$inspect_u24lambda_u2410.containsKey((Object)"media-ready")) {
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$4($this$inspect));
        }
        if ($this$inspect_u24lambda_u2410.containsKey((Object)"media-default")) {
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$5($this$inspect));
        }
        logger.info(IppInspector::inspect$lambda$10$lambda$6);
        Iterable $this$forEach$iv = $this$inspect.getCommunicationChannelsSupported();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommunicationChannel it = (CommunicationChannel)element$iv;
            boolean bl2 = false;
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$8$lambda$7(it));
        }
        logger.info(() -> IppInspector.inspect$lambda$10$lambda$9($this$inspect));
        if ($this$inspect.getAttributes().containsKey((Object)"printer-icons")) {
            logger.info(IppInspector::inspect$lambda$11);
            $this$inspect.savePrinterIcons();
        }
        $this$inspect.getIppClient().setSaveMessages(false);
        if ($this$inspect.getAttributes().containsKey((Object)"printer-strings-languages-supported")) {
            logger.info(IppInspector::inspect$lambda$12);
            $this$inspect.saveAllPrinterStrings();
        } else if ($this$inspect.getAttributes().containsKey((Object)"printer-strings-uri")) {
            String string = (String)$this$inspect.getAttributes().getValueOrNull("natural-language-configured");
            if (string != null) {
                IppAttributeBuilder[] it = $this$inspect_u24lambda_u2410 = string;
                boolean bl3 = false;
                logger.info(() -> IppInspector.inspect$lambda$14$lambda$13((String)it));
                $this$inspect.savePrinterStrings((String)it);
            }
        }
        $this$inspect.getIppClient().setSaveMessages(true);
        IppOperation[] ippOperationArray = new IppOperation[]{IppOperation.CupsGetPPD};
        if ($this$inspect.supportsOperations(ippOperationArray)) {
            logger.info(IppInspector::inspect$lambda$15);
            IppPrinter.savePPD$default($this$inspect, null, printerModel + ".ppd", 1, null);
        }
        ippOperationArray = new IppOperation[]{IppOperation.IdentifyPrinter};
        if ($this$inspect.supportsOperations(ippOperationArray)) {
            List<String> $this$inspect_u24lambda_u2416 = $this$inspect.getIdentifyActionsSupported();
            boolean bl4 = false;
            String action = $this$inspect_u24lambda_u2416.contains("sound") ? "sound" : (String)CollectionsKt.first($this$inspect_u24lambda_u2416);
            logger.info(() -> IppInspector.inspect$lambda$17(action));
            $this$inspect_u24lambda_u2410 = new String[]{action};
            $this$inspect.identify((String[])$this$inspect_u24lambda_u2410);
        }
        logger.info(IppInspector::inspect$lambda$18);
        try {
            $this$inspect_u24lambda_u2410 = new IppAttributeBuilder[]{TemplateAttributes.jobName("Validation"), DocumentFormat.OCTET_STREAM, Sides.TwoSidedShortEdge, PrintQuality.Normal, ColorMode.Color, Media.ISO_A3};
            $this$inspect_u24lambda_u2410 = $this$inspect.validateJob((IppAttributeBuilder)$this$inspect_u24lambda_u2410);
        }
        catch (IppOperationException ippOperationException) {
            $this$inspect_u24lambda_u2410 = ippOperationException.getResponse();
        }
        Object response = $this$inspect_u24lambda_u2410;
        logger.info(() -> IppInspector.inspect$lambda$19((IppResponse)response));
        logger.info(IppInspector::inspect$lambda$20);
        IppJob job = this.printPdf($this$inspect);
        logger.info(() -> IppInspector.inspect$lambda$21(job));
        logger.info(IppInspector::inspect$lambda$22);
        Iterable $this$forEach$iv2 = IppPrinter.getJobs$default($this$inspect, null, null, null, null, 15, null);
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            IppJob it = (IppJob)element$iv;
            boolean bl5 = false;
            logger.info(() -> IppInspector.inspect$lambda$24$lambda$23(it));
        }
        this.inspect(job, cancelJob);
    }

    private final IppJob printPdf(IppPrinter $this$printPdf) {
        String string;
        if (!$this$printPdf.getAttributes().containsKey((Object)"media-ready")) {
            logger.warning(IppInspector::printPdf$lambda$25);
            string = pdfA4;
        } else if ($this$printPdf.getMediaReady().contains("iso-a4") || $this$printPdf.getMediaReady().contains("iso_a4_210x297mm")) {
            string = pdfA4;
        } else if ($this$printPdf.getMediaReady().contains("na_letter") || $this$printPdf.getMediaReady().contains("na_letter_8.5x11in")) {
            string = "blank_USLetter.pdf";
        } else {
            logger.warning(() -> IppInspector.printPdf$lambda$26($this$printPdf));
            string = pdfA4;
        }
        String pdfResource = string;
        InputStream inputStream = $this$printPdf.getClass().getResourceAsStream('/' + pdfResource);
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream documentStream = inputStream;
        IppAttributeBuilder[] ippAttributeBuilderArray = new IppAttributeBuilder[]{TemplateAttributes.jobName(pdfResource)};
        return IppPrinter.printJob$default($this$printPdf, documentStream, ippAttributeBuilderArray, null, 4, null);
    }

    private final void inspect(IppJob $this$inspect, boolean cancelJob) {
        IppOperation[] ippOperationArray = new IppOperation[]{IppOperation.HoldJob, IppOperation.ReleaseJob};
        if ($this$inspect.getPrinter().supportsOperations(ippOperationArray)) {
            logger.info(IppInspector::inspect$lambda$27);
            $this$inspect.hold();
            logger.info(IppInspector::inspect$lambda$28);
            $this$inspect.release();
        }
        if (cancelJob) {
            logger.info(IppInspector::inspect$lambda$29);
            IppJob.cancel$default($this$inspect, null, 1, null);
        }
        logger.info(IppInspector::inspect$lambda$30);
        IppJob.updateAttributes$default($this$inspect, null, 1, null);
        $this$inspect.getPrinter().getIppClient().setSaveMessages(false);
        logger.info(IppInspector::inspect$lambda$31);
        IppJob.waitForTermination$default($this$inspect, null, null, null, 7, null);
        if (!cancelJob) {
            $this$inspect.getPrinter().getIppClient().setSaveMessages(true);
            logger.info(IppInspector::inspect$lambda$32);
            IppJob.updateAttributes$default($this$inspect, null, 1, null);
        }
    }

    private static final String inspect$lambda$0(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Inspect printer " + $this_inspect.getPrinterUri();
    }

    private static final String inspect$lambda$1(String $printerModel) {
        Intrinsics.checkNotNullParameter((Object)$printerModel, (String)"$printerModel");
        return "Printer model: " + $printerModel;
    }

    private static final String inspect$lambda$2() {
        return "> Get printer attributes";
    }

    private static final String inspect$lambda$10$lambda$3(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Media supported: " + $this_inspect.getMediaSupported();
    }

    private static final String inspect$lambda$10$lambda$4(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Media ready: " + $this_inspect.getMediaReady();
    }

    private static final String inspect$lambda$10$lambda$5(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Media default: " + $this_inspect.getMediaDefault();
    }

    private static final String inspect$lambda$10$lambda$6() {
        return "Communication channels supported:";
    }

    private static final String inspect$lambda$10$lambda$8$lambda$7(CommunicationChannel $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "  " + $it;
    }

    private static final String inspect$lambda$10$lambda$9(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Document formats: " + $this_inspect.getDocumentFormatSupported();
    }

    private static final String inspect$lambda$11() {
        return "> Save printer icons";
    }

    private static final String inspect$lambda$12() {
        return "> Save all printer strings";
    }

    private static final String inspect$lambda$14$lambda$13(String $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "> Save printer strings for configured language " + $it;
    }

    private static final String inspect$lambda$15() {
        return "> CUPS Get PPD";
    }

    private static final String inspect$lambda$17(String $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return "> Identify by " + $action;
    }

    private static final String inspect$lambda$18() {
        return "> Validate job";
    }

    private static final String inspect$lambda$19(IppResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        return $response.toString();
    }

    private static final String inspect$lambda$20() {
        return "> Print job";
    }

    private static final String inspect$lambda$21(IppJob $job) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        return String.valueOf($job);
    }

    private static final String inspect$lambda$22() {
        return "> Get jobs";
    }

    private static final String inspect$lambda$24$lambda$23(IppJob $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return String.valueOf($it);
    }

    private static final String printPdf$lambda$25() {
        return "media-ready not supported";
    }

    private static final String printPdf$lambda$26(IppPrinter $this_printPdf) {
        Intrinsics.checkNotNullParameter((Object)$this_printPdf, (String)"$this_printPdf");
        return "No PDF available for media '" + $this_printPdf.getMediaReady() + "', trying A4";
    }

    private static final String inspect$lambda$27() {
        return "> Hold job";
    }

    private static final String inspect$lambda$28() {
        return "> Release job";
    }

    private static final String inspect$lambda$29() {
        return "> Cancel job";
    }

    private static final String inspect$lambda$30() {
        return "> Update job attributes";
    }

    private static final String inspect$lambda$31() {
        return "> Wait for termination";
    }

    private static final String inspect$lambda$32() {
        return "> Get last attributes of terminated job";
    }

    static {
        Path path = Path.of("inspected-printers", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(\"inspected-printers\")");
        inspectorDirectory = path;
        logger = Logger.getLogger(IppInspector.class.getName());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/gmuth/ipp/client/IppInspector$Companion;", "", "()V", "inspectorDirectory", "Ljava/nio/file/Path;", "getInspectorDirectory", "()Ljava/nio/file/Path;", "setInspectorDirectory", "(Ljava/nio/file/Path;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "pdfA4", "", "getModel", "printerUri", "Ljava/net/URI;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path getInspectorDirectory() {
            return inspectorDirectory;
        }

        public final void setInspectorDirectory(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
            inspectorDirectory = path;
        }

        private final String getModel(URI printerUri) {
            StringBuilder $this$getModel_u24lambda_u241 = new StringBuilder();
            boolean bl = false;
            IppPrinter $this$getModel_u24lambda_u241_u24lambda_u240 = new IppPrinter(printerUri, null, null, null, false, null, 46, null);
            boolean bl2 = false;
            Object object = new String[]{"cups-version", "printer-make-and-model"};
            $this$getModel_u24lambda_u241_u24lambda_u240.updateAttributes((String)object);
            if ($this$getModel_u24lambda_u241_u24lambda_u240.isCups()) {
                $this$getModel_u24lambda_u241.append("CUPS_");
            }
            object = $this$getModel_u24lambda_u241_u24lambda_u240.getMakeAndModel().getText();
            Regex regex = new Regex("\\s+");
            String string = "_";
            $this$getModel_u24lambda_u241.append(regex.replace((CharSequence)object, string));
            String string2 = $this$getModel_u24lambda_u241.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().run {\n  \u2026     toString()\n        }");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

