/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.attributes.JobState;
import de.gmuth.ipp.attributes.PrinterState;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppString;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010?\u001a\u00020@J\u0010\u0010A\u001a\u00020B2\b\b\u0002\u0010C\u001a\u00020 J\u001a\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020IH\u0007J\b\u0010J\u001a\u00020\u0019H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u001bR\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00105\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0010R\u0011\u00107\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010;\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0010R\u0011\u0010=\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010&\u00a8\u0006K"}, d2={"Lde/gmuth/ipp/client/IppEventNotification;", "", "subscription", "Lde/gmuth/ipp/client/IppSubscription;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "(Lde/gmuth/ipp/client/IppSubscription;Lde/gmuth/ipp/core/IppAttributesGroup;)V", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "jobId", "", "getJobId", "()I", "jobImpressionsCompleted", "getJobImpressionsCompleted", "jobState", "Lde/gmuth/ipp/attributes/JobState;", "getJobState", "()Lde/gmuth/ipp/attributes/JobState;", "jobStateReasons", "", "", "getJobStateReasons", "()Ljava/util/List;", "naturalLanguage", "getNaturalLanguage", "()Ljava/lang/String;", "printerIsAcceptingJobs", "", "getPrinterIsAcceptingJobs", "()Z", "printerName", "Lde/gmuth/ipp/core/IppString;", "getPrinterName", "()Lde/gmuth/ipp/core/IppString;", "printerState", "Lde/gmuth/ipp/attributes/PrinterState;", "getPrinterState", "()Lde/gmuth/ipp/attributes/PrinterState;", "printerStateReasons", "getPrinterStateReasons", "printerUpTime", "Ljava/time/ZonedDateTime;", "getPrinterUpTime", "()Ljava/time/ZonedDateTime;", "printerUri", "Ljava/net/URI;", "getPrinterUri", "()Ljava/net/URI;", "sequenceNumber", "getSequenceNumber", "subscribedEvent", "getSubscribedEvent", "getSubscription", "()Lde/gmuth/ipp/client/IppSubscription;", "subscriptionId", "getSubscriptionId", "text", "getText", "getJob", "Lde/gmuth/ipp/client/IppJob;", "getPrinter", "Lde/gmuth/ipp/client/IppPrinter;", "getPrinterAttributesOnInit", "log", "", "logger", "Ljava/util/logging/Logger;", "level", "Ljava/util/logging/Level;", "toString", "ipp-client"})
public final class IppEventNotification {
    @NotNull
    private final IppSubscription subscription;
    @NotNull
    private final IppAttributesGroup attributes;

    public IppEventNotification(@NotNull IppSubscription subscription, @NotNull IppAttributesGroup attributes) {
        Intrinsics.checkNotNullParameter((Object)subscription, (String)"subscription");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.subscription = subscription;
        this.attributes = attributes;
    }

    @NotNull
    public final IppSubscription getSubscription() {
        return this.subscription;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final Charset getCharset() {
        return (Charset)this.attributes.getValue("notify-charset");
    }

    @NotNull
    public final String getNaturalLanguage() {
        return (String)this.attributes.getValue("notify-natural-language");
    }

    public final int getSubscriptionId() {
        return ((Number)this.attributes.getValue("notify-subscription-id")).intValue();
    }

    public final int getSequenceNumber() {
        return ((Number)this.attributes.getValue("notify-sequence-number")).intValue();
    }

    @NotNull
    public final String getSubscribedEvent() {
        return (String)this.attributes.getValue("notify-subscribed-event");
    }

    @NotNull
    public final IppString getText() {
        return (IppString)this.attributes.getValue("notify-text");
    }

    public final int getJobId() {
        return ((Number)this.attributes.getValue("notify-job-id")).intValue();
    }

    @NotNull
    public final JobState getJobState() {
        return JobState.Companion.fromAttributes(this.attributes);
    }

    @NotNull
    public final List<String> getJobStateReasons() {
        return (List)this.attributes.getValues("job-state-reasons");
    }

    public final int getJobImpressionsCompleted() {
        return ((Number)this.attributes.getValue("job-impressions-completed")).intValue();
    }

    @NotNull
    public final URI getPrinterUri() {
        return (URI)this.attributes.getValue("notify-printer-uri");
    }

    @NotNull
    public final IppString getPrinterName() {
        return (IppString)this.attributes.getValue("printer-name");
    }

    @NotNull
    public final PrinterState getPrinterState() {
        return PrinterState.Companion.fromInt(((Number)this.attributes.getValue("printer-state")).intValue());
    }

    @NotNull
    public final List<String> getPrinterStateReasons() {
        return (List)this.attributes.getValues("printer-state-reasons");
    }

    public final boolean getPrinterIsAcceptingJobs() {
        return (Boolean)this.attributes.getValue("printer-is-accepting-jobs");
    }

    @NotNull
    public final ZonedDateTime getPrinterUpTime() {
        return IppAttributesGroup.getValueAsZonedDateTime$default(this.attributes, "printer-up-time", null, 2, null);
    }

    @NotNull
    public final IppJob getJob() {
        return this.subscription.getPrinter().getJob(this.getJobId());
    }

    @NotNull
    public final IppPrinter getPrinter(boolean getPrinterAttributesOnInit) {
        return new IppPrinter(this.getPrinterUri(), null, null, this.subscription.getPrinter().getIppClient(), getPrinterAttributesOnInit, null, 38, null);
    }

    public static /* synthetic */ IppPrinter getPrinter$default(IppEventNotification ippEventNotification, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippEventNotification.getPrinter(bl);
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u241 = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u241.append(this.getPrinterUpTime().toLocalDateTime());
        $this$toString_u24lambda_u241.append(" EventNotification #" + this.getSequenceNumber());
        $this$toString_u24lambda_u241.append(" [" + this.getSubscribedEvent() + "] " + this.getText());
        IppAttributesGroup $this$toString_u24lambda_u241_u24lambda_u240 = this.attributes;
        boolean bl2 = false;
        if ($this$toString_u24lambda_u241_u24lambda_u240.containsKey((Object)"notify-job-id")) {
            $this$toString_u24lambda_u241.append(", job #" + this.getJobId());
        }
        if ($this$toString_u24lambda_u241_u24lambda_u240.containsKey((Object)"job-state")) {
            $this$toString_u24lambda_u241.append(", job-state=" + this.getJobState());
        }
        if ($this$toString_u24lambda_u241_u24lambda_u240.containsKey((Object)"job-state-reasons")) {
            $this$toString_u24lambda_u241.append(" (reasons=" + CollectionsKt.joinToString$default((Iterable)this.getJobStateReasons(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        if ($this$toString_u24lambda_u241_u24lambda_u240.containsKey((Object)"printer-name")) {
            $this$toString_u24lambda_u241.append(", printer-name=" + this.getPrinterName());
        }
        if ($this$toString_u24lambda_u241_u24lambda_u240.containsKey((Object)"printer-state")) {
            $this$toString_u24lambda_u241.append(", printer-state=" + this.getPrinterState());
        }
        if ($this$toString_u24lambda_u241_u24lambda_u240.containsKey((Object)"printer-state-reasons")) {
            $this$toString_u24lambda_u241.append(" (reasons=" + CollectionsKt.joinToString$default((Iterable)this.getPrinterStateReasons(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')');
        }
        String string = $this$toString_u24lambda_u241.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().run {\n  \u2026\n        toString()\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, "EVENT_NOTIFICATION #" + this.getSequenceNumber() + " [" + this.getSubscribedEvent() + "] " + this.getText(), null, 8, null);
    }

    public static /* synthetic */ void log$default(IppEventNotification ippEventNotification, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippEventNotification.log(logger, level);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppEventNotification.log$default(this, logger, null, 2, null);
    }
}

