/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u0012J\u001a\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010)\u001a\u00020*H\u0007J\u0006\u0010+\u001a\u00020,J\u0016\u0010-\u001a\n \u0019*\u0004\u0018\u00010.0.2\u0006\u0010/\u001a\u00020\u0012J,\u00100\u001a\n \u0019*\u0004\u0018\u00010\f0\f2\b\b\u0002\u00101\u001a\u00020\f2\b\b\u0002\u0010&\u001a\u00020\u00122\b\b\u0002\u00102\u001a\u000203J\b\u00104\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00066"}, d2={"Lde/gmuth/ipp/client/IppDocument;", "", "job", "Lde/gmuth/ipp/client/IppJob;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "inputStream", "Ljava/io/InputStream;", "(Lde/gmuth/ipp/client/IppJob;Lde/gmuth/ipp/core/IppAttributesGroup;Ljava/io/InputStream;)V", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "file", "Ljava/nio/file/Path;", "getFile", "()Ljava/nio/file/Path;", "setFile", "(Ljava/nio/file/Path;)V", "format", "", "getFormat", "()Ljava/lang/String;", "getJob", "()Lde/gmuth/ipp/client/IppJob;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "name", "Lde/gmuth/ipp/core/IppString;", "getName", "()Lde/gmuth/ipp/core/IppString;", "number", "", "getNumber", "()I", "copyTo", "", "outputStream", "Ljava/io/OutputStream;", "filename", "log", "", "level", "Ljava/util/logging/Level;", "readBytes", "", "runtimeExecCommand", "Ljava/lang/Process;", "commandToHandleFile", "save", "directory", "overwrite", "", "toString", "Companion", "ipp-client"})
public final class IppDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppJob job;
    @NotNull
    private final IppAttributesGroup attributes;
    @NotNull
    private final InputStream inputStream;
    private final Logger logger;
    @Nullable
    private Path file;

    public IppDocument(@NotNull IppJob job, @NotNull IppAttributesGroup attributes, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.job = job;
        this.attributes = attributes;
        this.inputStream = inputStream;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @NotNull
    public final IppJob getJob() {
        return this.job;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    public final int getNumber() {
        return ((Number)this.attributes.getValue("document-number")).intValue();
    }

    @NotNull
    public final String getFormat() {
        return (String)this.attributes.getValue("document-format");
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("document-name");
    }

    @Nullable
    public final Path getFile() {
        return this.file;
    }

    public final void setFile(@Nullable Path path) {
        this.file = path;
    }

    @NotNull
    public final byte[] readBytes() {
        byte[] byArray;
        byte[] it = byArray = ByteStreamsKt.readBytes((InputStream)this.inputStream);
        boolean bl = false;
        this.logger.fine(() -> IppDocument.readBytes$lambda$1$lambda$0(it, this));
        return byArray;
    }

    @NotNull
    public final String filename() {
        StringBuilder stringBuilder;
        StringBuilder $this$filename_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String extension = null;
        extension = Companion.getFilenameExtension(this.getFormat());
        IppJob $this$filename_u24lambda_u247_u24lambda_u245 = this.job;
        boolean bl2 = false;
        $this$filename_u24lambda_u247.append("job-" + $this$filename_u24lambda_u247_u24lambda_u245.getId());
        int it = $this$filename_u24lambda_u247_u24lambda_u245.getNumberOfDocumentsOrDocumentCount();
        boolean bl3 = false;
        if (it > 1) {
            $this$filename_u24lambda_u247.append("-doc-" + it);
        }
        String string = $this$filename_u24lambda_u247_u24lambda_u245.getOriginatingUserNameOrAppleJobOwnerOrNull();
        if (string != null) {
            String it2 = string;
            boolean bl4 = false;
            $this$filename_u24lambda_u247.append('-' + it2);
        }
        if ($this$filename_u24lambda_u247_u24lambda_u245.getAttributes().containsKey((Object)"com.apple.print.JobInfo.PMApplicationName")) {
            $this$filename_u24lambda_u247.append('-' + (String)$this$filename_u24lambda_u247_u24lambda_u245.getAttributes().getValue("com.apple.print.JobInfo.PMApplicationName"));
        }
        String string2 = $this$filename_u24lambda_u247_u24lambda_u245.getJobNameOrDocumentNameSuppliedOrAppleJobNameOrNull();
        if (string2 != null) {
            String $this$filename_u24lambda_u247_u24lambda_u245_u24lambda_u244 = string2;
            boolean bl5 = false;
            $this$filename_u24lambda_u247.append('-' + StringsKt.take((String)$this$filename_u24lambda_u247_u24lambda_u245_u24lambda_u244, (int)100));
            String string3 = $this$filename_u24lambda_u247_u24lambda_u245_u24lambda_u244.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (StringsKt.endsWith$default((String)string3, (String)('.' + extension), (boolean)false, (int)2, null)) {
                extension = null;
            }
        }
        String string4 = extension;
        if (string4 != null) {
            String it3 = string4;
            boolean bl6 = false;
            $this$filename_u24lambda_u247.append('.' + it3);
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringBuilder().apply {\n\u2026.$it\") }\n    }.toString()");
        String string6 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"separator");
        return StringsKt.replace$default((String)string5, (String)string6, (String)"_", (boolean)false, (int)4, null);
    }

    public final long copyTo(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        return ByteStreamsKt.copyTo$default((InputStream)this.inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
    }

    public final Path save(@NotNull Path directory, @NotNull String filename, boolean overwrite) {
        Path path;
        Path path2;
        Path path3;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path it = path3 = directory.resolve(filename);
        boolean bl = false;
        Path path4 = path2 = it.getParent();
        if (path4 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"parent");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path5 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"createDirectories(this, *attributes)");
        } else {
            path = null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && !overwrite) {
            throw new IOException("File '" + it + "' already exists");
        }
        OutputStream outputStream = Files.newOutputStream(it, new OpenOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(it)");
        this.copyTo(outputStream);
        this.file = it;
        this.logger.info(() -> IppDocument.save$lambda$9$lambda$8(this));
        return path3;
    }

    public static /* synthetic */ Path save$default(IppDocument ippDocument, Path path, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            path = ippDocument.job.getPrinter().getPrinterDirectory();
        }
        if ((n & 2) != 0) {
            string = ippDocument.filename();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return ippDocument.save(path, string, bl);
    }

    public final Process runtimeExecCommand(@NotNull String commandToHandleFile) {
        Intrinsics.checkNotNullParameter((Object)commandToHandleFile, (String)"commandToHandleFile");
        if (this.file == null) {
            throw new IppException("Missing file to handle.", null, 2, null);
        }
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[2];
        stringArray[0] = commandToHandleFile;
        Path path = this.file;
        Intrinsics.checkNotNull((Object)path);
        stringArray[1] = ((Object)path.toAbsolutePath()).toString();
        return runtime.exec(stringArray);
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u2410 = new StringBuilder("Document #" + this.getNumber());
        boolean bl = false;
        $this$toString_u24lambda_u2410.append(" (" + this.getFormat() + ") of job #" + this.job.getId());
        if (this.attributes.containsKey((Object)"document-name")) {
            $this$toString_u24lambda_u2410.append(" '" + this.getName() + '\'');
        }
        if (this.file != null) {
            StringBuilder stringBuilder = new StringBuilder().append(": ").append(this.file).append(" (");
            Path path = this.file;
            Intrinsics.checkNotNull((Object)path);
            $this$toString_u24lambda_u2410.append(stringBuilder.append(Files.size(path)).append(" bytes)").toString());
        }
        String string = $this$toString_u24lambda_u2410.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"Document \u2026\n        toString()\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, "DOCUMENT #" + this.getNumber(), null, 8, null);
    }

    public static /* synthetic */ void log$default(IppDocument ippDocument, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippDocument.log(logger, level);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppDocument.log$default(this, logger, null, 2, null);
    }

    private static final String readBytes$lambda$1$lambda$0(byte[] $it, IppDocument this$0) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Read " + $it.length + " bytes of " + this$0;
    }

    private static final String save$lambda$9$lambda$8(IppDocument this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Saved " + this$0.file + ' ' + (this$0.attributes.containsKey((Object)"document-format") ? '(' + this$0.getFormat() + ')' : "");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lde/gmuth/ipp/client/IppDocument$Companion;", "", "()V", "getDocumentFormatFilenameExtension", "", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "getFilenameExtension", "mediaType", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFilenameExtension(@NotNull String mediaType) {
            String string;
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            switch (mediaType) {
                case "application/vnd.cups-postscript": 
                case "application/postscript": 
                case "application/vnd.adobe-reader-postscript": {
                    string = "ps";
                    break;
                }
                case "application/pdf": 
                case "application/vnd.cups-pdf": {
                    string = "pdf";
                    break;
                }
                case "application/octet-stream": {
                    string = "bin";
                    break;
                }
                case "text/plain": {
                    string = "txt";
                    break;
                }
                default: {
                    String[] stringArray = new String[]{"/"};
                    string = (String)StringsKt.split$default((CharSequence)mediaType, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                }
            }
            return string;
        }

        @NotNull
        public final String getDocumentFormatFilenameExtension(@NotNull IppAttributesGroup attributes) {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            return this.getFilenameExtension((String)attributes.getValue("document-format"));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

