/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.HttpPostException;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppOperationException;
import de.gmuth.ipp.client.IppRequestExchangedEvent;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributesGroupKt;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 ]2\u00020\u0001:\u0001]B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>J\u0018\u0010@\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010A\u001a\u00020BH\u0002J\u001a\u0010C\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u001e2\b\b\u0002\u0010D\u001a\u00020\bH\u0007J\u000e\u0010E\u001a\u00020F2\u0006\u0010!\u001a\u00020\u001eJ\u000e\u0010G\u001a\u00020\"2\u0006\u0010!\u001a\u00020\u001eJ\u0018\u0010H\u001a\u00020\"2\u0006\u0010I\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u001eH\u0016JD\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020L2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010\b2\u0010\b\u0002\u0010N\u001a\n\u0012\u0004\u0012\u00020>\u0018\u00010O2\n\b\u0002\u0010P\u001a\u0004\u0018\u00010>2\b\b\u0002\u0010Q\u001a\u00020>H\u0007J\u0018\u0010R\u001a\u00020$2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\"H\u0002J\u0016\u0010S\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\"J\u001e\u0010T\u001a\u00020$*\u00020U2\u0006\u0010V\u001a\u00020\u000e2\b\u0010W\u001a\u0004\u0018\u00010>H\u0002J2\u0010X\u001a\u0004\u0018\u00010Y*\u00020U2\u0006\u0010!\u001a\u00020\u001e2\b\u0010A\u001a\u0004\u0018\u00010B2\u0010\b\u0002\u0010Z\u001a\n\u0018\u00010[j\u0004\u0018\u0001`\\H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0010\"\u0004\b\u0019\u0010\u0012R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\u001c\u001a:\u0012\u0013\u0012\u00110\u001e\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(!\u0012\u0013\u0012\u00110\"\u00a2\u0006\f\b\u001f\u0012\b\b \u0012\u0004\b\b(#\u0012\u0004\u0012\u00020$\u0018\u00010\u001dj\u0004\u0018\u0001`%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0010\"\u0004\b,\u0010\u0012R\u001a\u0010-\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0010\"\u0004\b/\u0010\u0012R\u001a\u00100\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0010\"\u0004\b2\u0010\u0012R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0010\"\u0004\b;\u0010\u0012\u00a8\u0006^"}, d2={"Lde/gmuth/ipp/client/IppClient;", "", "config", "Lde/gmuth/ipp/client/IppConfig;", "(Lde/gmuth/ipp/client/IppConfig;)V", "getConfig", "()Lde/gmuth/ipp/client/IppConfig;", "defaultPrinterUri", "Ljava/net/URI;", "getDefaultPrinterUri", "()Ljava/net/URI;", "setDefaultPrinterUri", "(Ljava/net/URI;)V", "disconnectAfterHttpPost", "", "getDisconnectAfterHttpPost", "()Z", "setDisconnectAfterHttpPost", "(Z)V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "onExceptionSaveMessages", "getOnExceptionSaveMessages", "setOnExceptionSaveMessages", "requestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "responseInterceptor", "Lkotlin/Function2;", "Lde/gmuth/ipp/core/IppRequest;", "Lkotlin/ParameterName;", "name", "request", "Lde/gmuth/ipp/core/IppResponse;", "response", "", "Lde/gmuth/ipp/client/IppResponseInterceptor;", "getResponseInterceptor", "()Lkotlin/jvm/functions/Function2;", "setResponseInterceptor", "(Lkotlin/jvm/functions/Function2;)V", "saveDocuments", "getSaveDocuments", "setSaveDocuments", "saveEvents", "getSaveEvents", "setSaveEvents", "saveMessages", "getSaveMessages", "setSaveMessages", "saveMessagesDirectory", "Ljava/nio/file/Path;", "getSaveMessagesDirectory", "()Ljava/nio/file/Path;", "setSaveMessagesDirectory", "(Ljava/nio/file/Path;)V", "throwWhenNotSuccessful", "getThrowWhenNotSuccessful", "setThrowWhenNotSuccessful", "basicAuth", "user", "", "password", "decodeContentStream", "contentStream", "Ljava/io/InputStream;", "exchange", "ippUri", "exchangeForEvent", "Lde/gmuth/ipp/client/IppRequestExchangedEvent;", "exchangeWrapped", "httpPost", "httpUri", "ippRequest", "operation", "Lde/gmuth/ipp/core/IppOperation;", "printerUri", "requestedAttributes", "", "userName", "naturalLanguage", "validateIppResponse", "wrap", "configure", "Ljava/net/HttpURLConnection;", "chunked", "userAgent", "validateHttpResponse", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "ipp-client"})
public class IppClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppConfig config;
    @NotNull
    private final Logger logger;
    @Nullable
    private Function2<? super IppRequest, ? super IppResponse, Unit> responseInterceptor;
    private boolean saveEvents;
    private boolean saveMessages;
    private boolean saveDocuments;
    @NotNull
    private Path saveMessagesDirectory;
    private boolean onExceptionSaveMessages;
    private boolean throwWhenNotSuccessful;
    private boolean disconnectAfterHttpPost;
    @Nullable
    private URI defaultPrinterUri;
    @NotNull
    private final AtomicInteger requestCounter;
    @NotNull
    public static final String APPLICATION_IPP = "application/ipp";

    public IppClient(@NotNull IppConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass.name)");
        this.logger = logger;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
        this.saveMessagesDirectory = path;
        this.throwWhenNotSuccessful = true;
        this.defaultPrinterUri = URI.create("ipp://ippbin.net:12345");
        this.requestCounter = new AtomicInteger(1);
    }

    public /* synthetic */ IppClient(IppConfig ippConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ippConfig = new IppConfig(null, null, null, null, null, null, null, null, false, 511, null);
        }
        this(ippConfig);
    }

    @NotNull
    public final IppConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final Function2<IppRequest, IppResponse, Unit> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public final void setResponseInterceptor(@Nullable Function2<? super IppRequest, ? super IppResponse, Unit> function2) {
        this.responseInterceptor = function2;
    }

    public final boolean getSaveEvents() {
        return this.saveEvents;
    }

    public final void setSaveEvents(boolean bl) {
        this.saveEvents = bl;
    }

    public final boolean getSaveMessages() {
        return this.saveMessages;
    }

    public final void setSaveMessages(boolean bl) {
        this.saveMessages = bl;
    }

    public final boolean getSaveDocuments() {
        return this.saveDocuments;
    }

    public final void setSaveDocuments(boolean bl) {
        this.saveDocuments = bl;
    }

    @NotNull
    public final Path getSaveMessagesDirectory() {
        return this.saveMessagesDirectory;
    }

    public final void setSaveMessagesDirectory(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.saveMessagesDirectory = path;
    }

    public final boolean getOnExceptionSaveMessages() {
        return this.onExceptionSaveMessages;
    }

    public final void setOnExceptionSaveMessages(boolean bl) {
        this.onExceptionSaveMessages = bl;
    }

    public final boolean getThrowWhenNotSuccessful() {
        return this.throwWhenNotSuccessful;
    }

    public final void setThrowWhenNotSuccessful(boolean bl) {
        this.throwWhenNotSuccessful = bl;
    }

    public final boolean getDisconnectAfterHttpPost() {
        return this.disconnectAfterHttpPost;
    }

    public final void setDisconnectAfterHttpPost(boolean bl) {
        this.disconnectAfterHttpPost = bl;
    }

    @Nullable
    public final URI getDefaultPrinterUri() {
        return this.defaultPrinterUri;
    }

    public final void setDefaultPrinterUri(@Nullable URI uRI) {
        this.defaultPrinterUri = uRI;
    }

    public final void basicAuth(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.config.setUserName(user);
        this.config.setPassword(password);
    }

    @JvmOverloads
    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable URI printerUri, @Nullable Collection<String> requestedAttributes, @Nullable String userName, @NotNull String naturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)naturalLanguage, (String)"naturalLanguage");
        return new IppRequest(operation, printerUri, requestedAttributes, userName, this.config.getIppVersion(), this.requestCounter.getAndIncrement(), this.config.getCharset(), naturalLanguage, this.config.getUserAgent());
    }

    public static /* synthetic */ IppRequest ippRequest$default(IppClient ippClient, IppOperation ippOperation, URI uRI, Collection collection, String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ippRequest");
        }
        if ((n & 2) != 0) {
            uRI = ippClient.defaultPrinterUri;
        }
        if ((n & 4) != 0) {
            collection = null;
        }
        if ((n & 8) != 0) {
            string = ippClient.config.getUserName();
        }
        if ((n & 0x10) != 0) {
            string2 = ippClient.config.getNaturalLanguage();
        }
        return ippClient.ippRequest(ippOperation, uRI, collection, string, string2);
    }

    @NotNull
    public final IppRequest wrap(@NotNull IppRequest request, @NotNull IppResponse response) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        IppRequest $this$wrap_u24lambda_u240 = ippRequest = IppClient.ippRequest$default(this, request.getOperation(), null, null, null, null, 30, null);
        boolean bl = false;
        $this$wrap_u24lambda_u240.setDocumentInputStream(new ByteArrayInputStream(response.getRawBytes()));
        return ippRequest;
    }

    @JvmOverloads
    @NotNull
    public final IppResponse exchange(@NotNull IppRequest request, @NotNull URI ippUri) {
        IppResponse ippResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)ippUri, (String)"ippUri");
        IppRequest $this$exchange_u24lambda_u245 = request;
        boolean bl = false;
        URI $this$exchange_u24lambda_u245_u24lambda_u241 = ippUri;
        boolean bl2 = false;
        String string = $this$exchange_u24lambda_u245_u24lambda_u241.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scheme");
        URI httpUri = new URI(StringsKt.replace$default((String)string, (String)"ipp", (String)"http", (boolean)false, (int)4, null), $this$exchange_u24lambda_u245_u24lambda_u241.getUserInfo(), $this$exchange_u24lambda_u245_u24lambda_u241.getHost(), $this$exchange_u24lambda_u245_u24lambda_u241.getPort() == -1 ? 631 : $this$exchange_u24lambda_u245_u24lambda_u241.getPort(), $this$exchange_u24lambda_u245_u24lambda_u241.getPath(), $this$exchange_u24lambda_u245_u24lambda_u241.getQuery(), $this$exchange_u24lambda_u245_u24lambda_u241.getFragment());
        IppResponse it = ippResponse = this.httpPost(httpUri, request);
        boolean bl3 = false;
        Level level = Level.FINEST;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINEST");
        $this$exchange_u24lambda_u245.log(this.logger, level, ">>> ");
        Level level2 = Level.FINEST;
        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
        it.log(this.logger, level2, "<<< ");
        IppRequestExchangedEvent $this$exchange_u24lambda_u245_u24lambda_u244_u24lambda_u243 = new IppRequestExchangedEvent(request, it);
        boolean bl4 = false;
        this.logger.fine(() -> IppClient.exchange$lambda$5$lambda$4$lambda$3$lambda$2($this$exchange_u24lambda_u245_u24lambda_u244_u24lambda_u243));
        if (this.saveEvents || this.saveDocuments || this.saveMessages) {
            IppRequestExchangedEvent.save$default($this$exchange_u24lambda_u245_u24lambda_u244_u24lambda_u243, this.saveMessagesDirectory, this.saveEvents, this.saveDocuments, this.saveMessages, 0, 16, null);
        }
        Function2<? super IppRequest, ? super IppResponse, Unit> function2 = this.responseInterceptor;
        if (function2 != null) {
            function2.invoke((Object)request, (Object)it);
        }
        this.validateIppResponse(request, it);
        return ippResponse;
    }

    public static /* synthetic */ IppResponse exchange$default(IppClient ippClient, IppRequest ippRequest, URI uRI, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exchange");
        }
        if ((n & 2) != 0) {
            uRI = ippRequest.getPrinterOrJobUri();
        }
        return ippClient.exchange(ippRequest, uRI);
    }

    @NotNull
    public final IppRequestExchangedEvent exchangeForEvent(@NotNull IppRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return new IppRequestExchangedEvent(request, IppClient.exchange$default(this, request, null, 2, null));
    }

    @NotNull
    public final IppResponse exchangeWrapped(@NotNull IppRequest request) {
        IppResponse ippResponse;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        IppResponse it = ippResponse = IppClient.exchange$default(this, request, null, 2, null);
        boolean bl = false;
        try {
            IppClient.exchange$default(this, this.wrap(request, it), null, 2, null);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable.getCause();
            this.logger.finer(throwable2 != null ? throwable2.toString() : null);
        }
        return ippResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public IppResponse httpPost(@NotNull URI httpUri, @NotNull IppRequest request) {
        Intrinsics.checkNotNullParameter((Object)httpUri, (String)"httpUri");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URLConnection uRLConnection = httpUri.toURL().openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$httpPost_u24lambda_u2411 = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        if ($this$httpPost_u24lambda_u2411 instanceof HttpsURLConnection && this.config.getSslContext() != null) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)$this$httpPost_u24lambda_u2411;
            SSLContext sSLContext = this.config.getSslContext();
            Intrinsics.checkNotNull((Object)sSLContext);
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
            if (!this.config.getVerifySSLHostname()) {
                ((HttpsURLConnection)$this$httpPost_u24lambda_u2411).setHostnameVerifier(IppClient::httpPost$lambda$11$lambda$7);
            }
        }
        this.configure($this$httpPost_u24lambda_u2411, request.hasDocument(), request.getHttpUserAgent());
        try {
            Object object;
            IppMessage ippMessage = request;
            OutputStream outputStream = $this$httpPost_u24lambda_u2411.getOutputStream();
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
            IppMessage.write$default(ippMessage, outputStream, false, 2, null);
            try {
                IppClient.validateHttpResponse$default(this, $this$httpPost_u24lambda_u2411, request, $this$httpPost_u24lambda_u2411.getInputStream(), null, 4, null);
                object = $this$httpPost_u24lambda_u2411.getInputStream();
            }
            catch (IOException ioException) {
                this.validateHttpResponse($this$httpPost_u24lambda_u2411, request, $this$httpPost_u24lambda_u2411.getErrorStream(), ioException);
                object = $this$httpPost_u24lambda_u2411.getErrorStream();
            }
            InputStream responseContentStream = object;
            Intrinsics.checkNotNullExpressionValue((Object)responseContentStream, (String)"responseContentStream");
            Object $this$httpPost_u24lambda_u2411_u24lambda_u248 = object = this.decodeContentStream(request, responseContentStream);
            boolean bl2 = false;
            ((IppResponse)$this$httpPost_u24lambda_u2411_u24lambda_u248).setHttpServer($this$httpPost_u24lambda_u2411.getHeaderField("Server"));
            return object;
        }
        catch (IOException ioException) {
            StringBuilder stringBuilder;
            StringBuilder $this$httpPost_u24lambda_u2411_u24lambda_u2410 = stringBuilder = new StringBuilder();
            boolean bl3 = false;
            IOException $this$httpPost_u24lambda_u2411_u24lambda_u2410_u24lambda_u249 = ioException;
            boolean bl4 = false;
            $this$httpPost_u24lambda_u2411_u24lambda_u2410.append(httpUri + ": " + $this$httpPost_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.getClass().getSimpleName() + ": " + $this$httpPost_u24lambda_u2411_u24lambda_u2410_u24lambda_u249.getMessage());
            IppAttributesGroupKt.appendAttributeIfGroupContainsKey$default($this$httpPost_u24lambda_u2411_u24lambda_u2410, request.getOperationGroup(), "compression", false, null, 12, null);
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
            throw new HttpPostException(request, null, null, null, string, ioException, 14, null);
        }
        finally {
            if (this.disconnectAfterHttpPost) {
                $this$httpPost_u24lambda_u2411.disconnect();
            }
        }
    }

    private final void validateIppResponse(IppRequest request, IppResponse response) {
        IppResponse $this$validateIppResponse_u24lambda_u2414 = response;
        boolean bl = false;
        if ($this$validateIppResponse_u24lambda_u2414.getStatus() == IppStatus.ClientErrorBadRequest) {
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            request.log(this.logger, level, "REQUEST: ");
            Level level2 = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"WARNING");
            response.log(this.logger, level2, "RESPONSE: ");
        }
        if ($this$validateIppResponse_u24lambda_u2414.containsGroup(IppTag.Unsupported)) {
            Collection<IppAttribute<?>> collection = $this$validateIppResponse_u24lambda_u2414.getUnsupportedGroup().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"unsupportedGroup.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IppAttribute it = (IppAttribute)element$iv;
                boolean bl2 = false;
                this.logger.warning(() -> IppClient.validateIppResponse$lambda$14$lambda$13$lambda$12(it));
            }
        }
        if (!$this$validateIppResponse_u24lambda_u2414.isSuccessful()) {
            IppOperationException exception;
            IppRegistrationsSection2.INSTANCE.validate(request);
            IppOperationException ippOperationException = exception = $this$validateIppResponse_u24lambda_u2414.getStatus() == IppStatus.ClientErrorNotFound ? (IppOperationException)new IppOperationException.ClientErrorNotFoundException(request, response) : new IppOperationException(request, response, null, null, 12, null);
            if (this.onExceptionSaveMessages) {
                IppExchangeException.saveMessages$default(exception, null, "" + (Object)((Object)request.getOperation()) + '_' + (Object)((Object)$this$validateIppResponse_u24lambda_u2414.getStatus()) + '_' + request.getRequestId(), 1, null);
            }
            if (this.throwWhenNotSuccessful) {
                throw exception;
            }
        }
    }

    private final void configure(HttpURLConnection $this$configure, boolean chunked, String userAgent) {
        block2: {
            IppConfig $this$configure_u24lambda_u2415 = this.config;
            boolean bl = false;
            $this$configure.setConnectTimeout((int)$this$configure_u24lambda_u2415.getTimeout().toMillis());
            $this$configure.setReadTimeout((int)$this$configure_u24lambda_u2415.getTimeout().toMillis());
            if ($this$configure_u24lambda_u2415.getPassword() != null) {
                $this$configure.setRequestProperty("Authorization", $this$configure_u24lambda_u2415.authorization());
            }
            $this$configure.setDoOutput(true);
            if (chunked) {
                $this$configure.setChunkedStreamingMode(0);
            }
            $this$configure.setRequestProperty("Content-Type", APPLICATION_IPP);
            $this$configure.setRequestProperty("Accept", APPLICATION_IPP);
            $this$configure.setRequestProperty("Accept-Encoding", "identity");
            String string = userAgent;
            if (string == null) break block2;
            String it = string;
            boolean bl2 = false;
            $this$configure.setRequestProperty("User-Agent", it);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Void validateHttpResponse(HttpURLConnection $this$validateHttpResponse, IppRequest request, InputStream contentStream, Exception exception) {
        block7: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                var6_5 = $this$validateHttpResponse.getResponseCode();
                                v0 = 300 <= var6_5 ? var6_5 < 309 : false;
                                if (!v0) break block6;
                                v1 = "HTTP redirect: " + $this$validateHttpResponse.getResponseCode() + ", " + $this$validateHttpResponse.getResponseMessage() + ", Location: " + $this$validateHttpResponse.getHeaderField("Location");
                                break block7;
                            }
                            if ($this$validateHttpResponse.getResponseCode() != 401 || !request.getOperationGroup().containsKey((Object)"requesting-user-name")) break block8;
                            $this$validateHttpResponse_u24lambda_u2417 = request;
                            $i$a$-with-IppClient$validateHttpResponse$1 = false;
                            v1 = "User \"" + $this$validateHttpResponse_u24lambda_u2417.getRequestingUserName() + "\" is not authorized for operation " + (Object)$this$validateHttpResponse_u24lambda_u2417.getOperation() + " on " + $this$validateHttpResponse_u24lambda_u2417.getPrinterOrJobUri();
                            break block7;
                        }
                        if ($this$validateHttpResponse.getResponseCode() != 401) break block9;
                        $this$validateHttpResponse_u24lambda_u2418 = request;
                        $i$a$-with-IppClient$validateHttpResponse$2 = false;
                        v1 = "Not authorized for operation " + (Object)$this$validateHttpResponse_u24lambda_u2418.getOperation() + " on " + $this$validateHttpResponse_u24lambda_u2418.getPrinterOrJobUri() + " (userName required)";
                        break block7;
                    }
                    if ($this$validateHttpResponse.getResponseCode() != 426) break block10;
                    upgrade = $this$validateHttpResponse.getHeaderField("Upgrade");
                    v1 = "HTTP status " + $this$validateHttpResponse.getResponseCode() + ", " + $this$validateHttpResponse.getResponseMessage() + ", Try ipps://" + request.getPrinterOrJobUri().getHost() + ", Upgrade: " + upgrade;
                    break block7;
                }
                if ($this$validateHttpResponse.getResponseCode() == 200) break block11;
                v1 = "HTTP request failed: " + $this$validateHttpResponse.getResponseCode() + ", " + $this$validateHttpResponse.getResponseMessage();
                break block7;
            }
            if ($this$validateHttpResponse.getContentType() == null) ** GOTO lbl-1000
            v2 = $this$validateHttpResponse.getContentType();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"contentType");
            if (!StringsKt.startsWith$default((String)v2, (String)"application/ipp", (boolean)false, (int)2, null)) {
                v1 = "Invalid Content-Type: " + $this$validateHttpResponse.getContentType();
            } else lbl-1000:
            // 2 sources

            {
                v3 = exception;
                if (v3 != null) {
                    v1 = v3.getMessage();
                } else {
                    v4 = $this$validateHttpResponse.getHeaderFields();
                    Intrinsics.checkNotNullExpressionValue(v4, (String)"headerFields");
                    $this$forEach$iv = v4;
                    $i$f$forEach = false;
                    var8_12 = $this$forEach$iv.entrySet().iterator();
                    while (var8_12.hasNext()) {
                        var10_15 = element$iv = var8_12.next();
                        $i$a$-forEach-IppClient$validateHttpResponse$3 = false;
                        key = var10_15.getKey();
                        values = var10_15.getValue();
                        this.logger.finest((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, validateHttpResponse$lambda$20$lambda$19(java.lang.String java.util.List ), ()Ljava/lang/String;)((String)key, values));
                    }
                    v1 = var5_19 = null;
                }
            }
        }
        if (var5_19 != null) {
            it = var5_19;
            $i$a$-let-IppClient$validateHttpResponse$4 = false;
            throw new HttpPostException(request, $this$validateHttpResponse.getResponseCode(), $this$validateHttpResponse.getHeaderFields(), contentStream, it, exception);
        }
        return null;
    }

    static /* synthetic */ Void validateHttpResponse$default(IppClient ippClient, HttpURLConnection httpURLConnection, IppRequest ippRequest, InputStream inputStream, Exception exception, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validateHttpResponse");
        }
        if ((n & 4) != 0) {
            exception = null;
        }
        return ippClient.validateHttpResponse(httpURLConnection, ippRequest, inputStream, exception);
    }

    private final IppResponse decodeContentStream(IppRequest request, InputStream contentStream) {
        IppResponse ippResponse;
        IppResponse $this$decodeContentStream_u24lambda_u2423 = ippResponse = new IppResponse();
        boolean bl = false;
        try {
            $this$decodeContentStream_u24lambda_u2423.read(contentStream);
        }
        catch (Throwable throwable) {
            IppOperationException ippOperationException;
            IppOperationException $this$decodeContentStream_u24lambda_u2423_u24lambda_u2422 = ippOperationException = new IppOperationException(request, $this$decodeContentStream_u24lambda_u2423, "Failed to decode ipp response", throwable);
            boolean bl2 = false;
            if (this.onExceptionSaveMessages) {
                IppExchangeException.saveMessages$default($this$decodeContentStream_u24lambda_u2423_u24lambda_u2422, null, "decoding_ipp_response_" + request.getRequestId() + "_from_" + (Object)((Object)request.getOperation()) + "_failed", 1, null);
            }
            throw (Throwable)ippOperationException;
        }
        return ippResponse;
    }

    @JvmOverloads
    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable URI printerUri, @Nullable Collection<String> requestedAttributes, @Nullable String userName) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return IppClient.ippRequest$default(this, operation, printerUri, requestedAttributes, userName, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable URI printerUri, @Nullable Collection<String> requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return IppClient.ippRequest$default(this, operation, printerUri, requestedAttributes, null, null, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable URI printerUri) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return IppClient.ippRequest$default(this, operation, printerUri, null, null, null, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return IppClient.ippRequest$default(this, operation, null, null, null, null, 30, null);
    }

    @JvmOverloads
    @NotNull
    public final IppResponse exchange(@NotNull IppRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return IppClient.exchange$default(this, request, null, 2, null);
    }

    private static final String exchange$lambda$5$lambda$4$lambda$3$lambda$2(IppRequestExchangedEvent $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return $this_run.toString();
    }

    private static final boolean httpPost$lambda$11$lambda$7(String string, SSLSession sSLSession) {
        return true;
    }

    private static final String validateIppResponse$lambda$14$lambda$13$lambda$12(IppAttribute $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "Unsupported: " + $it;
    }

    private static final String validateHttpResponse$lambda$20$lambda$19(String $key, List $values) {
        return $key + ": " + $values;
    }

    public IppClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/gmuth/ipp/client/IppClient$Companion;", "", "()V", "APPLICATION_IPP", "", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

