/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.CupsClient;
import de.gmuth.ipp.client.IppClient;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.client.IppEventNotification;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppOperationException;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.client.WhichJobs;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007JJ\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u001a2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00105\u001a\u0004\u0018\u000106J6\u00107\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u001a2\u0006\u00108\u001a\u000209J\u0016\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\u001aJ8\u0010>\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u001a2\b\b\u0002\u0010?\u001a\u00020@J4\u0010A\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u001a2\u0006\u00101\u001a\u00020\u00032\b\u00102\u001a\u0004\u0018\u00010\u001a2\b\u00103\u001a\u0004\u0018\u00010\u001a2\b\u00104\u001a\u0004\u0018\u00010\u001aJ9\u0010B\u001a\u00020C2\u0014\b\u0002\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001a0E\"\u00020\u001a2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010G2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010G\u00a2\u0006\u0002\u0010IJ0\u0010B\u001a\u00020C2\u0010\b\u0002\u0010D\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010J2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010G2\n\b\u0002\u0010H\u001a\u0004\u0018\u00010GJT\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\u0006\u00100\u001a\u00020\u001a2\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u001a2\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u0010O\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u001aH\u0002J\u000e\u0010P\u001a\u00020/2\u0006\u00100\u001a\u00020\u001aJ\u0010\u0010Q\u001a\u00020/2\u0006\u0010R\u001a\u00020LH\u0002J\u0006\u0010S\u001a\u00020\u0016J\u000e\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u00020WJ;\u0010X\u001a\b\u0012\u0004\u0012\u00020U0Y2\n\b\u0002\u0010Z\u001a\u0004\u0018\u00010[2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010W2\u0010\b\u0002\u0010]\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010J\u00a2\u0006\u0002\u0010^J,\u0010_\u001a\b\u0012\u0004\u0012\u00020U0Y2\b\b\u0002\u0010Z\u001a\u00020[2\b\b\u0002\u0010`\u001a\u00020@2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u001aJ\f\u0010b\u001a\b\u0012\u0004\u0012\u00020\u001a0cJ\f\u0010d\u001a\b\u0012\u0004\u0012\u00020f0eJ\u000e\u0010g\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u001aJ\f\u0010h\u001a\b\u0012\u0004\u0012\u00020\u001a0JJ\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00160JJ\u000e\u0010j\u001a\u00020C2\u0006\u0010V\u001a\u00020WJ\f\u0010k\u001a\b\u0012\u0004\u0012\u00020C0JJ\u001a\u0010R\u001a\u00020L2\u0006\u0010M\u001a\u00020N2\b\b\u0002\u0010l\u001a\u00020\u0003H\u0002J\u000e\u0010m\u001a\u00020@2\u0006\u00100\u001a\u00020\u001aJ\u000e\u0010n\u001a\u00020/2\u0006\u00100\u001a\u00020\u001aJD\u0010o\u001a\u00020;2\b\b\u0002\u0010p\u001a\u00020\u001a2\b\b\u0002\u0010q\u001a\u00020G2\b\b\u0002\u0010r\u001a\u00020@2\b\b\u0002\u0010s\u001a\u00020G2\b\b\u0002\u0010t\u001a\u00020@2\n\b\u0002\u0010u\u001a\u0004\u0018\u00010\u001aR\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\f\u0010\r*\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\n \u0010*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010$\u001a\u0004\u0018\u00010\u001a2\b\u0010#\u001a\u0004\u0018\u00010\u001a8F@FX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0004\b(\u0010)\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001e*\u0004\b%\u0010\u000bR\u001b\u0010*\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b+\u0010\u001c\u00a8\u0006v"}, d2={"Lde/gmuth/ipp/client/CupsClient;", "", "cupsUri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "ippClient", "Lde/gmuth/ipp/client/IppClient;", "(Ljava/net/URI;Lde/gmuth/ipp/client/IppClient;)V", "config", "Lde/gmuth/ipp/client/IppConfig;", "getConfig$delegate", "(Lde/gmuth/ipp/client/CupsClient;)Ljava/lang/Object;", "getConfig", "()Lde/gmuth/ipp/client/IppConfig;", "cupsDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getCupsDirectory", "()Ljava/nio/file/Path;", "setCupsDirectory", "(Ljava/nio/file/Path;)V", "cupsServer", "Lde/gmuth/ipp/client/IppPrinter;", "getCupsUri", "()Ljava/net/URI;", "httpServer", "", "getHttpServer", "()Ljava/lang/String;", "setHttpServer", "(Ljava/lang/String;)V", "getIppClient", "()Lde/gmuth/ipp/client/IppClient;", "logger", "Ljava/util/logging/Logger;", "<set-?>", "userName", "getUserName$delegate", "getUserName", "setUserName", "userName$receiver", "Lde/gmuth/ipp/client/IppConfig;", "version", "getVersion", "version$delegate", "Lkotlin/Lazy;", "addModifyPrinter", "Lde/gmuth/ipp/core/IppResponse;", "printerName", "deviceUri", "printerInfo", "printerLocation", "ppdName", "ppdInputStream", "Ljava/io/InputStream;", "addPrinterWithPPD", "ppdFile", "Ljava/io/File;", "basicAuth", "", "user", "password", "createIppEverywherePrinter", "savePPD", "", "createLocalPrinter", "createSubscription", "Lde/gmuth/ipp/client/IppSubscription;", "notifyEvents", "", "notifyLeaseDuration", "Ljava/time/Duration;", "notifyTimeInterval", "([Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)Lde/gmuth/ipp/client/IppSubscription;", "", "cupsPrinterRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "Lde/gmuth/ipp/core/IppOperation;", "cupsPrinterUri", "deletePrinter", "exchange", "ippRequest", "getDefault", "getJob", "Lde/gmuth/ipp/client/IppJob;", "id", "", "getJobs", "", "whichJobs", "Lde/gmuth/ipp/client/WhichJobs;", "limit", "requestedAttributes", "(Lde/gmuth/ipp/client/WhichJobs;Ljava/lang/Integer;Ljava/util/List;)Ljava/util/Collection;", "getJobsAndSaveDocuments", "updateJobAttributes", "commandToHandleSavedFile", "getOwnersOfAllJobs", "Ljava/util/SortedSet;", "getOwnersOfAllSubscriptions", "", "Lde/gmuth/ipp/core/IppString;", "getPrinter", "getPrinterNames", "getPrinters", "getSubscription", "getSubscriptions", "printerURI", "printerExists", "setDefault", "subscribeToJobEventsAndThenGetDocuments", "whichJobEvents", "leaseDuration", "autoRenewLease", "pollEvery", "saveDocuments", "commandToHandleFile", "ipp-client"})
public final class CupsClient {
    @NotNull
    private final URI cupsUri;
    @NotNull
    private final IppClient ippClient;
    private final Logger logger;
    @NotNull
    private final IppConfig userName$receiver;
    private Path cupsDirectory;
    @NotNull
    private final IppPrinter cupsServer;
    @NotNull
    private final Lazy version$delegate;
    @Nullable
    private String httpServer;

    /*
     * WARNING - void declaration
     */
    public CupsClient(@NotNull URI cupsUri, @NotNull IppClient ippClient) {
        void $this$cupsServer_u24lambda_u241;
        IppPrinter ippPrinter;
        IppPrinter $this$cupsDirectory_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)cupsUri, (String)"cupsUri");
        Intrinsics.checkNotNullParameter((Object)ippClient, (String)"ippClient");
        this.cupsUri = cupsUri;
        this.ippClient = ippClient;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.userName$receiver = this.getConfig();
        URI uRI = this.cupsUri;
        CupsClient cupsClient = this;
        boolean bl = false;
        Object[] objectArray = new String[]{"localhost", "127.0.0.1"};
        cupsClient.cupsDirectory = Path.of("CUPS" + (CollectionsKt.listOf((Object[])objectArray).contains(((URI)((Object)$this$cupsDirectory_u24lambda_u240)).getHost()) ? "-" : File.separator) + ((URI)((Object)$this$cupsDirectory_u24lambda_u240)).getHost(), new String[0]);
        $this$cupsDirectory_u24lambda_u240 = ippPrinter = new IppPrinter(this.cupsUri, null, null, this.ippClient, false, null, 38, null);
        cupsClient = this;
        boolean bl2 = false;
        Path path = this.cupsDirectory;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cupsDirectory");
        $this$cupsServer_u24lambda_u241.setPrinterDirectory(path);
        cupsClient.cupsServer = ippPrinter;
        if (this.cupsUri.getScheme() == null) {
            boolean bl3 = false;
            String string = "URI scheme required";
            throw new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)this.cupsUri.getScheme(), (Object)"ipps")) {
            this.getConfig().trustAnyCertificateAndSSLHostname();
        }
        this.version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ CupsClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object;
                try {
                    object = this.this$0.getPrinters();
                    CupsClient cupsClient = this.this$0;
                    Object $this$invoke_u24lambda_u240 = object;
                    boolean bl = false;
                    object = (!((Collection)$this$invoke_u24lambda_u240).isEmpty() ? (IppPrinter)CollectionsKt.last((List)$this$invoke_u24lambda_u240) : new IppPrinter(((IppJob)CollectionsKt.last((Iterable)CupsClient.getJobs$default(cupsClient, WhichJobs.All, null, null, 6, null))).getPrinterUri(), null, null, null, false, null, 62, null)).getCupsVersion();
                }
                catch (NoSuchElementException exception) {
                    object = "?";
                }
                return object;
            }
        }));
    }

    public /* synthetic */ CupsClient(URI uRI, IppClient ippClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = URI.create("ipps://localhost");
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"create(\"ipps://localhost\")");
            uRI = uRI2;
        }
        if ((n & 2) != 0) {
            ippClient = new IppClient(null, 1, null);
        }
        this(uRI, ippClient);
    }

    @NotNull
    public final URI getCupsUri() {
        return this.cupsUri;
    }

    @NotNull
    public final IppClient getIppClient() {
        return this.ippClient;
    }

    @JvmOverloads
    public CupsClient(@NotNull URI cupsUri) {
        Intrinsics.checkNotNullParameter((Object)cupsUri, (String)"cupsUri");
        this(cupsUri, new IppClient(null, 1, null));
    }

    public /* synthetic */ CupsClient(URI uRI, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = URI.create("ipps://localhost");
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"create(\"ipps://localhost\")");
            uRI = uRI2;
        }
        this(uRI);
    }

    @NotNull
    public final IppConfig getConfig() {
        return this.ippClient.getConfig();
    }

    private static Object getConfig$delegate(CupsClient cupsClient) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)cupsClient.ippClient, IppClient.class, "config", "getConfig()Lde/gmuth/ipp/client/IppConfig;", 0)));
    }

    @Nullable
    public final String getUserName() {
        return this.userName$receiver.getUserName();
    }

    public final void setUserName(@Nullable String string) {
        this.userName$receiver.setUserName(string);
    }

    private static Object getUserName$delegate(CupsClient cupsClient) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)cupsClient.userName$receiver, IppConfig.class, "userName", "getUserName()Ljava/lang/String;", 0)));
    }

    public final Path getCupsDirectory() {
        return this.cupsDirectory;
    }

    public final void setCupsDirectory(Path path) {
        this.cupsDirectory = path;
    }

    private final URI cupsPrinterUri(String printerName) {
        URI uRI;
        URI $this$cupsPrinterUri_u24lambda_u243 = this.cupsUri;
        boolean bl = false;
        URI $this$cupsPrinterUri_u24lambda_u245 = uRI = new URI($this$cupsPrinterUri_u24lambda_u243.getScheme() + "://" + $this$cupsPrinterUri_u24lambda_u243.getHost() + ($this$cupsPrinterUri_u24lambda_u243.getPort() > 0 ? "" + ':' + $this$cupsPrinterUri_u24lambda_u243.getPort() : "") + "/printers/" + printerName);
        boolean bl2 = false;
        this.logger.finer(() -> CupsClient.cupsPrinterUri$lambda$5$lambda$4(printerName, $this$cupsPrinterUri_u24lambda_u245));
        return uRI;
    }

    @NotNull
    public final String getVersion() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppPrinter> getPrinters() {
        List list;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.exchange(CupsClient.ippRequest$default(this, IppOperation.CupsGetPrinters, null, 2, null)).getAttributesGroups(IppTag.Printer);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IppPrinter((IppAttributesGroup)it, this.ippClient));
            }
            list = (List)destination$iv$iv;
        }
        catch (IppOperationException.ClientErrorNotFoundException clientErrorNotFoundException) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPrinterNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getPrinters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppPrinter ippPrinter = (IppPrinter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().toString());
        }
        return (List)destination$iv$iv;
    }

    public final boolean printerExists(@NotNull String printerName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.getPrinterNames().contains(printerName);
    }

    @NotNull
    public final IppPrinter getPrinter(@NotNull String printerName) {
        IppPrinter ippPrinter;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        try {
            IppPrinter $this$getPrinter_u24lambda_u248 = ippPrinter = new IppPrinter(this.cupsPrinterUri(printerName), null, null, this.ippClient, false, null, 54, null);
            boolean bl = false;
            Path path = this.cupsDirectory.resolve(printerName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cupsDirectory.resolve(printerName)");
            $this$getPrinter_u24lambda_u248.setPrinterDirectory(path);
        }
        catch (IppOperationException.ClientErrorNotFoundException clientErrorNotFoundException) {
            List<IppPrinter> $this$getPrinter_u24lambda_u2411 = this.getPrinters();
            boolean bl = false;
            if (!((Collection)$this$getPrinter_u24lambda_u2411).isEmpty()) {
                this.logger.warning(() -> CupsClient.getPrinter$lambda$11$lambda$10($this$getPrinter_u24lambda_u2411));
            }
            throw clientErrorNotFoundException;
        }
        return ippPrinter;
    }

    @NotNull
    public final IppPrinter getDefault() {
        return new IppPrinter(this.exchange(CupsClient.ippRequest$default(this, IppOperation.CupsGetDefault, null, 2, null)).getPrinterGroup(), this.ippClient);
    }

    @NotNull
    public final IppResponse setDefault(@NotNull String printerName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.exchange(CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsSetDefault, printerName, null, null, null, null, null, 124, null));
    }

    @NotNull
    public final IppResponse addModifyPrinter(@NotNull String printerName, @Nullable URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, @Nullable String ppdName, @Nullable InputStream ppdInputStream) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.exchange(this.cupsPrinterRequest(IppOperation.CupsAddModifyPrinter, printerName, deviceUri, printerInfo, printerLocation, ppdName, ppdInputStream));
    }

    public static /* synthetic */ IppResponse addModifyPrinter$default(CupsClient cupsClient, String string, URI uRI, String string2, String string3, String string4, InputStream inputStream, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            inputStream = null;
        }
        return cupsClient.addModifyPrinter(string, uRI, string2, string3, string4, inputStream);
    }

    @NotNull
    public final IppPrinter addPrinterWithPPD(@NotNull String printerName, @NotNull URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, @NotNull File ppdFile) {
        IppPrinter ippPrinter;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        Intrinsics.checkNotNullParameter((Object)deviceUri, (String)"deviceUri");
        Intrinsics.checkNotNullParameter((Object)ppdFile, (String)"ppdFile");
        IppResponse $this$addPrinterWithPPD_u24lambda_u2413 = CupsClient.addModifyPrinter$default(this, printerName, deviceUri, printerInfo, printerLocation, null, new FileInputStream(ppdFile), 16, null);
        boolean bl = false;
        IppPrinter $this$addPrinterWithPPD_u24lambda_u2413_u24lambda_u2412 = ippPrinter = this.getPrinter(printerName);
        boolean bl2 = false;
        $this$addPrinterWithPPD_u24lambda_u2413_u24lambda_u2412.enable();
        $this$addPrinterWithPPD_u24lambda_u2413_u24lambda_u2412.resume();
        IppPrinter.updateAttributes$default($this$addPrinterWithPPD_u24lambda_u2413_u24lambda_u2412, null, 1, null);
        return ippPrinter;
    }

    public static /* synthetic */ IppPrinter addPrinterWithPPD$default(CupsClient cupsClient, String string, URI uRI, String string2, String string3, File file, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return cupsClient.addPrinterWithPPD(string, uRI, string2, string3, file);
    }

    @NotNull
    public final IppResponse deletePrinter(@NotNull String printerName) {
        IppResponse ippResponse;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        IppResponse $this$deletePrinter_u24lambda_u2415 = ippResponse = this.exchange(CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsDeletePrinter, printerName, null, null, null, null, null, 124, null));
        boolean bl = false;
        this.logger.info(() -> CupsClient.deletePrinter$lambda$15$lambda$14(printerName));
        return ippResponse;
    }

    @NotNull
    public final IppPrinter createLocalPrinter(@NotNull String printerName, @NotNull URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, @Nullable String ppdName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        Intrinsics.checkNotNullParameter((Object)deviceUri, (String)"deviceUri");
        if (!(!StringsKt.contains$default((CharSequence)printerName, (CharSequence)"-", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-CupsClient$createLocalPrinter$22 = false;
            String $i$a$-require-CupsClient$createLocalPrinter$22 = "printerName must not contain '-'";
            throw new IllegalArgumentException($i$a$-require-CupsClient$createLocalPrinter$22.toString());
        }
        IppResponse $this$createLocalPrinter_u24lambda_u2418 = this.exchange(CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsCreateLocalPrinter, printerName, deviceUri, printerInfo, printerLocation, ppdName, null, 64, null));
        boolean bl = false;
        this.logger.info(() -> CupsClient.createLocalPrinter$lambda$18$lambda$17($this$createLocalPrinter_u24lambda_u2418));
        return new IppPrinter($this$createLocalPrinter_u24lambda_u2418.getPrinterGroup(), this.ippClient);
    }

    private final IppRequest cupsPrinterRequest(IppOperation operation, String printerName, URI deviceUri, String printerInfo, String printerLocation, String ppdName, InputStream ppdInputStream) {
        IppRequest ippRequest;
        block4: {
            Object[] objectArray;
            Object it;
            IppRequest $this$cupsPrinterRequest_u24lambda_u2425 = ippRequest = this.ippRequest(operation, this.cupsPrinterUri(printerName));
            boolean bl = false;
            IppAttributesGroup $this$cupsPrinterRequest_u24lambda_u2425_u24lambda_u2423 = $this$cupsPrinterRequest_u24lambda_u2425.createAttributesGroup(IppTag.Printer);
            boolean bl2 = false;
            Object[] objectArray2 = new Object[]{printerName};
            $this$cupsPrinterRequest_u24lambda_u2425_u24lambda_u2423.attribute("printer-name", IppTag.NameWithoutLanguage, objectArray2);
            URI uRI = deviceUri;
            if (uRI != null) {
                it = uRI;
                boolean bl3 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2425_u24lambda_u2423.attribute("device-uri", IppTag.Uri, objectArray);
            }
            String string = ppdName;
            if (string != null) {
                it = string;
                boolean bl4 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2425_u24lambda_u2423.attribute("ppd-name", IppTag.NameWithoutLanguage, objectArray);
            }
            String string2 = printerInfo;
            if (string2 != null) {
                it = string2;
                boolean bl5 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2425_u24lambda_u2423.attribute("printer-info", IppTag.TextWithoutLanguage, objectArray);
            }
            String string3 = printerLocation;
            if (string3 != null) {
                it = string3;
                boolean bl6 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2425_u24lambda_u2423.attribute("printer-location", IppTag.TextWithoutLanguage, objectArray);
            }
            InputStream inputStream = ppdInputStream;
            if (inputStream == null) break block4;
            InputStream it2 = inputStream;
            boolean bl7 = false;
            $this$cupsPrinterRequest_u24lambda_u2425.setDocumentInputStream(ppdInputStream);
        }
        return ippRequest;
    }

    static /* synthetic */ IppRequest cupsPrinterRequest$default(CupsClient cupsClient, IppOperation ippOperation, String string, URI uRI, String string2, String string3, String string4, InputStream inputStream, int n, Object object) {
        if ((n & 4) != 0) {
            uRI = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            inputStream = null;
        }
        return cupsClient.cupsPrinterRequest(ippOperation, string, uRI, string2, string3, string4, inputStream);
    }

    public final void basicAuth(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.ippClient.basicAuth(user, password);
    }

    private final IppRequest ippRequest(IppOperation operation, URI printerURI) {
        return IppClient.ippRequest$default(this.ippClient, operation, printerURI, null, null, null, 28, null);
    }

    static /* synthetic */ IppRequest ippRequest$default(CupsClient cupsClient, IppOperation ippOperation, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = cupsClient.cupsUri;
        }
        return cupsClient.ippRequest(ippOperation, uRI);
    }

    private final IppResponse exchange(IppRequest ippRequest) {
        IppResponse ippResponse;
        IppResponse it = ippResponse = IppClient.exchange$default(this.ippClient, ippRequest, null, 2, null);
        boolean bl = false;
        this.httpServer = it.getHttpServer();
        return ippResponse;
    }

    @Nullable
    public final String getHttpServer() {
        return this.httpServer;
    }

    public final void setHttpServer(@Nullable String string) {
        this.httpServer = string;
    }

    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs, @Nullable Integer limit, @Nullable List<String> requestedAttributes) {
        return IppPrinter.getJobs$default(this.cupsServer, whichJobs, null, limit, requestedAttributes, 2, null);
    }

    public static /* synthetic */ Collection getJobs$default(CupsClient cupsClient, WhichJobs whichJobs, Integer n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            whichJobs = null;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            list = cupsClient.cupsServer.getGetJobsRequestedAttributes();
        }
        return cupsClient.getJobs(whichJobs, n, list);
    }

    @NotNull
    public final IppJob getJob(int id) {
        return this.cupsServer.getJob(id);
    }

    @NotNull
    public final List<IppSubscription> getSubscriptions() {
        return IppPrinter.getSubscriptions$default(this.cupsServer, null, null, null, null, 15, null);
    }

    @NotNull
    public final IppSubscription getSubscription(int id) {
        return this.cupsServer.getSubscription(id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<IppString> getOwnersOfAllSubscriptions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSubscriptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppSubscription ippSubscription = (IppSubscription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSubscriberUserName());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final IppSubscription createSubscription(@Nullable List<String> notifyEvents, @Nullable Duration notifyLeaseDuration, @Nullable Duration notifyTimeInterval) {
        return this.cupsServer.createPrinterSubscription((Collection<String>)notifyEvents, notifyLeaseDuration, notifyTimeInterval);
    }

    public static /* synthetic */ IppSubscription createSubscription$default(CupsClient cupsClient, List list, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.listOf((Object)"all");
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            duration2 = null;
        }
        return cupsClient.createSubscription(list, duration, duration2);
    }

    @NotNull
    public final IppSubscription createSubscription(@NotNull String[] notifyEvents, @Nullable Duration notifyLeaseDuration, @Nullable Duration notifyTimeInterval) {
        Intrinsics.checkNotNullParameter((Object)notifyEvents, (String)"notifyEvents");
        return this.createSubscription(ArraysKt.toList((Object[])notifyEvents), notifyLeaseDuration, notifyTimeInterval);
    }

    public static /* synthetic */ IppSubscription createSubscription$default(CupsClient cupsClient, String[] stringArray, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            String[] stringArray2 = new String[]{"all"};
            stringArray = stringArray2;
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            duration2 = null;
        }
        return cupsClient.createSubscription(stringArray, duration, duration2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppPrinter createIppEverywherePrinter(@NotNull String printerName, @NotNull URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, boolean savePPD) {
        void $this$createIppEverywherePrinter_u24lambda_u2434_u24lambda_u2432;
        IppPrinter ippPrinter;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        Intrinsics.checkNotNullParameter((Object)deviceUri, (String)"deviceUri");
        IppPrinter $this$createIppEverywherePrinter_u24lambda_u2434 = ippPrinter = this.createLocalPrinter(printerName, deviceUri, printerInfo, printerLocation, "everywhere");
        boolean bl = false;
        $this$createIppEverywherePrinter_u24lambda_u2434.setThrowIfSupportedAttributeIsNotAvailable(false);
        Object object = new String[]{"printer-name"};
        $this$createIppEverywherePrinter_u24lambda_u2434.updateAttributes((String)object);
        this.logger.info($this$createIppEverywherePrinter_u24lambda_u2434.toString());
        this.logger.info(CupsClient::createIppEverywherePrinter$lambda$34$lambda$29);
        try {
            String string;
            do {
                object = new String[]{"printer-make-and-model"};
                $this$createIppEverywherePrinter_u24lambda_u2434.updateAttributes((String)object);
                Thread.sleep(500L);
                string = $this$createIppEverywherePrinter_u24lambda_u2434.getMakeAndModel().getText().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            } while (!StringsKt.contains$default((CharSequence)string, (CharSequence)"everywhere", (boolean)false, (int)2, null));
        }
        catch (IppOperationException.ClientErrorNotFoundException exception) {
            this.logger.warning(CupsClient::createIppEverywherePrinter$lambda$34$lambda$30);
            throw new IppException("Failed to createIppEverywherePrinter() as described here: https://github.com/apple/cups/issues/5919", null, 2, null);
        }
        this.logger.info(CupsClient::createIppEverywherePrinter$lambda$34$lambda$31);
        Object object2 = object = CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsAddModifyPrinter, printerName, null, null, null, null, null, 124, null);
        IppPrinter ippPrinter2 = $this$createIppEverywherePrinter_u24lambda_u2434;
        boolean bl2 = false;
        Object[] objectArray = new Object[]{false};
        $this$createIppEverywherePrinter_u24lambda_u2434_u24lambda_u2432.getPrinterGroup().attribute("printer-is-temporary", IppTag.Boolean, objectArray);
        ippPrinter2.exchange((IppRequest)object);
        this.logger.info(CupsClient::createIppEverywherePrinter$lambda$34$lambda$33);
        $this$createIppEverywherePrinter_u24lambda_u2434.enable();
        $this$createIppEverywherePrinter_u24lambda_u2434.resume();
        IppPrinter.updateAttributes$default($this$createIppEverywherePrinter_u24lambda_u2434, null, 1, null);
        if (savePPD) {
            IppPrinter.savePPD$default($this$createIppEverywherePrinter_u24lambda_u2434, null, null, 3, null);
        }
        return ippPrinter;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ IppPrinter createIppEverywherePrinter$default(CupsClient cupsClient, String string, URI uRI, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            void $this$createIppEverywherePrinter_u24lambda_u2428;
            IppConfig ippConfig;
            IppConfig ippConfig2 = ippConfig = new IppConfig(null, null, null, null, null, null, null, null, false, 511, null);
            IppAttributesGroup ippAttributesGroup = null;
            URI uRI2 = uRI;
            boolean bl2 = false;
            $this$createIppEverywherePrinter_u24lambda_u2428.trustAnyCertificateAndSSLHostname();
            Unit unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 58;
            List list = null;
            boolean bl3 = false;
            IppClient ippClient = null;
            IppConfig ippConfig3 = ippConfig;
            IppAttributesGroup ippAttributesGroup2 = ippAttributesGroup;
            URI uRI3 = uRI2;
            string3 = new IppPrinter(uRI3, ippAttributesGroup2, ippConfig3, ippClient, bl3, list, n2, defaultConstructorMarker).getLocation().getText();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return cupsClient.createIppEverywherePrinter(string, uRI, string2, string3, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedSet<String> getOwnersOfAllJobs() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CupsClient.getJobs$default(this, WhichJobs.All, null, null, 6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IppJob it = (IppJob)element$iv$iv;
            boolean bl2 = false;
            if (it.getOriginatingUserNameOrAppleJobOwnerOrNull() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSortedSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<IppJob> getJobsAndSaveDocuments(@NotNull WhichJobs whichJobs, boolean updateJobAttributes, @Nullable String commandToHandleSavedFile) {
        IppJob it;
        void $this$onEach$iv;
        void var8_9;
        Intrinsics.checkNotNullParameter((Object)((Object)whichJobs), (String)"whichJobs");
        AtomicInteger numberOfJobsWithoutDocuments = new AtomicInteger(0);
        AtomicInteger numberOfSavedDocuments = new AtomicInteger(0);
        Object object = new String[]{"job-id", "job-uri", "job-printer-uri", "job-originating-user-name", "job-name", "job-state", "job-state-reasons", this.getVersion().compareTo("1.6.0") < 0 ? "document-count" : "number-of-documents"};
        object = CupsClient.getJobs$default(this, whichJobs, null, CollectionsKt.listOf((Object[])object), 2, null);
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var8_9 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            it = (IppJob)element$iv;
            boolean bl2 = false;
            if (updateJobAttributes) {
                IppJob.updateAttributes$default(it, null, 1, null);
            }
            this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$37$lambda$36(it));
        }
        $this$onEach$iv = var8_9;
        $i$f$onEach = false;
        $this$onEach_u24lambda_u2416$iv = var8_9 = $this$onEach$iv;
        bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            IppJob ippJob;
            it = (IppJob)element$iv;
            boolean bl3 = false;
            IppJob $this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440 = ippJob = it;
            boolean bl4 = false;
            if ($this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440.getNumberOfDocumentsOrDocumentCount() == 0) {
                numberOfJobsWithoutDocuments.incrementAndGet();
                continue;
            }
            try {
                List<IppDocument> list;
                $this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440.setUseJobOwnerAsUserName(true);
                String string = $this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440.getPrinterUri().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"printerUri.path");
                Path path = this.cupsDirectory.resolve(StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"cupsDirectory.resolve(pr\u2026.substringAfterLast(\"/\"))");
                List<IppDocument> $this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440_u24lambda_u2438 = list = $this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440.cupsGetDocuments(true, path, commandToHandleSavedFile);
                boolean bl5 = false;
                numberOfSavedDocuments.addAndGet($this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440_u24lambda_u2438.size());
            }
            catch (IppExchangeException ippExchangeException) {
                this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$41$lambda$40$lambda$39($this$getJobsAndSaveDocuments_u24lambda_u2441_u24lambda_u2440, ippExchangeException));
            }
        }
        object = var8_9;
        Collection $this$getJobsAndSaveDocuments_u24lambda_u2444 = (Collection)object;
        boolean bl6 = false;
        this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$44$lambda$42($this$getJobsAndSaveDocuments_u24lambda_u2444, whichJobs, numberOfJobsWithoutDocuments));
        this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$44$lambda$43(numberOfSavedDocuments, $this$getJobsAndSaveDocuments_u24lambda_u2444, numberOfJobsWithoutDocuments, this));
        return (Collection)object;
    }

    public static /* synthetic */ Collection getJobsAndSaveDocuments$default(CupsClient cupsClient, WhichJobs whichJobs, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            whichJobs = WhichJobs.All;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return cupsClient.getJobsAndSaveDocuments(whichJobs, bl, string);
    }

    public final void subscribeToJobEventsAndThenGetDocuments(@NotNull String whichJobEvents, @NotNull Duration leaseDuration, boolean autoRenewLease, @NotNull Duration pollEvery, boolean saveDocuments, @Nullable String commandToHandleFile) {
        Intrinsics.checkNotNullParameter((Object)whichJobEvents, (String)"whichJobEvents");
        Intrinsics.checkNotNullParameter((Object)leaseDuration, (String)"leaseDuration");
        Intrinsics.checkNotNullParameter((Object)pollEvery, (String)"pollEvery");
        String[] stringArray = new String[]{whichJobEvents};
        CupsClient.createSubscription$default(this, stringArray, leaseDuration, null, 4, null).pollAndHandleNotifications(pollEvery, autoRenewLease, (Function1<? super IppEventNotification, Unit>)((Function1)new Function1<IppEventNotification, Unit>(this, saveDocuments, commandToHandleFile){
            final /* synthetic */ CupsClient this$0;
            final /* synthetic */ boolean $saveDocuments;
            final /* synthetic */ String $commandToHandleFile;
            {
                this.this$0 = $receiver;
                this.$saveDocuments = $saveDocuments;
                this.$commandToHandleFile = $commandToHandleFile;
                super(1);
            }

            public final void invoke(@NotNull IppEventNotification event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CupsClient.access$getLogger$p(this.this$0).info(() -> subscribeToJobEventsAndThenGetDocuments.1.invoke$lambda$0(event));
                IppJob ippJob = event.getJob();
                CupsClient cupsClient = this.this$0;
                boolean bl = this.$saveDocuments;
                String string = this.$commandToHandleFile;
                IppJob $this$invoke_u24lambda_u242 = ippJob;
                boolean bl2 = false;
                while ($this$invoke_u24lambda_u242.isIncoming()) {
                    CupsClient.access$getLogger$p(cupsClient).info(() -> subscribeToJobEventsAndThenGetDocuments.1.invoke$lambda$2$lambda$1($this$invoke_u24lambda_u242));
                    Thread.sleep(1969L);
                    IppJob.updateAttributes$default($this$invoke_u24lambda_u242, null, 1, null);
                }
                $this$invoke_u24lambda_u242.setUseJobOwnerAsUserName(true);
                IppJob.cupsGetDocuments$default($this$invoke_u24lambda_u242, bl, null, string, 2, null);
            }

            private static final String invoke$lambda$0(IppEventNotification $event) {
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                return $event.toString();
            }

            private static final String invoke$lambda$2$lambda$1(IppJob $this_with) {
                Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
                return $this_with.toString();
            }
        }));
    }

    public static /* synthetic */ void subscribeToJobEventsAndThenGetDocuments$default(CupsClient cupsClient, String string, Duration duration, boolean bl, Duration duration2, boolean bl2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "job-created";
        }
        if ((n & 2) != 0) {
            Duration duration3 = Duration.ofMinutes(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(60)");
            duration = duration3;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            Duration duration4 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(1)");
            duration2 = duration4;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        cupsClient.subscribeToJobEventsAndThenGetDocuments(string, duration, bl, duration2, bl2, string2);
    }

    @JvmOverloads
    public CupsClient() {
        this(null, 1, null);
    }

    private static final String cupsPrinterUri$lambda$5$lambda$4(String $printerName, URI $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$printerName, (String)"$printerName");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "cupsPrinterUri(" + $printerName + ") = " + $this_apply;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getPrinter$lambda$11$lambda$10(List $this_with) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Iterable iterable = $this_with;
        StringBuilder stringBuilder = new StringBuilder().append("Available CUPS printers: ");
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppPrinter ippPrinter = (IppPrinter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return stringBuilder.append((List)destination$iv$iv).toString();
    }

    private static final String deletePrinter$lambda$15$lambda$14(String $printerName) {
        Intrinsics.checkNotNullParameter((Object)$printerName, (String)"$printerName");
        return "Printer deleted: " + $printerName;
    }

    private static final String createLocalPrinter$lambda$18$lambda$17(IppResponse $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "" + $this_run.getStatusMessage() + ' ' + $this_run.getPrinterGroup().getValues("printer-uri-supported");
    }

    private static final String createIppEverywherePrinter$lambda$34$lambda$29() {
        return "CUPS now should generate an everywhere PPD. Waiting for 'everywhere' in printer-make-and-model.";
    }

    private static final String createIppEverywherePrinter$lambda$34$lambda$30() {
        return "Check your CUPS log files - it looks like the everywhere PPD wasn't generated...";
    }

    private static final String createIppEverywherePrinter$lambda$34$lambda$31() {
        return "Make printer permanent.";
    }

    private static final String createIppEverywherePrinter$lambda$34$lambda$33() {
        return "Make printer operational.";
    }

    private static final String getJobsAndSaveDocuments$lambda$37$lambda$36(IppJob $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return String.valueOf($it);
    }

    private static final String getJobsAndSaveDocuments$lambda$41$lambda$40$lambda$39(IppJob $this_apply, IppExchangeException $ippExchangeException) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$ippExchangeException, (String)"$ippExchangeException");
        return "Get documents for job #" + $this_apply.getId() + " failed: " + $ippExchangeException.getMessage();
    }

    private static final String getJobsAndSaveDocuments$lambda$44$lambda$42(Collection $this_apply, WhichJobs $whichJobs, AtomicInteger $numberOfJobsWithoutDocuments) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)((Object)$whichJobs), (String)"$whichJobs");
        Intrinsics.checkNotNullParameter((Object)$numberOfJobsWithoutDocuments, (String)"$numberOfJobsWithoutDocuments");
        return "Found " + $this_apply.size() + " jobs (which=" + (Object)((Object)$whichJobs) + ") where " + $numberOfJobsWithoutDocuments + " jobs have no documents";
    }

    private static final String getJobsAndSaveDocuments$lambda$44$lambda$43(AtomicInteger $numberOfSavedDocuments, Collection $this_apply, AtomicInteger $numberOfJobsWithoutDocuments, CupsClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$numberOfSavedDocuments, (String)"$numberOfSavedDocuments");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$numberOfJobsWithoutDocuments, (String)"$numberOfJobsWithoutDocuments");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Saved " + $numberOfSavedDocuments + " documents of " + ($this_apply.size() - $numberOfJobsWithoutDocuments.intValue()) + " jobs with documents to directory: " + this$0.cupsDirectory;
    }

    public static final /* synthetic */ Logger access$getLogger$p(CupsClient $this) {
        return $this.logger;
    }
}

