/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.attributes;

import de.gmuth.ipp.attributes.MediaCollection;
import de.gmuth.ipp.attributes.MediaSize;
import de.gmuth.ipp.attributes.MediaSource;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0007J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0016\u001a\u00020\u000bJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0007J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\u0007H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\tR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006 "}, d2={"Lde/gmuth/ipp/attributes/MediaColDatabase;", "", "mediaCollections", "", "Lde/gmuth/ipp/attributes/MediaCollection;", "(Ljava/util/List;)V", "distinctMediaKeys", "", "getDistinctMediaKeys", "()Ljava/util/List;", "distinctMediaSizes", "Lde/gmuth/ipp/attributes/MediaSize;", "getDistinctMediaSizes", "distinctMediaSources", "Lde/gmuth/ipp/attributes/MediaSource;", "getDistinctMediaSources", "distinctMediaTypes", "getDistinctMediaTypes", "getMediaCollections", "findByMediaKeyContaining", "text", "findByMediaSize", "size", "findByMediaSizeNameContaining", "log", "", "logger", "Ljava/util/logging/Logger;", "level", "Ljava/util/logging/Level;", "toString", "Companion", "ipp-client"})
public final class MediaColDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<MediaCollection> mediaCollections;

    public MediaColDatabase(@NotNull List<MediaCollection> mediaCollections) {
        Intrinsics.checkNotNullParameter(mediaCollections, (String)"mediaCollections");
        this.mediaCollections = mediaCollections;
    }

    @NotNull
    public final List<MediaCollection> getMediaCollections() {
        return this.mediaCollections;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MediaCollection> findByMediaSize(@NotNull MediaSize size) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Iterable $this$filter$iv = this.mediaCollections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl = false;
            if (!it.sizeEqualsByDimensions(size)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MediaCollection> findByMediaSizeNameContaining(@NotNull String text) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$filter$iv = this.mediaCollections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl = false;
            String string = it.getSizeName();
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)text, (boolean)false, (int)2, null) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MediaCollection> findByMediaKeyContaining(@NotNull String text) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Iterable $this$filter$iv = this.mediaCollections;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl = false;
            String string = it.getKey();
            if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)text, (boolean)false, (int)2, null) : false)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDistinctMediaKeys() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.mediaCollections;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl2 = false;
            if (it.getKey() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getDistinctMediaTypes() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.mediaCollections;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl2 = false;
            if (it.getType() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MediaSource> getDistinctMediaSources() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.mediaCollections;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MediaSource it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl2 = false;
            if (it.getSource() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MediaSize> getDistinctMediaSizes() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.mediaCollections;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MediaSize it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MediaCollection it = (MediaCollection)element$iv$iv;
            boolean bl2 = false;
            if (it.getSize() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u247 = stringBuilder = new StringBuilder("MEDIA-COL-DATABASE:");
        boolean bl = false;
        $this$toString_u24lambda_u247.append("" + ' ' + this.mediaCollections.size() + " definitions");
        $this$toString_u24lambda_u247.append(", " + this.getDistinctMediaSources().size() + " distinct sources");
        $this$toString_u24lambda_u247.append(", " + this.getDistinctMediaSizes().size() + " distinct sizes");
        $this$toString_u24lambda_u247.append(", " + this.getDistinctMediaTypes().size() + " distinct types");
        $this$toString_u24lambda_u247.append(", " + this.getDistinctMediaKeys().size() + " distinct keys");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"MEDIA-COL\u2026t keys\")\n    }.toString()");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        logger.log(level, this.toString());
        List<MediaSource> $this$log_u24lambda_u249 = this.getDistinctMediaSources();
        boolean bl = false;
        if (!((Collection)$this$log_u24lambda_u249).isEmpty()) {
            logger.log(level, "media-sources:");
        }
        Iterable $this$forEach$iv = $this$log_u24lambda_u249;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MediaSource)element$iv;
            boolean bl2 = false;
            logger.log(level, "" + ' ' + it);
        }
        List<MediaSize> $this$log_u24lambda_u2411 = this.getDistinctMediaSizes();
        boolean bl3 = false;
        if (!((Collection)$this$log_u24lambda_u2411).isEmpty()) {
            logger.log(level, "media-sizes:");
        }
        $this$forEach$iv = $this$log_u24lambda_u2411;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MediaSize)element$iv;
            boolean bl4 = false;
            logger.log(level, "" + ' ' + it);
        }
        List<String> $this$log_u24lambda_u2413 = this.getDistinctMediaTypes();
        boolean bl5 = false;
        if (!((Collection)$this$log_u24lambda_u2413).isEmpty()) {
            logger.log(level, "media-types:");
        }
        $this$forEach$iv = $this$log_u24lambda_u2413;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            logger.log(level, ' ' + (String)it);
        }
        List<String> $this$log_u24lambda_u2415 = this.getDistinctMediaKeys();
        boolean bl7 = false;
        if (!((Collection)$this$log_u24lambda_u2415).isEmpty()) {
            logger.log(level, "media-keys:");
        }
        $this$forEach$iv = $this$log_u24lambda_u2415;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl8 = false;
            logger.log(level, ' ' + (String)it);
        }
    }

    public static /* synthetic */ void log$default(MediaColDatabase mediaColDatabase, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        mediaColDatabase.log(logger, level);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        MediaColDatabase.log$default(this, logger, null, 2, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lde/gmuth/ipp/attributes/MediaColDatabase$Companion;", "", "()V", "fromAttributes", "Lde/gmuth/ipp/attributes/MediaColDatabase;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "fromIppCollections", "mediaIppCollections", "", "Lde/gmuth/ipp/core/IppCollection;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MediaColDatabase fromAttributes(@NotNull IppAttributesGroup attributes) {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            return this.fromIppCollections((List)attributes.getValues("media-col-database"));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final MediaColDatabase fromIppCollections(@NotNull List<IppCollection> mediaIppCollections) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(mediaIppCollections, (String)"mediaIppCollections");
            Iterable $this$map$iv = mediaIppCollections;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IppCollection ippCollection = (IppCollection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(MediaCollection.Companion.fromIppCollection((IppCollection)it));
            }
            List list = (List)destination$iv$iv;
            return new MediaColDatabase(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

