/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.attributes;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppTag;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.zip.DeflaterInputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lde/gmuth/ipp/attributes/Compression;", "", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "keyword", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "buildIppAttribute", "Lde/gmuth/ipp/core/IppAttribute;", "printerAttributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "getCompressingOutputStream", "Ljava/io/OutputStream;", "outputStream", "getDecompressingInputStream", "Ljava/io/InputStream;", "inputStream", "COMPRESS", "DEFLATE", "GZIP", "NONE", "Companion", "ipp-client"})
public final class Compression
extends Enum<Compression>
implements IppAttributeBuilder {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String keyword;
    public static final /* enum */ Compression COMPRESS;
    public static final /* enum */ Compression DEFLATE;
    public static final /* enum */ Compression GZIP;
    public static final /* enum */ Compression NONE;
    private static final /* synthetic */ Compression[] $VALUES;

    private Compression(String keyword) {
        this.keyword = keyword;
    }

    @NotNull
    public final String getKeyword() {
        return this.keyword;
    }

    @NotNull
    public IppAttribute<String> buildIppAttribute(@NotNull IppAttributesGroup printerAttributes) {
        Intrinsics.checkNotNullParameter((Object)printerAttributes, (String)"printerAttributes");
        String[] stringArray = new String[]{this.keyword};
        return new IppAttribute<String>("compression", IppTag.Keyword, stringArray);
    }

    @NotNull
    public final OutputStream getCompressingOutputStream(@NotNull OutputStream outputStream) {
        OutputStream outputStream2;
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                outputStream2 = outputStream;
                break;
            }
            case 2: {
                outputStream2 = new GZIPOutputStream(outputStream);
                break;
            }
            case 3: {
                outputStream2 = new DeflaterOutputStream(outputStream);
                break;
            }
            default: {
                throw new NotImplementedError("compression '" + this + '\'');
            }
        }
        return outputStream2;
    }

    @NotNull
    public final InputStream getDecompressingInputStream(@NotNull InputStream inputStream) {
        InputStream inputStream2;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                inputStream2 = inputStream;
                break;
            }
            case 2: {
                inputStream2 = new GZIPInputStream(inputStream);
                break;
            }
            case 3: {
                inputStream2 = new DeflaterInputStream(inputStream);
                break;
            }
            default: {
                throw new NotImplementedError("compression '" + this + '\'');
            }
        }
        return inputStream2;
    }

    public static Compression[] values() {
        return (Compression[])$VALUES.clone();
    }

    public static Compression valueOf(String value) {
        return Enum.valueOf(Compression.class, value);
    }

    static {
        COMPRESS = new Compression("compress");
        DEFLATE = new Compression("deflate");
        GZIP = new Compression("gzip");
        NONE = new Compression("none");
        $VALUES = compressionArray = new Compression[]{Compression.COMPRESS, Compression.DEFLATE, Compression.GZIP, Compression.NONE};
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lde/gmuth/ipp/attributes/Compression$Companion;", "", "()V", "fromString", "Lde/gmuth/ipp/attributes/Compression;", "string", "", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Compression fromString(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Compression[] $this$single$iv = Compression.values();
            boolean $i$f$single = false;
            Compression single$iv = null;
            boolean found$iv = false;
            int n = $this$single$iv.length;
            for (int i = 0; i < n; ++i) {
                Compression element$iv;
                Compression it = element$iv = $this$single$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyword(), (Object)string)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            return single$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Compression.values().length];
            try {
                nArray[Compression.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compression.GZIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Compression.DEFLATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

