/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.iana;

import de.gmuth.ipp.iana.CSVTable;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 #*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001#B8\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012'\u0010\u0005\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u000bBD\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012'\u0010\u000e\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0016R2\u0010\u000e\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lde/gmuth/ipp/iana/CSVTable;", "T", "", "resourcePath", "", "rowFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "columns", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "inputStream", "Ljava/io/InputStream;", "buildRow", "skipHeader", "", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;Z)V", "getBuildRow", "()Lkotlin/jvm/functions/Function1;", "maxLengthMap", "", "", "getMaxLengthMap", "()Ljava/util/Map;", "rows", "", "getRows", "()Ljava/util/List;", "parseRow", "read", "", "updateMaxLengthMap", "columnIndex", "columnLength", "Companion", "ipp-client"})
public final class CSVTable<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<List<String>, T> buildRow;
    @NotNull
    private final List<T> rows;
    @NotNull
    private final Map<Integer, Integer> maxLengthMap;

    public CSVTable(@Nullable InputStream inputStream, @NotNull Function1<? super List<String>, ? extends T> buildRow, boolean skipHeader) {
        block0: {
            Intrinsics.checkNotNullParameter(buildRow, (String)"buildRow");
            this.buildRow = buildRow;
            this.rows = new ArrayList();
            this.maxLengthMap = new LinkedHashMap();
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) break block0;
            InputStream it = inputStream2;
            boolean bl = false;
            InputStream inputStream3 = it;
            int n = 8192;
            this.read(inputStream3 instanceof BufferedInputStream ? (BufferedInputStream)inputStream3 : new BufferedInputStream(inputStream3, n), skipHeader);
        }
    }

    public /* synthetic */ CSVTable(InputStream inputStream, Function1 function1, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            inputStream = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(inputStream, function1, bl);
    }

    @NotNull
    public final Function1<List<String>, T> getBuildRow() {
        return this.buildRow;
    }

    @NotNull
    public final List<T> getRows() {
        return this.rows;
    }

    @NotNull
    public final Map<Integer, Integer> getMaxLengthMap() {
        return this.maxLengthMap;
    }

    public CSVTable(@NotNull String resourcePath, @NotNull Function1<? super List<String>, ? extends T> rowFactory) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Intrinsics.checkNotNullParameter(rowFactory, (String)"rowFactory");
        this(CSVTable.class.getResourceAsStream(resourcePath), rowFactory, false, 4, null);
    }

    public final void updateMaxLengthMap(int columnIndex, int columnLength) {
        Integer $this$updateMaxLengthMap_u24lambda_u241 = this.maxLengthMap.get(columnIndex);
        boolean bl = false;
        if ($this$updateMaxLengthMap_u24lambda_u241 == null || $this$updateMaxLengthMap_u24lambda_u241 < columnLength) {
            Integer n = columnIndex;
            Integer n2 = columnLength;
            this.maxLengthMap.put(n, n2);
        }
    }

    public final void read(@NotNull InputStream inputStream, boolean skipHeader) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        if (skipHeader) {
            this.parseRow(inputStream);
        }
        while (this.parseRow(inputStream) != null) {
            List<String> rawRow;
            this.rows.add(this.buildRow.invoke(rawRow));
        }
    }

    @Nullable
    public final List<String> parseRow(@NotNull InputStream inputStream) {
        int i;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        List fields = new ArrayList();
        StringBuilder currentField = new StringBuilder();
        boolean inQuote = false;
        boolean lastCharacterWasQuote = false;
        while ((i = inputStream.read()) != -1) {
            char c = (char)i;
            boolean appendCharacter = false;
            if (inQuote) {
                appendCharacter = c != '\"';
            } else {
                char c2 = c;
                if (c2 == ',') {
                    String string = currentField.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentField.toString()");
                    fields.add(string);
                    CSVTable.parseRow$updateMaxLengthMap(this, fields);
                    StringsKt.clear((StringBuilder)currentField);
                } else {
                    if (c2 == '\n') {
                        String string = currentField.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentField.toString()");
                        fields.add(string);
                        CSVTable.parseRow$updateMaxLengthMap(this, fields);
                        return fields;
                    }
                    appendCharacter = c2 == '\"' ? lastCharacterWasQuote : c != '\r';
                }
            }
            boolean bl = lastCharacterWasQuote = c == '\"';
            if (lastCharacterWasQuote) {
                boolean bl2 = inQuote = !inQuote;
            }
            if (!appendCharacter) continue;
            currentField.append(c);
        }
        if (((CharSequence)currentField).length() == 0) {
            return null;
        }
        String string = currentField.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentField.toString()");
        fields.add(string);
        CSVTable.parseRow$updateMaxLengthMap(this, fields);
        return fields;
    }

    private static final <T> void parseRow$updateMaxLengthMap(CSVTable<T> this$0, List<String> fields) {
        this$0.updateMaxLengthMap(fields.size() - 1, ((String)CollectionsKt.last(fields)).length());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lde/gmuth/ipp/iana/CSVTable$Companion;", "", "()V", "print", "", "inputStream", "Ljava/io/InputStream;", "delimiter", "", "resourcePath", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        public final void print(@NotNull InputStream inputStream, @NotNull String delimiter) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            CSVTable $this$print_u24lambda_u241 = new CSVTable(inputStream, print.1.INSTANCE, false, 4, null);
            boolean bl = false;
            for (List row : $this$print_u24lambda_u241.getRows()) {
                StringBuffer $this$print_u24lambda_u241_u24lambda_u240 = new StringBuffer(delimiter);
                boolean bl2 = false;
                Iterator iterator = row.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int columnIndex = n++;
                    String column = (String)iterator.next();
                    String string = "%-" + $this$print_u24lambda_u241.getMaxLengthMap().get(columnIndex) + "s%s";
                    Object[] objectArray = new Object[]{column, delimiter};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
                    $this$print_u24lambda_u241_u24lambda_u240.append(string2);
                }
                System.out.println((Object)$this$print_u24lambda_u241_u24lambda_u240.toString());
            }
        }

        public static /* synthetic */ void print$default(Companion companion, InputStream inputStream, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = "|";
            }
            companion.print(inputStream, string);
        }

        public final void print(@NotNull String resourcePath, @NotNull String delimiter) {
            Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
            Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
            InputStream inputStream = CSVTable.class.getResourceAsStream(resourcePath);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"CSVTable::class.java.get\u2026rceAsStream(resourcePath)");
            this.print(inputStream, delimiter);
        }

        public static /* synthetic */ void print$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "|";
            }
            companion.print(string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

