/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppDateTime;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppResolution;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u001d\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bJ\u001f\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b%R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/gmuth/ipp/core/IppOutputStream;", "Ljava/io/DataOutputStream;", "outputStream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "attributesCharset", "Ljava/nio/charset/Charset;", "getAttributesCharset$ipp_client", "()Ljava/nio/charset/Charset;", "setAttributesCharset$ipp_client", "(Ljava/nio/charset/Charset;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "writeAttribute", "", "attribute", "Lde/gmuth/ipp/core/IppAttribute;", "writeAttribute$ipp_client", "writeAttributeValue", "tag", "Lde/gmuth/ipp/core/IppTag;", "value", "", "writeAttributeValue$ipp_client", "writeMessage", "message", "Lde/gmuth/ipp/core/IppMessage;", "writeString", "string", "", "charset", "writeString$ipp_client", "writeTag", "writeTag$ipp_client", "writeVersion", "version", "writeVersion$ipp_client", "ipp-client"})
public final class IppOutputStream
extends DataOutputStream {
    private final Logger logger;
    public Charset attributesCharset;

    public IppOutputStream(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        super(outputStream);
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @NotNull
    public final Charset getAttributesCharset$ipp_client() {
        Charset charset = this.attributesCharset;
        if (charset != null) {
            return charset;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"attributesCharset");
        return null;
    }

    public final void setAttributesCharset$ipp_client(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.attributesCharset = charset;
    }

    public final void writeMessage(@NotNull IppMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IppMessage $this$writeMessage_u24lambda_u243 = message;
        boolean bl = false;
        this.setAttributesCharset$ipp_client((Charset)$this$writeMessage_u24lambda_u243.getOperationGroup().getValue("attributes-charset"));
        String string = $this$writeMessage_u24lambda_u243.getVersion();
        if (string == null) {
            throw new IppException("missing version", null, 2, null);
        }
        this.writeVersion$ipp_client(string);
        this.logger.finest(() -> IppOutputStream.writeMessage$lambda$3$lambda$0($this$writeMessage_u24lambda_u243));
        Integer n = $this$writeMessage_u24lambda_u243.getCode();
        if (n == null) {
            throw new IppException("missing operation or status code", null, 2, null);
        }
        this.writeShort(n);
        this.logger.finest(() -> IppOutputStream.writeMessage$lambda$3$lambda$1($this$writeMessage_u24lambda_u243));
        Integer n2 = $this$writeMessage_u24lambda_u243.getRequestId();
        if (n2 == null) {
            throw new IppException("missing requestId", null, 2, null);
        }
        this.writeInt(n2);
        this.logger.finest(() -> IppOutputStream.writeMessage$lambda$3$lambda$2($this$writeMessage_u24lambda_u243));
        for (IppAttributesGroup group : $this$writeMessage_u24lambda_u243.getAttributesGroups()) {
            this.writeTag$ipp_client(group.getTag());
            for (IppAttribute<?> attribute : group.values()) {
                try {
                    Intrinsics.checkNotNullExpressionValue(attribute, (String)"attribute");
                    this.writeAttribute$ipp_client(attribute);
                }
                catch (Exception exception) {
                    throw new IppException("failed to write attribute: " + attribute, exception);
                }
            }
        }
        this.writeTag$ipp_client(IppTag.End);
    }

    public final void writeVersion$ipp_client(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        MatchResult matchResult = Regex.find$default((Regex)new Regex("^(\\d)\\.(\\d)$"), (CharSequence)version2, (int)0, (int)2, null);
        Intrinsics.checkNotNull((Object)matchResult);
        MatchResult $this$writeVersion_u24lambda_u244 = matchResult;
        boolean bl = false;
        MatchGroup matchGroup = $this$writeVersion_u24lambda_u244.getGroups().get(1);
        Intrinsics.checkNotNull((Object)matchGroup);
        this.writeByte(Integer.parseInt(matchGroup.getValue()));
        MatchGroup matchGroup2 = $this$writeVersion_u24lambda_u244.getGroups().get(2);
        Intrinsics.checkNotNull((Object)matchGroup2);
        this.writeByte(Integer.parseInt(matchGroup2.getValue()));
    }

    public final void writeTag$ipp_client(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        if (tag.isDelimiterTag()) {
            this.logger.finest(() -> IppOutputStream.writeTag$lambda$5(tag));
        }
        this.writeByte(tag.getCode());
    }

    public final void writeString$ipp_client(@NotNull String string, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] $this$writeString_u24lambda_u246 = byArray;
        boolean bl = false;
        this.writeShort($this$writeString_u24lambda_u246.length);
        this.write($this$writeString_u24lambda_u246);
    }

    public static /* synthetic */ void writeString$ipp_client$default(IppOutputStream ippOutputStream, String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.US_ASCII;
        }
        ippOutputStream.writeString$ipp_client(string, charset);
    }

    public final void writeAttribute$ipp_client(@NotNull IppAttribute<?> attribute) {
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        this.logger.finest(() -> IppOutputStream.writeAttribute$lambda$7(attribute));
        IppAttribute<?> $this$writeAttribute_u24lambda_u248 = attribute;
        boolean bl = false;
        if ($this$writeAttribute_u24lambda_u248.getValues().isEmpty() || $this$writeAttribute_u24lambda_u248.getTag().isOutOfBandTag()) {
            this.writeTag$ipp_client($this$writeAttribute_u24lambda_u248.getTag());
            IppOutputStream.writeString$ipp_client$default(this, $this$writeAttribute_u24lambda_u248.getName(), null, 2, null);
            this.writeShort(0);
        } else {
            Iterator<?> iterator = $this$writeAttribute_u24lambda_u248.getValues().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                Object value = iterator.next();
                this.writeTag$ipp_client($this$writeAttribute_u24lambda_u248.getTag());
                IppOutputStream.writeString$ipp_client$default(this, index == 0 ? $this$writeAttribute_u24lambda_u248.getName() : "", null, 2, null);
                IppTag ippTag = $this$writeAttribute_u24lambda_u248.getTag();
                Object obj = value;
                Intrinsics.checkNotNull(obj);
                this.writeAttributeValue$ipp_client(ippTag, obj);
            }
        }
    }

    public final void writeAttributeValue$ipp_client(@NotNull IppTag tag, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[tag.ordinal()]) {
            case 1: {
                boolean $this$writeAttributeValue_u24lambda_u249 = (Boolean)value;
                boolean bl = false;
                this.writeShort(1);
                this.writeBoolean((Boolean)value);
                break;
            }
            case 2: 
            case 3: {
                Number $this$writeAttributeValue_u24lambda_u2410 = (Number)value;
                boolean bl = false;
                this.writeShort(4);
                this.writeInt(((Number)value).intValue());
                break;
            }
            case 4: {
                IntRange $this$writeAttributeValue_u24lambda_u2411 = (IntRange)value;
                boolean bl = false;
                this.writeShort(8);
                this.writeInt($this$writeAttributeValue_u24lambda_u2411.getStart());
                this.writeInt($this$writeAttributeValue_u24lambda_u2411.getEndInclusive());
                break;
            }
            case 5: {
                IppResolution $this$writeAttributeValue_u24lambda_u2412 = (IppResolution)value;
                boolean bl = false;
                this.writeShort(9);
                this.writeInt($this$writeAttributeValue_u24lambda_u2412.getX());
                this.writeInt($this$writeAttributeValue_u24lambda_u2412.getY());
                this.writeByte($this$writeAttributeValue_u24lambda_u2412.getUnit());
                break;
            }
            case 6: {
                Charset $this$writeAttributeValue_u24lambda_u2413 = (Charset)value;
                boolean bl = false;
                String string = $this$writeAttributeValue_u24lambda_u2413.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                IppOutputStream.writeString$ipp_client$default(this, string2, null, 2, null);
                break;
            }
            case 7: {
                URI $this$writeAttributeValue_u24lambda_u2414 = (URI)value;
                boolean bl = false;
                IppOutputStream.writeString$ipp_client$default(this, value.toString(), null, 2, null);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                String $this$writeAttributeValue_u24lambda_u2415 = (String)value;
                boolean bl = false;
                IppOutputStream.writeString$ipp_client$default(this, (String)value, null, 2, null);
                break;
            }
            case 14: 
            case 15: {
                Object object = value;
                if (object instanceof String) {
                    this.writeString$ipp_client((String)value, this.getAttributesCharset$ipp_client());
                    break;
                }
                if (object instanceof IppString) {
                    this.writeString$ipp_client(((IppString)value).getText(), this.getAttributesCharset$ipp_client());
                    break;
                }
                throw new IppException("expecting value class String or IppString", null, 2, null);
            }
            case 16: 
            case 17: {
                IppString $this$writeAttributeValue_u24lambda_u2416 = (IppString)value;
                boolean bl = false;
                if ($this$writeAttributeValue_u24lambda_u2416.getLanguage() == null) {
                    throw new IppException("expecting IppString with language", null, 2, null);
                }
                this.writeShort(4 + $this$writeAttributeValue_u24lambda_u2416.getText().length() + $this$writeAttributeValue_u24lambda_u2416.getLanguage().length());
                this.writeString$ipp_client($this$writeAttributeValue_u24lambda_u2416.getLanguage(), this.getAttributesCharset$ipp_client());
                this.writeString$ipp_client($this$writeAttributeValue_u24lambda_u2416.getText(), this.getAttributesCharset$ipp_client());
                break;
            }
            case 18: {
                IppDateTime $this$writeAttributeValue_u24lambda_u2417 = (IppDateTime)value;
                boolean bl = false;
                this.writeShort(11);
                this.writeShort($this$writeAttributeValue_u24lambda_u2417.getYear());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getMonth());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getDay());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getHour());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getMinutes());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getSeconds());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getDeciSeconds());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getDirectionFromUTC());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getHoursFromUTC());
                this.writeByte($this$writeAttributeValue_u24lambda_u2417.getMinutesFromUTC());
                break;
            }
            case 19: {
                IppCollection $this$writeAttributeValue_u24lambda_u2418 = (IppCollection)value;
                boolean bl = false;
                this.writeShort(0);
                for (IppAttribute<?> member : $this$writeAttributeValue_u24lambda_u2418.getMembers()) {
                    String[] stringArray = new String[]{member.getName()};
                    this.writeAttribute$ipp_client(new IppAttribute<String>("", IppTag.MemberAttrName, stringArray));
                    for (Object memberValue : member.getValues()) {
                        Object[] objectArray = new Object[]{memberValue};
                        this.writeAttribute$ipp_client(new IppAttribute<Object>("", member.getTag(), objectArray));
                    }
                }
                this.writeAttribute$ipp_client(new IppAttribute("", IppTag.EndCollection));
                break;
            }
            default: {
                String string = "Unknown tag 0x%02X %s";
                Object[] objectArray = new Object[]{tag.getCode(), tag};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
                throw new IppException(string3, null, 2, null);
            }
        }
    }

    private static final String writeMessage$lambda$3$lambda$0(IppMessage $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "version = " + $this_run.getVersion();
    }

    private static final String writeMessage$lambda$3$lambda$1(IppMessage $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "code = " + $this_run.getCode() + " (" + $this_run.getCodeDescription() + ")";
    }

    private static final String writeMessage$lambda$3$lambda$2(IppMessage $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return "requestId = " + $this_run.getRequestId();
    }

    private static final String writeTag$lambda$5(IppTag $tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)$tag), (String)"$tag");
        return "--- " + $tag + " ---";
    }

    private static final String writeAttribute$lambda$7(IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return String.valueOf($attribute);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IppTag.values().length];
            try {
                nArray[IppTag.Boolean.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Integer.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Enum.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.RangeOfInteger.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Resolution.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Charset.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Uri.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.Keyword.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.UriScheme.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.OctetString.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.MimeMediaType.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.MemberAttrName.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.NaturalLanguage.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.TextWithoutLanguage.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.NameWithoutLanguage.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.TextWithLanguage.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.NameWithLanguage.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.DateTime.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IppTag.BegCollection.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

