/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppInputStream;
import de.gmuth.ipp.core.IppOutputStream;
import de.gmuth.ipp.core.IppTag;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tB\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0004J\u000e\u0010D\u001a\u00020\r2\u0006\u0010>\u001a\u00020?J\u000e\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000200J\u0006\u0010H\u001a\u000200J\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0I2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\bJJ\u0015\u0010K\u001a\u00020\r2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\bLJ\u0006\u0010M\u001a\u00020 J$\u0010N\u001a\u00020F2\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010O\u001a\u00020P2\b\b\u0002\u0010Q\u001a\u00020\u0003H\u0007J\u000e\u0010R\u001a\u00020F2\u0006\u0010S\u001a\u00020TJ\u000e\u0010R\u001a\u00020F2\u0006\u0010U\u001a\u00020\u001aJ\u000e\u0010V\u001a\u00020F2\u0006\u0010S\u001a\u00020TJ\u000e\u0010W\u001a\u00020F2\u0006\u0010S\u001a\u00020TJ\u000e\u0010X\u001a\u00020T2\u0006\u0010S\u001a\u00020TJ\b\u0010Y\u001a\u00020\u0003H\u0016J\u0018\u0010Z\u001a\u00020F2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\u0003H\u0004J\u000e\u0010Z\u001a\u00020F2\u0006\u0010S\u001a\u00020TJ\u000e\u0010Z\u001a\u00020F2\u0006\u0010B\u001a\u00020CR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0016\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\n **\u0004\u0018\u00010)0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010'R\u0011\u0010-\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010'R\u001c\u0010/\u001a\u0004\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b5\u0010\u0012\"\u0004\b6\u0010\u0014R\u0011\u00107\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010'R(\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u00109\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0018\"\u0004\b;\u0010<\u00a8\u0006^"}, d2={"Lde/gmuth/ipp/core/IppMessage;", "", "version", "", "requestId", "", "charset", "Ljava/nio/charset/Charset;", "naturalLanguage", "(Ljava/lang/String;ILjava/nio/charset/Charset;Ljava/lang/String;)V", "()V", "attributesGroups", "", "Lde/gmuth/ipp/core/IppAttributesGroup;", "getAttributesGroups", "()Ljava/util/List;", "code", "getCode", "()Ljava/lang/Integer;", "setCode", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "codeDescription", "getCodeDescription", "()Ljava/lang/String;", "documentInputStream", "Ljava/io/InputStream;", "getDocumentInputStream", "()Ljava/io/InputStream;", "setDocumentInputStream", "(Ljava/io/InputStream;)V", "documentInputStreamIsConsumed", "", "getDocumentInputStreamIsConsumed", "()Z", "setDocumentInputStreamIsConsumed", "(Z)V", "jobGroup", "getJobGroup", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "operationGroup", "getOperationGroup", "printerGroup", "getPrinterGroup", "rawBytes", "", "getRawBytes", "()[B", "setRawBytes", "([B)V", "getRequestId", "setRequestId", "subscriptionGroup", "getSubscriptionGroup", "value", "getVersion", "setVersion", "(Ljava/lang/String;)V", "containsGroup", "tag", "Lde/gmuth/ipp/core/IppTag;", "copyDocumentStream", "", "outputStream", "Ljava/io/OutputStream;", "createAttributesGroup", "decode", "", "byteArray", "encode", "", "getAttributesGroups$ipp_client", "getSingleAttributesGroup", "getSingleAttributesGroup$ipp_client", "hasDocument", "log", "level", "Ljava/util/logging/Level;", "prefix", "read", "file", "Ljava/io/File;", "inputStream", "saveBytes", "saveDocumentStream", "saveText", "toString", "write", "bufferedWriter", "Ljava/io/BufferedWriter;", "title", "ipp-client"})
public abstract class IppMessage {
    private final Logger logger;
    @Nullable
    private Integer code;
    @Nullable
    private Integer requestId;
    @Nullable
    private String version;
    @NotNull
    private final List<IppAttributesGroup> attributesGroups;
    @Nullable
    private InputStream documentInputStream;
    private boolean documentInputStreamIsConsumed;
    @Nullable
    private byte[] rawBytes;

    public IppMessage() {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.attributesGroups = new ArrayList();
    }

    @Nullable
    public final Integer getCode() {
        return this.code;
    }

    public final void setCode(@Nullable Integer n) {
        this.code = n;
    }

    @Nullable
    public final Integer getRequestId() {
        return this.requestId;
    }

    public final void setRequestId(@Nullable Integer n) {
        this.requestId = n;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    public final void setVersion(@Nullable String value) {
        Regex regex = new Regex("^\\d\\.\\d$");
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        if (!regex.matches((CharSequence)string)) {
            throw new IppException("Invalid version string: " + value, null, 2, null);
        }
        this.version = value;
    }

    @NotNull
    public final List<IppAttributesGroup> getAttributesGroups() {
        return this.attributesGroups;
    }

    @Nullable
    public final InputStream getDocumentInputStream() {
        return this.documentInputStream;
    }

    public final void setDocumentInputStream(@Nullable InputStream inputStream) {
        this.documentInputStream = inputStream;
    }

    public final boolean getDocumentInputStreamIsConsumed() {
        return this.documentInputStreamIsConsumed;
    }

    public final void setDocumentInputStreamIsConsumed(boolean bl) {
        this.documentInputStreamIsConsumed = bl;
    }

    @Nullable
    public final byte[] getRawBytes() {
        return this.rawBytes;
    }

    public final void setRawBytes(@Nullable byte[] byArray) {
        this.rawBytes = byArray;
    }

    @NotNull
    public abstract String getCodeDescription();

    public IppMessage(@NotNull String version2, int requestId, @NotNull Charset charset, @NotNull String naturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Intrinsics.checkNotNullParameter((Object)naturalLanguage, (String)"naturalLanguage");
        this();
        this.setVersion(version2);
        this.requestId = requestId;
        IppAttributesGroup $this$_init__u24lambda_u240 = this.createAttributesGroup(IppTag.Operation);
        boolean bl = false;
        Object[] objectArray = new Object[]{charset};
        $this$_init__u24lambda_u240.attribute("attributes-charset", IppTag.Charset, objectArray);
        objectArray = new Object[]{naturalLanguage};
        $this$_init__u24lambda_u240.attribute("attributes-natural-language", IppTag.NaturalLanguage, objectArray);
    }

    @NotNull
    public final IppAttributesGroup getOperationGroup() {
        return this.getSingleAttributesGroup$ipp_client(IppTag.Operation);
    }

    @NotNull
    public final IppAttributesGroup getPrinterGroup() {
        return this.getSingleAttributesGroup$ipp_client(IppTag.Printer);
    }

    @NotNull
    public final IppAttributesGroup getJobGroup() {
        return this.getSingleAttributesGroup$ipp_client(IppTag.Job);
    }

    @NotNull
    public final IppAttributesGroup getSubscriptionGroup() {
        return this.getSingleAttributesGroup$ipp_client(IppTag.Subscription);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppAttributesGroup> getAttributesGroups$ipp_client(@NotNull IppTag tag) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Iterable $this$filter$iv = this.attributesGroups;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IppAttributesGroup it = (IppAttributesGroup)element$iv$iv;
            boolean bl = false;
            if (!(it.getTag() == tag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final IppAttributesGroup getSingleAttributesGroup$ipp_client(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        List<IppAttributesGroup> $this$getSingleAttributesGroup_u24lambda_u242 = this.getAttributesGroups$ipp_client(tag);
        boolean bl = false;
        if ($this$getSingleAttributesGroup_u24lambda_u242.isEmpty()) {
            throw new IppException("No group found with tag '" + tag + "' in " + this.attributesGroups, null, 2, null);
        }
        return (IppAttributesGroup)CollectionsKt.single($this$getSingleAttributesGroup_u24lambda_u242);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsGroup(@NotNull IppTag tag) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Iterable $this$map$iv = this.attributesGroups;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTag());
        }
        return ((List)destination$iv$iv).contains((Object)tag);
    }

    @NotNull
    public final IppAttributesGroup createAttributesGroup(@NotNull IppTag tag) {
        IppAttributesGroup ippAttributesGroup;
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        IppAttributesGroup $this$createAttributesGroup_u24lambda_u244 = ippAttributesGroup = new IppAttributesGroup(tag);
        boolean bl = false;
        this.attributesGroups.add($this$createAttributesGroup_u24lambda_u244);
        return ippAttributesGroup;
    }

    public final boolean hasDocument() {
        return this.documentInputStream != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream byteArraySavingOutputStream2 = new OutputStream(outputStream, byteArrayOutputStream){
            final /* synthetic */ OutputStream $outputStream;
            final /* synthetic */ ByteArrayOutputStream $byteArrayOutputStream;
            {
                this.$outputStream = $outputStream;
                this.$byteArrayOutputStream = $byteArrayOutputStream;
            }

            public void write(int n) {
                this.$outputStream.write(n);
                Unit unit = Unit.INSTANCE;
                ByteArrayOutputStream byteArrayOutputStream = this.$byteArrayOutputStream;
                Unit it = unit;
                boolean bl = false;
                byteArrayOutputStream.write(n);
            }
        };
        try {
            new IppOutputStream(byteArraySavingOutputStream2).writeMessage(this);
        }
        finally {
            this.rawBytes = byteArrayOutputStream.toByteArray();
        }
        if (this.hasDocument()) {
            this.copyDocumentStream(outputStream);
        }
    }

    public final void write(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.write(new FileOutputStream(file));
    }

    @NotNull
    public final byte[] encode() {
        ByteArrayOutputStream $this$encode_u24lambda_u245 = new ByteArrayOutputStream();
        boolean bl = false;
        this.write($this$encode_u24lambda_u245);
        byte[] byArray = $this$encode_u24lambda_u245.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteArrayOutputStream().\u2026      toByteArray()\n    }");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream byteArraySavingInputStream2 = new InputStream(inputStream, byteArrayOutputStream){
            final /* synthetic */ InputStream $inputStream;
            final /* synthetic */ ByteArrayOutputStream $byteArrayOutputStream;
            {
                this.$inputStream = $inputStream;
                this.$byteArrayOutputStream = $byteArrayOutputStream;
            }

            public int read() {
                int n = this.$inputStream.read();
                ByteArrayOutputStream byteArrayOutputStream = this.$byteArrayOutputStream;
                int it = n;
                boolean bl = false;
                if (it != -1) {
                    byteArrayOutputStream.write(it);
                }
                return n;
            }
        };
        InputStream inputStream2 = byteArraySavingInputStream2;
        int n = 8192;
        BufferedInputStream bufferedInputStream = inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n);
        try {
            new IppInputStream(bufferedInputStream).readMessage(this);
            this.documentInputStream = bufferedInputStream;
        }
        finally {
            this.rawBytes = byteArrayOutputStream.toByteArray();
        }
    }

    public final void read(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.logger.fine(() -> IppMessage.read$lambda$6(file));
        this.read(new FileInputStream(file));
    }

    public final void decode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        this.logger.fine(() -> IppMessage.decode$lambda$7(byteArray));
        this.read(new ByteArrayInputStream(byteArray));
    }

    protected final long copyDocumentStream(@NotNull OutputStream outputStream) {
        long l;
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        if (this.documentInputStreamIsConsumed) {
            this.logger.warning(IppMessage::copyDocumentStream$lambda$8);
        }
        InputStream inputStream = this.documentInputStream;
        Intrinsics.checkNotNull((Object)inputStream);
        long $this$copyDocumentStream_u24lambda_u2410 = l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
        boolean bl = false;
        this.logger.fine(() -> IppMessage.copyDocumentStream$lambda$10$lambda$9($this$copyDocumentStream_u24lambda_u2410));
        this.documentInputStreamIsConsumed = true;
        return l;
    }

    public final void saveDocumentStream(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.copyDocumentStream(new FileOutputStream(file));
        this.logger.info(() -> IppMessage.saveDocumentStream$lambda$11(file));
    }

    public final void saveBytes(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.rawBytes == null) {
            throw new IppException("No raw bytes to save. You must call read/decode or write/encode before.", null, 2, null);
        }
        Intrinsics.checkNotNull((Object)this.rawBytes);
        FilesKt.writeBytes((File)file, (byte[])this.rawBytes);
        this.logger.info(() -> IppMessage.saveBytes$lambda$12(file));
    }

    protected final void write(@NotNull BufferedWriter bufferedWriter, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)bufferedWriter, (String)"bufferedWriter");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        bufferedWriter.write(title);
        if (this.rawBytes != null) {
            Intrinsics.checkNotNull((Object)this.rawBytes);
            bufferedWriter.write(" (decoded " + this.rawBytes.length + " raw IPP bytes)");
        }
        bufferedWriter.newLine();
        IppMessage.write$writeln(bufferedWriter, "version " + this.version);
        IppMessage.write$writeln(bufferedWriter, String.valueOf(this.getCodeDescription()));
        IppMessage.write$writeln(bufferedWriter, "request-id " + this.requestId);
        for (IppAttributesGroup group : this.attributesGroups) {
            IppAttributesGroup.write$default(group, bufferedWriter, null, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File saveText(@NotNull File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$saveText_u24lambda_u2416 = file2 = file;
        boolean bl = false;
        Object object = $this$saveText_u24lambda_u2416;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl2 = false;
            this.write(it, "# File: " + file.getName());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        this.logger.info(() -> IppMessage.saveText$lambda$16$lambda$15($this$saveText_u24lambda_u2416));
        return file2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        Object object;
        Collection<CallSite> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = "%s %s%s";
        Object[] objectArray = new Object[3];
        objectArray[0] = this.getCodeDescription();
        Iterable iterable = this.attributesGroups;
        int n = 1;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CallSite)((Object)(it.values().size() + " " + it.getTag())));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = collection;
        if (this.rawBytes == null) {
            object = "";
        } else {
            Intrinsics.checkNotNull((Object)this.rawBytes);
            object = " (" + this.rawBytes.length + " bytes)";
        }
        objectArray[2] = object;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (this.rawBytes != null) {
            logger.log(level, () -> IppMessage.log$lambda$18(prefix, this));
        }
        logger.log(level, () -> IppMessage.log$lambda$19(prefix, this));
        logger.log(level, () -> IppMessage.log$lambda$20(prefix, this));
        logger.log(level, () -> IppMessage.log$lambda$21(prefix, this));
        for (IppAttributesGroup group : this.attributesGroups) {
            IppAttributesGroup.log$default(group, logger, level, prefix, null, 8, null);
        }
    }

    public static /* synthetic */ void log$default(IppMessage ippMessage, Logger logger, Level level, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: log");
        }
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        ippMessage.log(logger, level, string);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppMessage.log$default(this, logger, level, null, 4, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppMessage.log$default(this, logger, null, null, 6, null);
    }

    private static final String read$lambda$6(File $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return "Read file " + $file.getAbsolutePath() + ": " + $file.length() + " bytes";
    }

    private static final String decode$lambda$7(byte[] $byteArray) {
        Intrinsics.checkNotNullParameter((Object)$byteArray, (String)"$byteArray");
        return "Decode " + $byteArray.length + " bytes";
    }

    private static final String copyDocumentStream$lambda$8() {
        return "documentInputStream is consumed";
    }

    private static final String copyDocumentStream$lambda$10$lambda$9(long $this_apply) {
        return "consumed documentInputStream: " + $this_apply + " bytes";
    }

    private static final String saveDocumentStream$lambda$11(File $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return "saved " + $file.length() + " document bytes to file " + $file.getPath();
    }

    private static final String saveBytes$lambda$12(File $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return "Saved " + $file.getPath() + " (" + $file.length() + " bytes)";
    }

    private static final void write$writeln(BufferedWriter $bufferedWriter, String text) {
        BufferedWriter $this$write_u24writeln_u24lambda_u2413 = $bufferedWriter;
        boolean bl = false;
        $this$write_u24writeln_u24lambda_u2413.write(text);
        $this$write_u24writeln_u24lambda_u2413.newLine();
    }

    private static final String saveText$lambda$16$lambda$15(File $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Saved " + $this_apply.getPath() + " (" + $this_apply.length() + " bytes)";
    }

    private static final String log$lambda$18(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)this$0.rawBytes);
        return $prefix + this$0.rawBytes.length + " raw ipp bytes";
    }

    private static final String log$lambda$19(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + "version = " + this$0.version;
    }

    private static final String log$lambda$20(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + this$0.getCodeDescription();
    }

    private static final String log$lambda$21(String $prefix, IppMessage this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + "request-id = " + this$0.requestId;
    }
}

