/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002&\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001j\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016\"\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0002J\u000e\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0002J\u001e\u0010!\u001a\u0004\b\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0014\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u001b\u0010$\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0002\u0010#J\u001e\u0010%\u001a\u0004\b\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0014\u001a\u00020\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u001b\u0010&\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\u0002\u0010#J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0014\u001a\u00020\u00022\b\b\u0002\u0010)\u001a\u00020*J.\u0010+\u001a\u00020,2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010-\u001a\u00020.2\b\b\u0002\u0010/\u001a\u00020\u00022\b\b\u0002\u00100\u001a\u00020\u0002H\u0007J\u0018\u00101\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003J\u000e\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u000204J\b\u00106\u001a\u00020\u0002H\u0016J\u0018\u00107\u001a\u00020,2\u0006\u00108\u001a\u0002092\b\b\u0002\u00100\u001a\u00020\u0002R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006:"}, d2={"Lde/gmuth/ipp/core/IppAttributesGroup;", "Ljava/util/LinkedHashMap;", "", "Lde/gmuth/ipp/core/IppAttribute;", "Lkotlin/collections/LinkedHashMap;", "tag", "Lde/gmuth/ipp/core/IppTag;", "(Lde/gmuth/ipp/core/IppTag;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "onReplaceWarn", "", "getOnReplaceWarn", "()Z", "setOnReplaceWarn", "(Z)V", "getTag", "()Lde/gmuth/ipp/core/IppTag;", "attribute", "name", "values", "", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)Lde/gmuth/ipp/core/IppAttribute;", "", "attributeNotFoundException", "Lde/gmuth/ipp/core/IppException;", "getDurationOfSecondsValue", "Ljava/time/Duration;", "getTextValue", "getUriValue", "Ljava/net/URI;", "getValue", "T", "(Ljava/lang/String;)Ljava/lang/Object;", "getValueOrNull", "getValues", "getValuesOrNull", "getZonedDateTimeValue", "Ljava/time/ZonedDateTime;", "zoneId", "Ljava/time/ZoneId;", "log", "", "level", "Ljava/util/logging/Level;", "prefix", "title", "put", "attributesGroup", "saveText", "Ljava/io/File;", "file", "toString", "write", "bufferedWriter", "Ljava/io/BufferedWriter;", "ipp-client"})
public final class IppAttributesGroup
extends LinkedHashMap<String, IppAttribute<?>> {
    @NotNull
    private final IppTag tag;
    private final Logger logger;
    private boolean onReplaceWarn;

    public IppAttributesGroup(@NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.tag = tag;
        this.logger = Logger.getLogger(this.getClass().getName());
        if (!this.tag.isGroupTag()) {
            throw new IppException("'" + this.tag + "' is not a group tag", null, 2, null);
        }
    }

    @NotNull
    public final IppTag getTag() {
        return this.tag;
    }

    public final boolean getOnReplaceWarn() {
        return this.onReplaceWarn;
    }

    public final void setOnReplaceWarn(boolean bl) {
        this.onReplaceWarn = bl;
    }

    @Nullable
    public final IppAttribute<?> put(@NotNull IppAttribute<?> attribute) {
        IppAttribute<?> ippAttribute;
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        IppAttribute<?> it = ippAttribute = this.put(attribute.getName(), attribute);
        boolean bl = false;
        if (it != null && this.onReplaceWarn) {
            this.logger.warning(() -> IppAttributesGroup.put$lambda$1$lambda$0(it, attribute, this));
        }
        return ippAttribute;
    }

    @Nullable
    public final IppAttribute<?> attribute(@NotNull String name, @NotNull IppTag tag, Object ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        return this.put(new IppAttribute(name, tag, ArraysKt.toList((Object[])values)));
    }

    @Nullable
    public final IppAttribute<?> attribute(@NotNull String name, @NotNull IppTag tag, @NotNull Collection<? extends Object> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.put(new IppAttribute<Object>(name, tag, values));
    }

    @Nullable
    public final <T> T getValueOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppAttribute ippAttribute = (IppAttribute)this.get((Object)name);
        return (T)(ippAttribute != null ? ippAttribute.getValue() : null);
    }

    @Nullable
    public final <T> T getValuesOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppAttribute ippAttribute = (IppAttribute)this.get((Object)name);
        return (T)(ippAttribute != null ? ippAttribute.getValues() : null);
    }

    @NotNull
    public final <T> T getValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppAttribute ippAttribute = (IppAttribute)this.get((Object)name);
        Object object = ippAttribute != null ? ippAttribute.getValue() : null;
        if (object == null) {
            throw this.attributeNotFoundException(name);
        }
        return object;
    }

    @NotNull
    public final <T> T getValues(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IppAttribute ippAttribute = (IppAttribute)this.get((Object)name);
        Object object = ippAttribute != null ? ippAttribute.getValues() : null;
        if (object == null) {
            throw this.attributeNotFoundException(name);
        }
        return (T)object;
    }

    @NotNull
    public final URI getUriValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (URI)this.getValue(name);
    }

    @NotNull
    public final String getTextValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ((IppString)this.getValue(name)).getText();
    }

    @NotNull
    public final ZonedDateTime getZonedDateTimeValue(@NotNull String name, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        Object object = (IppAttribute)this.get((Object)name);
        ZonedDateTime zonedDateTime = object != null && (object = ((IppAttribute)object).getZonedDateTimeValue()) != null ? ((ZonedDateTime)object).withZoneSameInstant(zoneId) : null;
        if (zonedDateTime == null) {
            throw this.attributeNotFoundException(name);
        }
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime getZonedDateTimeValue$default(IppAttributesGroup ippAttributesGroup, String string, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"systemDefault()");
            zoneId = zoneId2;
        }
        return ippAttributesGroup.getZonedDateTimeValue(string, zoneId);
    }

    @NotNull
    public final Duration getDurationOfSecondsValue(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = (IppAttribute)this.get((Object)name);
        if (object == null || (object = ((IppAttribute)object).getDurationOfSecondsValue()) == null) {
            throw this.attributeNotFoundException(name);
        }
        return object;
    }

    public final void put(@NotNull IppAttributesGroup attributesGroup) {
        Intrinsics.checkNotNullParameter((Object)attributesGroup, (String)"attributesGroup");
        Collection<IppAttribute<?>> collection = attributesGroup.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"attributesGroup.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IppAttribute it = (IppAttribute)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.put(it);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "'" + this.tag + "' " + this.size() + " attributes";
    }

    private final IppException attributeNotFoundException(String name) {
        return new IppException("Attribute '" + name + "' not found in group " + this.tag, null, 2, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        logger.log(level, () -> IppAttributesGroup.log$lambda$3(prefix, title));
        Set<String> set = this.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            logger.log(level, () -> IppAttributesGroup.log$lambda$5$lambda$4(prefix, this, it));
        }
    }

    public static /* synthetic */ void log$default(IppAttributesGroup ippAttributesGroup, Logger logger, Level level, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        if ((n & 8) != 0) {
            string2 = String.valueOf((Object)ippAttributesGroup.tag);
        }
        ippAttributesGroup.log(logger, level, string, string2);
    }

    public final void write(@NotNull BufferedWriter bufferedWriter, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)bufferedWriter, (String)"bufferedWriter");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        BufferedWriter $this$write_u24lambda_u247 = bufferedWriter;
        boolean bl = false;
        $this$write_u24lambda_u247.write(title);
        $this$write_u24lambda_u247.newLine();
        Collection<IppAttribute<?>> collection = this.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IppAttribute it = (IppAttribute)element$iv;
            boolean bl2 = false;
            $this$write_u24lambda_u247.write("  " + it);
            $this$write_u24lambda_u247.newLine();
        }
    }

    public static /* synthetic */ void write$default(IppAttributesGroup ippAttributesGroup, BufferedWriter bufferedWriter, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = String.valueOf((Object)ippAttributesGroup.tag);
        }
        ippAttributesGroup.write(bufferedWriter, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File saveText(@NotNull File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File $this$saveText_u24lambda_u2410 = file2 = file;
        boolean bl = false;
        Object object = $this$saveText_u24lambda_u2410;
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
        object = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl2 = false;
            IppAttributesGroup.write$default(this, it, null, 2, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        this.logger.info(() -> IppAttributesGroup.saveText$lambda$10$lambda$9($this$saveText_u24lambda_u2410));
        return file2;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        IppAttributesGroup.log$default(this, logger, level, prefix, null, 8, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this, logger, level, null, null, 12, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppAttributesGroup.log$default(this, logger, null, null, null, 14, null);
    }

    private static final String put$lambda$1$lambda$0(IppAttribute $it, IppAttribute $attribute, IppAttributesGroup this$0) {
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "replaced '" + $it + "' with '" + CollectionsKt.joinToString$default((Iterable)$attribute.getValues(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "' in group " + this$0.tag;
    }

    private static final String log$lambda$3(String $prefix, String $title) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        return $prefix + $title;
    }

    private static final String log$lambda$5$lambda$4(String $prefix, IppAttributesGroup this$0, String $it) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $prefix + "  " + this$0.get((Object)$it);
    }

    private static final String saveText$lambda$10$lambda$9(File $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Saved " + $this_apply.getPath();
    }
}

