/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.core;

import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppCollection;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import de.gmuth.ipp.iana.IppRegistrationsSection6;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tB+\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\n\"\u00028\u0000\u00a2\u0006\u0002\u0010\u000bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u001a\u001a\u00020\u001b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0000J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\t\u0010 \u001a\u00020\u0004H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J#\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0014\u001a\u00020$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010$H\u00d6\u0003J\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\n \u000f*\u0004\u0018\u00010+0+J\t\u0010,\u001a\u00020-H\u00d6\u0001J\u0006\u0010.\u001a\u00020&J\u0006\u0010/\u001a\u00020&J\"\u00100\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\u0004J\b\u00104\u001a\u00020\u0004H\u0016J\u0015\u00105\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00106R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00067"}, d2={"Lde/gmuth/ipp/core/IppAttribute;", "T", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "name", "", "tag", "Lde/gmuth/ipp/core/IppTag;", "values", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;Ljava/util/Collection;)V", "", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;[Ljava/lang/Object;)V", "(Ljava/lang/String;Lde/gmuth/ipp/core/IppTag;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "getTag", "()Lde/gmuth/ipp/core/IppTag;", "value", "getValue", "()Ljava/lang/Object;", "", "getValues", "()Ljava/util/Collection;", "additionalValue", "", "attribute", "buildIppAttribute", "printerAttributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "component1", "component2", "copy", "enumNameOrValue", "", "equals", "", "other", "getDurationOfSecondsValue", "Ljava/time/Duration;", "getZonedDateTimeValue", "Ljava/time/ZonedDateTime;", "hashCode", "", "is1setOf", "isCollection", "log", "level", "Ljava/util/logging/Level;", "prefix", "toString", "valueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "ipp-client"})
public final class IppAttribute<T>
implements IppAttributeBuilder {
    @NotNull
    private final String name;
    @NotNull
    private final IppTag tag;
    private final Logger logger;
    @NotNull
    private final Collection<T> values;

    public IppAttribute(@NotNull String name, @NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        this.name = name;
        this.tag = tag;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.values = new ArrayList();
        if (this.tag.isDelimiterTag()) {
            throw new IppException("'" + this.tag + "' is not a value tag", null, 2, null);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final IppTag getTag() {
        return this.tag;
    }

    @NotNull
    public final Collection<T> getValues() {
        return this.values;
    }

    public IppAttribute(@NotNull String name, @NotNull IppTag tag, @NotNull Collection<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, tag);
        if (!values.isEmpty()) {
            Object object = CollectionsKt.first((Iterable)values);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            tag.validateValueClass(object);
        }
        this.values.addAll(values);
    }

    public IppAttribute(@NotNull String name, @NotNull IppTag tag, T ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(name, tag, ArraysKt.toList((Object[])values));
    }

    public final T getValue() {
        if (Intrinsics.areEqual((Object)IppRegistrationsSection2.INSTANCE.attributeIs1setOf(this.name), (Object)true)) {
            throw new IppException("'" + this.name + "' is registered as '1setOf', use 'values' instead", null, 2, null);
        }
        return (T)CollectionsKt.single((Iterable)this.values);
    }

    public final void additionalValue(@NotNull IppAttribute<?> attribute) {
        Intrinsics.checkNotNullParameter(attribute, (String)"attribute");
        if (((CharSequence)attribute.name).length() > 0) {
            throw new IppException("For additional '" + this.name + "' values attribute name must be empty", null, 2, null);
        }
        if (attribute.values.size() != 1) {
            throw new IppException("Expected 1 additional value, not " + attribute.values.size(), null, 2, null);
        }
        if (attribute.tag != this.tag) {
            this.logger.warning(() -> IppAttribute.additionalValue$lambda$0(this, attribute));
        } else {
            IppTag ippTag = attribute.tag;
            Object object = CollectionsKt.single((Iterable)attribute.values);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Any");
            ippTag.validateValueClass(object);
            this.values.add(CollectionsKt.single((Iterable)attribute.values));
        }
    }

    public final boolean is1setOf() {
        return this.values.size() > 1 || Intrinsics.areEqual((Object)IppRegistrationsSection2.INSTANCE.attributeIs1setOf(this.name), (Object)true);
    }

    public final boolean isCollection() {
        return this.tag == IppTag.BegCollection;
    }

    @NotNull
    public IppAttribute<T> buildIppAttribute(@NotNull IppAttributesGroup printerAttributes) {
        Intrinsics.checkNotNullParameter((Object)printerAttributes, (String)"printerAttributes");
        return this;
    }

    public final ZonedDateTime getZonedDateTimeValue() {
        T t = this.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Int");
        return Instant.ofEpochSecond(((Integer)t).intValue()).atZone(ZoneOffset.UTC);
    }

    @NotNull
    public final Duration getDurationOfSecondsValue() {
        T t = this.getValue();
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Int");
        Duration duration = Duration.ofSeconds(((Integer)t).intValue());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds((value as Int).toLong())");
        return duration;
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u241 = new StringBuilder(this.name);
        boolean bl = false;
        $this$toString_u24lambda_u241.append(" (" + (this.is1setOf() ? "1setOf " : "") + this.tag + ") = ");
        $this$toString_u24lambda_u241.append(this.values.isEmpty() ? "no-value" : CollectionsKt.joinToString$default((Iterable)this.values, (CharSequence)",", null, null, (int)0, null, (Function1)new Function1<T, CharSequence>(this){
            final /* synthetic */ IppAttribute<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(T it) {
                return IppAttribute.access$valueToString(this.this$0, it);
            }
        }, (int)30, null));
        String string = $this$toString_u24lambda_u241.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(name).run \u2026\n        toString()\n    }");
        return string;
    }

    private final String valueToString(T value) {
        Object object;
        if (this.tag == IppTag.Charset) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type java.nio.charset.Charset");
            Charset $this$valueToString_u24lambda_u242 = (Charset)value;
            boolean bl = false;
            String string = $this$valueToString_u24lambda_u242.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name()");
            String string2 = string.toLowerCase(Locale.ROOT);
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else if (this.tag == IppTag.RangeOfInteger) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.ranges.IntRange");
            IntRange $this$valueToString_u24lambda_u243 = (IntRange)value;
            boolean bl = false;
            object = $this$valueToString_u24lambda_u243.getStart() + "-" + $this$valueToString_u24lambda_u243.getEndInclusive();
        } else if (this.tag == IppTag.Integer && StringsKt.endsWith$default((String)this.name, (String)"time", (boolean)false, (int)2, null)) {
            object = value + " (" + this.getZonedDateTimeValue() + ")";
        } else if (this.tag == IppTag.Integer && (StringsKt.endsWith$default((String)this.name, (String)"duration", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)this.name, (String)"time-interval", (boolean)false, (int)2, null))) {
            object = value + " (" + this.getDurationOfSecondsValue() + ")";
        } else if (value instanceof byte[]) {
            byte[] $this$valueToString_u24lambda_u244 = (byte[])value;
            boolean bl = false;
            object = $this$valueToString_u24lambda_u244.length == 0 ? "no-value" : $this$valueToString_u24lambda_u244.length + " bytes";
        } else {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Any");
            object = this.enumNameOrValue(value).toString();
        }
        return object;
    }

    @NotNull
    public final Object enumNameOrValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.tag == IppTag.Enum ? IppRegistrationsSection6.INSTANCE.getEnumName(this.name, value) : value;
    }

    public final void log(@NotNull Logger logger, @NotNull Level level, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Logger $this$log_u24lambda_u248 = logger;
        boolean bl = false;
        String string = $this$log_u24lambda_u248.toString();
        if (string.length() < 160) {
            $this$log_u24lambda_u248.log(level, () -> IppAttribute.log$lambda$8$lambda$5(prefix, string));
        } else {
            $this$log_u24lambda_u248.log(level, () -> IppAttribute.log$lambda$8$lambda$6(prefix, $this$log_u24lambda_u248, this));
            for (T value : this.values) {
                if (value instanceof IppCollection) {
                    ((IppCollection)value).log(logger, level, prefix + "  ");
                    continue;
                }
                $this$log_u24lambda_u248.log(level, () -> IppAttribute.log$lambda$8$lambda$7(prefix, this, value));
            }
        }
    }

    public static /* synthetic */ void log$default(IppAttribute ippAttribute, Logger logger, Level level, String string, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        if ((n & 4) != 0) {
            string = "";
        }
        ippAttribute.log(logger, level, string);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final IppTag component2() {
        return this.tag;
    }

    @NotNull
    public final IppAttribute<T> copy(@NotNull String name, @NotNull IppTag tag) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)tag), (String)"tag");
        return new IppAttribute<T>(name, tag);
    }

    public static /* synthetic */ IppAttribute copy$default(IppAttribute ippAttribute, String string, IppTag ippTag, int n, Object object) {
        if ((n & 1) != 0) {
            string = ippAttribute.name;
        }
        if ((n & 2) != 0) {
            ippTag = ippAttribute.tag;
        }
        return ippAttribute.copy(string, ippTag);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.tag.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IppAttribute)) {
            return false;
        }
        IppAttribute ippAttribute = (IppAttribute)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)ippAttribute.name)) {
            return false;
        }
        return this.tag == ippAttribute.tag;
    }

    private static final String additionalValue$lambda$0(IppAttribute this$0, IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return this$0.name + ": ignore additional value \"" + $attribute + "\" - tag is not '" + this$0.tag + "'";
    }

    private static final String log$lambda$8$lambda$5(String $prefix, String $string) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)$string, (String)"$string");
        return $prefix + $string;
    }

    private static final String log$lambda$8$lambda$6(String $prefix, Logger $this_run, IppAttribute this$0) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return $prefix + $this_run.getName() + " (" + this$0.tag + ") =";
    }

    private static final String log$lambda$8$lambda$7(String $prefix, IppAttribute this$0, Object $value) {
        Intrinsics.checkNotNullParameter((Object)$prefix, (String)"$prefix");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)$value, (String)"null cannot be cast to non-null type kotlin.Any");
        return $prefix + "  " + this$0.enumNameOrValue($value);
    }

    public static final /* synthetic */ String access$valueToString(IppAttribute $this, Object value) {
        return $this.valueToString(value);
    }
}

