/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppEventNotification;
import de.gmuth.ipp.client.IppExchange;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u00100\u001a\u000201J\u0011\u00102\u001a\u0002012\u0006\u00103\u001a\u000204H\u0096\u0001J\u0006\u00105\u001a\u00020\u0007J\b\u00106\u001a\u00020\rH\u0002J\u0006\u00107\u001a\u00020\u0007J\u001f\u00108\u001a\b\u0012\u0004\u0012\u0002090\f2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010\u0015H\u0007\u00a2\u0006\u0002\u0010;J\u001a\u0010<\u001a\u0002012\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010>H\u0007J\u001a\u0010?\u001a\u00020@2\u0006\u0010 \u001a\u00020!2\b\b\u0002\u0010A\u001a\u00020BH\u0007JA\u0010C\u001a\u00020@2\b\b\u0002\u0010D\u001a\u00020\u001c2\b\b\u0002\u0010E\u001a\u00020\u00072#\b\u0002\u0010F\u001a\u001d\u0012\u0013\u0012\u001109\u00a2\u0006\f\bH\u0012\b\bI\u0012\u0004\b\b(J\u0012\u0004\u0012\u00020@0GH\u0007J\u0014\u0010K\u001a\u0002012\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\"\u0010L\u001a\u0002042\u0006\u0010M\u001a\u00020N2\u0010\b\u0002\u0010=\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010>H\u0002J\b\u0010O\u001a\u00020\rH\u0016J\u0006\u0010P\u001a\u00020@R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001e\u00a8\u0006Q"}, d2={"Lde/gmuth/ipp/client/IppSubscription;", "Lde/gmuth/ipp/client/IppExchange;", "printer", "Lde/gmuth/ipp/client/IppPrinter;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "startLease", "", "(Lde/gmuth/ipp/client/IppPrinter;Lde/gmuth/ipp/core/IppAttributesGroup;Z)V", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "events", "", "", "getEvents", "()Ljava/util/List;", "expiresAt", "Ljava/time/LocalDateTime;", "getExpiresAt", "()Ljava/time/LocalDateTime;", "id", "", "getId", "()I", "jobId", "getJobId", "lastSequenceNumber", "leaseDuration", "Ljava/time/Duration;", "getLeaseDuration", "()Ljava/time/Duration;", "leaseStartedAt", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "pollHandlesNotifications", "getPollHandlesNotifications", "()Z", "setPollHandlesNotifications", "(Z)V", "getPrinter", "()Lde/gmuth/ipp/client/IppPrinter;", "subscriberUserName", "Lde/gmuth/ipp/core/IppString;", "getSubscriberUserName", "()Lde/gmuth/ipp/core/IppString;", "timeInterval", "getTimeInterval", "cancel", "Lde/gmuth/ipp/core/IppResponse;", "exchange", "request", "Lde/gmuth/ipp/core/IppRequest;", "expired", "expires", "expiryAvailable", "getNotifications", "Lde/gmuth/ipp/client/IppEventNotification;", "notifySequenceNumber", "(Ljava/lang/Integer;)Ljava/util/List;", "getSubscriptionAttributes", "requestedAttributes", "", "log", "", "level", "Ljava/util/logging/Level;", "pollAndHandleNotifications", "pollEvery", "autoRenewSubscription", "handleNotification", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "event", "renew", "subscriptionRequest", "operation", "Lde/gmuth/ipp/core/IppOperation;", "toString", "updateAttributes", "ipp-client"})
public final class IppSubscription
implements IppExchange {
    @NotNull
    private final IppPrinter printer;
    @NotNull
    private final IppAttributesGroup attributes;
    private final Logger logger;
    private int lastSequenceNumber;
    @Nullable
    private LocalDateTime leaseStartedAt;
    private boolean pollHandlesNotifications;

    public IppSubscription(@NotNull IppPrinter printer, @NotNull IppAttributesGroup attributes, boolean startLease) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.printer = printer;
        this.attributes = attributes;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.leaseStartedAt = startLease ? LocalDateTime.now() : null;
        if (this.attributes.size() == 1 && this.attributes.containsKey((Object)"notify-subscription-id")) {
            this.updateAttributes();
        }
    }

    public /* synthetic */ IppSubscription(IppPrinter ippPrinter, IppAttributesGroup ippAttributesGroup, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(ippPrinter, ippAttributesGroup, bl);
    }

    @NotNull
    public final IppPrinter getPrinter() {
        return this.printer;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public IppResponse exchange(@NotNull IppRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.printer.exchange(request);
    }

    public final int getId() {
        return ((Number)this.attributes.getValue("notify-subscription-id")).intValue();
    }

    @NotNull
    public final Duration getLeaseDuration() {
        return this.attributes.getDurationOfSecondsValue("notify-lease-duration");
    }

    @NotNull
    public final List<String> getEvents() {
        return (List)this.attributes.getValues("notify-events");
    }

    public final int getJobId() {
        return ((Number)this.attributes.getValue("notify-job-id")).intValue();
    }

    @NotNull
    public final IppString getSubscriberUserName() {
        return (IppString)this.attributes.getValue("notify-subscriber-user-name");
    }

    @NotNull
    public final Duration getTimeInterval() {
        return this.attributes.getDurationOfSecondsValue("notify-time-interval");
    }

    private final String expires() {
        return this.getLeaseDuration().isZero() ? "(never expires)" : (this.leaseStartedAt == null ? "" : "(expires " + this.getExpiresAt() + ")");
    }

    @JvmOverloads
    @NotNull
    public final IppResponse getSubscriptionAttributes(@Nullable Collection<String> requestedAttributes) {
        return this.exchange(this.subscriptionRequest(IppOperation.GetSubscriptionAttributes, requestedAttributes));
    }

    public static /* synthetic */ IppResponse getSubscriptionAttributes$default(IppSubscription ippSubscription, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            collection = null;
        }
        return ippSubscription.getSubscriptionAttributes(collection);
    }

    public final void updateAttributes() {
        this.attributes.put(IppSubscription.getSubscriptionAttributes$default(this, null, 1, null).getSubscriptionGroup());
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<IppEventNotification> getNotifications(@Nullable Integer notifySequenceNumber) {
        void $this$mapTo$iv$iv;
        Object object = IppSubscription.subscriptionRequest$default(this, IppOperation.GetNotifications, null, 2, null);
        IppRequest $this$getNotifications_u24lambda_u242 = object;
        boolean $i$a$-apply-IppSubscription$getNotifications$request$22 = false;
        IppAttributesGroup $this$getNotifications_u24lambda_u242_u24lambda_u241 = $this$getNotifications_u24lambda_u242.getOperationGroup();
        boolean bl = false;
        Object[] objectArray = new Object[]{this.getId()};
        $this$getNotifications_u24lambda_u242_u24lambda_u241.attribute("notify-subscription-ids", IppTag.Integer, objectArray);
        Integer n = notifySequenceNumber;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            Object[] objectArray2 = new Object[]{it};
            $this$getNotifications_u24lambda_u242_u24lambda_u241.attribute("notify-sequence-numbers", IppTag.Integer, objectArray2);
        }
        IppRequest request = object;
        Iterable $this$map$iv = this.exchange(request).getAttributesGroups$ipp_client(IppTag.EventNotification);
        boolean $i$f$map = false;
        Iterable $i$a$-apply-IppSubscription$getNotifications$request$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppAttributesGroup bl2 = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new IppEventNotification(this, (IppAttributesGroup)it));
        }
        Object $this$getNotifications_u24lambda_u244 = object = (List)destination$iv$iv;
        boolean bl4 = false;
        if (!((Collection)$this$getNotifications_u24lambda_u244).isEmpty()) {
            this.lastSequenceNumber = ((IppEventNotification)CollectionsKt.last((List)$this$getNotifications_u24lambda_u244)).getSequenceNumber();
        }
        return object;
    }

    public static /* synthetic */ List getNotifications$default(IppSubscription ippSubscription, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = ippSubscription.lastSequenceNumber + 1;
        }
        return ippSubscription.getNotifications(n);
    }

    @NotNull
    public final IppResponse cancel() {
        IppResponse ippResponse;
        IppResponse it = ippResponse = this.exchange(IppSubscription.subscriptionRequest$default(this, IppOperation.CancelSubscription, null, 2, null));
        boolean bl = false;
        this.logger.info(() -> IppSubscription.cancel$lambda$6$lambda$5(this));
        return ippResponse;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final IppResponse renew(@Nullable Duration leaseDuration) {
        void $this$renew_u24lambda_u247;
        IppMessage ippMessage;
        IppRequest ippRequest = ippMessage = IppSubscription.subscriptionRequest$default(this, IppOperation.RenewSubscription, null, 2, null);
        IppSubscription ippSubscription = this;
        boolean bl = false;
        IppRequest.createSubscriptionAttributesGroup$default((IppRequest)$this$renew_u24lambda_u247, null, leaseDuration, null, null, 13, null);
        IppMessage it = ippMessage = ippSubscription.exchange((IppRequest)ippMessage);
        boolean bl2 = false;
        this.leaseStartedAt = LocalDateTime.now();
        this.updateAttributes();
        this.logger.fine(() -> IppSubscription.renew$lambda$9$lambda$8(this));
        return ippMessage;
    }

    public static /* synthetic */ IppResponse renew$default(IppSubscription ippSubscription, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = null;
        }
        return ippSubscription.renew(duration);
    }

    private final IppRequest subscriptionRequest(IppOperation operation, Collection<String> requestedAttributes) {
        IppRequest ippRequest;
        IppRequest $this$subscriptionRequest_u24lambda_u2410 = ippRequest = IppPrinter.ippRequest$ipp_client$default(this.printer, operation, requestedAttributes, null, null, 12, null);
        boolean bl = false;
        Object[] objectArray = new Object[]{this.getId()};
        $this$subscriptionRequest_u24lambda_u2410.getOperationGroup().attribute("notify-subscription-id", IppTag.Integer, objectArray);
        return ippRequest;
    }

    static /* synthetic */ IppRequest subscriptionRequest$default(IppSubscription ippSubscription, IppOperation ippOperation, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = null;
        }
        return ippSubscription.subscriptionRequest(ippOperation, collection);
    }

    public final boolean getPollHandlesNotifications() {
        return this.pollHandlesNotifications;
    }

    public final void setPollHandlesNotifications(boolean bl) {
        this.pollHandlesNotifications = bl;
    }

    @Nullable
    public final LocalDateTime getExpiresAt() {
        LocalDateTime localDateTime;
        if (this.getLeaseDuration().isZero()) {
            localDateTime = null;
        } else {
            if (!(this.leaseStartedAt != null)) {
                boolean bl = false;
                String string = "leaseStartedAt required to calculate expiration";
                throw new IllegalArgumentException(string.toString());
            }
            LocalDateTime localDateTime2 = this.leaseStartedAt;
            Intrinsics.checkNotNull((Object)localDateTime2);
            localDateTime = localDateTime2.plus(this.getLeaseDuration());
        }
        return localDateTime;
    }

    public final boolean expired() {
        return this.getExpiresAt() != null && LocalDateTime.now().isAfter(this.getExpiresAt());
    }

    public final boolean expiryAvailable() {
        return this.leaseStartedAt != null && !this.getLeaseDuration().isZero();
    }

    @JvmOverloads
    public final void pollAndHandleNotifications(@NotNull Duration pollEvery, boolean autoRenewSubscription, @NotNull Function1<? super IppEventNotification, Unit> handleNotification) {
        Intrinsics.checkNotNullParameter((Object)pollEvery, (String)"pollEvery");
        Intrinsics.checkNotNullParameter(handleNotification, (String)"handleNotification");
        try {
            this.pollHandlesNotifications = true;
            while (this.pollHandlesNotifications) {
                if (this.expiryAvailable() && this.expired()) {
                    this.logger.warning(() -> IppSubscription.pollAndHandleNotifications$lambda$12(this));
                }
                Iterable $this$forEach$iv = IppSubscription.getNotifications$default(this, null, 1, null);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IppEventNotification it = (IppEventNotification)element$iv;
                    boolean bl = false;
                    handleNotification.invoke((Object)it);
                }
                if (this.expiryAvailable() && IppSubscription.pollAndHandleNotifications$expiresAfterDelay(this, pollEvery) && autoRenewSubscription) {
                    this.renew(this.getLeaseDuration());
                }
                Thread.sleep(pollEvery.toMillis());
            }
        }
        catch (IppExchangeException.ClientErrorNotFoundException clientErrorNotFoundException) {
            this.logger.info(() -> IppSubscription.pollAndHandleNotifications$lambda$14(clientErrorNotFoundException));
        }
    }

    public static /* synthetic */ void pollAndHandleNotifications$default(IppSubscription ippSubscription, Duration duration, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(5)");
            duration = duration2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<IppEventNotification, Unit>(ippSubscription){
                final /* synthetic */ IppSubscription this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull IppEventNotification it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    IppSubscription.access$getLogger$p(this.this$0).info(() -> pollAndHandleNotifications.1.invoke$lambda$0(it));
                }

                private static final String invoke$lambda$0(IppEventNotification $it) {
                    Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                    return $it.toString();
                }
            };
        }
        ippSubscription.pollAndHandleNotifications(duration, bl, (Function1<? super IppEventNotification, Unit>)function1);
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u2415 = new StringBuilder("Subscription #" + this.getId());
        boolean bl = false;
        if (this.attributes.containsKey((Object)"notify-job-id")) {
            $this$toString_u24lambda_u2415.append(", job #" + this.getJobId());
        }
        if (this.attributes.containsKey((Object)"notify-events")) {
            $this$toString_u24lambda_u2415.append(" events=" + CollectionsKt.joinToString$default((Iterable)this.getEvents(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        if (this.attributes.containsKey((Object)"notify-time-interval")) {
            $this$toString_u24lambda_u2415.append(" time-interval=" + this.getTimeInterval());
        }
        if (this.attributes.containsKey((Object)"notify-lease-duration")) {
            $this$toString_u24lambda_u2415.append(" lease-duration=" + this.getLeaseDuration() + " " + this.expires());
        }
        String string = $this$toString_u24lambda_u2415.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"Subscript\u2026\n        toString()\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, null, "SUBSCRIPTION #" + this.getId() + " " + (this.attributes.containsKey((Object)"notify-lease-duration") ? this.expires() : ""), 4, null);
    }

    public static /* synthetic */ void log$default(IppSubscription ippSubscription, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippSubscription.log(logger, level);
    }

    @JvmOverloads
    @NotNull
    public final IppResponse getSubscriptionAttributes() {
        return IppSubscription.getSubscriptionAttributes$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppEventNotification> getNotifications() {
        return IppSubscription.getNotifications$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final IppResponse renew() {
        return IppSubscription.renew$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void pollAndHandleNotifications(@NotNull Duration pollEvery, boolean autoRenewSubscription) {
        Intrinsics.checkNotNullParameter((Object)pollEvery, (String)"pollEvery");
        IppSubscription.pollAndHandleNotifications$default(this, pollEvery, autoRenewSubscription, null, 4, null);
    }

    @JvmOverloads
    public final void pollAndHandleNotifications(@NotNull Duration pollEvery) {
        Intrinsics.checkNotNullParameter((Object)pollEvery, (String)"pollEvery");
        IppSubscription.pollAndHandleNotifications$default(this, pollEvery, false, null, 6, null);
    }

    @JvmOverloads
    public final void pollAndHandleNotifications() {
        IppSubscription.pollAndHandleNotifications$default(this, null, false, null, 7, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppSubscription.log$default(this, logger, null, 2, null);
    }

    private static final String cancel$lambda$6$lambda$5(IppSubscription this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Canceled " + this$0;
    }

    private static final String renew$lambda$9$lambda$8(IppSubscription this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Renewed " + this$0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean pollAndHandleNotifications$expiresAfterDelay(IppSubscription this$0, Duration $pollEvery) {
        if (this$0.getExpiresAt() == null) return false;
        LocalDateTime localDateTime = LocalDateTime.now().plus($pollEvery);
        LocalDateTime localDateTime2 = this$0.getExpiresAt();
        Intrinsics.checkNotNull((Object)localDateTime2);
        if (!localDateTime.isAfter(localDateTime2.minusSeconds(2L))) return false;
        return true;
    }

    private static final String pollAndHandleNotifications$lambda$12(IppSubscription this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Subscription #" + this$0.getId() + " has expired";
    }

    private static final String pollAndHandleNotifications$lambda$14(IppExchangeException.ClientErrorNotFoundException $clientErrorNotFoundException) {
        Intrinsics.checkNotNullParameter((Object)$clientErrorNotFoundException, (String)"$clientErrorNotFoundException");
        IppResponse ippResponse = $clientErrorNotFoundException.getResponse();
        Intrinsics.checkNotNull((Object)ippResponse);
        return ippResponse.getStatusMessage().toString();
    }

    public static final /* synthetic */ Logger access$getLogger$p(IppSubscription $this) {
        return $this.logger;
    }
}

