/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.attributes.CommunicationChannel;
import de.gmuth.ipp.attributes.Marker;
import de.gmuth.ipp.attributes.PrinterState;
import de.gmuth.ipp.attributes.PrinterType;
import de.gmuth.ipp.client.IppClient;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppExchange;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.client.IppValueSupport;
import de.gmuth.ipp.client.WhichJobs;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010!\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u001c\u0018\u0000 \u00e3\u00012\u00020\u0001:\u0002\u00e3\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fBG\u0012\u0006\u0010\u0007\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012\u00a2\u0006\u0002\u0010\u0013J\u001e\u0010l\u001a\u00020m2\u0006\u0010n\u001a\u00020P2\f\u0010o\u001a\b\u0012\u0004\u0012\u00020p0AH\u0004J\u0016\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\b2\u0006\u0010t\u001a\u00020\bJ\u0006\u0010u\u001a\u00020vJ\u000e\u0010u\u001a\u00020r2\u0006\u0010w\u001a\u00020xJ\u0006\u0010y\u001a\u00020vJ\u0018\u0010z\u001a\u00020r2\u0006\u0010{\u001a\u00020\b2\u0006\u0010|\u001a\u00020}H\u0002J\u001e\u0010~\u001a\u0004\u0018\u00010r2\u000e\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010A\u00a2\u0006\u0003\u0010\u0080\u0001J#\u0010\u0081\u0001\u001a\u00030\u0082\u00012\u0013\u0010o\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020p0\u0083\u0001\"\u00020p\u00a2\u0006\u0003\u0010\u0084\u0001J6\u0010\u0085\u0001\u001a\u00030\u0086\u00012\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010A2\f\b\u0002\u0010\u0087\u0001\u001a\u0005\u0018\u00010\u0088\u00012\f\b\u0002\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u0088\u0001J\u0015\u0010\u008a\u0001\u001a\u00020v2\f\b\u0002\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u0001J\u0007\u0010\u008d\u0001\u001a\u00020vJ\u0007\u0010\u008e\u0001\u001a\u00020vJ\u0012\u0010\u008f\u0001\u001a\u00020v2\u0007\u0010\u0090\u0001\u001a\u00020mH\u0016J\u0013\u0010\u0091\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u0090\u0001\u001a\u00020mH\u0002J\u0007\u0010\u0092\u0001\u001a\u00020vJ\u0012\u0010\u0093\u0001\u001a\u00030\u0082\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001J6\u0010\u0096\u0001\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010A2\n\b\u0002\u0010w\u001a\u0004\u0018\u00010x2\u0014\u0010\u0097\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020\b0\u0083\u0001\"\u00020\b\u00a2\u0006\u0003\u0010\u0098\u0001JP\u0010\u0096\u0001\u001a\t\u0012\u0005\u0012\u00030\u0082\u00010A2\n\b\u0002\u0010w\u001a\u0004\u0018\u00010x2\u000b\b\u0002\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u00102\f\b\u0002\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0095\u00012\u0011\b\u0002\u0010\u0097\u0001\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012H\u0007\u00a2\u0006\u0003\u0010\u009b\u0001J#\u0010\u009c\u0001\u001a\u00020\u00032\u0014\u0010\u0097\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020\b0\u0083\u0001\"\u00020\b\u00a2\u0006\u0003\u0010\u009d\u0001J\u001a\u0010\u009c\u0001\u001a\u00020\u00032\u0011\b\u0002\u0010\u0097\u0001\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010AJ\u0012\u0010\u009e\u0001\u001a\u00030\u0086\u00012\b\u0010\u009f\u0001\u001a\u00030\u0095\u0001JP\u0010\u00a0\u0001\u001a\t\u0012\u0005\u0012\u00030\u0086\u00010\u00122\f\b\u0002\u0010\u00a1\u0001\u001a\u0005\u0018\u00010\u0095\u00012\u000b\b\u0002\u0010\u00a2\u0001\u001a\u0004\u0018\u00010\u00102\f\b\u0002\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0095\u00012\u0011\b\u0002\u0010\u0097\u0001\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010A\u00a2\u0006\u0003\u0010\u00a3\u0001J\u0011\u0010\u00a4\u0001\u001a\u00020\u00102\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001J\u0007\u0010\u00a7\u0001\u001a\u00020vJ#\u0010\u00a8\u0001\u001a\u00020v2\u0014\u0010\u00a9\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020\b0\u0083\u0001\"\u00020\b\u00a2\u0006\u0003\u0010\u00aa\u0001J\u0016\u0010\u00a8\u0001\u001a\u00020v2\r\u0010\u00a9\u0001\u001a\b\u0012\u0004\u0012\u00020\b0\u0012JC\u0010\u00ab\u0001\u001a\u00020m2\u0006\u0010n\u001a\u00020P2\u0011\b\u0002\u0010\u0097\u0001\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010A2\u000b\b\u0002\u0010\u00ac\u0001\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\rH\u0000\u00a2\u0006\u0003\b\u00ad\u0001J\u0007\u0010\u00ae\u0001\u001a\u00020\u0010J\u0007\u0010\u00af\u0001\u001a\u00020\u0010J\u0007\u0010\u00b0\u0001\u001a\u00020\u0010J\u0007\u0010\u00b1\u0001\u001a\u00020\u0010J\u0007\u0010\u00b2\u0001\u001a\u00020\u0010J\u0007\u0010\u00b3\u0001\u001a\u00020\u0010J\u0007\u0010\u00b4\u0001\u001a\u00020\u0010J\u0007\u0010\u00b5\u0001\u001a\u00020\u0010J\u0007\u0010\u00b6\u0001\u001a\u00020\u0010J\u001d\u0010\u00b7\u0001\u001a\u00020r2\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010\u00b8\u0001\u001a\u00030\u00b9\u0001H\u0007J\u0011\u0010\u00ba\u0001\u001a\u00020B2\b\u0010\u00bb\u0001\u001a\u00030\u00bc\u0001J\u0007\u0010\u00bd\u0001\u001a\u00020\u0010J\u0007\u0010\u00be\u0001\u001a\u00020\u0010J\u0007\u0010\u00bf\u0001\u001a\u00020vJ\u0007\u0010\u00c0\u0001\u001a\u00020\u0010J@\u0010\u00c1\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u00c2\u0001\u001a\u00020g2\u0013\u0010o\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020p0\u0083\u0001\"\u00020p2\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012H\u0007\u00a2\u0006\u0003\u0010\u00c3\u0001JA\u0010\u00c1\u0001\u001a\u00030\u0082\u00012\b\u0010\u00c4\u0001\u001a\u00030\u00c5\u00012\u0013\u0010o\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020p0\u0083\u0001\"\u00020p2\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012H\u0007\u00a2\u0006\u0003\u0010\u00c6\u0001J4\u0010\u00c1\u0001\u001a\u00030\u0082\u00012\b\u0010\u00c4\u0001\u001a\u00030\u00c5\u00012\f\u0010o\u001a\b\u0012\u0004\u0012\u00020p0A2\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012H\u0007JA\u0010\u00c1\u0001\u001a\u00030\u0082\u00012\b\u0010\u00c7\u0001\u001a\u00030\u00c8\u00012\u0013\u0010o\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020p0\u0083\u0001\"\u00020p2\u0010\b\u0002\u0010\u007f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012H\u0007\u00a2\u0006\u0003\u0010\u00c9\u0001J,\u0010\u00ca\u0001\u001a\u00030\u0082\u00012\u0007\u0010\u00cb\u0001\u001a\u00020\r2\u0013\u0010o\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020p0\u0083\u0001\"\u00020p\u00a2\u0006\u0003\u0010\u00cc\u0001J\u0012\u0010\u00cd\u0001\u001a\u00020g2\t\b\u0002\u0010\u00ce\u0001\u001a\u00020\bJ\u0007\u0010\u00cf\u0001\u001a\u00020vJ\u0007\u0010\u00d0\u0001\u001a\u00020vJ\u0007\u0010\u00d1\u0001\u001a\u00020vJ(\u0010\u00d2\u0001\u001a\u00020g2\t\b\u0002\u0010\u00d3\u0001\u001a\u00020g2\t\b\u0002\u0010\u00d4\u0001\u001a\u00020\b2\t\b\u0002\u0010\u00c2\u0001\u001a\u00020gJ\u0012\u0010\u00d5\u0001\u001a\u00020r2\t\b\u0002\u0010\u00d3\u0001\u001a\u00020\bJ\u0007\u0010\u00d6\u0001\u001a\u00020vJ#\u0010\u00d7\u0001\u001a\u00020\u00102\u0014\u0010\u00d8\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020P0\u0083\u0001\"\u00020P\u00a2\u0006\u0003\u0010\u00d9\u0001J\u0010\u0010\u00da\u0001\u001a\u00020\u00102\u0007\u0010\u00db\u0001\u001a\u00020\bJ\t\u0010\u00dc\u0001\u001a\u00020\bH\u0016J#\u0010\u00dd\u0001\u001a\u00020r2\u0014\u0010\u0097\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020\b0\u0083\u0001\"\u00020\b\u00a2\u0006\u0003\u0010\u00de\u0001J\u001a\u0010\u00dd\u0001\u001a\u00020r2\u0011\b\u0002\u0010\u0097\u0001\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0012J\"\u0010\u00df\u0001\u001a\u00020v2\u0013\u0010o\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020p0\u0083\u0001\"\u00020p\u00a2\u0006\u0003\u0010\u00e0\u0001J\u0013\u0010\u00e1\u0001\u001a\u00020g*\u00020gH\u0000\u00a2\u0006\u0003\b\u00e2\u0001R\u0019\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0016R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00128F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0016R\u0011\u0010\"\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0017\u0010(\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0016R \u0010*\u001a\b\u0012\u0004\u0012\u00020\b0+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010.R\u0017\u0010/\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0016R\u0011\u00101\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b6\u00107R\u0011\u00108\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001eR\u0011\u00109\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b:\u00103R\u0016\u0010;\u001a\n =*\u0004\u0018\u00010<0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010>\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b?\u00103R\u0017\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A8F\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u0011\u0010E\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010$R\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\bH\u0010\u0016R\u0017\u0010I\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0016R\u0017\u0010K\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0016R\u0011\u0010M\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bN\u00103R\u0017\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u00128F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010\u0016R\u0011\u0010R\u001a\u00020S8F\u00a2\u0006\u0006\u001a\u0004\bT\u0010UR\u0011\u0010\u0007\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bV\u0010'R\u0017\u0010W\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\bX\u0010\u0016R\u0011\u0010Y\u001a\u00020Z8F\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0013\u0010]\u001a\u0004\u0018\u00010\u00188F\u00a2\u0006\u0006\u001a\u0004\b^\u00103R\u0017\u0010_\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u0016R\u001b\u0010a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0A\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010DR\u0017\u0010d\u001a\b\u0012\u0004\u0012\u00020\b0\u00128F\u00a2\u0006\u0006\u001a\u0004\be\u0010\u0016R\u001a\u0010f\u001a\u00020gX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010i\"\u0004\bj\u0010k\u00a8\u0006\u00e4\u0001"}, d2={"Lde/gmuth/ipp/client/IppPrinter;", "Lde/gmuth/ipp/client/IppExchange;", "printerAttributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "ippClient", "Lde/gmuth/ipp/client/IppClient;", "(Lde/gmuth/ipp/core/IppAttributesGroup;Lde/gmuth/ipp/client/IppClient;)V", "printerUri", "", "(Ljava/lang/String;)V", "ippConfig", "Lde/gmuth/ipp/client/IppConfig;", "(Ljava/lang/String;Lde/gmuth/ipp/client/IppConfig;)V", "Ljava/net/URI;", "attributes", "getPrinterAttributesOnInit", "", "requestedAttributesOnInit", "", "(Ljava/net/URI;Lde/gmuth/ipp/core/IppAttributesGroup;Lde/gmuth/ipp/client/IppConfig;Lde/gmuth/ipp/client/IppClient;ZLjava/util/List;)V", "alert", "getAlert", "()Ljava/util/List;", "alertDescription", "Lde/gmuth/ipp/core/IppString;", "getAlertDescription", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "colorSupported", "getColorSupported", "()Z", "communicationChannelsSupported", "Lde/gmuth/ipp/attributes/CommunicationChannel;", "getCommunicationChannelsSupported", "cupsVersion", "getCupsVersion", "()Ljava/lang/String;", "deviceUri", "getDeviceUri", "()Ljava/net/URI;", "documentFormatSupported", "getDocumentFormatSupported", "getJobsRequestedAttributes", "", "getGetJobsRequestedAttributes", "setGetJobsRequestedAttributes", "(Ljava/util/List;)V", "identifyActionsSupported", "getIdentifyActionsSupported", "info", "getInfo", "()Lde/gmuth/ipp/core/IppString;", "getIppClient$ipp_client", "()Lde/gmuth/ipp/client/IppClient;", "getIppConfig", "()Lde/gmuth/ipp/client/IppConfig;", "isAcceptingJobs", "location", "getLocation", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "makeAndModel", "getMakeAndModel", "markers", "", "Lde/gmuth/ipp/attributes/Marker;", "getMarkers", "()Ljava/util/Collection;", "mediaDefault", "getMediaDefault", "mediaReady", "getMediaReady", "mediaSourceSupported", "getMediaSourceSupported", "mediaSupported", "getMediaSupported", "name", "getName", "operationsSupported", "Lde/gmuth/ipp/core/IppOperation;", "getOperationsSupported", "printerType", "Lde/gmuth/ipp/attributes/PrinterType;", "getPrinterType", "()Lde/gmuth/ipp/attributes/PrinterType;", "getPrinterUri", "sidesSupported", "getSidesSupported", "state", "Lde/gmuth/ipp/attributes/PrinterState;", "getState", "()Lde/gmuth/ipp/attributes/PrinterState;", "stateMessage", "getStateMessage", "stateReasons", "getStateReasons", "supportedAttributes", "Lde/gmuth/ipp/core/IppAttribute;", "getSupportedAttributes", "versionsSupported", "getVersionsSupported", "workDirectory", "Ljava/io/File;", "getWorkDirectory", "()Ljava/io/File;", "setWorkDirectory", "(Ljava/io/File;)V", "attributeBuildersRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "attributeBuilders", "Lde/gmuth/ipp/core/IppAttributeBuilder;", "basicAuth", "", "user", "password", "cancelJobs", "Lde/gmuth/ipp/core/IppResponse;", "whichJobs", "Lde/gmuth/ipp/client/WhichJobs;", "cancelMyJobs", "checkIfValueIsSupported", "supportedAttributeName", "value", "", "checkNotifyEvents", "notifyEvents", "(Ljava/util/Collection;)Lkotlin/Unit;", "createJob", "Lde/gmuth/ipp/client/IppJob;", "", "([Lde/gmuth/ipp/core/IppAttributeBuilder;)Lde/gmuth/ipp/client/IppJob;", "createPrinterSubscription", "Lde/gmuth/ipp/client/IppSubscription;", "notifyLeaseDuration", "Ljava/time/Duration;", "notifyTimeInterval", "cupsGetPPD", "copyTo", "Ljava/io/OutputStream;", "disable", "enable", "exchange", "request", "exchangeForIppJob", "flash", "getJob", "jobId", "", "getJobs", "requestedAttributes", "(Lde/gmuth/ipp/client/WhichJobs;[Ljava/lang/String;)Ljava/util/Collection;", "myJobs", "limit", "(Lde/gmuth/ipp/client/WhichJobs;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/util/List;)Ljava/util/Collection;", "getPrinterAttributes", "([Ljava/lang/String;)Lde/gmuth/ipp/core/IppAttributesGroup;", "getSubscription", "id", "getSubscriptions", "notifyJobId", "mySubscriptions", "(Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/util/Collection;)Ljava/util/List;", "hasCapability", "capability", "Lde/gmuth/ipp/attributes/PrinterType$Capability;", "holdNewJobs", "identify", "actions", "([Ljava/lang/String;)Lde/gmuth/ipp/core/IppResponse;", "ippRequest", "userName", "ippRequest$ipp_client", "isCups", "isDuplexSupported", "isIdle", "isMediaEmpty", "isMediaJam", "isMediaLow", "isMediaNeeded", "isProcessing", "isStopped", "log", "level", "Ljava/util/logging/Level;", "marker", "color", "Lde/gmuth/ipp/attributes/Marker$Color;", "mediaEmptyReport", "offlineReport", "pause", "paused", "printJob", "file", "(Ljava/io/File;[Lde/gmuth/ipp/core/IppAttributeBuilder;Ljava/util/List;)Lde/gmuth/ipp/client/IppJob;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;[Lde/gmuth/ipp/core/IppAttributeBuilder;Ljava/util/List;)Lde/gmuth/ipp/client/IppJob;", "byteArray", "", "([B[Lde/gmuth/ipp/core/IppAttributeBuilder;Ljava/util/List;)Lde/gmuth/ipp/client/IppJob;", "printUri", "documentUri", "(Ljava/net/URI;[Lde/gmuth/ipp/core/IppAttributeBuilder;)Lde/gmuth/ipp/client/IppJob;", "printerDirectory", "printerName", "purgeJobs", "releaseHeldNewJobs", "resume", "savePPD", "directory", "filename", "savePrinterAttributes", "sound", "supportsOperations", "operations", "([Lde/gmuth/ipp/core/IppOperation;)Z", "supportsVersion", "version", "toString", "updateAttributes", "([Ljava/lang/String;)V", "validateJob", "([Lde/gmuth/ipp/core/IppAttributeBuilder;)Lde/gmuth/ipp/core/IppResponse;", "createDirectoryIfNotExists", "createDirectoryIfNotExists$ipp_client", "Companion", "ipp-client"})
public final class IppPrinter
implements IppExchange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URI printerUri;
    @NotNull
    private final IppAttributesGroup attributes;
    @NotNull
    private final IppClient ippClient;
    private final Logger logger;
    @NotNull
    private File workDirectory;
    @NotNull
    private List<String> getJobsRequestedAttributes;
    @NotNull
    private final Collection<IppAttribute<?>> supportedAttributes;
    @NotNull
    private static final List<String> printerClassAttributes;

    /*
     * WARNING - void declaration
     */
    public IppPrinter(@NotNull URI printerUri, @NotNull IppAttributesGroup attributes, @NotNull IppConfig ippConfig, @NotNull IppClient ippClient, boolean getPrinterAttributesOnInit, @Nullable List<String> requestedAttributesOnInit) {
        void $this$sortedBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List<Object> it;
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)ippConfig, (String)"ippConfig");
        Intrinsics.checkNotNullParameter((Object)ippClient, (String)"ippClient");
        this.printerUri = printerUri;
        this.attributes = attributes;
        this.ippClient = ippClient;
        this.logger = Logger.getLogger(this.getClass().getName());
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory().toFile()");
        this.workDirectory = file;
        this.logger.fine(() -> IppPrinter._init_$lambda$0(this));
        String string = this.printerUri.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"printerUri.scheme");
        if (!StringsKt.startsWith$default((String)string, (String)"ipp", (boolean)false, (int)2, null)) {
            boolean $i$a$-require-IppPrinter$32 = false;
            String $i$a$-require-IppPrinter$32 = "uri scheme unsupported: " + this.printerUri.getScheme();
            throw new IllegalArgumentException($i$a$-require-IppPrinter$32.toString());
        }
        if (Intrinsics.areEqual((Object)this.printerUri.getScheme(), (Object)"ipps")) {
            ippConfig.trustAnyCertificateAndSSLHostname();
        }
        if (!getPrinterAttributesOnInit) {
            this.logger.fine(IppPrinter::_init_$lambda$2);
        } else if (this.attributes.isEmpty()) {
            block16: {
                try {
                    this.updateAttributes(requestedAttributesOnInit);
                    if (!this.isStopped()) break block16;
                    this.logger.fine(() -> IppPrinter._init_$lambda$3(this));
                    List<String> list = this.getAlert();
                    if (list != null) {
                        it = list;
                        boolean bl = false;
                        this.logger.info(() -> IppPrinter.lambda$5$lambda$4(it));
                    }
                    List<IppString> list2 = this.getAlertDescription();
                    if (list2 != null) {
                        it = list2;
                        boolean bl = false;
                        this.logger.info(() -> IppPrinter.lambda$7$lambda$6(it));
                    }
                }
                catch (IppExchangeException ippExchangeException) {
                    if (ippExchangeException.statusIs(IppStatus.ClientErrorNotFound)) {
                        this.logger.severe(() -> IppPrinter._init_$lambda$8(ippExchangeException));
                    } else {
                        this.logger.severe(IppPrinter::_init_$lambda$9);
                        IppResponse ippResponse = ippExchangeException.getResponse();
                        if (ippResponse != null) {
                            IppResponse it2 = ippResponse;
                            boolean bl = false;
                            if (it2.containsGroup(IppTag.Printer)) {
                                this.logger.info(() -> IppPrinter.lambda$12$lambda$10(it2));
                            } else {
                                this.logger.warning(() -> IppPrinter.lambda$12$lambda$11(it2));
                            }
                        }
                    }
                    throw ippExchangeException;
                }
            }
            if (this.isCups()) {
                this.workDirectory = new File("cups-" + this.printerUri.getHost());
            }
        }
        Object ippExchangeException = new String[]{"job-id", "job-uri", "job-printer-uri", "job-state", "job-name", "job-state-reasons", "job-originating-user-name"};
        this.getJobsRequestedAttributes = CollectionsKt.mutableListOf((Object[])ippExchangeException);
        Collection<IppAttribute<?>> collection = this.attributes.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"attributes.values");
        ippExchangeException = collection;
        IppPrinter ippPrinter = this;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IppAttribute it3 = (IppAttribute)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.endsWith$default((String)it3.getName(), (String)"-supported", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        ippPrinter.supportedAttributes = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                IppAttribute it = (IppAttribute)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (IppAttribute)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    public /* synthetic */ IppPrinter(URI uRI, IppAttributesGroup ippAttributesGroup, IppConfig ippConfig, IppClient ippClient, boolean bl, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ippAttributesGroup = new IppAttributesGroup(IppTag.Printer);
        }
        if ((n & 4) != 0) {
            ippConfig = new IppConfig(null, null, null, null, null, null, null, null, false, 511, null);
        }
        if ((n & 8) != 0) {
            ippClient = new IppClient(ippConfig);
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        if ((n & 0x20) != 0) {
            list = null;
        }
        this(uRI, ippAttributesGroup, ippConfig, ippClient, bl, list);
    }

    @NotNull
    public final URI getPrinterUri() {
        return this.printerUri;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    @NotNull
    public final IppClient getIppClient$ipp_client() {
        return this.ippClient;
    }

    @NotNull
    public final File getWorkDirectory() {
        return this.workDirectory;
    }

    public final void setWorkDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.workDirectory = file;
    }

    public IppPrinter(@NotNull IppAttributesGroup printerAttributes, @NotNull IppClient ippClient) {
        Intrinsics.checkNotNullParameter((Object)printerAttributes, (String)"printerAttributes");
        Intrinsics.checkNotNullParameter((Object)ippClient, (String)"ippClient");
        this((URI)CollectionsKt.first((List)((List)printerAttributes.getValues("printer-uri-supported"))), printerAttributes, null, ippClient, false, null, 52, null);
    }

    public IppPrinter(@NotNull String printerUri) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        URI uRI = URI.create(printerUri);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(printerUri)");
        this(uRI, null, null, null, false, null, 62, null);
    }

    public IppPrinter(@NotNull String printerUri, @NotNull IppConfig ippConfig) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        Intrinsics.checkNotNullParameter((Object)ippConfig, (String)"ippConfig");
        URI uRI = URI.create(printerUri);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(printerUri)");
        this(uRI, null, ippConfig, null, false, null, 58, null);
    }

    @NotNull
    public final IppConfig getIppConfig() {
        return this.ippClient.getConfig();
    }

    public final void basicAuth(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.ippClient.basicAuth(user, password);
    }

    @NotNull
    public final List<String> getGetJobsRequestedAttributes() {
        return this.getJobsRequestedAttributes;
    }

    public final void setGetJobsRequestedAttributes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.getJobsRequestedAttributes = list;
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("printer-name");
    }

    @NotNull
    public final IppString getMakeAndModel() {
        return (IppString)this.attributes.getValue("printer-make-and-model");
    }

    @NotNull
    public final IppString getInfo() {
        return (IppString)this.attributes.getValue("printer-info");
    }

    @NotNull
    public final IppString getLocation() {
        return (IppString)this.attributes.getValue("printer-location");
    }

    public final boolean isAcceptingJobs() {
        return (Boolean)this.attributes.getValue("printer-is-accepting-jobs");
    }

    @NotNull
    public final PrinterState getState() {
        return PrinterState.Companion.fromAttributes(this.attributes);
    }

    @NotNull
    public final List<String> getStateReasons() {
        return (List)this.attributes.getValues("printer-state-reasons");
    }

    @Nullable
    public final IppString getStateMessage() {
        return (IppString)this.attributes.getValueOrNull("printer-state-message");
    }

    @NotNull
    public final List<String> getDocumentFormatSupported() {
        return (List)this.attributes.getValues("document-format-supported");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppOperation> getOperationsSupported() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.attributes.getValues("operations-supported");
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(IppOperation.Companion.fromInt((int)it));
        }
        return (List)destination$iv$iv;
    }

    public final boolean getColorSupported() {
        return (Boolean)this.attributes.getValue("color-supported");
    }

    @NotNull
    public final List<String> getSidesSupported() {
        return (List)this.attributes.getValues("sides-supported");
    }

    @NotNull
    public final List<String> getMediaSupported() {
        return (List)this.attributes.getValues("media-supported");
    }

    @NotNull
    public final List<String> getMediaReady() {
        return (List)this.attributes.getValues("media-ready");
    }

    @NotNull
    public final String getMediaDefault() {
        return (String)this.attributes.getValue("media-default");
    }

    @NotNull
    public final List<String> getMediaSourceSupported() {
        return (List)this.attributes.getValues("media-source-supported");
    }

    @NotNull
    public final List<String> getVersionsSupported() {
        return (List)this.attributes.getValues("ipp-versions-supported");
    }

    @NotNull
    public final List<CommunicationChannel> getCommunicationChannelsSupported() {
        return CommunicationChannel.Companion.getCommunicationChannelsSupported(this.attributes);
    }

    @Nullable
    public final List<String> getAlert() {
        return (List)this.attributes.getValuesOrNull("printer-alert");
    }

    @Nullable
    public final List<IppString> getAlertDescription() {
        return (List)this.attributes.getValuesOrNull("printer-alert-description");
    }

    @NotNull
    public final List<String> getIdentifyActionsSupported() {
        return (List)this.attributes.getValues("identify-actions-supported");
    }

    @NotNull
    public final Collection<Marker> getMarkers() {
        return Marker.Companion.getMarkers(this.attributes);
    }

    @NotNull
    public final Marker marker(@NotNull Marker.Color color) {
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        Iterable $this$single$iv = this.getMarkers();
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            Marker it = (Marker)element$iv;
            boolean bl = false;
            if (!(it.getColor() == color)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return single$iv;
    }

    @NotNull
    public final URI getDeviceUri() {
        return (URI)this.attributes.getValue("device-uri");
    }

    @NotNull
    public final PrinterType getPrinterType() {
        return PrinterType.Companion.fromAttributes(this.attributes);
    }

    public final boolean hasCapability(@NotNull PrinterType.Capability capability) {
        Intrinsics.checkNotNullParameter((Object)((Object)capability), (String)"capability");
        return this.getPrinterType().contains(capability);
    }

    @NotNull
    public final String getCupsVersion() {
        return this.attributes.getTextValue("cups-version");
    }

    @NotNull
    public final Collection<IppAttribute<?>> getSupportedAttributes() {
        return this.supportedAttributes;
    }

    public final boolean isIdle() {
        return this.getState() == PrinterState.Idle;
    }

    public final boolean isStopped() {
        return this.getState() == PrinterState.Stopped;
    }

    public final boolean isProcessing() {
        return this.getState() == PrinterState.Processing;
    }

    public final boolean isMediaJam() {
        return this.getStateReasons().contains("media-jam");
    }

    public final boolean isMediaLow() {
        return this.getStateReasons().contains("media-low");
    }

    public final boolean isMediaEmpty() {
        return this.getStateReasons().contains("media-empty");
    }

    public final boolean isMediaNeeded() {
        return this.getStateReasons().contains("media-needed");
    }

    public final boolean isDuplexSupported() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.getSidesSupported();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)it, (String)"two-sided", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean supportsOperations(IppOperation ... operations) {
        Intrinsics.checkNotNullParameter((Object)operations, (String)"operations");
        return this.getOperationsSupported().containsAll(ArraysKt.toList((Object[])operations));
    }

    public final boolean supportsVersion(@NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return this.getVersionsSupported().contains(version2);
    }

    public final boolean isCups() {
        return ((Map)this.attributes).containsKey("cups-version");
    }

    public final boolean paused() {
        return this.getStateReasons().contains("paused");
    }

    public final boolean offlineReport() {
        return this.getStateReasons().contains("offline-report");
    }

    public final boolean mediaEmptyReport() {
        return this.getStateReasons().contains("media-empty-report");
    }

    @NotNull
    public final IppResponse identify(String ... actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        return this.identify(ArraysKt.toList((Object[])actions));
    }

    @NotNull
    public final IppResponse identify(@NotNull List<String> actions) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        IppRequest $this$identify_u24lambda_u2418 = ippRequest = IppPrinter.ippRequest$ipp_client$default(this, IppOperation.IdentifyPrinter, null, null, null, 14, null);
        boolean bl = false;
        this.checkIfValueIsSupported("identify-actions-supported", actions);
        $this$identify_u24lambda_u2418.getOperationGroup().attribute("identify-actions", IppTag.Keyword, (Collection<? extends Object>)actions);
        IppRequest request = ippRequest;
        return this.exchange(request);
    }

    @NotNull
    public final IppResponse flash() {
        String[] stringArray = new String[]{"flash"};
        return this.identify(stringArray);
    }

    @NotNull
    public final IppResponse sound() {
        String[] stringArray = new String[]{"sound"};
        return this.identify(stringArray);
    }

    @NotNull
    public final IppResponse pause() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.PausePrinter, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse resume() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.ResumePrinter, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse purgeJobs() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.PurgeJobs, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse enable() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.EnablePrinter, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse disable() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.DisablePrinter, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse holdNewJobs() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.HoldNewJobs, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse releaseHeldNewJobs() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.ReleaseHeldNewJobs, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse cancelJobs() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.CancelJobs, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse cancelMyJobs() {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.CancelMyJobs, null, null, null, 14, null));
    }

    @NotNull
    public final IppResponse cupsGetPPD(@Nullable OutputStream copyTo) {
        IppResponse ippResponse;
        block0: {
            IppResponse $this$cupsGetPPD_u24lambda_u2420 = ippResponse = this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.CupsGetPPD, null, null, null, 14, null));
            boolean bl = false;
            OutputStream outputStream = copyTo;
            if (outputStream == null) break block0;
            OutputStream it = outputStream;
            boolean bl2 = false;
            InputStream inputStream = $this$cupsGetPPD_u24lambda_u2420.getDocumentInputStream();
            Intrinsics.checkNotNull((Object)inputStream);
            ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)it, (int)0, (int)2, null);
        }
        return ippResponse;
    }

    public static /* synthetic */ IppResponse cupsGetPPD$default(IppPrinter ippPrinter, OutputStream outputStream, int n, Object object) {
        if ((n & 1) != 0) {
            outputStream = null;
        }
        return ippPrinter.cupsGetPPD(outputStream);
    }

    @NotNull
    public final File savePPD(@NotNull File directory, @NotNull String filename, @NotNull File file) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File it = file2 = file;
        boolean bl = false;
        this.cupsGetPPD(new FileOutputStream(it));
        this.logger.info(() -> IppPrinter.savePPD$lambda$22$lambda$21(it));
        return file2;
    }

    public static /* synthetic */ File savePPD$default(IppPrinter ippPrinter, File file, String object, File file2, int n, Object object2) {
        if ((n & 1) != 0) {
            file = ippPrinter.workDirectory;
        }
        if ((n & 2) != 0) {
            object = ippPrinter.getName() + ".ppd";
        }
        if ((n & 4) != 0) {
            file2 = new File(file, (String)object);
        }
        return ippPrinter.savePPD(file, (String)object, file2);
    }

    @NotNull
    public final IppAttributesGroup getPrinterAttributes(@Nullable Collection<String> requestedAttributes) {
        return this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.GetPrinterAttributes, requestedAttributes, null, null, 12, null)).getPrinterGroup();
    }

    public static /* synthetic */ IppAttributesGroup getPrinterAttributes$default(IppPrinter ippPrinter, Collection collection, int n, Object object) {
        if ((n & 1) != 0) {
            collection = null;
        }
        return ippPrinter.getPrinterAttributes(collection);
    }

    @NotNull
    public final IppAttributesGroup getPrinterAttributes(String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        return this.getPrinterAttributes(ArraysKt.toList((Object[])requestedAttributes));
    }

    public final void updateAttributes(@Nullable List<String> requestedAttributes) {
        this.attributes.put(this.getPrinterAttributes((Collection<String>)requestedAttributes));
    }

    public static /* synthetic */ void updateAttributes$default(IppPrinter ippPrinter, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        ippPrinter.updateAttributes(list);
    }

    public final void updateAttributes(String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        this.updateAttributes(ArraysKt.toList((Object[])requestedAttributes));
    }

    @NotNull
    public final IppResponse validateJob(IppAttributeBuilder ... attributeBuilders) throws IppExchangeException {
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        IppRequest request = this.attributeBuildersRequest(IppOperation.ValidateJob, ArraysKt.toList((Object[])attributeBuilders));
        return this.exchange(request);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, @NotNull Collection<? extends IppAttributeBuilder> attributeBuilders, @Nullable List<String> notifyEvents) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(attributeBuilders, (String)"attributeBuilders");
        IppRequest $this$printJob_u24lambda_u2424 = ippRequest = this.attributeBuildersRequest(IppOperation.PrintJob, attributeBuilders);
        boolean bl = false;
        List<String> list = notifyEvents;
        if (list != null) {
            List<String> it = list;
            boolean bl2 = false;
            this.checkNotifyEvents((Collection<String>)notifyEvents);
            IppRequest.createSubscriptionAttributesGroup$default($this$printJob_u24lambda_u2424, notifyEvents, null, null, null, 14, null);
        }
        $this$printJob_u24lambda_u2424.setDocumentInputStream(inputStream);
        IppRequest request = ippRequest;
        return this.exchangeForIppJob(request);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, InputStream inputStream, Collection collection, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(inputStream, collection, (List<String>)list);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, @NotNull IppAttributeBuilder[] attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return this.printJob(inputStream, ArraysKt.toList((Object[])attributeBuilders), notifyEvents);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, InputStream inputStream, IppAttributeBuilder[] ippAttributeBuilderArray, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(inputStream, ippAttributeBuilderArray, (List<String>)list);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull byte[] byteArray, @NotNull IppAttributeBuilder[] attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return this.printJob((InputStream)new ByteArrayInputStream(byteArray), ArraysKt.toList((Object[])attributeBuilders), notifyEvents);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, byte[] byArray, IppAttributeBuilder[] ippAttributeBuilderArray, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(byArray, ippAttributeBuilderArray, (List<String>)list);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull File file, @NotNull IppAttributeBuilder[] attributeBuilders, @Nullable List<String> notifyEvents) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return this.printJob((InputStream)new FileInputStream(file), ArraysKt.toList((Object[])attributeBuilders), notifyEvents);
    }

    public static /* synthetic */ IppJob printJob$default(IppPrinter ippPrinter, File file, IppAttributeBuilder[] ippAttributeBuilderArray, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = null;
        }
        return ippPrinter.printJob(file, ippAttributeBuilderArray, (List<String>)list);
    }

    @NotNull
    public final IppJob printUri(@NotNull URI documentUri, IppAttributeBuilder ... attributeBuilders) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        IppRequest $this$printUri_u24lambda_u2425 = ippRequest = this.attributeBuildersRequest(IppOperation.PrintURI, ArraysKt.toList((Object[])attributeBuilders));
        boolean bl = false;
        Object[] objectArray = new Object[]{documentUri};
        $this$printUri_u24lambda_u2425.getOperationGroup().attribute("document-uri", IppTag.Uri, objectArray);
        IppRequest request = ippRequest;
        return this.exchangeForIppJob(request);
    }

    @NotNull
    public final IppJob createJob(IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        IppRequest request = this.attributeBuildersRequest(IppOperation.CreateJob, ArraysKt.toList((Object[])attributeBuilders));
        return this.exchangeForIppJob(request);
    }

    @NotNull
    protected final IppRequest attributeBuildersRequest(@NotNull IppOperation operation, @NotNull Collection<? extends IppAttributeBuilder> attributeBuilders) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter(attributeBuilders, (String)"attributeBuilders");
        IppRequest $this$attributeBuildersRequest_u24lambda_u2427 = ippRequest = IppPrinter.ippRequest$ipp_client$default(this, operation, null, null, null, 14, null);
        boolean bl = false;
        for (IppAttributeBuilder ippAttributeBuilder : attributeBuilders) {
            IppTag groupTag;
            IppAttribute<?> attribute = ippAttributeBuilder.buildIppAttribute(this.attributes);
            this.checkIfValueIsSupported(attribute.getName() + "-supported", attribute.getValues());
            IppTag ippTag = IppRegistrationsSection2.INSTANCE.selectGroupForAttribute(attribute.getName());
            if (ippTag == null) {
                ippTag = IppTag.Job;
            }
            if (!$this$attributeBuildersRequest_u24lambda_u2427.containsGroup(groupTag = ippTag)) {
                $this$attributeBuildersRequest_u24lambda_u2427.createAttributesGroup(groupTag);
            }
            this.logger.finer(() -> IppPrinter.attributeBuildersRequest$lambda$27$lambda$26(groupTag, attribute));
            $this$attributeBuildersRequest_u24lambda_u2427.getSingleAttributesGroup$ipp_client(groupTag).put(attribute);
        }
        return ippRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppJob getJob(int jobId) {
        void $this$getJob_u24lambda_u2428;
        IppRequest ippRequest;
        IppRequest ippRequest2 = ippRequest = IppPrinter.ippRequest$ipp_client$default(this, IppOperation.GetJobAttributes, null, null, null, 14, null);
        IppPrinter ippPrinter = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{jobId};
        $this$getJob_u24lambda_u2428.getOperationGroup().attribute("job-id", IppTag.Integer, objectArray);
        return ippPrinter.exchangeForIppJob(ippRequest);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs, @Nullable Boolean myJobs, @Nullable Integer limit, @Nullable List<String> requestedAttributes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int it;
        this.logger.fine(() -> IppPrinter.getJobs$lambda$29(whichJobs, requestedAttributes));
        Object object = IppPrinter.ippRequest$ipp_client$default(this, IppOperation.GetJobs, requestedAttributes, null, null, 12, null);
        IppRequest $this$getJobs_u24lambda_u2434 = object;
        boolean $i$a$-apply-IppPrinter$getJobs$request$22 = false;
        IppAttributesGroup $this$getJobs_u24lambda_u2434_u24lambda_u2433 = $this$getJobs_u24lambda_u2434.getOperationGroup();
        boolean bl = false;
        Object object2 = whichJobs;
        if (object2 != null && (object2 = object2.getKeyword()) != null) {
            Object it2 = object2;
            boolean bl2 = false;
            this.checkIfValueIsSupported("which-jobs-supported", it2);
            Object[] objectArray = new Object[]{it2};
            $this$getJobs_u24lambda_u2434_u24lambda_u2433.attribute("which-jobs", IppTag.Keyword, objectArray);
        }
        Boolean bl3 = myJobs;
        if (bl3 != null) {
            it = bl3.booleanValue();
            boolean bl4 = false;
            Object[] bl2 = new Object[]{it != 0};
            $this$getJobs_u24lambda_u2434_u24lambda_u2433.attribute("my-jobs", IppTag.Boolean, bl2);
        }
        Integer n = limit;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl5 = false;
            Object[] bl2 = new Object[]{it};
            $this$getJobs_u24lambda_u2434_u24lambda_u2433.attribute("limit", IppTag.Integer, bl2);
        }
        IppRequest request = object;
        object = this.exchange(request).getAttributesGroups$ipp_client(IppTag.Job);
        boolean $i$f$map = false;
        void $i$a$-apply-IppPrinter$getJobs$request$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            IppAttributesGroup bl2 = (IppAttributesGroup)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl6 = false;
            collection.add(new IppJob(this, (IppAttributesGroup)it3));
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ Collection getJobs$default(IppPrinter ippPrinter, WhichJobs whichJobs, Boolean bl, Integer n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            whichJobs = null;
        }
        if ((n2 & 2) != 0) {
            bl = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            list = ippPrinter.getJobsRequestedAttributes;
        }
        return ippPrinter.getJobs(whichJobs, bl, n, list);
    }

    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs, String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        return IppPrinter.getJobs$default(this, whichJobs, null, null, ArraysKt.toList((Object[])requestedAttributes), 6, null);
    }

    public static /* synthetic */ Collection getJobs$default(IppPrinter ippPrinter, WhichJobs whichJobs, String[] stringArray, int n, Object object) {
        if ((n & 1) != 0) {
            whichJobs = null;
        }
        return ippPrinter.getJobs(whichJobs, stringArray);
    }

    public final void cancelJobs(@NotNull WhichJobs whichJobs) {
        Intrinsics.checkNotNullParameter((Object)((Object)whichJobs), (String)"whichJobs");
        Iterable $this$forEach$iv = IppPrinter.getJobs$default(this, whichJobs, null, null, null, 14, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IppJob it = (IppJob)element$iv;
            boolean bl = false;
            IppJob.cancel$default(it, null, 1, null);
        }
    }

    @NotNull
    public final IppSubscription createPrinterSubscription(@Nullable Collection<String> notifyEvents, @Nullable Duration notifyLeaseDuration, @Nullable Duration notifyTimeInterval) {
        Object object = IppPrinter.ippRequest$ipp_client$default(this, IppOperation.CreatePrinterSubscriptions, null, null, null, 14, null);
        IppRequest $this$createPrinterSubscription_u24lambda_u2437 = object;
        boolean bl = false;
        this.checkNotifyEvents(notifyEvents);
        IppRequest.createSubscriptionAttributesGroup$default($this$createPrinterSubscription_u24lambda_u2437, notifyEvents, notifyLeaseDuration, notifyTimeInterval, null, 8, null);
        IppRequest request = object;
        Object $this$createPrinterSubscription_u24lambda_u2439 = object = new IppSubscription(this, this.exchange(request).getSubscriptionGroup(), false, 4, null);
        boolean bl2 = false;
        this.logger.info(() -> IppPrinter.createPrinterSubscription$lambda$39$lambda$38((IppSubscription)$this$createPrinterSubscription_u24lambda_u2439));
        return object;
    }

    public static /* synthetic */ IppSubscription createPrinterSubscription$default(IppPrinter ippPrinter, Collection collection, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            collection = CollectionsKt.listOf((Object)"all");
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            duration2 = null;
        }
        return ippPrinter.createPrinterSubscription(collection, duration, duration2);
    }

    @Nullable
    public final Unit checkNotifyEvents(@Nullable Collection<String> notifyEvents) {
        Unit unit;
        Collection<String> collection = notifyEvents;
        if (collection != null) {
            Collection<String> it = collection;
            boolean bl = false;
            if (!it.isEmpty() && !Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)it), (Object)"all")) {
                this.checkIfValueIsSupported("notify-events-supported", it);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppSubscription getSubscription(int id) {
        void $this$getSubscription_u24lambda_u2441;
        IppRequest ippRequest;
        IppRequest ippRequest2 = ippRequest = IppPrinter.ippRequest$ipp_client$default(this, IppOperation.GetSubscriptionAttributes, null, null, null, 14, null);
        IppPrinter ippPrinter = this;
        IppPrinter ippPrinter2 = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{id};
        $this$getSubscription_u24lambda_u2441.getOperationGroup().attribute("notify-subscription-id", IppTag.Integer, objectArray);
        Unit unit = Unit.INSTANCE;
        boolean bl2 = false;
        IppAttributesGroup ippAttributesGroup = ippPrinter.exchange(ippRequest).getSubscriptionGroup();
        IppPrinter ippPrinter3 = ippPrinter2;
        return new IppSubscription(ippPrinter3, ippAttributesGroup, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppSubscription> getSubscriptions(@Nullable Integer notifyJobId, @Nullable Boolean mySubscriptions, @Nullable Integer limit, @Nullable Collection<String> requestedAttributes) {
        Object object;
        int it;
        Object object2 = IppPrinter.ippRequest$ipp_client$default(this, IppOperation.GetSubscriptions, requestedAttributes, null, null, 12, null);
        IppRequest $this$getSubscriptions_u24lambda_u2446 = object2;
        boolean bl7 = false;
        IppAttributesGroup $this$getSubscriptions_u24lambda_u2446_u24lambda_u2445 = $this$getSubscriptions_u24lambda_u2446.getOperationGroup();
        boolean bl2 = false;
        Integer n = notifyJobId;
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl3 = false;
            object = new Object[]{it};
            $this$getSubscriptions_u24lambda_u2446_u24lambda_u2445.attribute("notify-job-id", IppTag.Integer, object);
        }
        Boolean bl4 = mySubscriptions;
        if (bl4 != null) {
            it = bl4.booleanValue() ? 1 : 0;
            boolean bl5 = false;
            object = new Object[]{it != 0};
            $this$getSubscriptions_u24lambda_u2446_u24lambda_u2445.attribute("my-subscriptions", IppTag.Boolean, object);
        }
        Integer n2 = limit;
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl6 = false;
            object = new Object[]{it};
            $this$getSubscriptions_u24lambda_u2446_u24lambda_u2445.attribute("limit", IppTag.Integer, object);
        }
        IppRequest request = object2;
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            object2 = this.exchange(request).getAttributesGroups$ipp_client(IppTag.Subscription);
            boolean $i$f$map = false;
            void bl7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                object = (IppAttributesGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl8 = false;
                collection.add(new IppSubscription(this, (IppAttributesGroup)it2, false));
            }
            object2 = (List)destination$iv$iv;
        }
        catch (IppExchangeException.ClientErrorNotFoundException notFoundException) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    public static /* synthetic */ List getSubscriptions$default(IppPrinter ippPrinter, Integer n, Boolean bl, Integer n2, Collection collection, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = null;
        }
        if ((n3 & 2) != 0) {
            bl = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        if ((n3 & 8) != 0) {
            collection = null;
        }
        return ippPrinter.getSubscriptions(n, bl, n2, collection);
    }

    @NotNull
    public final IppRequest ippRequest$ipp_client(@NotNull IppOperation operation, @Nullable Collection<String> requestedAttributes, @Nullable String userName, @Nullable URI printerUri) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return this.ippClient.ippRequest(operation, printerUri, requestedAttributes, userName);
    }

    public static /* synthetic */ IppRequest ippRequest$ipp_client$default(IppPrinter ippPrinter, IppOperation ippOperation, Collection collection, String string, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            collection = null;
        }
        if ((n & 4) != 0) {
            string = ippPrinter.getIppConfig().getUserName();
        }
        if ((n & 8) != 0) {
            uRI = ippPrinter.printerUri;
        }
        return ippPrinter.ippRequest$ipp_client(ippOperation, collection, string, uRI);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IppResponse exchange(@NotNull IppRequest request) {
        void $this$exchange_u24lambda_u2448;
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        IppRequest ippRequest2 = ippRequest = request;
        IppClient ippClient = this.ippClient;
        boolean bl = false;
        String string = $this$exchange_u24lambda_u2448.getVersion();
        Intrinsics.checkNotNull((Object)string);
        this.checkIfValueIsSupported("ipp-versions-supported", string);
        Integer n = $this$exchange_u24lambda_u2448.getCode();
        Intrinsics.checkNotNull((Object)n);
        this.checkIfValueIsSupported("operations-supported", (int)n);
        this.checkIfValueIsSupported("charset-supported", $this$exchange_u24lambda_u2448.getAttributesCharset());
        return ippClient.exchange(ippRequest);
    }

    private final IppJob exchangeForIppJob(IppRequest request) {
        IppJob ippJob;
        IppJob $this$exchangeForIppJob_u24lambda_u2449 = ippJob = new IppJob(this, this.exchange(request));
        boolean bl = false;
        if (request.containsGroup(IppTag.Subscription) && $this$exchangeForIppJob_u24lambda_u2449.getSubscription() == null) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            request.log(logger, level, "REQUEST: ");
            List events = (List)request.getSubscriptionGroup().getValues("notify-events");
            throw new IppException("printer/server did not create subscription for events: " + CollectionsKt.joinToString$default((Iterable)events, (CharSequence)",", null, null, (int)0, null, null, (int)62, null), null, 2, null);
        }
        return ippJob;
    }

    private final void checkIfValueIsSupported(String supportedAttributeName, Object value) {
        IppValueSupport.INSTANCE.checkIfValueIsSupported(this.attributes, supportedAttributeName, value);
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u2451 = new StringBuilder("Printer");
        boolean bl = false;
        if (this.attributes.containsKey((Object)"printer-name")) {
            $this$toString_u24lambda_u2451.append(" " + this.getName());
        }
        if (this.attributes.containsKey((Object)"printer-make-and-model")) {
            $this$toString_u24lambda_u2451.append(" (" + this.getMakeAndModel() + ")");
        }
        $this$toString_u24lambda_u2451.append(", state=" + this.getState() + ", stateReasons=" + this.getStateReasons());
        IppString ippString = this.getStateMessage();
        if (ippString != null) {
            IppString it = ippString;
            boolean bl2 = false;
            if (((CharSequence)it.getText()).length() > 0) {
                $this$toString_u24lambda_u2451.append(", stateMessage=" + this.getStateMessage());
            }
        }
        if (this.attributes.containsKey((Object)"printer-is-accepting-jobs")) {
            $this$toString_u24lambda_u2451.append(", isAcceptingJobs=" + this.isAcceptingJobs());
        }
        if (this.attributes.containsKey((Object)"printer-location")) {
            $this$toString_u24lambda_u2451.append(", location=" + this.getLocation());
        }
        if (this.attributes.containsKey((Object)"printer-info")) {
            $this$toString_u24lambda_u2451.append(", info=" + this.getInfo());
        }
        String string = $this$toString_u24lambda_u2451.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"Printer\")\u2026\n        toString()\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, null, "PRINTER " + this.getName() + " (" + this.getMakeAndModel() + ")", 4, null);
    }

    public static /* synthetic */ void log$default(IppPrinter ippPrinter, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippPrinter.log(logger, level);
    }

    public final void savePrinterAttributes(@NotNull String directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        CharSequence charSequence = this.getMakeAndModel().getText();
        Regex regex = new Regex("\\s+");
        String string = "_";
        String printerModel = regex.replace(charSequence, string);
        IppResponse $this$savePrinterAttributes_u24lambda_u2452 = this.exchange(IppPrinter.ippRequest$ipp_client$default(this, IppOperation.GetPrinterAttributes, null, null, null, 14, null));
        boolean bl = false;
        $this$savePrinterAttributes_u24lambda_u2452.saveBytes(new File(directory, printerModel + ".bin"));
        $this$savePrinterAttributes_u24lambda_u2452.getPrinterGroup().saveText(new File(directory, printerModel + ".txt"));
    }

    public static /* synthetic */ void savePrinterAttributes$default(IppPrinter ippPrinter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = ".";
        }
        ippPrinter.savePrinterAttributes(string);
    }

    @NotNull
    public final File printerDirectory(@NotNull String printerName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.createDirectoryIfNotExists$ipp_client(new File(this.workDirectory, printerName));
    }

    public static /* synthetic */ File printerDirectory$default(IppPrinter ippPrinter, String string, int n, Object object) {
        if ((n & 1) != 0) {
            CharSequence charSequence = ippPrinter.getName().getText();
            Regex regex = new Regex("\\s+");
            String string2 = "_";
            string = regex.replace(charSequence, string2);
        }
        return ippPrinter.printerDirectory(string);
    }

    @NotNull
    public final File createDirectoryIfNotExists$ipp_client(@NotNull File $this$createDirectoryIfNotExists) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$createDirectoryIfNotExists, (String)"<this>");
        File $this$createDirectoryIfNotExists_u24lambda_u2453 = file = $this$createDirectoryIfNotExists;
        boolean bl = false;
        if (!$this$createDirectoryIfNotExists_u24lambda_u2453.mkdirs() && !$this$createDirectoryIfNotExists_u24lambda_u2453.isDirectory()) {
            throw new IOException("Failed to create directory: " + $this$createDirectoryIfNotExists_u24lambda_u2453.getPath());
        }
        return file;
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, @NotNull Collection<? extends IppAttributeBuilder> attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter(attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, inputStream, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull InputStream inputStream, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, inputStream, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull byte[] byteArray, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, byteArray, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final IppJob printJob(@NotNull File file, IppAttributeBuilder ... attributeBuilders) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)attributeBuilders, (String)"attributeBuilders");
        return IppPrinter.printJob$default(this, file, attributeBuilders, null, 4, null);
    }

    @JvmOverloads
    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs, @Nullable Boolean myJobs, @Nullable Integer limit) {
        return IppPrinter.getJobs$default(this, whichJobs, myJobs, limit, null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs, @Nullable Boolean myJobs) {
        return IppPrinter.getJobs$default(this, whichJobs, myJobs, null, null, 12, null);
    }

    @JvmOverloads
    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs) {
        return IppPrinter.getJobs$default(this, whichJobs, null, null, null, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final Collection<IppJob> getJobs() {
        return IppPrinter.getJobs$default(this, null, null, null, null, 15, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppPrinter.log$default(this, logger, null, 2, null);
    }

    private static final String _init_$lambda$0(IppPrinter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "create IppPrinter for " + this$0.printerUri;
    }

    private static final String _init_$lambda$2() {
        return "getPrinterAttributesOnInit disabled => no printer attributes available";
    }

    private static final String _init_$lambda$3(IppPrinter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.toString();
    }

    private static final String lambda$5$lambda$4(List $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "alert: " + $it;
    }

    private static final String lambda$7$lambda$6(List $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "alert-description: " + $it;
    }

    private static final String _init_$lambda$8(IppExchangeException $ippExchangeException) {
        Intrinsics.checkNotNullParameter((Object)$ippExchangeException, (String)"$ippExchangeException");
        return $ippExchangeException.getMessage();
    }

    private static final String _init_$lambda$9() {
        return "Failed to get printer attributes on init. Workaround: getPrinterAttributesOnInit=false";
    }

    private static final String lambda$12$lambda$10(IppResponse $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return $it.getPrinterGroup().size() + " attributes parsed";
    }

    private static final String lambda$12$lambda$11(IppResponse $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "RESPONSE: " + $it;
    }

    private static final String savePPD$lambda$22$lambda$21(File $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "Saved PPD: " + $it;
    }

    private static final String attributeBuildersRequest$lambda$27$lambda$26(IppTag $groupTag, IppAttribute $attribute) {
        Intrinsics.checkNotNullParameter((Object)((Object)$groupTag), (String)"$groupTag");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return $groupTag + " put " + $attribute;
    }

    private static final String getJobs$lambda$29(WhichJobs $whichJobs, List $requestedAttributes) {
        return "getJobs(whichJobs=" + $whichJobs + ", requestedAttributes=" + $requestedAttributes + ")";
    }

    private static final String createPrinterSubscription$lambda$39$lambda$38(IppSubscription $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Created " + $this_apply;
    }

    static {
        Object[] objectArray = new String[]{"printer-name", "printer-make-and-model", "printer-info", "printer-location", "printer-is-accepting-jobs", "printer-state", "printer-state-reasons", "printer-state-message", "document-format-supported", "operations-supported", "color-supported", "sides-supported", "media-supported", "media-ready", "media-default", "media-source-supported", "ipp-versions-supported"};
        printerClassAttributes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lde/gmuth/ipp/client/IppPrinter$Companion;", "", "()V", "printerClassAttributes", "", "", "getPrinterClassAttributes", "()Ljava/util/List;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getPrinterClassAttributes() {
            return printerClassAttributes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

