/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.attributes.JobState;
import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.client.IppExchange;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppException;
import de.gmuth.ipp.core.IppMessage;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0090\u00012\u00020\u0001:\u0002\u0090\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010N\u001a\u00020\u00052\n\b\u0002\u0010O\u001a\u0004\u0018\u00010\u000bH\u0007J\u001a\u0010P\u001a\u00020?2\u0010\b\u0002\u0010Q\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;H\u0007J\u0012\u0010R\u001a\u00020S2\b\b\u0002\u0010T\u001a\u00020\u0015H\u0007J$\u0010U\u001a\b\u0012\u0004\u0012\u00020S0;2\b\b\u0002\u0010V\u001a\u00020W2\n\b\u0002\u0010X\u001a\u0004\u0018\u00010\u000bH\u0007J\u000e\u0010Y\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020\u0003J\u000e\u0010Y\u001a\u00020\u00052\u0006\u00102\u001a\u000203J,\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020W2\b\u0010`\u001a\u0004\u0018\u00010\u000b2\b\u0010a\u001a\u0004\u0018\u00010\u000bH\u0002J\u0011\u0010b\u001a\u00020\u00052\u0006\u0010c\u001a\u00020\\H\u0096\u0001J\u001f\u0010d\u001a\u00020\b2\u0012\u0010e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0f\"\u00020\u000b\u00a2\u0006\u0002\u0010gJ\u0018\u0010d\u001a\u00020\b2\u0010\b\u0002\u0010h\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;J\b\u0010i\u001a\u0004\u0018\u00010\u000bJ\b\u0010j\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010k\u001a\u00020\u0005J\"\u0010l\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0010\b\u0002\u0010h\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;H\u0002J\u0010\u0010m\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u0010\u0010o\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u0010\u0010p\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u0006\u0010q\u001a\u00020WJ\u0010\u0010r\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u0010\u0010s\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u0010\u0010t\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u0006\u0010u\u001a\u00020WJ\u0010\u0010v\u001a\u00020W2\b\b\u0002\u0010n\u001a\u00020WJ\u001a\u0010w\u001a\u00020x2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010y\u001a\u00020zH\u0007J\u0006\u0010{\u001a\u00020|J\u0006\u0010}\u001a\u00020\u0005J\u0006\u0010~\u001a\u00020WJ\u0006\u0010\u007f\u001a\u00020\u0005J4\u0010\u0080\u0001\u001a\u00020x2\u0007\u0010\u0081\u0001\u001a\u00020|2\b\b\u0002\u0010_\u001a\u00020W2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u000bH\u0007J5\u0010\u0080\u0001\u001a\u00020x2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\b\b\u0002\u0010_\u001a\u00020W2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u000bH\u0007J4\u0010\u0084\u0001\u001a\u00020x2\u0007\u0010\u0085\u0001\u001a\u0002032\b\b\u0002\u0010_\u001a\u00020W2\n\b\u0002\u0010`\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010a\u001a\u0004\u0018\u00010\u000bH\u0007J\u001a\u0010\u0086\u0001\u001a\u00020W2\u0006\u0010n\u001a\u00020W2\u0007\u0010\u0087\u0001\u001a\u000207H\u0002J\u0010\u0010\u0088\u0001\u001a\u00020W2\u0007\u0010\u0089\u0001\u001a\u00020\u000bJ\t\u0010\u008a\u0001\u001a\u00020\u000bH\u0016J!\u0010\u008b\u0001\u001a\u00020x2\u0012\u0010h\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0f\"\u00020\u000b\u00a2\u0006\u0003\u0010\u008c\u0001J\u0019\u0010\u008b\u0001\u001a\u00020x2\u0010\b\u0002\u0010h\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010;J\u0015\u0010\u008d\u0001\u001a\u00020x2\n\b\u0002\u0010\u008e\u0001\u001a\u00030\u008f\u0001H\u0007R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0017R\u0011\u0010!\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0013R\u0011\u0010#\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0017R\u0011\u0010%\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0017R\u0011\u0010'\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0013R\u0011\u0010)\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0013R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0017\u0010:\u001a\b\u0012\u0004\u0012\u00020\u000b0;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u001c\u0010>\u001a\u0004\u0018\u00010?X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0011\u0010H\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bI\u0010GR\u0011\u0010J\u001a\u00020E8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010GR\u0011\u0010L\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bM\u00105\u00a8\u0006\u0091\u0001"}, d2={"Lde/gmuth/ipp/client/IppJob;", "Lde/gmuth/ipp/client/IppExchange;", "printer", "Lde/gmuth/ipp/client/IppPrinter;", "response", "Lde/gmuth/ipp/core/IppResponse;", "(Lde/gmuth/ipp/client/IppPrinter;Lde/gmuth/ipp/core/IppResponse;)V", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "(Lde/gmuth/ipp/client/IppPrinter;Lde/gmuth/ipp/core/IppAttributesGroup;)V", "appleJobOwner", "", "getAppleJobOwner", "()Ljava/lang/String;", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "documentNameSupplied", "Lde/gmuth/ipp/core/IppString;", "getDocumentNameSupplied", "()Lde/gmuth/ipp/core/IppString;", "id", "", "getId", "()I", "impressionsCompleted", "getImpressionsCompleted", "kOctets", "getKOctets", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "mediaSheetsCompleted", "getMediaSheetsCompleted", "name", "getName", "numberOfDocuments", "getNumberOfDocuments", "numberOfDocumentsOrDocumentCount", "getNumberOfDocumentsOrDocumentCount", "originatingHostName", "getOriginatingHostName", "originatingUserName", "getOriginatingUserName", "pageRanges", "", "Lkotlin/ranges/IntRange;", "getPageRanges", "()Ljava/util/Collection;", "getPrinter", "()Lde/gmuth/ipp/client/IppPrinter;", "printerUri", "Ljava/net/URI;", "getPrinterUri", "()Ljava/net/URI;", "state", "Lde/gmuth/ipp/attributes/JobState;", "getState", "()Lde/gmuth/ipp/attributes/JobState;", "stateReasons", "", "getStateReasons", "()Ljava/util/List;", "subscription", "Lde/gmuth/ipp/client/IppSubscription;", "getSubscription", "()Lde/gmuth/ipp/client/IppSubscription;", "setSubscription", "(Lde/gmuth/ipp/client/IppSubscription;)V", "timeAtCompleted", "Ljava/time/ZonedDateTime;", "getTimeAtCompleted", "()Ljava/time/ZonedDateTime;", "timeAtCreation", "getTimeAtCreation", "timeAtProcessing", "getTimeAtProcessing", "uri", "getUri", "cancel", "messageForOperator", "createJobSubscription", "notifyEvents", "cupsGetDocument", "Lde/gmuth/ipp/client/IppDocument;", "documentNumber", "cupsGetDocuments", "save", "", "optionalCommandToHandleFile", "cupsMoveJob", "ippPrinter", "documentRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "Lde/gmuth/ipp/core/IppOperation;", "lastDocument", "documentName", "documentNaturalLanguage", "exchange", "request", "getJobAttributes", "requestedAttribute", "", "([Ljava/lang/String;)Lde/gmuth/ipp/core/IppAttributesGroup;", "requestedAttributes", "getJobNameOrDocumentNameSuppliedOrAppleJobNameOrNull", "getOriginatingUserNameOrAppleJobOwnerOrNull", "hold", "ippRequest", "isAborted", "updateStateAttributes", "isCanceled", "isCompleted", "isIncoming", "isPending", "isProcessing", "isProcessingStopped", "isProcessingToStopPoint", "isTerminated", "log", "", "level", "Ljava/util/logging/Level;", "printerDirectory", "Ljava/io/File;", "release", "resourcesAreNotReady", "restart", "sendDocument", "file", "inputStream", "Ljava/io/InputStream;", "sendUri", "documentUri", "stateIs", "expectedState", "stateReasonsContain", "reason", "toString", "updateAttributes", "([Ljava/lang/String;)V", "waitForTermination", "delay", "Ljava/time/Duration;", "Companion", "ipp-client"})
public final class IppJob
implements IppExchange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppPrinter printer;
    @NotNull
    private final IppAttributesGroup attributes;
    private final Logger logger;
    @Nullable
    private IppSubscription subscription;
    @NotNull
    private static Duration defaultDelay;
    private static boolean useJobOwnerAsUserName;
    private static boolean useJobUri;

    public IppJob(@NotNull IppPrinter printer, @NotNull IppAttributesGroup attributes) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        this.printer = printer;
        this.attributes = attributes;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @NotNull
    public final IppPrinter getPrinter() {
        return this.printer;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public IppResponse exchange(@NotNull IppRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return this.printer.exchange(request);
    }

    @Nullable
    public final IppSubscription getSubscription() {
        return this.subscription;
    }

    public final void setSubscription(@Nullable IppSubscription ippSubscription) {
        this.subscription = ippSubscription;
    }

    public IppJob(@NotNull IppPrinter printer, @NotNull IppResponse response) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this(printer, response.getJobGroup());
        if (response.getStatus() != IppStatus.SuccessfulOk) {
            this.logger.warning(() -> IppJob._init_$lambda$0(response));
        }
        if (response.containsGroup(IppTag.Subscription)) {
            this.subscription = new IppSubscription(printer, response.getSubscriptionGroup(), false, 4, null);
        }
    }

    public final int getId() {
        return ((Number)this.attributes.getValue("job-id")).intValue();
    }

    @NotNull
    public final URI getUri() {
        return (URI)this.attributes.getValue("job-uri");
    }

    @NotNull
    public final URI getPrinterUri() {
        return (URI)this.attributes.getValue("job-printer-uri");
    }

    @NotNull
    public final JobState getState() {
        return JobState.Companion.fromAttributes(this.attributes);
    }

    @NotNull
    public final List<String> getStateReasons() {
        return (List)this.attributes.getValues("job-state-reasons");
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("job-name");
    }

    @NotNull
    public final IppString getOriginatingUserName() {
        return (IppString)this.attributes.getValue("job-originating-user-name");
    }

    @NotNull
    public final IppString getOriginatingHostName() {
        return (IppString)this.attributes.getValue("job-originating-host-name");
    }

    public final int getImpressionsCompleted() {
        return ((Number)this.attributes.getValue("job-impressions-completed")).intValue();
    }

    public final int getMediaSheetsCompleted() {
        return ((Number)this.attributes.getValue("job-media-sheets-completed")).intValue();
    }

    public final int getKOctets() {
        return ((Number)this.attributes.getValue("job-k-octets")).intValue();
    }

    @NotNull
    public final Collection<IntRange> getPageRanges() {
        return (Collection)this.attributes.getValues("page-ranges");
    }

    public final int getNumberOfDocuments() {
        return ((Number)this.attributes.getValue("number-of-documents")).intValue();
    }

    @NotNull
    public final IppString getDocumentNameSupplied() {
        return (IppString)this.attributes.getValue("document-name-supplied");
    }

    @NotNull
    public final ZonedDateTime getTimeAtCreation() {
        return IppAttributesGroup.getZonedDateTimeValue$default(this.attributes, "time-at-creation", null, 2, null);
    }

    @NotNull
    public final ZonedDateTime getTimeAtProcessing() {
        return IppAttributesGroup.getZonedDateTimeValue$default(this.attributes, "time-at-processing", null, 2, null);
    }

    @NotNull
    public final ZonedDateTime getTimeAtCompleted() {
        return IppAttributesGroup.getZonedDateTimeValue$default(this.attributes, "time-at-completed", null, 2, null);
    }

    @NotNull
    public final String getAppleJobOwner() {
        return this.attributes.getTextValue("com.apple.print.JobInfo.PMJobOwner");
    }

    public final boolean isPending(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Pending);
    }

    public static /* synthetic */ boolean isPending$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isPending(bl);
    }

    public final boolean isAborted(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Aborted);
    }

    public static /* synthetic */ boolean isAborted$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isAborted(bl);
    }

    public final boolean isCanceled(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Canceled);
    }

    public static /* synthetic */ boolean isCanceled$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isCanceled(bl);
    }

    public final boolean isCompleted(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Completed);
    }

    public static /* synthetic */ boolean isCompleted$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isCompleted(bl);
    }

    public final boolean isProcessing(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Processing);
    }

    public static /* synthetic */ boolean isProcessing$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isProcessing(bl);
    }

    public final boolean isProcessingStopped(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.ProcessingStopped);
    }

    public static /* synthetic */ boolean isProcessingStopped$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isProcessingStopped(bl);
    }

    public final boolean isTerminated(boolean updateStateAttributes) {
        return this.stateIs(updateStateAttributes, JobState.Canceled) || this.stateIs(false, JobState.Aborted) || this.stateIs(false, JobState.Completed);
    }

    public static /* synthetic */ boolean isTerminated$default(IppJob ippJob, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ippJob.isTerminated(bl);
    }

    private final boolean stateIs(boolean updateStateAttributes, JobState expectedState) {
        if (updateStateAttributes) {
            String[] stringArray = new String[]{"job-state", "job-state-reasons"};
            this.updateAttributes(stringArray);
        }
        return this.getState() == expectedState;
    }

    public final boolean stateReasonsContain(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        return this.getStateReasons().contains(reason);
    }

    public final boolean isProcessingToStopPoint() {
        return this.stateReasonsContain("processing-to-stop-point");
    }

    public final boolean resourcesAreNotReady() {
        return this.stateReasonsContain("resources-are-not-ready");
    }

    public final boolean isIncoming() {
        return this.stateReasonsContain("job-incoming");
    }

    @Nullable
    public final String getOriginatingUserNameOrAppleJobOwnerOrNull() {
        return this.attributes.containsKey((Object)"job-originating-user-name") ? this.getOriginatingUserName().getText() : (this.attributes.containsKey((Object)"com.apple.print.JobInfo.PMJobOwner") ? this.getAppleJobOwner() : null);
    }

    @Nullable
    public final String getJobNameOrDocumentNameSuppliedOrAppleJobNameOrNull() {
        return this.attributes.containsKey((Object)"job-name") ? this.getName().getText() : (this.attributes.containsKey((Object)"document-name-supplied") ? this.getDocumentNameSupplied().getText() : (this.attributes.containsKey((Object)"com.apple.print.JobInfo.PMJobName") ? this.attributes.getTextValue("com.apple.print.JobInfo.PMJobName") : null));
    }

    public final int getNumberOfDocumentsOrDocumentCount() {
        int n;
        if (this.attributes.containsKey((Object)"number-of-documents")) {
            n = this.getNumberOfDocuments();
        } else if (this.attributes.containsKey((Object)"document-count")) {
            n = ((Number)this.attributes.getValue("document-count")).intValue();
        } else {
            throw new IppException("number-of-documents or document-count not found", null, 2, null);
        }
        return n;
    }

    @NotNull
    public final IppAttributesGroup getJobAttributes(@Nullable List<String> requestedAttributes) {
        return this.exchange(this.ippRequest(IppOperation.GetJobAttributes, requestedAttributes)).getJobGroup();
    }

    public static /* synthetic */ IppAttributesGroup getJobAttributes$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return ippJob.getJobAttributes(list);
    }

    @NotNull
    public final IppAttributesGroup getJobAttributes(String ... requestedAttribute) {
        Intrinsics.checkNotNullParameter((Object)requestedAttribute, (String)"requestedAttribute");
        return this.getJobAttributes(ArraysKt.toList((Object[])requestedAttribute));
    }

    public final void updateAttributes(@Nullable List<String> requestedAttributes) {
        this.attributes.put(this.getJobAttributes(requestedAttributes));
    }

    public static /* synthetic */ void updateAttributes$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        ippJob.updateAttributes(list);
    }

    public final void updateAttributes(String ... requestedAttributes) {
        Intrinsics.checkNotNullParameter((Object)requestedAttributes, (String)"requestedAttributes");
        this.updateAttributes(ArraysKt.toList((Object[])requestedAttributes));
    }

    @JvmOverloads
    public final void waitForTermination(@NotNull Duration delay) {
        Intrinsics.checkNotNullParameter((Object)delay, (String)"delay");
        this.logger.info(() -> IppJob.waitForTermination$lambda$1(this));
        Ref.ObjectRef lastPrinterString = new Ref.ObjectRef();
        lastPrinterString.element = "";
        Ref.ObjectRef lastJobString = new Ref.ObjectRef();
        lastJobString.element = this.toString();
        this.logger.info(() -> IppJob.waitForTermination$lambda$2(lastJobString));
        while (!IppJob.isTerminated$default(this, false, 1, null)) {
            Thread.sleep(delay.toMillis());
            IppJob.updateAttributes$default(this, null, 1, null);
            if (!Intrinsics.areEqual((Object)this.toString(), (Object)lastJobString.element)) {
                lastJobString.element = this.toString();
                this.logger.info(() -> IppJob.waitForTermination$lambda$3(lastJobString));
            }
            if (IppJob.isProcessingStopped$default(this, false, 1, null) || ((CharSequence)lastPrinterString.element).length() > 0) {
                String[] stringArray = new String[]{"printer-state", "printer-state-reasons", "printer-state-message", "printer-is-accepting-jobs"};
                this.printer.updateAttributes(stringArray);
                if (!Intrinsics.areEqual((Object)this.printer.toString(), (Object)lastPrinterString.element)) {
                    lastPrinterString.element = this.printer.toString();
                    this.logger.info(() -> IppJob.waitForTermination$lambda$4(lastPrinterString));
                }
            }
            if (!IppJob.isProcessing$default(this, false, 1, null) || !(((CharSequence)lastPrinterString.element).length() > 0)) continue;
            lastPrinterString.element = "";
        }
        if (IppJob.isAborted$default(this, false, 1, null)) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            IppJob.log$default(this, logger, null, 2, null);
        }
    }

    public static /* synthetic */ void waitForTermination$default(IppJob ippJob, Duration duration, int n, Object object) {
        if ((n & 1) != 0) {
            duration = defaultDelay;
        }
        ippJob.waitForTermination(duration);
    }

    @NotNull
    public final IppResponse hold() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.HoldJob, null, 2, null));
    }

    @NotNull
    public final IppResponse release() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.ReleaseJob, null, 2, null));
    }

    @NotNull
    public final IppResponse restart() {
        return this.exchange(IppJob.ippRequest$default(this, IppOperation.RestartJob, null, 2, null));
    }

    @JvmOverloads
    @NotNull
    public final IppResponse cancel(@Nullable String messageForOperator) {
        IppRequest ippRequest;
        if (IppJob.isCanceled$default(this, false, 1, null)) {
            this.logger.warning(() -> IppJob.cancel$lambda$5(this));
        }
        if (this.isProcessingToStopPoint()) {
            this.logger.warning(() -> IppJob.cancel$lambda$6(this));
        }
        IppRequest $this$cancel_u24lambda_u248 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CancelJob, null, 2, null);
        boolean bl = false;
        String string = messageForOperator;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            Object[] objectArray = new Object[]{it};
            $this$cancel_u24lambda_u248.getOperationGroup().attribute("message", IppTag.TextWithoutLanguage, objectArray);
        }
        IppRequest request = ippRequest;
        this.logger.info(() -> IppJob.cancel$lambda$9(this));
        return this.exchange(request);
    }

    public static /* synthetic */ IppResponse cancel$default(IppJob ippJob, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return ippJob.cancel(string);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppRequest $this$sendDocument_u24lambda_u2410 = ippRequest = this.documentRequest(IppOperation.SendDocument, lastDocument, documentName, documentNaturalLanguage);
        boolean bl = false;
        $this$sendDocument_u24lambda_u2410.setDocumentInputStream(inputStream);
        IppRequest request = ippRequest;
        this.attributes.put(this.exchange(request).getJobGroup());
    }

    public static /* synthetic */ void sendDocument$default(IppJob ippJob, InputStream inputStream, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        ippJob.sendDocument(inputStream, bl, string, string2);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.sendDocument(new FileInputStream(file), lastDocument, documentName, documentNaturalLanguage);
    }

    public static /* synthetic */ void sendDocument$default(IppJob ippJob, File file, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        ippJob.sendDocument(file, bl, string, string2);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName, @Nullable String documentNaturalLanguage) {
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppRequest $this$sendUri_u24lambda_u2411 = ippRequest = this.documentRequest(IppOperation.SendURI, lastDocument, documentName, documentNaturalLanguage);
        boolean bl = false;
        Object[] objectArray = new Object[]{documentUri};
        $this$sendUri_u24lambda_u2411.getOperationGroup().attribute("document-uri", IppTag.Uri, objectArray);
        IppRequest request = ippRequest;
        this.attributes.put(this.exchange(request).getJobGroup());
    }

    public static /* synthetic */ void sendUri$default(IppJob ippJob, URI uRI, boolean bl, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        ippJob.sendUri(uRI, bl, string, string2);
    }

    private final IppRequest documentRequest(IppOperation operation, boolean lastDocument, String documentName, String documentNaturalLanguage) {
        IppRequest ippRequest;
        block1: {
            Object[] objectArray;
            String it;
            IppRequest $this$documentRequest_u24lambda_u2415 = ippRequest = IppJob.ippRequest$default(this, operation, null, 2, null);
            boolean bl = false;
            IppAttributesGroup $this$documentRequest_u24lambda_u2415_u24lambda_u2414 = $this$documentRequest_u24lambda_u2415.getOperationGroup();
            boolean bl2 = false;
            Object[] objectArray2 = new Object[]{lastDocument};
            $this$documentRequest_u24lambda_u2415_u24lambda_u2414.attribute("last-document", IppTag.Boolean, objectArray2);
            String string = documentName;
            if (string != null) {
                it = string;
                boolean bl3 = false;
                objectArray = new Object[]{it};
                $this$documentRequest_u24lambda_u2415_u24lambda_u2414.attribute("document-name", IppTag.NameWithoutLanguage, objectArray);
            }
            String string2 = documentNaturalLanguage;
            if (string2 == null) break block1;
            it = string2;
            boolean bl4 = false;
            objectArray = new Object[]{it};
            $this$documentRequest_u24lambda_u2415_u24lambda_u2414.attribute("document-natural-language", IppTag.NaturalLanguage, objectArray);
        }
        return ippRequest;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppResponse cupsMoveJob(@NotNull URI printerUri) {
        void $this$cupsMoveJob_u24lambda_u2417;
        IppRequest ippRequest;
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        IppRequest ippRequest2 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CupsMoveJob, null, 2, null);
        IppJob ippJob = this;
        boolean bl = false;
        if (!Intrinsics.areEqual((Object)this.getUri().getHost(), (Object)printerUri.getHost())) {
            boolean bl2 = false;
            String string = "Printer " + printerUri + " must be on the same server: " + this.getUri().getHost();
            throw new IllegalArgumentException(string.toString());
        }
        Object[] objectArray = new Object[]{printerUri};
        $this$cupsMoveJob_u24lambda_u2417.createAttributesGroup(IppTag.Job).attribute("job-printer-uri", IppTag.Uri, objectArray);
        return ippJob.exchange(ippRequest);
    }

    @NotNull
    public final IppResponse cupsMoveJob(@NotNull IppPrinter ippPrinter) {
        Intrinsics.checkNotNullParameter((Object)ippPrinter, (String)"ippPrinter");
        return this.cupsMoveJob(ippPrinter.getPrinterUri());
    }

    @JvmOverloads
    @NotNull
    public final IppSubscription createJobSubscription(@Nullable List<String> notifyEvents) {
        IppSubscription ippSubscription;
        IppRequest ippRequest;
        IppRequest $this$createJobSubscription_u24lambda_u2418 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CreateJobSubscriptions, null, 2, null);
        boolean bl = false;
        this.printer.checkNotifyEvents((Collection<String>)notifyEvents);
        IppRequest.createSubscriptionAttributesGroup$default($this$createJobSubscription_u24lambda_u2418, notifyEvents, null, null, this.getId(), 6, null);
        IppRequest request = ippRequest;
        IppAttributesGroup subscriptionAttributes = this.exchange(request).getSubscriptionGroup();
        IppSubscription $this$createJobSubscription_u24lambda_u2420 = ippSubscription = new IppSubscription(this.printer, subscriptionAttributes, false, 4, null);
        boolean bl2 = false;
        this.subscription = $this$createJobSubscription_u24lambda_u2420;
        if (notifyEvents != null && !$this$createJobSubscription_u24lambda_u2420.getEvents().containsAll((Collection)notifyEvents)) {
            this.logger.warning(() -> IppJob.createJobSubscription$lambda$20$lambda$19(notifyEvents, $this$createJobSubscription_u24lambda_u2420));
        }
        return ippSubscription;
    }

    public static /* synthetic */ IppSubscription createJobSubscription$default(IppJob ippJob, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return ippJob.createJobSubscription(list);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final IppDocument cupsGetDocument(int documentNumber) {
        void $this$cupsGetDocument_u24lambda_u2422;
        IppRequest ippRequest;
        this.logger.fine(() -> IppJob.cupsGetDocument$lambda$21(documentNumber, this));
        IppRequest ippRequest2 = ippRequest = IppJob.ippRequest$default(this, IppOperation.CupsGetDocument, null, 2, null);
        IppJob ippJob = this;
        boolean bl = false;
        Object[] objectArray = new Object[]{documentNumber};
        $this$cupsGetDocument_u24lambda_u2422.getOperationGroup().attribute("document-number", IppTag.Integer, objectArray);
        IppResponse response = ippJob.exchange(ippRequest);
        IppAttributesGroup ippAttributesGroup = response.getJobGroup();
        InputStream inputStream = response.getDocumentInputStream();
        Intrinsics.checkNotNull((Object)inputStream);
        return new IppDocument(this, ippAttributesGroup, inputStream);
    }

    public static /* synthetic */ IppDocument cupsGetDocument$default(IppJob ippJob, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return ippJob.cupsGetDocument(n);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments(boolean save, @Nullable String optionalCommandToHandleFile) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)new IntRange(1, this.getNumberOfDocumentsOrDocumentCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.cupsGetDocument((int)it));
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            String it;
            IppDocument document = (IppDocument)element$iv;
            boolean bl2 = false;
            if (!save) continue;
            IppDocument $this$cupsGetDocuments_u24lambda_u2426_u24lambda_u2425 = document;
            boolean bl3 = false;
            IppDocument.save$default($this$cupsGetDocuments_u24lambda_u2426_u24lambda_u2425, this.printerDirectory(), null, true, 2, null);
            if (optionalCommandToHandleFile == null) continue;
            boolean bl4 = false;
            $this$cupsGetDocuments_u24lambda_u2426_u24lambda_u2425.runCommand(it);
        }
        return (List)iterable;
    }

    public static /* synthetic */ List cupsGetDocuments$default(IppJob ippJob, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return ippJob.cupsGetDocuments(bl, string);
    }

    @NotNull
    public final File printerDirectory() {
        String string = this.getPrinterUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"printerUri.toString()");
        String string2 = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
        return this.printer.printerDirectory(StringsKt.substringAfterLast$default((String)string, (String)string2, null, (int)2, null));
    }

    private final IppRequest ippRequest(IppOperation operation, List<String> requestedAttributes) {
        Object object = this.printer;
        String string = useJobOwnerAsUserName && this.attributes.containsKey((Object)"job-originating-user-name") ? this.getOriginatingUserName().getText() : (useJobOwnerAsUserName && this.attributes.containsKey((Object)"com.apple.print.JobInfo.PMJobOwner") ? this.getAppleJobOwner() : this.printer.getIppConfig().getUserName());
        Object $this$ippRequest_u24lambda_u2428 = object = ((IppPrinter)object).ippRequest$ipp_client(operation, (Collection<String>)requestedAttributes, string, null);
        boolean bl = false;
        IppAttributesGroup $this$ippRequest_u24lambda_u2428_u24lambda_u2427 = ((IppMessage)$this$ippRequest_u24lambda_u2428).getOperationGroup();
        boolean bl2 = false;
        if (useJobUri) {
            Object[] objectArray = new Object[]{this.getUri()};
            $this$ippRequest_u24lambda_u2428_u24lambda_u2427.attribute("job-uri", IppTag.Uri, objectArray);
        } else {
            Object[] objectArray = new Object[]{this.printer.getPrinterUri()};
            $this$ippRequest_u24lambda_u2428_u24lambda_u2427.attribute("printer-uri", IppTag.Uri, objectArray);
            objectArray = new Object[]{this.getId()};
            $this$ippRequest_u24lambda_u2428_u24lambda_u2427.attribute("job-id", IppTag.Integer, objectArray);
        }
        return object;
    }

    static /* synthetic */ IppRequest ippRequest$default(IppJob ippJob, IppOperation ippOperation, List list, int n, Object object) {
        if ((n & 2) != 0) {
            list = null;
        }
        return ippJob.ippRequest(ippOperation, list);
    }

    @NotNull
    public String toString() {
        IppAttributesGroup $this$toString_u24lambda_u2430 = this.attributes;
        boolean bl = false;
        StringBuilder $this$toString_u24lambda_u2430_u24lambda_u2429 = new StringBuilder("Job #" + this.getId());
        boolean bl2 = false;
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-state")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", state=" + this.getState());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-state-reasons")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(" (reasons=" + CollectionsKt.joinToString$default((Iterable)this.getStateReasons(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ")");
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-name")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", name=" + this.getName());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-impressions-completed")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", impressions-completed=" + this.getImpressionsCompleted());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-originating-host-name")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", originating-host-name=" + this.getOriginatingHostName());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-originating-user-name")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", originating-user-name=" + this.getOriginatingUserName());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"com.apple.print.JobInfo.PMJobOwner")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", appleJobOwner=" + this.getAppleJobOwner());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"number-of-documents") || $this$toString_u24lambda_u2430.containsKey((Object)"document-count")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", " + this.getNumberOfDocumentsOrDocumentCount() + " documents");
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-printer-uri")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", printer-uri=" + this.getPrinterUri());
        }
        if ($this$toString_u24lambda_u2430.containsKey((Object)"job-uri")) {
            $this$toString_u24lambda_u2430_u24lambda_u2429.append(", uri=" + this.getUri());
        }
        String string = $this$toString_u24lambda_u2430_u24lambda_u2429.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attributes.run {\n       \u2026oString()\n        }\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, null, "JOB #" + this.getId(), 4, null);
    }

    public static /* synthetic */ void log$default(IppJob ippJob, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippJob.log(logger, level);
    }

    @JvmOverloads
    public final void waitForTermination() {
        IppJob.waitForTermination$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final IppResponse cancel() {
        return IppJob.cancel$default(this, null, 1, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, documentName, null, 8, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, lastDocument, null, null, 12, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        IppJob.sendDocument$default(this, inputStream, false, null, null, 14, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, lastDocument, documentName, null, 8, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, lastDocument, null, null, 12, null);
    }

    @JvmOverloads
    public final void sendDocument(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IppJob.sendDocument$default(this, file, false, null, null, 14, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument, @Nullable String documentName) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, documentName, null, 8, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri, boolean lastDocument) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, lastDocument, null, null, 12, null);
    }

    @JvmOverloads
    public final void sendUri(@NotNull URI documentUri) {
        Intrinsics.checkNotNullParameter((Object)documentUri, (String)"documentUri");
        IppJob.sendUri$default(this, documentUri, false, null, null, 14, null);
    }

    @JvmOverloads
    @NotNull
    public final IppSubscription createJobSubscription() {
        return IppJob.createJobSubscription$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final IppDocument cupsGetDocument() {
        return IppJob.cupsGetDocument$default(this, 0, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments(boolean save) {
        return IppJob.cupsGetDocuments$default(this, save, null, 2, null);
    }

    @JvmOverloads
    @NotNull
    public final List<IppDocument> cupsGetDocuments() {
        return IppJob.cupsGetDocuments$default(this, false, null, 3, null);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppJob.log$default(this, logger, null, 2, null);
    }

    private static final String _init_$lambda$0(IppResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        return "Job response status: " + $response.getStatus();
    }

    private static final String waitForTermination$lambda$1(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Wait for termination of job #" + this$0.getId();
    }

    private static final String waitForTermination$lambda$2(Ref.ObjectRef $lastJobString) {
        Intrinsics.checkNotNullParameter((Object)$lastJobString, (String)"$lastJobString");
        return (String)$lastJobString.element;
    }

    private static final String waitForTermination$lambda$3(Ref.ObjectRef $lastJobString) {
        Intrinsics.checkNotNullParameter((Object)$lastJobString, (String)"$lastJobString");
        return (String)$lastJobString.element;
    }

    private static final String waitForTermination$lambda$4(Ref.ObjectRef $lastPrinterString) {
        Intrinsics.checkNotNullParameter((Object)$lastPrinterString, (String)"$lastPrinterString");
        return (String)$lastPrinterString.element;
    }

    private static final String cancel$lambda$5(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Job #" + this$0.getId() + " is already 'canceled'";
    }

    private static final String cancel$lambda$6(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Job #" + this$0.getId() + " is already 'processing-to-stop-point'";
    }

    private static final String cancel$lambda$9(IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Cancel " + this$0;
    }

    private static final String createJobSubscription$lambda$20$lambda$19(List $notifyEvents, IppSubscription $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "Server ignored some notifyEvents " + $notifyEvents + ", subscribed events: " + $this_apply.getEvents();
    }

    private static final String cupsGetDocument$lambda$21(int $documentNumber, IppJob this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "CupsGetDocument #" + $documentNumber + " for job #" + this$0.getId();
    }

    static {
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(1)");
        defaultDelay = duration;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lde/gmuth/ipp/client/IppJob$Companion;", "", "()V", "defaultDelay", "Ljava/time/Duration;", "getDefaultDelay", "()Ljava/time/Duration;", "setDefaultDelay", "(Ljava/time/Duration;)V", "useJobOwnerAsUserName", "", "getUseJobOwnerAsUserName", "()Z", "setUseJobOwnerAsUserName", "(Z)V", "useJobUri", "getUseJobUri", "setUseJobUri", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getDefaultDelay() {
            return defaultDelay;
        }

        public final void setDefaultDelay(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
            defaultDelay = duration;
        }

        public final boolean getUseJobOwnerAsUserName() {
            return useJobOwnerAsUserName;
        }

        public final void setUseJobOwnerAsUserName(boolean bl) {
            useJobOwnerAsUserName = bl;
        }

        public final boolean getUseJobUri() {
            return useJobUri;
        }

        public final void setUseJobUri(boolean bl) {
            useJobUri = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

