/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.attributes.ColorMode;
import de.gmuth.ipp.attributes.CommunicationChannel;
import de.gmuth.ipp.attributes.DocumentFormat;
import de.gmuth.ipp.attributes.Media;
import de.gmuth.ipp.attributes.PrintQuality;
import de.gmuth.ipp.attributes.Sides;
import de.gmuth.ipp.attributes.TemplateAttributes;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.core.IppAttributeBuilder;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppResponse;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0014\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lde/gmuth/ipp/client/IppInspector;", "", "()V", "directory", "", "getDirectory", "()Ljava/lang/String;", "setDirectory", "(Ljava/lang/String;)V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "pdfA4", "inspect", "", "printerUri", "Ljava/net/URI;", "cancelJob", "", "Lde/gmuth/ipp/client/IppPrinter;", "runInspectionWorkflow", "pdfResource", "ipp-client"})
public final class IppInspector {
    @NotNull
    public static final IppInspector INSTANCE = new IppInspector();
    private static final Logger logger = Logger.getLogger(INSTANCE.getClass().getName());
    @NotNull
    private static String directory = "inspected-printers";
    @NotNull
    public static final String pdfA4 = "blank_A4.pdf";

    private IppInspector() {
    }

    @NotNull
    public final String getDirectory() {
        return directory;
    }

    public final void setDirectory(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        directory = string;
    }

    public final void inspect(@NotNull URI printerUri, boolean cancelJob) {
        Intrinsics.checkNotNullParameter((Object)printerUri, (String)"printerUri");
        this.inspect(new IppPrinter(printerUri, null, null, null, false, null, 62, null), cancelJob);
    }

    public static /* synthetic */ void inspect$default(IppInspector ippInspector, URI uRI, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ippInspector.inspect(uRI, bl);
    }

    private final void inspect(IppPrinter $this$inspect, boolean cancelJob) {
        String string;
        logger.info(() -> IppInspector.inspect$lambda$0($this$inspect));
        StringBuilder $this$inspect_u24lambda_u241 = new StringBuilder();
        boolean bl = false;
        if ($this$inspect.isCups()) {
            $this$inspect_u24lambda_u241.append("CUPS-");
        }
        CharSequence charSequence = $this$inspect.getMakeAndModel().getText();
        Regex regex = new Regex("\\s+");
        String string2 = "_";
        $this$inspect_u24lambda_u241.append(regex.replace(charSequence, string2));
        String string3 = $this$inspect_u24lambda_u241.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"with(StringBuilder()) {\n\u2026     toString()\n        }");
        String printerModel = string3;
        logger.info(() -> IppInspector.inspect$lambda$2(printerModel));
        $this$inspect.getIppClient$ipp_client().setSaveMessages(true);
        $this$inspect.getIppClient$ipp_client().setSaveMessagesDirectory($this$inspect.createDirectoryIfNotExists$ipp_client(new File(directory, printerModel)));
        $this$inspect.setWorkDirectory($this$inspect.getIppClient$ipp_client().getSaveMessagesDirectory());
        IppAttributesGroup $this$inspect_u24lambda_u2410 = $this$inspect.getAttributes();
        boolean bl2 = false;
        if ($this$inspect_u24lambda_u2410.containsKey((Object)"media-supported")) {
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$3($this$inspect));
        }
        if ($this$inspect_u24lambda_u2410.containsKey((Object)"media-ready")) {
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$4($this$inspect));
        }
        if ($this$inspect_u24lambda_u2410.containsKey((Object)"media-default")) {
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$5($this$inspect));
        }
        logger.info(IppInspector::inspect$lambda$10$lambda$6);
        Iterable $this$forEach$iv = $this$inspect.getCommunicationChannelsSupported();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommunicationChannel it = (CommunicationChannel)element$iv;
            boolean bl3 = false;
            logger.info(() -> IppInspector.inspect$lambda$10$lambda$8$lambda$7(it));
        }
        logger.info(() -> IppInspector.inspect$lambda$10$lambda$9($this$inspect));
        if (!$this$inspect.getAttributes().containsKey((Object)"media-ready")) {
            logger.warning(IppInspector::inspect$lambda$11);
            string = pdfA4;
        } else if ($this$inspect.getMediaReady().contains("iso-a4") || $this$inspect.getMediaReady().contains("iso_a4_210x297mm")) {
            string = pdfA4;
        } else if ($this$inspect.getMediaReady().contains("na_letter") || $this$inspect.getMediaReady().contains("na_letter_8.5x11in")) {
            string = "blank_USLetter.pdf";
        } else {
            logger.warning(() -> IppInspector.inspect$lambda$12($this$inspect));
            string = pdfA4;
        }
        String pdfResource = string;
        $this$inspect.getIppConfig().setUserName("ipp-inspector");
        this.runInspectionWorkflow($this$inspect, pdfResource, cancelJob);
    }

    private final void runInspectionWorkflow(IppPrinter $this$runInspectionWorkflow, String pdfResource, boolean cancelJob) {
        Object object;
        logger.info(IppInspector::runInspectionWorkflow$lambda$13);
        IppPrinter.getPrinterAttributes$default($this$runInspectionWorkflow, null, 1, null);
        IppOperation[] ippOperationArray = new IppOperation[]{IppOperation.CupsGetPPD};
        if ($this$runInspectionWorkflow.supportsOperations(ippOperationArray)) {
            logger.info(IppInspector::runInspectionWorkflow$lambda$14);
            IppPrinter.savePPD$default($this$runInspectionWorkflow, null, null, new File($this$runInspectionWorkflow.getWorkDirectory(), "0-" + $this$runInspectionWorkflow.getName().getText() + ".ppd"), 3, null);
        }
        ippOperationArray = new IppOperation[]{IppOperation.IdentifyPrinter};
        if ($this$runInspectionWorkflow.supportsOperations(ippOperationArray)) {
            List<String> $this$runInspectionWorkflow_u24lambda_u2415 = $this$runInspectionWorkflow.getIdentifyActionsSupported();
            boolean bl = false;
            String action = $this$runInspectionWorkflow_u24lambda_u2415.contains("sound") ? "sound" : (String)CollectionsKt.first($this$runInspectionWorkflow_u24lambda_u2415);
            logger.info(() -> IppInspector.runInspectionWorkflow$lambda$16(action));
            object = new String[]{action};
            $this$runInspectionWorkflow.identify((String[])object);
        }
        logger.info(IppInspector::runInspectionWorkflow$lambda$17);
        try {
            object = new IppAttributeBuilder[]{TemplateAttributes.jobName("Validation"), DocumentFormat.OCTET_STREAM, Sides.TwoSidedShortEdge, PrintQuality.Normal, ColorMode.Color, Media.ISO_A3};
            object = $this$runInspectionWorkflow.validateJob((IppAttributeBuilder)object);
        }
        catch (IppExchangeException ippExchangeException) {
            object = ippExchangeException.getResponse();
        }
        Object response = object;
        logger.info(() -> IppInspector.runInspectionWorkflow$lambda$18((IppResponse)response));
        logger.info(() -> IppInspector.runInspectionWorkflow$lambda$19(pdfResource));
        InputStream inputStream = IppInspector.class.getResourceAsStream("/" + pdfResource);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"IppInspector::class.java\u2026AsStream(\"/$pdfResource\")");
        object = new IppAttributeBuilder[]{TemplateAttributes.jobName(pdfResource)};
        IppJob $this$runInspectionWorkflow_u24lambda_u2428 = IppPrinter.printJob$default($this$runInspectionWorkflow, inputStream, object, null, 4, null);
        boolean bl = false;
        logger.info(() -> IppInspector.runInspectionWorkflow$lambda$28$lambda$20($this$runInspectionWorkflow_u24lambda_u2428));
        logger.info(IppInspector::runInspectionWorkflow$lambda$28$lambda$21);
        for (IppJob job : IppPrinter.getJobs$default($this$runInspectionWorkflow, null, null, null, null, 15, null)) {
            logger.info(() -> IppInspector.runInspectionWorkflow$lambda$28$lambda$22(job));
        }
        IppOperation[] ippOperationArray2 = new IppOperation[]{IppOperation.HoldJob, IppOperation.ReleaseJob};
        if ($this$runInspectionWorkflow.supportsOperations(ippOperationArray2)) {
            logger.info(IppInspector::runInspectionWorkflow$lambda$28$lambda$23);
            $this$runInspectionWorkflow_u24lambda_u2428.hold();
            logger.info(IppInspector::runInspectionWorkflow$lambda$28$lambda$24);
            $this$runInspectionWorkflow_u24lambda_u2428.release();
        }
        if (cancelJob) {
            logger.info(IppInspector::runInspectionWorkflow$lambda$28$lambda$25);
            IppJob.cancel$default($this$runInspectionWorkflow_u24lambda_u2428, null, 1, null);
        }
        logger.info(IppInspector::runInspectionWorkflow$lambda$28$lambda$26);
        IppJob.updateAttributes$default($this$runInspectionWorkflow_u24lambda_u2428, null, 1, null);
        $this$runInspectionWorkflow.getIppClient$ipp_client().setSaveMessages(false);
        logger.info(IppInspector::runInspectionWorkflow$lambda$28$lambda$27);
        IppJob.waitForTermination$default($this$runInspectionWorkflow_u24lambda_u2428, null, 1, null);
    }

    private static final String inspect$lambda$0(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Inspect printer " + $this_inspect.getPrinterUri();
    }

    private static final String inspect$lambda$2(String $printerModel) {
        Intrinsics.checkNotNullParameter((Object)$printerModel, (String)"$printerModel");
        return "Printer model: " + $printerModel;
    }

    private static final String inspect$lambda$10$lambda$3(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Media supported: " + $this_inspect.getMediaSupported();
    }

    private static final String inspect$lambda$10$lambda$4(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Media ready: " + $this_inspect.getMediaReady();
    }

    private static final String inspect$lambda$10$lambda$5(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Media default: " + $this_inspect.getMediaDefault();
    }

    private static final String inspect$lambda$10$lambda$6() {
        return "Communication channels supported:";
    }

    private static final String inspect$lambda$10$lambda$8$lambda$7(CommunicationChannel $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "  " + $it;
    }

    private static final String inspect$lambda$10$lambda$9(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "Document formats: " + $this_inspect.getDocumentFormatSupported();
    }

    private static final String inspect$lambda$11() {
        return "media-ready not supported";
    }

    private static final String inspect$lambda$12(IppPrinter $this_inspect) {
        Intrinsics.checkNotNullParameter((Object)$this_inspect, (String)"$this_inspect");
        return "No PDF available for media '" + $this_inspect.getMediaReady() + "', trying A4";
    }

    private static final String runInspectionWorkflow$lambda$13() {
        return "> Get printer attributes";
    }

    private static final String runInspectionWorkflow$lambda$14() {
        return "> CUPS Get PPD";
    }

    private static final String runInspectionWorkflow$lambda$16(String $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        return "> Identify by " + $action;
    }

    private static final String runInspectionWorkflow$lambda$17() {
        return "> Validate job";
    }

    private static final String runInspectionWorkflow$lambda$18(IppResponse $response) {
        return String.valueOf($response);
    }

    private static final String runInspectionWorkflow$lambda$19(String $pdfResource) {
        Intrinsics.checkNotNullParameter((Object)$pdfResource, (String)"$pdfResource");
        return "> Print job " + $pdfResource;
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$20(IppJob $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return $this_run.toString();
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$21() {
        return "> Get jobs";
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$22(IppJob $job) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        return String.valueOf($job);
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$23() {
        return "> Hold job";
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$24() {
        return "> Release job";
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$25() {
        return "> Cancel job";
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$26() {
        return "> Update job attributes";
    }

    private static final String runInspectionWorkflow$lambda$28$lambda$27() {
        return "> Wait for termination";
    }
}

