/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020\u0012J\r\u0010'\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b(J\u001a\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010+\u001a\u00020,H\u0007J\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\n \u0019*\u0004\u0018\u000100002\u0006\u00101\u001a\u00020\u0012J$\u00102\u001a\u00020\f2\b\b\u0002\u00103\u001a\u00020\f2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u00104\u001a\u000205J\b\u00106\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00067"}, d2={"Lde/gmuth/ipp/client/IppDocument;", "", "job", "Lde/gmuth/ipp/client/IppJob;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "inputStream", "Ljava/io/InputStream;", "(Lde/gmuth/ipp/client/IppJob;Lde/gmuth/ipp/core/IppAttributesGroup;Ljava/io/InputStream;)V", "getAttributes", "()Lde/gmuth/ipp/core/IppAttributesGroup;", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "setFile", "(Ljava/io/File;)V", "format", "", "getFormat", "()Ljava/lang/String;", "getJob", "()Lde/gmuth/ipp/client/IppJob;", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "name", "Lde/gmuth/ipp/core/IppString;", "getName", "()Lde/gmuth/ipp/core/IppString;", "number", "", "getNumber", "()I", "copyTo", "", "outputStream", "Ljava/io/OutputStream;", "filename", "filenameSuffix", "filenameSuffix$ipp_client", "log", "", "level", "Ljava/util/logging/Level;", "readBytes", "", "runCommand", "Ljava/lang/Process;", "commandToHandleFile", "save", "directory", "overwrite", "", "toString", "ipp-client"})
public final class IppDocument {
    @NotNull
    private final IppJob job;
    @NotNull
    private final IppAttributesGroup attributes;
    @NotNull
    private final InputStream inputStream;
    private final Logger logger;
    @Nullable
    private File file;

    public IppDocument(@NotNull IppJob job, @NotNull IppAttributesGroup attributes, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this.job = job;
        this.attributes = attributes;
        this.inputStream = inputStream;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    @NotNull
    public final IppJob getJob() {
        return this.job;
    }

    @NotNull
    public final IppAttributesGroup getAttributes() {
        return this.attributes;
    }

    public final int getNumber() {
        return ((Number)this.attributes.getValue("document-number")).intValue();
    }

    @NotNull
    public final String getFormat() {
        return (String)this.attributes.getValue("document-format");
    }

    @NotNull
    public final IppString getName() {
        return (IppString)this.attributes.getValue("document-name");
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@Nullable File file) {
        this.file = file;
    }

    @NotNull
    public final byte[] readBytes() {
        byte[] byArray;
        byte[] it = byArray = ByteStreamsKt.readBytes((InputStream)this.inputStream);
        boolean bl = false;
        this.logger.fine(() -> IppDocument.readBytes$lambda$1$lambda$0(it, this));
        return byArray;
    }

    @NotNull
    public final String filenameSuffix$ipp_client() {
        String string;
        switch (this.getFormat()) {
            case "application/pdf": 
            case "application/vnd.cups-pdf": {
                string = "pdf";
                break;
            }
            case "application/octet-stream": {
                string = "bin";
                break;
            }
            case "application/postscript": {
                string = "ps";
                break;
            }
            case "image/jpeg": {
                string = "jpg";
                break;
            }
            case "text/plain": {
                string = "txt";
                break;
            }
            default: {
                String[] stringArray = new String[]{"/"};
                string = (String)StringsKt.split$default((CharSequence)this.getFormat(), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
            }
        }
        return string;
    }

    @NotNull
    public final String filename() {
        String it;
        StringBuilder $this$filename_u24lambda_u246 = new StringBuilder();
        boolean bl = false;
        String suffix = null;
        suffix = this.filenameSuffix$ipp_client();
        IppJob $this$filename_u24lambda_u246_u24lambda_u244 = this.job;
        boolean bl2 = false;
        $this$filename_u24lambda_u246.append("job-" + $this$filename_u24lambda_u246_u24lambda_u244.getId());
        if ($this$filename_u24lambda_u246_u24lambda_u244.getNumberOfDocuments() > 1) {
            $this$filename_u24lambda_u246.append("-doc-" + this.getNumber());
        }
        String string = this.job.getOriginatingUserNameOrAppleJobOwnerOrNull();
        if (string != null) {
            it = string;
            boolean bl3 = false;
            $this$filename_u24lambda_u246.append("-" + it);
        }
        if ($this$filename_u24lambda_u246_u24lambda_u244.getAttributes().containsKey((Object)"com.apple.print.JobInfo.PMApplicationName")) {
            $this$filename_u24lambda_u246.append("-" + $this$filename_u24lambda_u246_u24lambda_u244.getAttributes().getTextValue("com.apple.print.JobInfo.PMApplicationName"));
        }
        String string2 = this.job.getJobNameOrDocumentNameSuppliedOrAppleJobNameOrNull();
        if (string2 != null) {
            it = string2;
            boolean bl4 = false;
            $this$filename_u24lambda_u246.append("-" + StringsKt.take((String)it, (int)100));
            String string3 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (StringsKt.endsWith$default((String)string3, (String)("." + suffix), (boolean)false, (int)2, null)) {
                suffix = null;
            }
        }
        String string4 = suffix;
        if (string4 != null) {
            String it2 = string4;
            boolean bl5 = false;
            $this$filename_u24lambda_u246.append("." + it2);
        }
        String string5 = $this$filename_u24lambda_u246.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString()");
        return StringsKt.replace$default((String)string5, (char)'/', (char)'_', (boolean)false, (int)4, null);
    }

    public final long copyTo(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        return ByteStreamsKt.copyTo$default((InputStream)this.inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
    }

    @NotNull
    public final File save(@NotNull File directory, @NotNull File file, boolean overwrite) {
        File file2;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        File it = file2 = file;
        boolean bl = false;
        if (file.isFile() && !overwrite) {
            throw new IOException("File '" + file + "' already exists");
        }
        this.copyTo(new FileOutputStream(file));
        this.file = file;
        this.logger.info(() -> IppDocument.save$lambda$8$lambda$7(file));
        return file2;
    }

    public static /* synthetic */ File save$default(IppDocument ippDocument, File file, File file2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Path path = Files.createTempDirectory(null, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
            File file3 = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"createTempDirectory().toFile()");
            file = file3;
        }
        if ((n & 2) != 0) {
            file2 = new File(file, ippDocument.filename());
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return ippDocument.save(file, file2, bl);
    }

    public final Process runCommand(@NotNull String commandToHandleFile) {
        Intrinsics.checkNotNullParameter((Object)commandToHandleFile, (String)"commandToHandleFile");
        Runtime runtime = Runtime.getRuntime();
        String[] stringArray = new String[2];
        stringArray[0] = commandToHandleFile;
        File file = this.file;
        Intrinsics.checkNotNull((Object)file);
        stringArray[1] = file.getAbsolutePath();
        return runtime.exec(stringArray);
    }

    @NotNull
    public String toString() {
        StringBuilder $this$toString_u24lambda_u249 = new StringBuilder("Document #" + this.getNumber());
        boolean bl = false;
        $this$toString_u24lambda_u249.append(" (" + this.getFormat() + ") of job #" + this.job.getId());
        if (this.attributes.containsKey((Object)"document-name")) {
            $this$toString_u24lambda_u249.append(" '" + this.getName() + "'");
        }
        if (this.file != null) {
            File file = this.file;
            Intrinsics.checkNotNull((Object)file);
            $this$toString_u24lambda_u249.append(": " + this.file + " (" + file.length() + " bytes)");
        }
        String string = $this$toString_u24lambda_u249.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder(\"Document \u2026\n        toString()\n    }");
        return string;
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        IppAttributesGroup.log$default(this.attributes, logger, level, null, "DOCUMENT #" + this.getNumber(), 4, null);
    }

    public static /* synthetic */ void log$default(IppDocument ippDocument, Logger logger, Level level, int n, Object object) {
        if ((n & 2) != 0) {
            Level level2 = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"INFO");
            level = level2;
        }
        ippDocument.log(logger, level);
    }

    @JvmOverloads
    public final void log(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        IppDocument.log$default(this, logger, null, 2, null);
    }

    private static final String readBytes$lambda$1$lambda$0(byte[] $it, IppDocument this$0) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Read " + $it.length + " bytes of " + this$0;
    }

    private static final String save$lambda$8$lambda$7(File $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        return "Saved " + $file;
    }
}

