/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppExchange;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.core.IppAttribute;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppStatus;
import de.gmuth.ipp.core.IppTag;
import de.gmuth.ipp.iana.IppRegistrationsSection2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 K2\u00020\u0001:\u0001KB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/J \u00101\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0018\u00107\u001a\u00020\u00192\u0006\u00108\u001a\u0002092\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J8\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<2\n\b\u0002\u0010=\u001a\u0004\u0018\u0001092\u0010\b\u0002\u0010>\u001a\n\u0012\u0004\u0012\u00020/\u0018\u00010?2\n\b\u0002\u0010@\u001a\u0004\u0018\u00010/J\u0010\u0010A\u001a\u0002092\u0006\u0010B\u001a\u000209H\u0002J\u0018\u0010C\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0014\u0010D\u001a\u00020\u001b*\u00020E2\u0006\u0010F\u001a\u00020\fH\u0002J2\u0010C\u001a\u0004\u0018\u00010G*\u00020E2\u0006\u0010\u0018\u001a\u00020\u00152\b\u00104\u001a\u0004\u0018\u0001052\u0010\b\u0002\u0010H\u001a\n\u0018\u00010Ij\u0004\u0018\u0001`JH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010\u0013\u001a:\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0014j\u0004\u0018\u0001`\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000e\"\u0004\b#\u0010\u0010R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000e\"\u0004\b,\u0010\u0010\u00a8\u0006L"}, d2={"Lde/gmuth/ipp/client/IppClient;", "Lde/gmuth/ipp/client/IppExchange;", "config", "Lde/gmuth/ipp/client/IppConfig;", "(Lde/gmuth/ipp/client/IppConfig;)V", "getConfig", "()Lde/gmuth/ipp/client/IppConfig;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "onExceptionSaveMessages", "", "getOnExceptionSaveMessages", "()Z", "setOnExceptionSaveMessages", "(Z)V", "requestCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "responseInterceptor", "Lkotlin/Function2;", "Lde/gmuth/ipp/core/IppRequest;", "Lkotlin/ParameterName;", "name", "request", "Lde/gmuth/ipp/core/IppResponse;", "response", "", "Lde/gmuth/ipp/client/IppResponseInterceptor;", "getResponseInterceptor", "()Lkotlin/jvm/functions/Function2;", "setResponseInterceptor", "(Lkotlin/jvm/functions/Function2;)V", "saveMessages", "getSaveMessages", "setSaveMessages", "saveMessagesDirectory", "Ljava/io/File;", "getSaveMessagesDirectory", "()Ljava/io/File;", "setSaveMessagesDirectory", "(Ljava/io/File;)V", "throwWhenNotSuccessful", "getThrowWhenNotSuccessful", "setThrowWhenNotSuccessful", "basicAuth", "user", "", "password", "decodeContentStream", "httpStatus", "", "contentStream", "Ljava/io/InputStream;", "exchange", "httpPost", "httpUri", "Ljava/net/URI;", "ippRequest", "operation", "Lde/gmuth/ipp/core/IppOperation;", "printerUri", "requestedAttributes", "", "userName", "toHttpUri", "ippUri", "validateResponse", "configure", "Ljava/net/HttpURLConnection;", "chunked", "", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "ipp-client"})
public class IppClient
implements IppExchange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IppConfig config;
    @NotNull
    private final Logger logger;
    @Nullable
    private Function2<? super IppRequest, ? super IppResponse, Unit> responseInterceptor;
    private boolean saveMessages;
    @NotNull
    private File saveMessagesDirectory;
    private boolean onExceptionSaveMessages;
    private boolean throwWhenNotSuccessful;
    @NotNull
    private final AtomicInteger requestCounter;
    @NotNull
    public static final String APPLICATION_IPP = "application/ipp";

    public IppClient(@NotNull IppConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(javaClass.name)");
        this.logger = logger;
        this.saveMessagesDirectory = new File("ipp-messages");
        this.throwWhenNotSuccessful = true;
        this.requestCounter = new AtomicInteger(1);
    }

    public /* synthetic */ IppClient(IppConfig ippConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ippConfig = new IppConfig(null, null, null, null, null, null, null, null, false, 511, null);
        }
        this(ippConfig);
    }

    @NotNull
    public final IppConfig getConfig() {
        return this.config;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final Function2<IppRequest, IppResponse, Unit> getResponseInterceptor() {
        return this.responseInterceptor;
    }

    public final void setResponseInterceptor(@Nullable Function2<? super IppRequest, ? super IppResponse, Unit> function2) {
        this.responseInterceptor = function2;
    }

    public final boolean getSaveMessages() {
        return this.saveMessages;
    }

    public final void setSaveMessages(boolean bl) {
        this.saveMessages = bl;
    }

    @NotNull
    public final File getSaveMessagesDirectory() {
        return this.saveMessagesDirectory;
    }

    public final void setSaveMessagesDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.saveMessagesDirectory = file;
    }

    public final boolean getOnExceptionSaveMessages() {
        return this.onExceptionSaveMessages;
    }

    public final void setOnExceptionSaveMessages(boolean bl) {
        this.onExceptionSaveMessages = bl;
    }

    public final boolean getThrowWhenNotSuccessful() {
        return this.throwWhenNotSuccessful;
    }

    public final void setThrowWhenNotSuccessful(boolean bl) {
        this.throwWhenNotSuccessful = bl;
    }

    public final void basicAuth(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.config.setUserName(user);
        this.config.setPassword(password);
    }

    @NotNull
    public final IppRequest ippRequest(@NotNull IppOperation operation, @Nullable URI printerUri, @Nullable Collection<String> requestedAttributes, @Nullable String userName) {
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        return new IppRequest(operation, printerUri, requestedAttributes, userName, this.config.getIppVersion(), this.requestCounter.getAndIncrement(), this.config.getCharset(), this.config.getNaturalLanguage());
    }

    public static /* synthetic */ IppRequest ippRequest$default(IppClient ippClient, IppOperation ippOperation, URI uRI, Collection collection, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ippRequest");
        }
        if ((n & 2) != 0) {
            uRI = null;
        }
        if ((n & 4) != 0) {
            collection = null;
        }
        if ((n & 8) != 0) {
            string = ippClient.config.getUserName();
        }
        return ippClient.ippRequest(ippOperation, uRI, collection, string);
    }

    @Override
    @NotNull
    public IppResponse exchange(@NotNull IppRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URI ippUri = request.getPrinterOrJobUri();
        this.logger.finer(() -> IppClient.exchange$lambda$0(request, ippUri));
        IppResponse response = this.httpPost(this.toHttpUri(ippUri), request);
        this.logger.fine(() -> IppClient.exchange$lambda$1(ippUri, request, response));
        if (this.saveMessages) {
            request.saveBytes(IppClient.exchange$file(this, request, "request"));
            response.saveBytes(IppClient.exchange$file(this, request, "response"));
            response.saveText(IppClient.exchange$file(this, request, "txt"));
        }
        Function2<? super IppRequest, ? super IppResponse, Unit> function2 = this.responseInterceptor;
        if (function2 != null) {
            function2.invoke((Object)request, (Object)response);
        }
        this.validateResponse(request, response);
        return response;
    }

    @NotNull
    public IppResponse httpPost(@NotNull URI httpUri, @NotNull IppRequest request) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)httpUri, (String)"httpUri");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        URLConnection uRLConnection = httpUri.toURL().openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection $this$httpPost_u24lambda_u244 = (HttpURLConnection)uRLConnection;
        boolean bl = false;
        if ($this$httpPost_u24lambda_u244 instanceof HttpsURLConnection && this.config.getSslContext() != null) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)$this$httpPost_u24lambda_u244;
            SSLContext sSLContext = this.config.getSslContext();
            Intrinsics.checkNotNull((Object)sSLContext);
            httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
            if (!this.config.getVerifySSLHostname()) {
                ((HttpsURLConnection)$this$httpPost_u24lambda_u244).setHostnameVerifier(IppClient::httpPost$lambda$4$lambda$2);
            }
        }
        this.configure($this$httpPost_u24lambda_u244, request.hasDocument());
        OutputStream outputStream = $this$httpPost_u24lambda_u244.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
        request.write(outputStream);
        try {
            IppClient.validateResponse$default(this, $this$httpPost_u24lambda_u244, request, $this$httpPost_u24lambda_u244.getInputStream(), null, 4, null);
            object = $this$httpPost_u24lambda_u244.getInputStream();
        }
        catch (IOException ioException) {
            this.validateResponse($this$httpPost_u24lambda_u244, request, $this$httpPost_u24lambda_u244.getErrorStream(), ioException);
            object = $this$httpPost_u24lambda_u244.getErrorStream();
        }
        InputStream responseContentStream = object;
        int n = $this$httpPost_u24lambda_u244.getResponseCode();
        Intrinsics.checkNotNullExpressionValue((Object)responseContentStream, (String)"responseContentStream");
        Object $this$httpPost_u24lambda_u244_u24lambda_u243 = object = this.decodeContentStream(request, n, responseContentStream);
        boolean bl2 = false;
        List<String> list = $this$httpPost_u24lambda_u244.getHeaderFields().get("Server");
        ((IppResponse)$this$httpPost_u24lambda_u244_u24lambda_u243).setHttpServer(list != null ? (String)CollectionsKt.first(list) : null);
        return object;
    }

    private final void validateResponse(IppRequest request, IppResponse response) {
        IppResponse $this$validateResponse_u24lambda_u247 = response;
        boolean bl = false;
        if ($this$validateResponse_u24lambda_u247.getStatus() == IppStatus.ClientErrorBadRequest) {
            Level level = Level.SEVERE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
            request.log(this.logger, level, "BAD-REQUEST: ");
        }
        if ($this$validateResponse_u24lambda_u247.containsGroup(IppTag.Unsupported)) {
            Collection<IppAttribute<?>> collection = $this$validateResponse_u24lambda_u247.getUnsupportedGroup().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"unsupportedGroup.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IppAttribute it = (IppAttribute)element$iv;
                boolean bl2 = false;
                this.logger.warning(() -> IppClient.validateResponse$lambda$7$lambda$6$lambda$5(it));
            }
        }
        if (!$this$validateResponse_u24lambda_u247.isSuccessful()) {
            IppRegistrationsSection2.INSTANCE.validate(request);
            if (this.throwWhenNotSuccessful) {
                throw $this$validateResponse_u24lambda_u247.getStatus() == IppStatus.ClientErrorNotFound ? (Throwable)new IppExchangeException.ClientErrorNotFoundException(request, response) : (Throwable)new IppExchangeException(request, response, null, null, null, null, null, 124, null);
            }
        }
    }

    private final URI toHttpUri(URI ippUri) {
        URI $this$toHttpUri_u24lambda_u248 = ippUri;
        boolean bl = false;
        String string = $this$toHttpUri_u24lambda_u248.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scheme");
        String scheme = StringsKt.replace$default((String)string, (String)"ipp", (String)"http", (boolean)false, (int)4, null);
        int port = $this$toHttpUri_u24lambda_u248.getPort() == -1 ? 631 : $this$toHttpUri_u24lambda_u248.getPort();
        URI uRI = URI.create(scheme + "://" + $this$toHttpUri_u24lambda_u248.getHost() + ":" + port + $this$toHttpUri_u24lambda_u248.getRawPath());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"with(ippUri) {\n        v\u2026ost:$port$rawPath\")\n    }");
        return uRI;
    }

    private final void configure(HttpURLConnection $this$configure, boolean chunked) {
        IppConfig $this$configure_u24lambda_u2410 = this.config;
        boolean bl = false;
        $this$configure.setConnectTimeout((int)$this$configure_u24lambda_u2410.getTimeout().toMillis());
        $this$configure.setReadTimeout((int)$this$configure_u24lambda_u2410.getTimeout().toMillis());
        String string = $this$configure_u24lambda_u2410.getUserAgent();
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$configure.setRequestProperty("User-Agent", it);
        }
        if ($this$configure_u24lambda_u2410.getPassword() != null) {
            $this$configure.setRequestProperty("Authorization", $this$configure_u24lambda_u2410.authorization());
        }
        $this$configure.setDoOutput(true);
        if (chunked) {
            $this$configure.setChunkedStreamingMode(0);
        }
        $this$configure.setRequestProperty("Content-Type", APPLICATION_IPP);
        $this$configure.setRequestProperty("Accept", APPLICATION_IPP);
        $this$configure.setRequestProperty("Accept-Encoding", "identity");
    }

    /*
     * Unable to fully structure code
     */
    private final Void validateResponse(HttpURLConnection $this$validateResponse, IppRequest request, InputStream contentStream, Exception cause) {
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            if ($this$validateResponse.getResponseCode() != 401 || !request.getOperationGroup().containsKey((Object)"requesting-user-name")) break block3;
                            $this$validateResponse_u24lambda_u2411 = request;
                            $i$a$-with-IppClient$validateResponse$2 = false;
                            v0 = "User \"" + $this$validateResponse_u24lambda_u2411.getRequestingUserName() + "\" is not authorized for operation " + $this$validateResponse_u24lambda_u2411.getOperation() + " on " + $this$validateResponse_u24lambda_u2411.getPrinterOrJobUri();
                            break block4;
                        }
                        if ($this$validateResponse.getResponseCode() != 401) break block5;
                        $this$validateResponse_u24lambda_u2412 = request;
                        $i$a$-with-IppClient$validateResponse$3 = false;
                        v0 = "Not authorized for operation " + $this$validateResponse_u24lambda_u2412.getOperation() + " on " + $this$validateResponse_u24lambda_u2412.getPrinterOrJobUri() + " (userName required)";
                        break block4;
                    }
                    if ($this$validateResponse.getResponseCode() != 426) break block6;
                    v0 = "HTTP status " + $this$validateResponse.getResponseCode() + ", " + $this$validateResponse.getResponseMessage() + ", Try ipps://" + request.getPrinterOrJobUri().getHost();
                    break block4;
                }
                if ($this$validateResponse.getResponseCode() == 200) break block7;
                v0 = "HTTP request failed: " + $this$validateResponse.getResponseCode() + ", " + $this$validateResponse.getResponseMessage();
                break block4;
            }
            if ($this$validateResponse.getContentType() == null) ** GOTO lbl-1000
            v1 = $this$validateResponse.getContentType();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"contentType");
            if (!StringsKt.startsWith$default((String)v1, (String)"application/ipp", (boolean)false, (int)2, null)) {
                v0 = "Invalid Content-Type: " + $this$validateResponse.getContentType();
            } else lbl-1000:
            // 2 sources

            {
                v2 = cause;
                v0 = var5_8 = v2 != null ? v2.getMessage() : null;
            }
        }
        if (var5_8 != null) {
            it = var5_8;
            $i$a$-let-IppClient$validateResponse$4 = false;
            throw new IppExchangeException(request, null, $this$validateResponse.getResponseCode(), $this$validateResponse.getHeaderFields(), contentStream, it, cause);
        }
        return null;
    }

    static /* synthetic */ Void validateResponse$default(IppClient ippClient, HttpURLConnection httpURLConnection, IppRequest ippRequest, InputStream inputStream, Exception exception, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validateResponse");
        }
        if ((n & 4) != 0) {
            exception = null;
        }
        return ippClient.validateResponse(httpURLConnection, ippRequest, inputStream, exception);
    }

    private final IppResponse decodeContentStream(IppRequest request, int httpStatus, InputStream contentStream) {
        IppResponse ippResponse;
        IppResponse $this$decodeContentStream_u24lambda_u2415 = ippResponse = new IppResponse();
        boolean bl = false;
        try {
            $this$decodeContentStream_u24lambda_u2415.read(contentStream);
        }
        catch (Throwable throwable) {
            IppExchangeException ippExchangeException;
            IppExchangeException $this$decodeContentStream_u24lambda_u2415_u24lambda_u2414 = ippExchangeException = new IppExchangeException(request, $this$decodeContentStream_u24lambda_u2415, httpStatus, null, null, "Failed to decode ipp response", throwable, 24, null);
            boolean bl2 = false;
            if (this.onExceptionSaveMessages) {
                IppExchangeException.saveMessages$default($this$decodeContentStream_u24lambda_u2415_u24lambda_u2414, "decoding_ipp_response_" + request.getRequestId() + "_failed", null, 2, null);
            }
            throw (Throwable)ippExchangeException;
        }
        return ippResponse;
    }

    private static final String exchange$lambda$0(IppRequest $request, URI $ippUri) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$ippUri, (String)"$ippUri");
        return "Send '" + $request.getOperation() + "' request to " + $ippUri;
    }

    private static final String exchange$lambda$1(URI $ippUri, IppRequest $request, IppResponse $response) {
        Intrinsics.checkNotNullParameter((Object)$ippUri, (String)"$ippUri");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$response, (String)"$response");
        return $ippUri + ": " + $request + " => " + $response;
    }

    private static final File exchange$file(IppClient this$0, IppRequest $request, String suffix) {
        return new File(this$0.saveMessagesDirectory, $request.getRequestId() + "-" + $request.getOperation() + "." + suffix);
    }

    private static final boolean httpPost$lambda$4$lambda$2(String string, SSLSession sSLSession) {
        return true;
    }

    private static final String validateResponse$lambda$7$lambda$6$lambda$5(IppAttribute $it) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        return "Unsupported: " + $it;
    }

    public IppClient() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lde/gmuth/ipp/client/IppClient$Companion;", "", "()V", "APPLICATION_IPP", "", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

