/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.client;

import de.gmuth.ipp.client.CupsClient;
import de.gmuth.ipp.client.IppClient;
import de.gmuth.ipp.client.IppConfig;
import de.gmuth.ipp.client.IppDocument;
import de.gmuth.ipp.client.IppEventNotification;
import de.gmuth.ipp.client.IppExchangeException;
import de.gmuth.ipp.client.IppJob;
import de.gmuth.ipp.client.IppPrinter;
import de.gmuth.ipp.client.IppSubscription;
import de.gmuth.ipp.client.WhichJobs;
import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppOperation;
import de.gmuth.ipp.core.IppRequest;
import de.gmuth.ipp.core.IppResponse;
import de.gmuth.ipp.core.IppString;
import de.gmuth.ipp.core.IppTag;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJJ\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00105\u001a\u0004\u0018\u000106J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00032\u0006\u0010:\u001a\u00020\u0003J8\u0010;\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00062\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010<\u001a\u00020=J4\u0010>\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00062\b\u00102\u001a\u0004\u0018\u00010\u00032\b\u00103\u001a\u0004\u0018\u00010\u00032\b\u00104\u001a\u0004\u0018\u00010\u0003J9\u0010?\u001a\u00020@2\u0014\b\u0002\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030B\"\u00020\u00032\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010D\u00a2\u0006\u0002\u0010FJ0\u0010?\u001a\u00020@2\u0010\b\u0002\u0010A\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010G2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010DJT\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\u0006\u00100\u001a\u00020\u00032\n\b\u0002\u00101\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00103\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00104\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0002J\u0010\u0010L\u001a\u00020\u00062\u0006\u00100\u001a\u00020\u0003H\u0002J\u000e\u0010M\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003J\u0010\u0010N\u001a\u00020/2\u0006\u0010O\u001a\u00020IH\u0002J1\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00110Q2\u0006\u0010R\u001a\u00020S2\b\b\u0002\u0010T\u001a\u00020=2\n\b\u0002\u0010U\u001a\u0004\u0018\u00010\u0003H\u0000\u00a2\u0006\u0002\bVJ\u0006\u0010W\u001a\u00020\u0017J\u000e\u0010X\u001a\u00020S2\u0006\u0010Y\u001a\u00020ZJ;\u0010[\u001a\b\u0012\u0004\u0012\u00020S0Q2\n\b\u0002\u0010\\\u001a\u0004\u0018\u00010]2\n\b\u0002\u0010^\u001a\u0004\u0018\u00010Z2\u0010\b\u0002\u0010_\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010G\u00a2\u0006\u0002\u0010`J,\u0010a\u001a\b\u0012\u0004\u0012\u00020S0Q2\b\b\u0002\u0010\\\u001a\u00020]2\b\b\u0002\u0010b\u001a\u00020=2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010\u0003J\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00030eJ\f\u0010f\u001a\b\u0012\u0004\u0012\u00020g0eJ\u000e\u0010h\u001a\u00020\u00172\u0006\u00100\u001a\u00020\u0003J\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00030GJ\f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u00170GJ\u000e\u0010k\u001a\u00020@2\u0006\u0010Y\u001a\u00020ZJ\f\u0010l\u001a\b\u0012\u0004\u0012\u00020@0GJ\u001a\u0010O\u001a\u00020I2\u0006\u0010J\u001a\u00020K2\b\b\u0002\u0010m\u001a\u00020\u0006H\u0002J\u000e\u0010n\u001a\u00020=2\u0006\u00100\u001a\u00020\u0003J\u000e\u0010o\u001a\u00020/2\u0006\u00100\u001a\u00020\u0003J:\u0010p\u001a\u0002082\b\b\u0002\u0010q\u001a\u00020\u00032\b\b\u0002\u0010r\u001a\u00020D2\b\b\u0002\u0010s\u001a\u00020=2\b\b\u0002\u0010t\u001a\u00020D2\n\b\u0002\u0010u\u001a\u0004\u0018\u00010\u0003R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f*\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u0004R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010$\u001a\u0004\u0018\u00010\u00032\b\u0010#\u001a\u0004\u0018\u00010\u00038F@FX\u0086\u008e\u0002\u00a2\u0006\u0018\n\u0004\b(\u0010)\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u0004*\u0004\b%\u0010\rR\u001b\u0010*\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b+\u0010\u001c\u00a8\u0006v"}, d2={"Lde/gmuth/ipp/client/CupsClient;", "", "host", "", "(Ljava/lang/String;)V", "cupsUri", "Ljava/net/URI;", "ippClient", "Lde/gmuth/ipp/client/IppClient;", "(Ljava/net/URI;Lde/gmuth/ipp/client/IppClient;)V", "config", "Lde/gmuth/ipp/client/IppConfig;", "getConfig$delegate", "(Lde/gmuth/ipp/client/CupsClient;)Ljava/lang/Object;", "getConfig", "()Lde/gmuth/ipp/client/IppConfig;", "cupsClientWorkDirectory", "Ljava/io/File;", "getCupsClientWorkDirectory", "()Ljava/io/File;", "setCupsClientWorkDirectory", "(Ljava/io/File;)V", "cupsServer", "Lde/gmuth/ipp/client/IppPrinter;", "getCupsUri", "()Ljava/net/URI;", "httpServer", "getHttpServer", "()Ljava/lang/String;", "setHttpServer", "jobOwners", "", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "<set-?>", "userName", "getUserName$delegate", "getUserName", "setUserName", "userName$receiver", "Lde/gmuth/ipp/client/IppConfig;", "version", "getVersion", "version$delegate", "Lkotlin/Lazy;", "addModifyPrinter", "Lde/gmuth/ipp/core/IppResponse;", "printerName", "deviceUri", "printerInfo", "printerLocation", "ppdName", "ppdInputStream", "Ljava/io/InputStream;", "basicAuth", "", "user", "password", "createIppEverywherePrinter", "savePPD", "", "createLocalPrinter", "createSubscription", "Lde/gmuth/ipp/client/IppSubscription;", "notifyEvents", "", "notifyLeaseDuration", "Ljava/time/Duration;", "notifyTimeInterval", "([Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;)Lde/gmuth/ipp/client/IppSubscription;", "", "cupsPrinterRequest", "Lde/gmuth/ipp/core/IppRequest;", "operation", "Lde/gmuth/ipp/core/IppOperation;", "cupsPrinterUri", "deletePrinter", "exchange", "ippRequest", "getAndSaveDocuments", "", "job", "Lde/gmuth/ipp/client/IppJob;", "onSuccessUpdateJobAttributes", "optionalCommandToHandleFile", "getAndSaveDocuments$ipp_client", "getDefault", "getJob", "id", "", "getJobs", "whichJobs", "Lde/gmuth/ipp/client/WhichJobs;", "limit", "requestedAttributes", "(Lde/gmuth/ipp/client/WhichJobs;Ljava/lang/Integer;Ljava/util/List;)Ljava/util/Collection;", "getJobsAndSaveDocuments", "updateJobAttributes", "commandToHandleSavedFile", "getOwnersOfAllJobs", "", "getOwnersOfAllSubscriptions", "Lde/gmuth/ipp/core/IppString;", "getPrinter", "getPrinterNames", "getPrinters", "getSubscription", "getSubscriptions", "printerURI", "printerExists", "setDefault", "subscribeToJobEventsAndThenGetDocuments", "whichJobEvents", "leaseDuration", "autoRenewLease", "pollEvery", "commandToHandleFile", "ipp-client"})
public final class CupsClient {
    @NotNull
    private final URI cupsUri;
    @NotNull
    private final IppClient ippClient;
    private final Logger logger;
    @NotNull
    private final IppConfig userName$receiver;
    @NotNull
    private File cupsClientWorkDirectory;
    @NotNull
    private final IppPrinter cupsServer;
    @NotNull
    private final Lazy version$delegate;
    @Nullable
    private String httpServer;
    @NotNull
    private final Set<String> jobOwners;

    /*
     * WARNING - void declaration
     */
    public CupsClient(@NotNull URI cupsUri, @NotNull IppClient ippClient) {
        void $this$cupsServer_u24lambda_u240;
        IppPrinter ippPrinter;
        Intrinsics.checkNotNullParameter((Object)cupsUri, (String)"cupsUri");
        Intrinsics.checkNotNullParameter((Object)ippClient, (String)"ippClient");
        this.cupsUri = cupsUri;
        this.ippClient = ippClient;
        this.logger = Logger.getLogger(this.getClass().getName());
        this.userName$receiver = this.getConfig();
        this.cupsClientWorkDirectory = new File("CUPS/" + this.cupsUri.getHost());
        IppPrinter ippPrinter2 = ippPrinter = new IppPrinter(this.cupsUri, null, null, this.ippClient, false, null, 38, null);
        CupsClient cupsClient = this;
        boolean bl = false;
        $this$cupsServer_u24lambda_u240.setWorkDirectory($this$cupsServer_u24lambda_u240.createDirectoryIfNotExists$ipp_client(this.cupsClientWorkDirectory));
        cupsClient.cupsServer = ippPrinter;
        if (Intrinsics.areEqual((Object)this.cupsUri.getScheme(), (Object)"ipps")) {
            this.getConfig().trustAnyCertificateAndSSLHostname();
        }
        this.version$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ CupsClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                Object object;
                try {
                    object = this.this$0.getPrinters();
                    CupsClient cupsClient = this.this$0;
                    Object $this$invoke_u24lambda_u240 = object;
                    boolean bl = false;
                    object = (!((Collection)$this$invoke_u24lambda_u240).isEmpty() ? (IppPrinter)CollectionsKt.last((List)$this$invoke_u24lambda_u240) : new IppPrinter(((IppJob)CollectionsKt.last((Iterable)CupsClient.getJobs$default(cupsClient, WhichJobs.All, null, null, 6, null))).getPrinterUri(), null, null, null, false, null, 62, null)).getCupsVersion();
                }
                catch (NoSuchElementException exception) {
                    object = "?";
                }
                return object;
            }
        }));
        this.jobOwners = new LinkedHashSet();
    }

    public /* synthetic */ CupsClient(URI uRI, IppClient ippClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = URI.create("ipp://localhost");
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"create(\"ipp://localhost\")");
            uRI = uRI2;
        }
        if ((n & 2) != 0) {
            ippClient = new IppClient(null, 1, null);
        }
        this(uRI, ippClient);
    }

    @NotNull
    public final URI getCupsUri() {
        return this.cupsUri;
    }

    public CupsClient(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        URI uRI = URI.create("ipp://" + host);
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"ipp://$host\")");
        this(uRI, null, 2, null);
    }

    public /* synthetic */ CupsClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "localhost";
        }
        this(string);
    }

    @NotNull
    public final IppConfig getConfig() {
        return this.ippClient.getConfig();
    }

    private static Object getConfig$delegate(CupsClient cupsClient) {
        return Reflection.property0((PropertyReference0)((PropertyReference0)new PropertyReference0Impl((Object)cupsClient.ippClient, IppClient.class, "config", "getConfig()Lde/gmuth/ipp/client/IppConfig;", 0)));
    }

    @Nullable
    public final String getUserName() {
        return this.userName$receiver.getUserName();
    }

    public final void setUserName(@Nullable String string) {
        this.userName$receiver.setUserName(string);
    }

    private static Object getUserName$delegate(CupsClient cupsClient) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)cupsClient.userName$receiver, IppConfig.class, "userName", "getUserName()Ljava/lang/String;", 0)));
    }

    @NotNull
    public final File getCupsClientWorkDirectory() {
        return this.cupsClientWorkDirectory;
    }

    public final void setCupsClientWorkDirectory(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.cupsClientWorkDirectory = file;
    }

    private final URI cupsPrinterUri(String printerName) {
        URI uRI;
        URI $this$cupsPrinterUri_u24lambda_u241 = this.cupsUri;
        boolean bl = false;
        URI $this$cupsPrinterUri_u24lambda_u243 = uRI = new URI($this$cupsPrinterUri_u24lambda_u241.getScheme() + "://" + $this$cupsPrinterUri_u24lambda_u241.getHost() + (String)($this$cupsPrinterUri_u24lambda_u241.getPort() > 0 ? ":" + $this$cupsPrinterUri_u24lambda_u241.getPort() : "") + "/printers/" + printerName);
        boolean bl2 = false;
        this.logger.finer(() -> CupsClient.cupsPrinterUri$lambda$3$lambda$2(printerName, $this$cupsPrinterUri_u24lambda_u243));
        return uRI;
    }

    @NotNull
    public final String getVersion() {
        Lazy lazy = this.version$delegate;
        return (String)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IppPrinter> getPrinters() {
        List list;
        try {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.exchange(CupsClient.ippRequest$default(this, IppOperation.CupsGetPrinters, null, 2, null)).getAttributesGroups$ipp_client(IppTag.Printer);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IppAttributesGroup ippAttributesGroup = (IppAttributesGroup)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new IppPrinter((IppAttributesGroup)it, this.ippClient));
            }
            list = (List)destination$iv$iv;
        }
        catch (IppExchangeException.ClientErrorNotFoundException clientErrorNotFoundException) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPrinterNames() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getPrinters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppPrinter ippPrinter = (IppPrinter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName().toString());
        }
        return (List)destination$iv$iv;
    }

    public final boolean printerExists(@NotNull String printerName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.getPrinterNames().contains(printerName);
    }

    @NotNull
    public final IppPrinter getPrinter(@NotNull String printerName) {
        IppPrinter ippPrinter;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        try {
            IppPrinter $this$getPrinter_u24lambda_u246 = ippPrinter = new IppPrinter(this.cupsPrinterUri(printerName), null, null, this.ippClient, false, null, 54, null);
            boolean bl = false;
            $this$getPrinter_u24lambda_u246.setWorkDirectory(this.cupsClientWorkDirectory);
        }
        catch (IppExchangeException.ClientErrorNotFoundException clientErrorNotFoundException) {
            List<IppPrinter> $this$getPrinter_u24lambda_u249 = this.getPrinters();
            boolean bl = false;
            if (!((Collection)$this$getPrinter_u24lambda_u249).isEmpty()) {
                this.logger.warning(() -> CupsClient.getPrinter$lambda$9$lambda$8($this$getPrinter_u24lambda_u249));
            }
            throw clientErrorNotFoundException;
        }
        return ippPrinter;
    }

    @NotNull
    public final IppPrinter getDefault() {
        return new IppPrinter(this.exchange(CupsClient.ippRequest$default(this, IppOperation.CupsGetDefault, null, 2, null)).getPrinterGroup(), this.ippClient);
    }

    @NotNull
    public final IppResponse setDefault(@NotNull String printerName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.exchange(CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsSetDefault, printerName, null, null, null, null, null, 124, null));
    }

    @NotNull
    public final IppResponse addModifyPrinter(@NotNull String printerName, @Nullable URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, @Nullable String ppdName, @Nullable InputStream ppdInputStream) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        return this.exchange(this.cupsPrinterRequest(IppOperation.CupsAddModifyPrinter, printerName, deviceUri, printerInfo, printerLocation, ppdName, ppdInputStream));
    }

    public static /* synthetic */ IppResponse addModifyPrinter$default(CupsClient cupsClient, String string, URI uRI, String string2, String string3, String string4, InputStream inputStream, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        if ((n & 0x20) != 0) {
            inputStream = null;
        }
        return cupsClient.addModifyPrinter(string, uRI, string2, string3, string4, inputStream);
    }

    @NotNull
    public final IppResponse deletePrinter(@NotNull String printerName) {
        IppResponse ippResponse;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        IppResponse $this$deletePrinter_u24lambda_u2411 = ippResponse = this.exchange(CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsDeletePrinter, printerName, null, null, null, null, null, 124, null));
        boolean bl = false;
        this.logger.info(() -> CupsClient.deletePrinter$lambda$11$lambda$10(printerName));
        return ippResponse;
    }

    @NotNull
    public final IppPrinter createLocalPrinter(@NotNull String printerName, @NotNull URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, @Nullable String ppdName) {
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        Intrinsics.checkNotNullParameter((Object)deviceUri, (String)"deviceUri");
        if (!(!StringsKt.contains$default((CharSequence)printerName, (CharSequence)"-", (boolean)false, (int)2, null))) {
            boolean $i$a$-require-CupsClient$createLocalPrinter$22 = false;
            String $i$a$-require-CupsClient$createLocalPrinter$22 = "printerName must not contain '-'";
            throw new IllegalArgumentException($i$a$-require-CupsClient$createLocalPrinter$22.toString());
        }
        IppResponse $this$createLocalPrinter_u24lambda_u2414 = this.exchange(CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsCreateLocalPrinter, printerName, deviceUri, printerInfo, printerLocation, ppdName, null, 64, null));
        boolean bl = false;
        this.logger.info(() -> CupsClient.createLocalPrinter$lambda$14$lambda$13($this$createLocalPrinter_u24lambda_u2414));
        return new IppPrinter($this$createLocalPrinter_u24lambda_u2414.getPrinterGroup(), this.ippClient);
    }

    private final IppRequest cupsPrinterRequest(IppOperation operation, String printerName, URI deviceUri, String printerInfo, String printerLocation, String ppdName, InputStream ppdInputStream) {
        IppRequest ippRequest;
        block4: {
            Object[] objectArray;
            Object it;
            IppRequest $this$cupsPrinterRequest_u24lambda_u2421 = ippRequest = this.ippRequest(operation, this.cupsPrinterUri(printerName));
            boolean bl = false;
            IppAttributesGroup $this$cupsPrinterRequest_u24lambda_u2421_u24lambda_u2419 = $this$cupsPrinterRequest_u24lambda_u2421.createAttributesGroup(IppTag.Printer);
            boolean bl2 = false;
            Object[] objectArray2 = new Object[]{printerName};
            $this$cupsPrinterRequest_u24lambda_u2421_u24lambda_u2419.attribute("printer-name", IppTag.NameWithoutLanguage, objectArray2);
            URI uRI = deviceUri;
            if (uRI != null) {
                it = uRI;
                boolean bl3 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2421_u24lambda_u2419.attribute("device-uri", IppTag.Uri, objectArray);
            }
            String string = ppdName;
            if (string != null) {
                it = string;
                boolean bl4 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2421_u24lambda_u2419.attribute("ppd-name", IppTag.NameWithoutLanguage, objectArray);
            }
            String string2 = printerInfo;
            if (string2 != null) {
                it = string2;
                boolean bl5 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2421_u24lambda_u2419.attribute("printer-info", IppTag.TextWithoutLanguage, objectArray);
            }
            String string3 = printerLocation;
            if (string3 != null) {
                it = string3;
                boolean bl6 = false;
                objectArray = new Object[]{it};
                $this$cupsPrinterRequest_u24lambda_u2421_u24lambda_u2419.attribute("printer-location", IppTag.TextWithoutLanguage, objectArray);
            }
            InputStream inputStream = ppdInputStream;
            if (inputStream == null) break block4;
            InputStream it2 = inputStream;
            boolean bl7 = false;
            $this$cupsPrinterRequest_u24lambda_u2421.setDocumentInputStream(ppdInputStream);
        }
        return ippRequest;
    }

    static /* synthetic */ IppRequest cupsPrinterRequest$default(CupsClient cupsClient, IppOperation ippOperation, String string, URI uRI, String string2, String string3, String string4, InputStream inputStream, int n, Object object) {
        if ((n & 4) != 0) {
            uRI = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            inputStream = null;
        }
        return cupsClient.cupsPrinterRequest(ippOperation, string, uRI, string2, string3, string4, inputStream);
    }

    public final void basicAuth(@NotNull String user, @NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.ippClient.basicAuth(user, password);
    }

    private final IppRequest ippRequest(IppOperation operation, URI printerURI) {
        return IppClient.ippRequest$default(this.ippClient, operation, printerURI, null, null, 12, null);
    }

    static /* synthetic */ IppRequest ippRequest$default(CupsClient cupsClient, IppOperation ippOperation, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = cupsClient.cupsUri;
        }
        return cupsClient.ippRequest(ippOperation, uRI);
    }

    private final IppResponse exchange(IppRequest ippRequest) {
        IppResponse ippResponse;
        IppResponse it = ippResponse = this.ippClient.exchange(ippRequest);
        boolean bl = false;
        this.httpServer = it.getHttpServer();
        return ippResponse;
    }

    @Nullable
    public final String getHttpServer() {
        return this.httpServer;
    }

    public final void setHttpServer(@Nullable String string) {
        this.httpServer = string;
    }

    @NotNull
    public final Collection<IppJob> getJobs(@Nullable WhichJobs whichJobs, @Nullable Integer limit, @Nullable List<String> requestedAttributes) {
        return IppPrinter.getJobs$default(this.cupsServer, whichJobs, null, limit, requestedAttributes, 2, null);
    }

    public static /* synthetic */ Collection getJobs$default(CupsClient cupsClient, WhichJobs whichJobs, Integer n, List list, int n2, Object object) {
        if ((n2 & 1) != 0) {
            whichJobs = null;
        }
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            list = cupsClient.cupsServer.getGetJobsRequestedAttributes();
        }
        return cupsClient.getJobs(whichJobs, n, list);
    }

    @NotNull
    public final IppJob getJob(int id) {
        return this.cupsServer.getJob(id);
    }

    @NotNull
    public final List<IppSubscription> getSubscriptions() {
        return IppPrinter.getSubscriptions$default(this.cupsServer, null, null, null, null, 15, null);
    }

    @NotNull
    public final IppSubscription getSubscription(int id) {
        return this.cupsServer.getSubscription(id);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<IppString> getOwnersOfAllSubscriptions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSubscriptions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppSubscription ippSubscription = (IppSubscription)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSubscriberUserName());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final IppSubscription createSubscription(@Nullable List<String> notifyEvents, @Nullable Duration notifyLeaseDuration, @Nullable Duration notifyTimeInterval) {
        return this.cupsServer.createPrinterSubscription((Collection<String>)notifyEvents, notifyLeaseDuration, notifyTimeInterval);
    }

    public static /* synthetic */ IppSubscription createSubscription$default(CupsClient cupsClient, List list, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.listOf((Object)"all");
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            duration2 = null;
        }
        return cupsClient.createSubscription(list, duration, duration2);
    }

    @NotNull
    public final IppSubscription createSubscription(@NotNull String[] notifyEvents, @Nullable Duration notifyLeaseDuration, @Nullable Duration notifyTimeInterval) {
        Intrinsics.checkNotNullParameter((Object)notifyEvents, (String)"notifyEvents");
        return this.createSubscription(ArraysKt.toList((Object[])notifyEvents), notifyLeaseDuration, notifyTimeInterval);
    }

    public static /* synthetic */ IppSubscription createSubscription$default(CupsClient cupsClient, String[] stringArray, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            String[] stringArray2 = new String[]{"all"};
            stringArray = stringArray2;
        }
        if ((n & 2) != 0) {
            duration = null;
        }
        if ((n & 4) != 0) {
            duration2 = null;
        }
        return cupsClient.createSubscription(stringArray, duration, duration2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IppPrinter createIppEverywherePrinter(@NotNull String printerName, @NotNull URI deviceUri, @Nullable String printerInfo, @Nullable String printerLocation, boolean savePPD) {
        void $this$createIppEverywherePrinter_u24lambda_u2428_u24lambda_u2426;
        String string;
        IppPrinter ippPrinter;
        Intrinsics.checkNotNullParameter((Object)printerName, (String)"printerName");
        Intrinsics.checkNotNullParameter((Object)deviceUri, (String)"deviceUri");
        IppPrinter $this$createIppEverywherePrinter_u24lambda_u2428 = ippPrinter = this.createLocalPrinter(printerName, deviceUri, printerInfo, printerLocation, "everywhere");
        boolean bl = false;
        Object object = new String[]{"printer-name"};
        $this$createIppEverywherePrinter_u24lambda_u2428.updateAttributes((String)object);
        this.logger.info($this$createIppEverywherePrinter_u24lambda_u2428.toString());
        this.logger.info(CupsClient::createIppEverywherePrinter$lambda$28$lambda$24);
        do {
            object = new String[]{"printer-make-and-model"};
            $this$createIppEverywherePrinter_u24lambda_u2428.updateAttributes((String)object);
            Thread.sleep(500L);
            string = $this$createIppEverywherePrinter_u24lambda_u2428.getMakeAndModel().getText().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } while (!StringsKt.contains$default((CharSequence)string, (CharSequence)"everywhere", (boolean)false, (int)2, null));
        this.logger.info(CupsClient::createIppEverywherePrinter$lambda$28$lambda$25);
        Object object2 = object = CupsClient.cupsPrinterRequest$default(this, IppOperation.CupsAddModifyPrinter, printerName, null, null, null, null, null, 124, null);
        IppPrinter ippPrinter2 = $this$createIppEverywherePrinter_u24lambda_u2428;
        boolean bl2 = false;
        Object[] objectArray = new Object[]{false};
        $this$createIppEverywherePrinter_u24lambda_u2428_u24lambda_u2426.getPrinterGroup().attribute("printer-is-temporary", IppTag.Boolean, objectArray);
        ippPrinter2.exchange((IppRequest)object);
        this.logger.info(CupsClient::createIppEverywherePrinter$lambda$28$lambda$27);
        $this$createIppEverywherePrinter_u24lambda_u2428.enable();
        $this$createIppEverywherePrinter_u24lambda_u2428.resume();
        IppPrinter.updateAttributes$default($this$createIppEverywherePrinter_u24lambda_u2428, null, 1, null);
        if (savePPD) {
            IppPrinter.savePPD$default($this$createIppEverywherePrinter_u24lambda_u2428, this.cupsClientWorkDirectory, null, null, 6, null);
        }
        return ippPrinter;
    }

    public static /* synthetic */ IppPrinter createIppEverywherePrinter$default(CupsClient cupsClient, String string, URI uRI, String string2, String string3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = new IppPrinter(uRI, null, null, null, false, null, 62, null).getLocation().getText();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return cupsClient.createIppEverywherePrinter(string, uRI, string2, string3, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getOwnersOfAllJobs() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CupsClient.getJobs$default(this, WhichJobs.All, null, null, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppJob ippJob = (IppJob)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOriginatingUserNameOrAppleJobOwnerOrNull());
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<IppJob> getJobsAndSaveDocuments(@NotNull WhichJobs whichJobs, boolean updateJobAttributes, @Nullable String commandToHandleSavedFile) {
        IppJob job;
        void $this$onEach$iv;
        void var8_9;
        Intrinsics.checkNotNullParameter((Object)((Object)whichJobs), (String)"whichJobs");
        AtomicInteger numberOfJobsWithoutDocuments = new AtomicInteger(0);
        AtomicInteger numberOfSavedDocuments = new AtomicInteger(0);
        Object object = new String[]{"job-id", "job-uri", "job-printer-uri", "job-originating-user-name", "job-name", "job-state", "job-state-reasons", this.getVersion().compareTo("1.6.0") < 0 ? "document-count" : "number-of-documents"};
        object = CupsClient.getJobs$default(this, whichJobs, null, CollectionsKt.listOf((Object[])object), 2, null);
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var8_9 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            String it;
            job = (IppJob)element$iv;
            boolean bl2 = false;
            if (updateJobAttributes) {
                IppJob.updateAttributes$default(job, null, 1, null);
            }
            this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$32$lambda$30(job));
            if (job.getOriginatingUserNameOrAppleJobOwnerOrNull() == null) continue;
            boolean bl3 = false;
            this.jobOwners.add(it);
        }
        $this$onEach$iv = var8_9;
        $i$f$onEach = false;
        $this$onEach_u24lambda_u2416$iv = var8_9 = $this$onEach$iv;
        bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            Collection collection;
            job = (IppJob)element$iv;
            boolean bl4 = false;
            if (job.getNumberOfDocuments() == 0) {
                numberOfJobsWithoutDocuments.incrementAndGet();
                continue;
            }
            Collection $this$getJobsAndSaveDocuments_u24lambda_u2434_u24lambda_u2433 = collection = CupsClient.getAndSaveDocuments$ipp_client$default(this, job, false, commandToHandleSavedFile, 2, null);
            boolean bl5 = false;
            numberOfSavedDocuments.addAndGet($this$getJobsAndSaveDocuments_u24lambda_u2434_u24lambda_u2433.size());
        }
        object = var8_9;
        Collection $this$getJobsAndSaveDocuments_u24lambda_u2438 = (Collection)object;
        boolean bl6 = false;
        this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$38$lambda$35(this));
        this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$38$lambda$36($this$getJobsAndSaveDocuments_u24lambda_u2438, whichJobs, numberOfJobsWithoutDocuments));
        this.logger.info(() -> CupsClient.getJobsAndSaveDocuments$lambda$38$lambda$37(numberOfSavedDocuments, $this$getJobsAndSaveDocuments_u24lambda_u2438, numberOfJobsWithoutDocuments, this));
        return (Collection)object;
    }

    public static /* synthetic */ Collection getJobsAndSaveDocuments$default(CupsClient cupsClient, WhichJobs whichJobs, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            whichJobs = WhichJobs.All;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return cupsClient.getJobsAndSaveDocuments(whichJobs, bl, string);
    }

    public final void subscribeToJobEventsAndThenGetDocuments(@NotNull String whichJobEvents, @NotNull Duration leaseDuration, boolean autoRenewLease, @NotNull Duration pollEvery, @Nullable String commandToHandleFile) {
        Intrinsics.checkNotNullParameter((Object)whichJobEvents, (String)"whichJobEvents");
        Intrinsics.checkNotNullParameter((Object)leaseDuration, (String)"leaseDuration");
        Intrinsics.checkNotNullParameter((Object)pollEvery, (String)"pollEvery");
        String[] stringArray = new String[]{whichJobEvents};
        CupsClient.createSubscription$default(this, stringArray, leaseDuration, null, 4, null).pollAndHandleNotifications(pollEvery, autoRenewLease, (Function1<? super IppEventNotification, Unit>)((Function1)new Function1<IppEventNotification, Unit>(this, commandToHandleFile){
            final /* synthetic */ CupsClient this$0;
            final /* synthetic */ String $commandToHandleFile;
            {
                this.this$0 = $receiver;
                this.$commandToHandleFile = $commandToHandleFile;
                super(1);
            }

            public final void invoke(@NotNull IppEventNotification event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CupsClient.access$getLogger$p(this.this$0).info(() -> subscribeToJobEventsAndThenGetDocuments.1.invoke$lambda$0(event));
                IppJob ippJob = event.getJob();
                CupsClient cupsClient = this.this$0;
                String string = this.$commandToHandleFile;
                IppJob $this$invoke_u24lambda_u242 = ippJob;
                boolean bl = false;
                while ($this$invoke_u24lambda_u242.isIncoming()) {
                    CupsClient.access$getLogger$p(cupsClient).info(() -> subscribeToJobEventsAndThenGetDocuments.1.invoke$lambda$2$lambda$1($this$invoke_u24lambda_u242));
                    Thread.sleep(1000L);
                    IppJob.updateAttributes$default($this$invoke_u24lambda_u242, null, 1, null);
                }
                CupsClient.getAndSaveDocuments$ipp_client$default(cupsClient, $this$invoke_u24lambda_u242, false, string, 2, null);
            }

            private static final String invoke$lambda$0(IppEventNotification $event) {
                Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
                return $event.toString();
            }

            private static final String invoke$lambda$2$lambda$1(IppJob $this_with) {
                Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
                return $this_with.toString();
            }
        }));
    }

    public static /* synthetic */ void subscribeToJobEventsAndThenGetDocuments$default(CupsClient cupsClient, String string, Duration duration, boolean bl, Duration duration2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = "job-created";
        }
        if ((n & 2) != 0) {
            Duration duration3 = Duration.ofMinutes(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMinutes(60)");
            duration = duration3;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            Duration duration4 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(1)");
            duration2 = duration4;
        }
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        cupsClient.subscribeToJobEventsAndThenGetDocuments(string, duration, bl, duration2, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getAndSaveDocuments$ipp_client(@NotNull IppJob job, boolean onSuccessUpdateJobAttributes, @Nullable String optionalCommandToHandleFile) {
        void $this$mapTo$iv$iv;
        IppDocument document;
        Iterable $i$f$forEach2;
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Ref.ObjectRef documents = new Ref.ObjectRef();
        documents.element = CollectionsKt.emptyList();
        if (!CupsClient.getAndSaveDocuments$getDocuments((Ref.ObjectRef<Collection<IppDocument>>)documents, job, onSuccessUpdateJobAttributes, this)) {
            String configuredUserName = this.getConfig().getUserName();
            Iterable $this$forEach$iv = this.jobOwners;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                this.getConfig().setUserName(it);
                this.logger.fine(() -> CupsClient.getAndSaveDocuments$lambda$41$lambda$40(this));
                if (CupsClient.getAndSaveDocuments$getDocuments((Ref.ObjectRef<Collection<IppDocument>>)documents, job, onSuccessUpdateJobAttributes, this)) continue;
            }
            this.getConfig().setUserName(configuredUserName);
        }
        Iterable $this$onEach$iv = (Iterable)documents.element;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2416$iv = $i$f$forEach2 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            String it;
            document = (IppDocument)element$iv;
            boolean bl2 = false;
            IppDocument.save$default(document, job.printerDirectory(), null, true, 2, null);
            if (optionalCommandToHandleFile == null) continue;
            boolean bl3 = false;
            document.runCommand(it);
        }
        Iterable $this$map$iv = (Iterable)documents.element;
        boolean $i$f$map = false;
        $i$f$forEach2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            document = (IppDocument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            File file = it.getFile();
            Intrinsics.checkNotNull((Object)file);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ Collection getAndSaveDocuments$ipp_client$default(CupsClient cupsClient, IppJob ippJob, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return cupsClient.getAndSaveDocuments$ipp_client(ippJob, bl, string);
    }

    private static final String cupsPrinterUri$lambda$3$lambda$2(String $printerName, URI $this_apply) {
        Intrinsics.checkNotNullParameter((Object)$printerName, (String)"$printerName");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        return "cupsPrinterUri(" + $printerName + ") = " + $this_apply;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getPrinter$lambda$9$lambda$8(List $this_with) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this_with, (String)"$this_with");
        Iterable $this$map$iv = $this_with;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IppPrinter ippPrinter = (IppPrinter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        return "Available CUPS printers: " + (List)destination$iv$iv;
    }

    private static final String deletePrinter$lambda$11$lambda$10(String $printerName) {
        Intrinsics.checkNotNullParameter((Object)$printerName, (String)"$printerName");
        return "Printer deleted: " + $printerName;
    }

    private static final String createLocalPrinter$lambda$14$lambda$13(IppResponse $this_run) {
        Intrinsics.checkNotNullParameter((Object)$this_run, (String)"$this_run");
        return $this_run.getStatusMessage() + " " + $this_run.getPrinterGroup().getValues("printer-uri-supported");
    }

    private static final String createIppEverywherePrinter$lambda$28$lambda$24() {
        return "CUPS now generates IPP Everywhere PPD.";
    }

    private static final String createIppEverywherePrinter$lambda$28$lambda$25() {
        return "Make printer permanent.";
    }

    private static final String createIppEverywherePrinter$lambda$28$lambda$27() {
        return "Make printer operational.";
    }

    private static final String getJobsAndSaveDocuments$lambda$32$lambda$30(IppJob $job) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        return $job.toString();
    }

    private static final String getJobsAndSaveDocuments$lambda$38$lambda$35(CupsClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Found " + this$0.jobOwners.size() + " job " + (this$0.jobOwners.size() == 1 ? "owner" : "owners") + ": " + this$0.jobOwners;
    }

    private static final String getJobsAndSaveDocuments$lambda$38$lambda$36(Collection $this_apply, WhichJobs $whichJobs, AtomicInteger $numberOfJobsWithoutDocuments) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)((Object)$whichJobs), (String)"$whichJobs");
        Intrinsics.checkNotNullParameter((Object)$numberOfJobsWithoutDocuments, (String)"$numberOfJobsWithoutDocuments");
        return "Found " + $this_apply.size() + " jobs (which=" + $whichJobs + ") where " + $numberOfJobsWithoutDocuments + " jobs have no documents";
    }

    private static final String getJobsAndSaveDocuments$lambda$38$lambda$37(AtomicInteger $numberOfSavedDocuments, Collection $this_apply, AtomicInteger $numberOfJobsWithoutDocuments, CupsClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$numberOfSavedDocuments, (String)"$numberOfSavedDocuments");
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)$numberOfJobsWithoutDocuments, (String)"$numberOfJobsWithoutDocuments");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Saved " + $numberOfSavedDocuments + " documents of " + ($this_apply.size() - $numberOfJobsWithoutDocuments.intValue()) + " jobs with documents to directory: " + this$0.cupsServer.getWorkDirectory();
    }

    private static final String getAndSaveDocuments$getDocuments$lambda$39(IppJob $job, IppExchangeException $ippExchangeException) {
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Intrinsics.checkNotNullParameter((Object)$ippExchangeException, (String)"$ippExchangeException");
        return "Get documents for job #" + $job.getId() + " failed: " + $ippExchangeException.getMessage();
    }

    private static final boolean getAndSaveDocuments$getDocuments(Ref.ObjectRef<Collection<IppDocument>> documents, IppJob $job, boolean $onSuccessUpdateJobAttributes, CupsClient this$0) {
        boolean bl;
        try {
            documents.element = IppJob.cupsGetDocuments$default($job, false, null, 3, null);
            if (!((Collection)documents.element).isEmpty() && $onSuccessUpdateJobAttributes) {
                IppJob.updateAttributes$default($job, null, 1, null);
            }
            bl = true;
        }
        catch (IppExchangeException ippExchangeException) {
            this$0.logger.info(() -> CupsClient.getAndSaveDocuments$getDocuments$lambda$39($job, ippExchangeException));
            Integer n = ippExchangeException.getHttpStatus();
            Intrinsics.checkNotNull((Object)n);
            bl = n != 401;
        }
        return bl;
    }

    private static final String getAndSaveDocuments$lambda$41$lambda$40(CupsClient this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "set userName '" + this$0.getConfig().getUserName() + "'";
    }

    public CupsClient() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Logger access$getLogger$p(CupsClient $this) {
        return $this.logger;
    }
}

