/*
 * Decompiled with CFR 0.152.
 */
package de.gmuth.ipp.attributes;

import de.gmuth.ipp.core.IppAttributesGroup;
import de.gmuth.ipp.core.IppString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lde/gmuth/ipp/attributes/Marker;", "", "type", "", "name", "level", "", "lowLevel", "highLevel", "colorCode", "(Ljava/lang/String;Ljava/lang/String;IIILjava/lang/String;)V", "color", "Lde/gmuth/ipp/attributes/Marker$Color;", "getColor", "()Lde/gmuth/ipp/attributes/Marker$Color;", "getColorCode", "()Ljava/lang/String;", "getHighLevel", "()I", "getLevel", "getLowLevel", "getName", "getType", "levelIsLow", "", "levelPercent", "toString", "Color", "Companion", "ipp-client"})
public final class Marker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String type;
    @NotNull
    private final String name;
    private final int level;
    private final int lowLevel;
    private final int highLevel;
    @NotNull
    private final String colorCode;
    @NotNull
    private final Color color;

    public Marker(@NotNull String type, @NotNull String name, int level, int lowLevel, int highLevel, @NotNull String colorCode) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)colorCode, (String)"colorCode");
        this.type = type;
        this.name = name;
        this.level = level;
        this.lowLevel = lowLevel;
        this.highLevel = highLevel;
        this.colorCode = colorCode;
        this.color = Color.Companion.fromString(this.colorCode);
    }

    @NotNull
    public final String getType() {
        return this.type;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final int getLevel() {
        return this.level;
    }

    public final int getLowLevel() {
        return this.lowLevel;
    }

    public final int getHighLevel() {
        return this.highLevel;
    }

    @NotNull
    public final String getColorCode() {
        return this.colorCode;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    public final int levelPercent() {
        return 100 * this.level / this.highLevel;
    }

    public final boolean levelIsLow() {
        return this.level < this.lowLevel;
    }

    @NotNull
    public String toString() {
        String string = "%-10s %3d %% %5s %-12s %-8s %s";
        Object[] objectArray = new Object[]{this.color, this.levelPercent(), this.levelIsLow() ? "(low)" : "", this.type, this.colorCode, this.name};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0001\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000eB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000f"}, d2={"Lde/gmuth/ipp/attributes/Marker$Color;", "", "code", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getCode", "()Ljava/lang/String;", "NONE", "CYAN", "BLACK", "YELLOW", "MAGENTA", "TRI_COLOR", "UNKNOWN", "Companion", "ipp-client"})
    public static final class Color
    extends Enum<Color> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String code;
        private static final Logger logger;
        public static final /* enum */ Color NONE;
        public static final /* enum */ Color CYAN;
        public static final /* enum */ Color BLACK;
        public static final /* enum */ Color YELLOW;
        public static final /* enum */ Color MAGENTA;
        public static final /* enum */ Color TRI_COLOR;
        public static final /* enum */ Color UNKNOWN;
        private static final /* synthetic */ Color[] $VALUES;

        private Color(String code) {
            this.code = code;
        }

        @NotNull
        public final String getCode() {
            return this.code;
        }

        public static Color[] values() {
            return (Color[])$VALUES.clone();
        }

        public static Color valueOf(String value) {
            return Enum.valueOf(Color.class, value);
        }

        static {
            NONE = new Color("NONE");
            CYAN = new Color("#00FFFF");
            BLACK = new Color("#000000");
            YELLOW = new Color("#FFFF00");
            MAGENTA = new Color("#FF00FF");
            TRI_COLOR = new Color("#00FFFF#FF00FF#FFFF00");
            UNKNOWN = new Color("#?");
            $VALUES = colorArray = new Color[]{Color.NONE, Color.CYAN, Color.BLACK, Color.YELLOW, Color.MAGENTA, Color.TRI_COLOR, Color.UNKNOWN};
            Companion = new Companion(null);
            logger = Logger.getLogger(Color.class.getName());
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/gmuth/ipp/attributes/Marker$Color$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "fromString", "Lde/gmuth/ipp/attributes/Marker$Color;", "code", "", "ipp-client"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Color fromString(@NotNull String code) {
                Color color;
                Color color2;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                    Color[] colorArray = Color.values();
                    int n = colorArray.length;
                    for (int i = 0; i < n; ++i) {
                        Color color3;
                        Color it = color3 = colorArray[i];
                        boolean bl = false;
                        String string = it.getCode();
                        String string2 = code.toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                        if (!Intrinsics.areEqual((Object)string, (Object)string2)) continue;
                        color2 = color3;
                        break block2;
                    }
                    color2 = color = null;
                }
                if (color2 == null) {
                    Color color4;
                    Color $this$fromString_u24lambda_u242 = color4 = UNKNOWN;
                    boolean bl = false;
                    logger.warning(() -> Companion.fromString$lambda$2$lambda$1(code));
                    color = color4;
                }
                return color;
            }

            private static final String fromString$lambda$2$lambda$1(String $code) {
                Intrinsics.checkNotNullParameter((Object)$code, (String)"$code");
                return "Unknown color code: " + $code;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lde/gmuth/ipp/attributes/Marker$Companion;", "", "()V", "getMarkers", "", "Lde/gmuth/ipp/attributes/Marker;", "attributes", "Lde/gmuth/ipp/core/IppAttributesGroup;", "ipp-client"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<Marker> getMarkers(@NotNull IppAttributesGroup attributes) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            IppAttributesGroup $this$getMarkers_u24lambda_u241 = attributes;
            boolean bl = false;
            List types = (List)$this$getMarkers_u24lambda_u241.getValues("marker-types");
            List names = (List)$this$getMarkers_u24lambda_u241.getValues("marker-names");
            List levels = (List)$this$getMarkers_u24lambda_u241.getValues("marker-levels");
            List lowLevels = (List)$this$getMarkers_u24lambda_u241.getValues("marker-low-levels");
            List highLevels = (List)$this$getMarkers_u24lambda_u241.getValues("marker-high-levels");
            List colors = (List)$this$getMarkers_u24lambda_u241.getValues("marker-colors");
            Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)types);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new Marker((String)types.get((int)it), ((IppString)names.get((int)it)).getText(), ((Number)levels.get((int)it)).intValue(), ((Number)lowLevels.get((int)it)).intValue(), ((Number)highLevels.get((int)it)).intValue(), ((IppString)colors.get((int)it)).getText()));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

